#include "XIpc.h"

extern char *getenv ();

/*
 * sample server routine to test XIpc
 */
void
main (argc, argv)
int argc;
char **argv;
{
    char buf[XIPCBUFSIZ];
    XIpcMessage *message;
    XIpcMessage *return_message;
    char *name = SERVER_ENV_NAME;
    XIpcServer *server;
    int i;
    char *ptr_in, *ptr_out;

    if ((server = XIpcSetupServer ((char *) NULL, (caddr_t) NULL,
				   (caddr_t) NULL, (char *) NULL)) != NULL)
    {
	fprintf (stderr, "%s=%s; export %s\n",
		 name, getenv (name), name);
    }
    else
    {
	fprintf (stderr, "%s: Could not initialize the server.\n",
		 argv[0]);
	exit (1);
    }

    XIpcCatchErrors (TRUE, NULL);

    i = 0;
    for (;;)
    {
	fprintf (stderr, "Server loop: %d\n", i);
	switch (XIpcServerMonitor (server, XIPC_MONITOR_MESSAGES, -1))
	{
	case XIPC_MONITOR_KEYBOARD:
	    fprintf (stderr, "keyboard read.\n");
	    read (0, buf, XIPCBUFSIZ);
	    continue;
	case XIPC_MONITOR_MESSAGES:
	    message = XIpcRecvFromClients (server);
	    if (message == (XIpcMessage *) NULL)
		continue;
	    fprintf (stderr,
		     "Server loop: %d client: %d length: %d\n",
		     i, message -> client_id, message -> length);
	    if (message -> type != XIPC_SERVER_PING)
	    {
		XIpcServerProcessMessage (server, message);
		continue;
	    }

	    /*
	     * get the return message type from the incoming
	     * message.
	     */
	    ptr_in = (char *) message -> buffer;
	    while (*ptr_in && *ptr_in != ',')
		ptr_in++;
	    if (*ptr_in == '\0')
		continue;
	    *ptr_in++ = '\0';
	    return_message = (XIpcMessage *) buf;
	    return_message -> type = atoi (message -> buffer);

	    /*
	     * copy the incoming message to the outgoing message.
	     */
	    ptr_out = (char *) return_message -> buffer;
	    while (*ptr_out++ = *ptr_in++)
		;
	    return_message -> length = ptr_out -
		(char *) return_message -> buffer;

	    /*
	     * send it back.
	     */
	    XIpcSendToClient (server, message -> client_id,
			      return_message);
	    XIpcFlushServer (server);
	    i++;
	    continue;
	default:
	    /* error or timeout */
	    continue;
	}
    }
}
