;;;
;;; sample AKCL base XIpc server
;;;
(require 'xipc "XIpcDefs.lsp")
(in-package 'xipc)

;;;
;;; xipc-serve is the top level that allows interactive keyboard input and
;;;   XIpc messages to be processed
;;;
(defvar *xipc-server* nil
  "XIPC server structure.  This is nil if the IPC has not been initialzied.")

(defvar *xipc-server-clients* '(-1)
  "The list of XIPC server client id's.")

(defun xipc-serve ()
  (loop
   (catch system::*quit-tag*
     (cond ((null *xipc-server*)
	    (progn
	      (setq *xipc-server* (XipcSetupServer))
	      (XIpcCatchErrors t)
	      (if (not (null *xipc-server*))
		  (xipc-serve))
	      (setq *xipc-server* nil)))
	   (t
	    (xipc-env)
	    (xipc-loop *xipc-server*))))))

;;;
;;; print the value of XIPC in the current UNIX\tm process environment
;;;
(defun xipc-env ()
  (format *error-output* "XIPC=~s; export XIPC~%" (getenv "XIPC")))

;;;
;;; message handler loop
;;;
(defun xipc-loop (server)
  (let ((rc 0))
    (format *error-output* "~%xipc-serve->")
    (loop
     (setq rc (XipcServerMonitor server XIPC-MONITOR-BOTH -1))
     (cond ((equal rc XIPC-MONITOR-KEYBOARD)
	    (format *error-output* "~s~%xipc-serve->" (eval (read))))
	   ((equal rc XIPC-MONITOR-MESSAGES)
	    (let ((message (XIpcRecvFromClients server)))
	      (cond ((null message) t)
		    ((equal (xipc-message-type message)
			    XIPC-SERVER-INTERPRETER-MESSAGE)
		     (eval
		      (with-input-from-string (s (xipc-message-buffer message)
						 :start 0) (read s))))
		    (t (XIpcServerProcessMessage server message)))))))))

;;;
;;; start widget
;;;
(defun xipc-start-client (string &optional (timeout 8))
  (if (equal 0 (system (concatenate 'string (string string) " &")))
      (let ((rc 0)
	    (message nil))
	(loop
	 (setq rc (XipcServerMonitor *xipc-server*
				     XIPC-MONITOR-MESSAGES timeout))
	 (cond
	  ((equal rc XIPC-MONITOR-MESSAGES)
	   (progn
	     (setq message (XIpcRecvFromClients *xipc-server*))
	     (cond ((equal (xipc-message-type message)
			   XIPC-SERVER-INTERPRETER-MESSAGE)
		    (eval
		     (with-input-from-string (s (xipc-message-buffer message)
						:start 0) (read s))))
		   (t
		    (progn
		      (XIpcServerProcessMessage *xipc-server* message)
		      (when (equal (xipc-message-type message)
				   XIPC-SERVER-NEW-CLIENT)
			    (setq *xipc-server-clients*
				  (cons (xipc-message-client_id message)
					*xipc-server-clients*))
			    (return-from xipc-start-client
				       (xipc-message-client_id message))))))))
	  ((equal rc XIPC-MONITOR-TIMEOUT)
	   (return nil)))))))

(defun xipc-stop-client (c)
  (let ((sub-list (member c *xipc-server-clients*)))
    (when sub-list
	  (XIpcSendToClient *xipc-server* c
			    (make-xipc-message :type xipc-client-exit))
    	  (rplaca sub-list (cadr sub-list))
	  (rplacd sub-list (cddr sub-list)))))

(defun xipc-stop-all-clients ()
  (let ((m (make-xipc-message :type xipc-client-exit)))
    (defun temp-lambda (x) (XIpcSendToClient *xipc-server* x m))
    (map 'list 'temp-lambda *xipc-server-clients*)
    (setq *xipc-server-clients* '(-1))))

(defun xx (&optional (client 0)
		     (type XIPC-SERVER-INTERPRETER-MESSAGE)
		     (buffer ""))
  (XIpcSendToClient *XIPC-SERVER* client
		    (make-xipc-message :type type :buffer buffer)))
