#include "XIpc.h"

extern char *getenv ();

/*
 * sample server routine to test XIpc
 */
void
main (argc, argv)
int argc;
char * argv[];
{
    char rbuf[XIPCBUFSIZ];
    char buf[XIPCBUFSIZ];
    XIpcMessage *message;
    char *name = SERVER_ENV_NAME;
    XIpcServer *server;
    int i;
    char *ptr;

    if ((server = XIpcSetupServer ((char *) NULL, (caddr_t) NULL,
				   (caddr_t) NULL, (char *) NULL)) != NULL)
    {
	fprintf (stderr, "%s=%s; export %s\n",
		 name, getenv (name), name);
    }
    else
    {
	fprintf (stderr, "%s: Could not initialize the server.\n",
		 argv[0]);
	exit (1);
    }

    XIpcCatchErrors (TRUE, NULL);

    i = 0;
    for (;;)
    {
	switch (XIpcServerMonitor (server, XIPC_MONITOR_BOTH, -1))
	{
	case XIPC_MONITOR_KEYBOARD:
	    fprintf (stderr, "keyboard read.\n");
	    read (0, rbuf, XIPCBUFSIZ);
	    ptr = rbuf;
	    while (*ptr)
	    {
		if (*ptr == '\n' || *ptr == '\r')
		{
		    *ptr = '\0';
		    break;
		}
		ptr++;
	    }
	    if (strcmp (rbuf, "exit") == 0)
		exit (0);
	    message = (XIpcMessage *) buf;
	    sprintf (message -> buffer, "%s", rbuf);
	    message -> length = strlen (message -> buffer);
	    message -> type = 0;
	    XIpcSendToClient (server, 0, message);
	    continue;
	case XIPC_MONITOR_MESSAGES:
	    message = XIpcRecvFromClients (server);
	    if (message == (XIpcMessage *) NULL)
		continue;
/*
	       fprintf (stderr,
	       "Server loop: %d client: %d length: %d\n",
	       i, message -> client_id, message -> length);
*/
	    XIpcServerProcessMessage (server, message);
	    if (message -> type == XIPC_SERVER_NEW_CLIENT)
		printf ("new client=%d\n", message -> client_id);
	    if (message -> type != XIPC_SERVER_PING)
		continue;
	    i++;
	    continue;
	default:
	    /* error or timeout */
	    continue;
	}
    }
}
