;;;
;;; sample AKCL base XIpc server
;;;
(require 'xipc "XIpcDefs.lsp")
(in-package 'xipc)

(defvar *xipc-client* nil
  "XIPC client structure.  This is nil if the IPC has not been initialzied.")

(defun xc (starting-length &optional (xipc "") (display 0) (window 0))
  (let ((message nil)
	(i 0) (length 0) (op 0))

    (XIpcCatchErrors t)
    (setq *xipc-client* (XIpcSetupClient xipc display window))
    (when (null *xipc-client*)
	  (format *error-output* "Cannot establish ipc links.~%")
	  (return-from XC nil))
    
    (XIpcSynchronize *xipc-client* nil)
    
    (setq message (make-xipc-message :type XIPC-SERVER-PING))

    (do ((length starting-length (1+ length))
	 (i 0 (1+ i)))
	((= i 20) nil)

	(progn
	  (format *error-output* "loop send ~d~%" i)
	  (setf (xipc-message-buffer message)
		(make-sequence 'string length
		:initial-element (character (+ (mod i 10) (char-code #\0)))))
	  (XIpcSendToServer *xipc-client* message)
	  (if (> i 15)
	      (XIpcFlushClient *xipc-client*))))

    (XIpcSynchronize *xipc-client* t)

    (do ((i 0))
	((= i 20.) nil)
	
	(when (null (XIpcIsClientActive *xipc-client*))
	      (format *error-output* "lost the connection~%")
	      (setq *xipc-client* nil)
	      (return-from XC nil))
	
	(setq op (XIpcClientMonitor *xipc-client* XIPC-MONITOR-MESSAGES -1))

	(cond
	 ((equal op XIPC-MONITOR-MESSAGES)
	  (progn
	    (setq message (XIpcRecvFromServer *xipc-client*))
	    (cond ((null message)
		   (format *error-output* "NULL message~%"))
		  (t
		   (progn
		     (XIpcPrintMessage t (format nil "message ~d" i) message)
		     (format *error-output* "length=~d~%" (length
					      (xipc-message-buffer message)))
		     (incf i))))))
	 ((equal op XIPC-MONITOR-KEYBOARD)
	  (read))
	 ((equal op XIPC-MONITOR-TIMEOUT)
	  (format *error-output* "timeout.~%"))))

    (XIpcCloseClient *xipc-client*)
    (setq *xipc-client* nil)

;;;	(setf (ixpc-message-type message) XIPC-SERVER-EXIT)
;;;	(XIpcSendToServer *xipc-client* message)
))
