static char TMXtAddXIpc_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "XIpc.h"

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

static void
XIpcInputHandler C_P_ARGS((XIpcClient *client, int source,
			   XtInputId xt_input_id));

extern int
XtAddXipc C_P_ARGS((Widget toplevel, char *ipc_name, void (*ipc_handler)()));

extern void
XtRemoveXIpc C_P_NO_ARGS();

extern XIpcClient *
XtXIpcClient C_P_NO_ARGS();

C_PROTOS_END_EXTERN

static XtInputId input_id = (XtInputId) NULL;
static XIpcClient *client;
static void (*handler) ();

static void
XIpcInputHandler (client, source, xt_input_id)
XIpcClient *client;
int source;
XtInputId xt_input_id;
{
    (*handler) (client);
}

int
XtAddXIpc (toplevel, ipc_name, ipc_handler)
Widget toplevel;
char *ipc_name;
void (*ipc_handler) ();
{
    extern char *getenv ();
    extern void XIpcXtHandleMsgToClient ();
	
    if (ipc_name == (char *) NULL || *ipc_name == '\0')
	ipc_name = getenv ("XIPC");
    if ((client = XIpcSetupClient (ipc_name, (caddr_t) XtDisplay (toplevel),
				   (caddr_t) NULL)) == (XIpcClient *) NULL)
    {
	XtWarning ("There is no IPC server running.");
	return FALSE;
    }
    client -> data = (caddr_t) toplevel;
    handler = ipc_handler;
    input_id = XtAppAddInput (XtWidgetToApplicationContext (toplevel),
			      client -> channel, 
			      (XtPointer) XtInputReadMask,
			      (XtInputCallbackProc) XIpcInputHandler, 
			      client);

    return TRUE;
}

void
XtRemoveXIpc ()
{
    if (client)
    {
	XtRemoveInput (input_id);
	input_id = (XtInputId) NULL;
	XIpcCloseClient (client);
	client = (XIpcClient *) NULL;
    }
}

XIpcClient *
XtXIpcClient ()
{
    return client;
}
