static char TMXIpcCombined_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include "XIpc.h"

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern int
XIpcClientAndServerMonitor C_P_ARGS((XIpcClient *client, int which_client,
				     XIpcServer *server, int which_server,
				     int timeout, int *client_return,
				     int *server_return));

C_PROTOS_END_EXTERN

/*
 * monitor routine for a combined server client monitor
 */
int
XIpcClientAndServerMonitor (client, which_client, server, which_server,
			    timeout, client_return, server_return)
XIpcClient *client;
int which_client;
XIpcServer *server;
int which_server;
int timeout;
int *client_return;
int *server_return;
{
	extern void XIpcAcceptNewClientSocket ();
	fd_set write_select_mask;
	fd_set *writefds;
	int write_flag;
	fd_set read_select_mask;
	fd_set *readfds;
	struct timeval local_timeout;
	struct timeval *time_ptr;
	int rc;
	int i;

	*client_return = *server_return = 0;

	if ((which_server & XIPC_MONITOR_BOTH) == 0 &&
	    (which_client & XIPC_MONITOR_BOTH) == 0 &&
	    timeout < 0)
	{
		*client_return = *server_return = XIPC_MONITOR_ERROR;
		return XIPC_MONITOR_ERROR;
	}

	readfds = &read_select_mask;

	if (which_client & XIPC_MONITOR_MESSAGES)
	{
		if (client -> channel && FD_ISSET (client -> channel,
						   &client -> select_mask))
		{
			*client_return = XIPC_MONITOR_MESSAGES;
			return XIPC_MONITOR_MESSAGES;
		}
		readfds = &client -> select_mask;
	}

	if (which_server & XIPC_MONITOR_MESSAGES)
	{
		for (i = 0; i < server -> max_clients; i++)
			if (server -> clients[i].recv_buffer &&
			    FD_ISSET (server -> clients[i].channel,
				      &server -> select_mask))
			{
				*server_return = XIPC_MONITOR_MESSAGES;
				return XIPC_MONITOR_MESSAGES;
			}

		readfds = &server -> select_mask;
	}

ContinueLoop:

	do {
		FD_ZERO (readfds);
		if (which_client & XIPC_MONITOR_MESSAGES)
			FD_SET (client -> channel, readfds);

		writefds = (fd_set *) NULL;
		if (which_client & XIPC_MONITOR_MESSAGES &&
		    client -> message_queue)
		{
			writefds = &write_select_mask;
			FD_ZERO (writefds);
			FD_SET (client -> channel, writefds);
		}
		if (which_server & XIPC_MONITOR_MESSAGES)
		{
			FD_SET (server -> channel, readfds);
			for (i = 0; i < server -> max_clients; i++)
			{
				if (server -> clients[i].recv_buffer)
					FD_SET (server -> clients[i].channel,
						readfds);

				if (server -> clients[i].message_queue)
				{
					if (writefds == (fd_set *) NULL)
					{
						writefds = &write_select_mask;
						FD_ZERO (writefds);
					}
					FD_SET (server -> clients[i].channel,
						writefds);
				}
			}
		}
		if (which_server & XIPC_MONITOR_KEYBOARD ||
		    which_client & XIPC_MONITOR_KEYBOARD)
			FD_SET (0, readfds);

		if (timeout >= 0)
		{
			local_timeout.tv_sec = timeout;
			local_timeout.tv_usec = 0;
			time_ptr = &local_timeout;
		}
		else
			time_ptr = (struct timeval *) NULL;

	} while ((rc = select (server -> max_clients, readfds, writefds, NULL,
			       time_ptr)) < 0);

	write_flag = FALSE;
	if (client -> message_queue &&
	    FD_ISSET (client -> channel, &write_select_mask))
	{
		write_flag = TRUE;
		if (XIpcSendQueue (client) == FALSE)
		{
			FD_CLR (client -> channel, readfds);
			XIpcCloseClient (client);
		}
	}
	for (i = 0; i < server -> max_clients; i++)
	{
		if (server -> clients[i].message_queue &&
		    FD_ISSET (server -> clients[i].channel,
			      &write_select_mask))
		{
			write_flag = TRUE;
			if (XIpcSendQueue (&server -> clients[i]) == FALSE)
			{
				FD_CLR (server -> clients[i].channel,
					&server -> select_mask);
				XIpcServerCloseClient (server, i);
			}
		}
	}
	if (FD_ISSET (server -> channel, readfds))
		XIpcAcceptNewClientSocket (server);
	if (FD_ISSET (client -> channel, readfds))
	{
		FD_CLR (client -> channel, readfds);
		FD_SET (client -> channel, &client -> select_mask);
	}
	if (rc == 0 && timeout >= 0)
	{
		*client_return = *server_return = XIPC_MONITOR_TIMEOUT;
		return XIPC_MONITOR_TIMEOUT;
	}
	if ((which_server & XIPC_MONITOR_KEYBOARD ||
	     which_client & XIPC_MONITOR_KEYBOARD) &&
	    FD_ISSET (0, readfds))
	{
		FD_CLR (server -> channel, readfds);
		FD_CLR (0, readfds);
		*server_return = *client_return = XIPC_MONITOR_KEYBOARD;
		return XIPC_MONITOR_KEYBOARD;
	}
	if (which_client & XIPC_MONITOR_MESSAGES &&
	    client -> channel &&
	    FD_ISSET (client -> channel, &client -> select_mask))
	{
		FD_CLR (server -> channel, readfds);
		*client_return = XIPC_MONITOR_MESSAGES;
		return XIPC_MONITOR_MESSAGES;
	}
	for (i = 0; i < server -> max_clients; i++)
	{
		if (server -> clients[i].recv_buffer &&
		    FD_ISSET (server -> clients[i].channel,
			      &server -> select_mask))
		{
			FD_CLR (server -> channel, &server -> select_mask);
			*server_return = XIPC_MONITOR_MESSAGES;
			return XIPC_MONITOR_MESSAGES;
		}
	}

	if (FD_ISSET (server -> channel, readfds))
	{
		FD_CLR (server -> channel, &server -> select_mask);
		goto ContinueLoop;
	}
	if (write_flag)
		goto ContinueLoop;

	*client_return = *server_return = XIPC_MONITOR_ERROR;
	return XIPC_MONITOR_ERROR;
}
