static char TMXIpcClient_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <sys/time.h>		/* RAD - added time.h and resource.h to use */
#include <sys/resource.h>	/* getrlimit instead of getdtablesize  */
#include "XIpc.h"

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern XIpcClient *
XIpcSetupClient C_P_ARGS((char *xipc_name, caddr_t client_display,
			  caddr_t client_window));

extern XIpcClient *
XIpcSetupKeyClient C_P_ARGS((char *xipc_name, int xipc_client_key,
			     caddr_t client_display, caddr_t client_window));

extern void
XIpcCloseClient C_P_ARGS((XIpcClient *client));

extern void
XIpcFlushClient C_P_ARGS((XIpcClient *client));

extern int
XIpcClientMonitor C_P_ARGS((XIpcClient *client, int which, int timeout));

extern int
XIpcSendToServer C_P_ARGS((XIpcClient *client, XIpcMessage *message));

extern XIpcMessage *
XIpcRecvFromServer C_P_ARGS((XIpcClient *client));

C_PROTOS_END_EXTERN
 
/*
 * interface routines for clients using XIpc
 */
XIpcClient *
XIpcSetupClient (xipc_name, client_display, client_window)
char *xipc_name;
caddr_t client_display;
caddr_t client_window;
{
    return XIpcSetupKeyClient (xipc_name, 0, client_display, client_window);
}

XIpcClient *
XIpcSetupKeyClient (xipc_name, xipc_client_key, client_display, client_window)
char *xipc_name;
int xipc_client_key;
caddr_t client_display;
caddr_t client_window;
{
    extern char *getenv ();
    extern struct hostent *gethostbyname ();
    char name_buffer[EBUFSIZ];
    register char *ptr;
    char *name = SERVER_ENV_NAME;
    struct hostent *server_host;
    struct sockaddr_in saddr;
    long port;
    XIpcMessage *message;
    register XIpcClient *client;
    int attempts = 0;

    if ((client = (XIpcClient *) malloc (sizeof (XIpcClient))) ==
	(XIpcClient *) NULL)
    {
	fprintf (stderr, "cannot create the client.\n");
	return (XIpcClient *) NULL;
    }
    memset (client, (char) 0, sizeof (XIpcClient));

    /*
     * check if there is a server running
     */
    if (xipc_name != (char *) NULL)
	ptr = xipc_name;
    else
	if ((ptr = getenv (name)) == NULL)
	{
	    fprintf (stderr, "%s: is not defined.\n", name);
	    free (client);
	    return (XIpcClient *) NULL;
	}
    strncpy (name_buffer, ptr, EBUFSIZ);
    for (ptr = name_buffer; *ptr; ptr++)
	if (*ptr == ':')
	    break;
    if (*ptr != ':')
    {
	fprintf (stderr, "%s=%s: no port number supplied.\n",
		 name, name_buffer);
	free (client);
	return (XIpcClient *) NULL;
    }
    *ptr++ = '\0';
    port = atol (ptr);

    if ((server_host = gethostbyname (name_buffer)) == NULL)
    {
	fprintf (stderr, "cannot get the server entry.\n");
	free (client);
	return (XIpcClient *) NULL;
    }

 CreateSocket:
    if ((client -> channel = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
	fprintf (stderr, "cannot create the client socket.\n");
	free (client);
	return (XIpcClient *) NULL;
    }

    if (xipc_fdopen (client) == FALSE)
    {
	fprintf (stderr, "Cannot create the open client socket.\n");
	close (client -> channel);
	free (client);
	return (XIpcClient *) NULL;
    }

    memset ((char *) &saddr, (char) 0, sizeof (saddr));
    memcpy (&saddr.sin_addr, server_host -> h_addr, server_host -> h_length);
    saddr.sin_family = AF_INET;
    saddr.sin_port = htons (port);
    if (connect (client -> channel, (struct sockaddr *) &saddr,
		 sizeof (saddr)) < 0)
    {
	close (client -> channel);
	xipc_fdclose (client);
	if (++attempts == 8)
	{
	    fprintf (stderr, "cannot connect to the socket.\n");
	    free (client);
	    return (XIpcClient *) NULL;
	}
	else
	{
	    sleep (1);
	    goto CreateSocket;
	}
    }

    /*
     * login
     */
    message = (XIpcMessage *) name_buffer;
    message -> type = XIPC_SERVER_NEW_CLIENT;
    if (xipc_client_key == 0)
    {
	ptr = getenv (XIPC_CLIENT_KEY);
	if (ptr == (char *) NULL)
	    xipc_client_key = 0;
	else
	    xipc_client_key = atoi (ptr);
    }
    sprintf ((char *) message -> buffer, "%d", xipc_client_key);
    message -> length = strlen ((char *) message -> buffer) + 1;
    XIpcSend (client, message);

    /*
     * wait for the return reply
     */
    if (XIpcClientMonitor (client, XIPC_MONITOR_MESSAGES, 30)
	!= XIPC_MONITOR_MESSAGES)
    {
	fprintf (stderr, "Cannot connect to the server.\n");
	close (client -> channel);
	xipc_fdclose (client);
	free (client);
	return (XIpcClient *) NULL;
    }

    message = XIpcRecvFromServer (client);
    if (message == (XIpcMessage *) NULL)
    {
	XIpcClose (client);
	free (client);
	fprintf (stderr, "Cannot connect to the server.\n");
	return (XIpcClient *) NULL;
    }
    client -> client_id = message -> client_id;

    return client;
}

void
XIpcCloseClient (client)
register XIpcClient *client;
{
    XIpcMessage message;

    message.type = XIPC_SERVER_DELETE_CLIENT;
    message.length = 0;
    message.client_id = client -> client_id;
    XIpcSendToServer (client, &message);
    XIpcClose (client);
}

void
XIpcFlushClient (client)
register XIpcClient *client;
{
    switch (XIpcSendQueue (client))
    {
    case XIPC_SENDQUEUE_DEAD:
    case XIPC_SENDQUEUE_BLOCKED:
	fprintf (stderr,"Unable to flush IPC channel.\n");
    }
}

int
XIpcClientMonitor (client, which, timeout)
register XIpcClient *client;
register int which;
int timeout;
{
    /* int max_clients = getdtablesize (); */  /* RAD - use getrlimit */
    static int max_clients = 0;
    fd_set write_select_mask;
    fd_set *writefds;
    int write_flag;
    fd_set read_select_mask;
    fd_set *readfds;
    struct timeval local_timeout;
    struct timeval *time_ptr;
    int rc;

#ifdef RLIMIT_NOFILE
    /* RAD */
    if (max_clients == 0)
    {
	struct rlimit rl;	/* RAD */

	getrlimit(RLIMIT_NOFILE, &rl);
	max_clients = (int) rl.rlim_cur;
    }
#else
    if (max_clients == 0)
	max_clients = getdtablesize ();
#endif

    if (which & XIPC_MONITOR_MESSAGES)
    {
	if (client -> channel && FD_ISSET (client -> channel,
					   &client -> select_mask))
	{
	    return XIPC_MONITOR_MESSAGES;
	}
	readfds = &client -> select_mask;
    }
    else
	readfds = &read_select_mask;

 ContinueLoop:

    do {
	FD_ZERO (readfds);
	if (which & XIPC_MONITOR_MESSAGES)
	    FD_SET (client -> channel, readfds);
	if (which & XIPC_MONITOR_KEYBOARD)
	    FD_SET (0, readfds);
	if (client -> message_queue)
	{
	    writefds = &write_select_mask;
	    FD_ZERO (writefds);
	    FD_SET (client -> channel, writefds);
	}
	else
	    writefds = (fd_set *) NULL;

	if (timeout >= 0)
	{
	    local_timeout.tv_sec = timeout;
	    local_timeout.tv_usec = 0;
	    time_ptr = &local_timeout;
	}
	else
	    time_ptr = (struct timeval *) NULL;

    } while ((rc = select (max_clients, readfds, writefds, NULL,
			   time_ptr)) < 0);

    if (client -> message_queue &&
	FD_ISSET (client -> channel, &write_select_mask))
    {
	write_flag = TRUE;
	if (XIpcSendQueue (client) == FALSE)
	{
	    FD_CLR (client -> channel, readfds);
	    XIpcCloseClient (client);
	}
    }
    else
	write_flag = FALSE;

    if (rc == 0 && timeout >= 0)
	return XIPC_MONITOR_TIMEOUT;

    if (which & XIPC_MONITOR_KEYBOARD && FD_ISSET (0, readfds))
	return XIPC_MONITOR_KEYBOARD;

    if (which & XIPC_MONITOR_MESSAGES &&
	client -> channel && FD_ISSET (client -> channel, readfds))
	return XIPC_MONITOR_MESSAGES;

    if (write_flag)
	goto ContinueLoop;

    return XIPC_MONITOR_ERROR;
}

int
XIpcSendToServer (client, message)
register XIpcClient *client;
register XIpcMessage *message;
{
    register int rc;

    message -> client_id = client -> client_id;
    rc = XIpcSend (client, message);
    if (rc == FALSE)
    {
	fprintf (stderr, "server died in send.\n");
	XIpcClose (client);
    }

    return rc;
}

XIpcMessage *
XIpcRecvFromServer (client)
register XIpcClient *client;
{
    register XIpcMessage *message;

    if (client -> recv_buffer == (unsigned char *) NULL ||
	FD_ISSET (client -> channel, &client -> select_mask) == FALSE)
	return (XIpcMessage *) NULL;

    message = XIpcRecv (client);
    if (message == (XIpcMessage *) NULL)
    {
	FD_CLR (client -> channel, &client -> select_mask);
	return (XIpcMessage *) NULL;
    }
    if (message == (XIpcMessage *) -1)
    {
	fprintf (stderr, "server died in recv.\n");
	FD_CLR (client -> channel, &client -> select_mask);
	XIpcClose (client);
	return (XIpcMessage *) NULL;
    }

    if (XIpcBufferEmpty (client))
	FD_CLR (client -> channel, &client -> select_mask);

    return message;
}
