/* static char TMXIpc_h[] = "<%W%	%D% %T%>"; */
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#ifndef _XIPC_H
#define _XIPC_H

#ifndef TRUE
#define	TRUE	1
#define	FALSE	0
#endif
	
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>
#include <fcntl.h>
#include <sys/errno.h>
#include <sys/param.h>
#include "XIpcServer.h"
#include "XIpcClient.h"
#include "C_P_args.h"

/*
 * assorted constants
 */
/*
 * size of one of our messages - must be a power of 2 and less than 64K
 */
#define XIPCBUFSIZ		(1024 * 16)

/*
 * default server name
 */
#define SERVER_ENV_NAME		"XIPC"

/*
 * strlen (SERVER_ENV_NAME)
 */
#define SERVER_NAME_SIZE	4

/*
 * 2^16 -1 - must fit in a short
 */
#define XIPC_SERVER_CLIENT_ID	65535

/*
 * size of hostname string from sys/param.h
 */
#define MACHINESIZ		MAXHOSTNAMELEN

/*
 * max length of an integer in ascii
 */
#define NUMBERLEN		11

/*
 * server token name size
 */
#define EBUFSIZ		(SERVER_NAME_SIZE + 1 + MACHINESIZ + 1 + NUMBERLEN + 1)

/*
 * number of times to read NULL before giving up on the client
 */
#define XIPC_BLOCK_COUNT	0 /* 3 */

/*
 * environment name in which the client key is stored
 */
#define XIPC_CLIENT_KEY		"XIPC_CLIENT_KEY"

/*
 * XIpcClientMonitor() and XIpcServerMonitor() return codes
 */
enum
{
    XIPC_MONITOR_ERROR		= -1,
    XIPC_MONITOR_TIMEOUT,
    XIPC_MONITOR_KEYBOARD,
    XIPC_MONITOR_MESSAGES,
    XIPC_MONITOR_BOTH
};

/*
 * XIpcSendQueue() return codes
 */
enum
{
	XIPC_SENDQUEUE_DEAD,
	XIPC_SENDQUEUE_BLOCKED,
	XIPC_SENDQUEUE_SENT
};

/*
 * the message structure - raw is used internally
 */
typedef struct XIpcMessageRaw
{
	unsigned char type[sizeof(short)];
	unsigned char client_id[sizeof(short)];
	unsigned char length[sizeof(short)];
	unsigned char buffer[sizeof(long)];	/* arbitrary length strings */
} XIpcMessageRaw;

typedef struct XIpcMessageCooked
{
	unsigned short type;
	unsigned short client_id;
	unsigned short length;
	unsigned char buffer[sizeof(long)];	/* arbitrary length strings */
} XIpcMessage;

/*
 * macros for manipulating messages
 */
#define XIPC_HEADER_SIZE	(sizeof(short) + sizeof(short) + sizeof(short))
#define XIpcToNextWord(x)	(((x) + 3) & (~03))
#define XIPC_MAX_MESSAGE_SIZE	(XIPCBUFSIZ - XIpcToNextWord(XIPC_HEADER_SIZE))

/*
 * the message link structure for saving outgoing queued messages
 */
typedef struct XIpcMessageLink
{
	struct XIpcMessageLink *next;
	int length;
	char *message;
} XIpcMessageLink;

/*
 * server ID for clients
 */
typedef unsigned short XIpcID;

/*
 * communication channel ID
 */
typedef long XIpcChannel;

/*
 * buffered I/O channels
 */
enum
{
    XIPC_WRITE_BUFFERED	= 01,
    XIPC_IOEOF 		= 02
};

typedef struct xipc_iobuf
{
    unsigned char *base;
    int base_byte_count;
    unsigned char *base_ptr;
    short status;
} xipc_iobuf;

/*
 * the client structure from the server and client side of the
 * channel
 */
typedef struct
{
	XIpcID client_id;
	int client_key;

	XIpcChannel channel;
	fd_set select_mask;

	xipc_iobuf recv_fp;
	unsigned char *recv_buffer;
	int recv_count;

	xipc_iobuf send_fp;
	XIpcMessageLink *message_queue;

	caddr_t data;
	caddr_t malloc_data;
	void (*cleanup) ();
	void (*queue_update) ();
} XIpcClient;

/*
 * the server structure
 */
typedef struct
{
	XIpcChannel channel;
	XIpcClient *clients;
	int max_clients;
	fd_set select_mask;
} XIpcServer;

C_PROTOS_BEGIN_EXTERN

/*
 * XIpc.c - support library for Servers and Clients
 */
extern int
xipc_fdopen C_P_ARGS((XIpcClient *client));

extern void
xipc_fdclose C_P_ARGS((XIpcClient *client));

extern int
xipc_fdread C_P_ARGS((XIpcClient *client, char *ptr, int count));

extern int
xipc_fdwrite C_P_ARGS((XIpcClient *client, char *ptr, int count));

extern int
xipc_fdflush C_P_ARGS((XIpcClient *client));

extern void
XIpcPrintMessage C_P_ARGS((FILE *fp, char *str, XIpcMessage *message));

extern void XIpcCatchErrors C_P_ARGS((int type, void (*user_routine)()));

extern XIpcMessage *
XIpcCopyMessage C_P_ARGS((XIpcMessage *message));

extern int
XIpcSetEnviron C_P_ARGS((char *new_env_variable));

extern int
XIpcUnsetEnviron C_P_ARGS((char *env_variable));

extern XIpcMessage *
XIpcRecv C_P_ARGS((XIpcClient *client));

extern int
XIpcSendQueue C_P_ARGS((XIpcClient *client));

extern int
XIpcSend C_P_ARGS((XIpcClient *client, XIpcMessage *message));

extern int
XIpcSynchronize C_P_ARGS((XIpcClient *client, int type));

extern int
XIpcBufferEmpty C_P_ARGS((XIpcClient *client));

extern void
XIpcClose C_P_ARGS((XIpcClient *client));

extern int
XIpcIsClientActive C_P_ARGS((XIpcClient *client));


/*
 * XIpcClient.c
 */
extern XIpcClient *
XIpcSetupClient C_P_ARGS((char *xipc_name, caddr_t client_display,
			  caddr_t client_window));

extern XIpcClient *
XIpcSetupKeyClient C_P_ARGS((char *xipc_name, int xipc_client_key,
			     caddr_t client_display, caddr_t client_window));

extern void
XIpcCloseClient C_P_ARGS((XIpcClient *client));

extern void
XIpcFlushClient C_P_ARGS((XIpcClient *client));

extern int
XIpcClientMonitor C_P_ARGS((XIpcClient *client, int which, int timeout));

extern int
XIpcSendToServer C_P_ARGS((XIpcClient *client, XIpcMessage *message));

extern XIpcMessage *
XIpcRecvFromServer C_P_ARGS((XIpcClient *client));

/*
 * XIpcCombined.c
 */
extern int
XIpcClientAndServerMonitor C_P_ARGS((XIpcClient *client, int which_client,
				     XIpcServer *server, int which_server,
				     int timeout, int *client_return,
				     int *server_return));

/*
 * XIpcServer.c
 */
extern XIpcServer *
XIpcSetupServer C_P_ARGS((char *server_display_name, caddr_t server_display,
			  caddr_t server_window, char *environment_name));

extern XIpcServer *
XIpcSetupPortServer C_P_ARGS((char *server_display_name,
			      caddr_t server_display, caddr_t server_window,
			      char *environment_name, int port_number));

extern void
XIpcCloseServer C_P_ARGS((XIpcServer *server));

extern void
XIpcFlushServer C_P_ARGS((XIpcServer *server));

extern void
XIpcServerCloseClient C_P_ARGS((XIpcServer *server,
				C_Promoted_UShort client_id));

extern int
XIpcServerMonitor C_P_ARGS((XIpcServer *server, int which, int timeout));

extern void
XIpcAcceptNewClientSocket C_P_ARGS((XIpcServer *server));

extern void
XIpcServerProcessMessage C_P_ARGS((XIpcServer *server, XIpcMessage *message));

extern int
XIpcFindClient C_P_ARGS((XIpcServer *server, XIpcChannel channel));

extern int
XIpcSendToClient C_P_ARGS((XIpcServer *server,
			   C_Promoted_UShort client_id,
			   XIpcMessage *message));

extern XIpcMessage *
XIpcRecvFromClients C_P_ARGS((XIpcServer *server));


C_PROTOS_END_EXTERN

#endif /* _XIPC_H */
