#include "XIpc.h"
#include "remote.h"
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static void
RemoteClientCleanup C_P_ARGS((XIpcClient *client));

C_PROTOS_END_EXTERN

/*
 * remote server for the remote execution system
 */
void
main (argc, argv)
int argc;
char **argv;
{
    extern char *getenv ();

    char buffer[BUFSIZ * 2];
    XIpcMessage *message, *local_message;
    char *name = REMOTE_SERVER_ENV_NAME;
    XIpcClient *client;
    int client_return;
    XIpcServer *server;
    int server_return;
    FILE *pp;
    char *ptr;
    int client_id;
    int load_client_id;

    /*
     * connect to the server that is accepting remote requests
     */
    if ((client = XIpcSetupClient (getenv (name), (caddr_t) NULL,
				   (caddr_t) NULL)) == NULL)
    {
	fprintf (stderr, "%s: Cannot establish CS ipc links.\n",
		 argv[0]);
	exit (1);
    }

    /*
     * inform the server that this process is accepting remote
     * execution requests
     */
    message = (XIpcMessage *) buffer;
    message -> type = REMOTE_SERVER_LOGIN;
    message -> length = 0;
    XIpcSendToServer (client, message);

    /*
     * create a local server environment.  If this piece of code is
     * removed then clients will login to the server that started this
     * process.  This will reduce the queing delays, but reduce the
     * number of clients that can be connected simultaneously by a
     * factor of 2.
     */
    if ((server = XIpcSetupServer ((char *) NULL, (caddr_t) NULL,
				   (caddr_t) NULL, name)) != NULL)
    {
	fprintf (stderr, "%s=%s; export %s\n",
		 name, getenv (name), name);
    }
    else
    {
	fprintf (stderr, "%s: Could not initialize the CS server.\n",
		 argv[0]);
	exit (1);
    }

    /*
     * disable errors from dead clients
     */
    XIpcCatchErrors (TRUE, NULL);

    /*
     * open a pipe to a shell to improve our REMOTE_CLIENT startup time.
     */
    if ((pp = popen ("ksh -i >/dev/null 2>/dev/null", "w"))
	== NULL)
    {
	fprintf (stderr, "%s: Server cannot start processes.\n",
		 argv[0]);
	exit (1);
    }

    /*
     * start up a load average monitor and get its id
     */
    fprintf (pp, "%s &\n", REMOTE_LOAD_AVG_PROG);
    fflush (pp);
    for (;;)
    {
	if (XIpcServerMonitor (server, XIPC_MONITOR_MESSAGES, -1) ==
	    XIPC_MONITOR_MESSAGES)
	{
	    message = XIpcRecvFromClients (server);
	    if (message == (XIpcMessage *) NULL)
		continue;

	    if (message -> type == XIPC_SERVER_NEW_CLIENT)
	    {
		load_client_id = message -> client_id;
		XIpcServerProcessMessage (server, message);
		break;
	    }
	}
    }

    /*
     * loop waiting for messages
     */
    for (;;)
    {
	if (XIpcIsClientActive (client) == FALSE)
	{
	    fprintf (stderr, "%s: lost the connection\n", argv[0]);
	    exit (1);
	}
		
	XIpcClientAndServerMonitor (client, XIPC_MONITOR_MESSAGES,
				    server, XIPC_MONITOR_MESSAGES, -1,
				    &client_return, &server_return);
	switch (client_return)
	{
	case XIPC_MONITOR_MESSAGES:
	    /*
	     * all messages from the server are for exec'ing
	     * clients.  The return client id is in the type
	     * field.
	     */
	    message = XIpcRecvFromServer (client);
	    if (message == (XIpcMessage *) NULL)
		continue;
			
	    /*
	     * startup the client with the return client
	     * id in argv[1].
	     */
	    ptr = (char *) message -> buffer;
	    while (*ptr != '\0')
	    {
		if (*ptr == ';')
		{
		    *ptr = ' ';
		    break;
		}
		ptr++;
	    }
	    fprintf (pp, "%s %d %s &\n",
		     REMOTE_CLIENT,
		     message -> type, message -> buffer);
	    fflush (pp);
	}

	switch (server_return)
	{
	case XIPC_MONITOR_MESSAGES:
	    message = XIpcRecvFromClients (server);
	    if (message == (XIpcMessage *) NULL)
		continue;
			
	    switch (message -> type)
	    {
	    case REMOTE_FORWARD:
		XIpcSendToServer (client, message);
		break;
	    case REMOTE_LOAD:
		XIpcSendToServer (client, message);
		break;
	    default:
		XIpcServerProcessMessage (server,
					  message);
		if (message -> type == XIPC_SERVER_NEW_CLIENT)
		{
    server -> clients[message -> client_id].cleanup = RemoteClientCleanup;
    server -> clients[message -> client_id].data = (caddr_t) server;
    server -> clients[message -> client_id].malloc_data = (caddr_t) load_client_id;
		}
	    }
	}
    }
}

static void
RemoteClientCleanup (client)
XIpcClient *client;
{
    static char buffer[BUFSIZ];
    XIpcMessage *message = (XIpcMessage *) buffer;
    XIpcServer *server = (XIpcServer *) client -> data;
    int load_client_id = (int) client -> malloc_data;
	
    client -> malloc_data = (caddr_t) NULL;

    message -> type = REMOTE_LOAD;
    message -> length = 0;
    XIpcSendToClient (server, load_client_id, message);
}
