#include "XIpc.h"
#include "remote.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static void
ReturnErrorMessage C_P_ARGS((XIpcClient *client, XIpcMessage *message,
			     int client_id, char *str));

C_PROTOS_END_EXTERN

/*
 * C - remote child of cs
 */
void
main (argc, argv)
int argc;
char **argv;
{
    extern char *getenv ();
    extern void ReturnErrorMessage ();
    static char error_string[BUFSIZ];
    static char buffer[BUFSIZ];
    XIpcMessage *message = (XIpcMessage *) buffer;
    XIpcClient *client;
    int client_id;
    int len1, len2;
    char *ptr1, *ptr2;
    static char command[2 * XIPCBUFSIZ];
    char *temp_file;
    int i;
    int rc;
    FILE *fp;

    if ((client = XIpcSetupClient (getenv (REMOTE_SERVER_ENV_NAME),
				   (caddr_t) NULL, (caddr_t) NULL))
	== NULL)
    {
	fprintf (stderr, "%s: Cannot establish ipc links.\n", argv[0]);
	exit (1);
    }

    if (argc < 3)
    {
	sprintf (error_string,
		 "usage: %s client_id directory <command to be run>\n",
		 argv[0]);
	if (argc < 2)
	{
	    fprintf (stderr, "%s", error_string);
	    exit (1);
	}
	ReturnErrorMessage (client, message, atoi (argv[1]),
			    error_string);
    }

    /*
     * get the return client id
     */
    client_id = atoi (argv[1]);

    /*
     * get the working directory
     */
    if (chdir (argv[2]) == -1)
    {
	sprintf (error_string, "%s: Cannot change directory to %s.\n",
		 argv[0], argv[2]);
	ReturnErrorMessage (client, message, client_id, error_string);
    }

    /*
     * create a temporary file name for output
     */
    if ((temp_file = tempnam ("/tmp", "remote")) == NULL)
    {
	sprintf (error_string, "%s: Cannot create temporary file.\n",
		 argv[0]);
	ReturnErrorMessage (client, message, client_id, error_string);
    }

    /*
     * run the command
     */
    ptr1 = command;
    for (i = 3; i < argc; i++)
    {
	ptr2 = argv[i];
	while (*ptr1 = *ptr2++)
	    ptr1++;
	*ptr1++ = ' ';
	if ((ptr1 - command) >= (2 * XIPCBUFSIZ))
	{
	    sprintf (error_string,
		     "%s: Cannot allocate space for command.\n",
		     argv[0]);
	    ReturnErrorMessage (client, message, client_id,
				error_string);
	}
    }

    *ptr1++ = ' ';
    *ptr1++ = '>';
    ptr2 = temp_file;
    while (*ptr1 = *ptr2++)
	ptr1++;
    *ptr1++ = ' ';
    *ptr1++ = '2';
    *ptr1++ = '>';
    ptr2 = temp_file;
    while (*ptr1 = *ptr2++)
	ptr1++;
    rc = system (command);

    /*
     * send the output back to the return client
     */
    if ((fp = fopen (temp_file, "r")) == NULL)
    {
	unlink (temp_file);
	sprintf (error_string,
		 "%s: cannot open the temporary file: %s\n",
		 argv[0], temp_file);
	ReturnErrorMessage (client, message, client_id, error_string);
    }
    XIpcSynchronize (client, FALSE);
    message = (XIpcMessage *) buffer;
    sprintf (message -> buffer, "%d;0;", client_id);
    len1 = strlen ((char *) message -> buffer);
    while ((len2 = fread (&message -> buffer[len1], 1,
			  XIPC_MAX_MESSAGE_SIZE - len1, fp)) != 0)
    {
	message -> type = REMOTE_FORWARD;
	message -> length = len2 + len1;
	XIpcSendToServer (client, message);
    }

    if (rc & 0277)		/* stopped via signal - ignore ptrace, etc. */
    {
	message -> type = REMOTE_FORWARD;
	sprintf (message -> buffer, "%d;0;%s", client_id,
		 (rc & 0200) ?
		 "Memory fault (coredump).\n" :
		 "Terminated via a signal.\n");
	message -> length = strlen ((char *) message -> buffer);
	XIpcSendToServer (client, message);
    }
    else
	rc = (rc >> 8) & 0377;

    message -> type = REMOTE_FORWARD;
    sprintf (message -> buffer, "%d;1;%d", client_id, rc);
    message -> length = strlen ((char *) message -> buffer);
    XIpcSendToServer (client, message);
    XIpcCloseClient (client);
    fclose (fp);
    unlink (temp_file);

    exit (0);
}

/*
 * return the error condition so that the initiating process can
 * echo the error.  This assumes message -> buffer is large
 * enough to handle the error message.
 */
static void
ReturnErrorMessage (client, message, client_id, str)
XIpcClient *client;
XIpcMessage *message;
int client_id;
char *str;
{
    message -> type = REMOTE_FORWARD;
    sprintf (message -> buffer, "%d;0;%s", client_id, str);
    message -> length = strlen ((char *) message -> buffer);
    XIpcSendToServer (client, message);

    sprintf (message -> buffer, "%d;1;%d", client_id, 1);
    message -> length = strlen ((char *) message -> buffer);
    XIpcSendToServer (client, message);
    XIpcCloseClient (client);
    exit (1);
}
