/* static char TMSMRasterP_h[] = "<%W%	%D% %T%>"; */
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

/*****************************************************************************
 **
 **   File:        SRasterP.h
 **
 **   Project:     X Widgets
 **
 **   Description: Private include file for Static Raster class widget
 **
 *****************************************************************************
 **   
 **   Copyright (c) 1988 by Hewlett-Packard Company
 **   Copyright (c) 1988 by the Massachusetts Institute of Technology
 **   
 **   Permission to use, copy, modify, and distribute this software 
 **   and its documentation for any purpose and without fee is hereby 
 **   granted, provided that the above copyright notice appear in all 
 **   copies and that both that copyright notice and this permission 
 **   notice appear in supporting documentation, and that the names of 
 **   Hewlett-Packard or  M.I.T.  not be used in advertising or publicity 
 **   pertaining to distribution of the software without specific, written 
 **   prior permission.
 **   
 *****************************************************************************
 *****************************************************************************/


/***************************************************
 *
 *  New fields for the Static Raster widget class record
 *  and the full class record.
 *
 **************************************************/

typedef struct _SMRasterClassPart
{
   int mumble;
} SMRasterClassPart;

typedef struct _XwSMRasterClassRec
{
   CoreClassPart      core_class;
#ifdef HP_WIDGETS
   XwPrimitiveClassPart primitive_class;
#endif /* HP_WIDGETS */
   SMRasterClassPart   smraster_class;
} SMRasterClassRec;

/**************************************************
 *
 *  New fields for the Static Raster instance record and
 *  the full instance record.
 *
 ***************************************************/

typedef struct _SMRasterPart
{
   XImage      * image;
   Boolean	 invert;
   Boolean	 poked;
   Boolean	 showme;
   GC            NormalGC;
   GC            InverseGC;
   char        * magstr;
   char		 magstr_store[32];
   double	 magnification;
   int		 ismapped;
   XImage      * smallimage;
#ifndef HP_WIDGETS
   XtCallbackList select;
   XtCallbackList release;
#endif
} SMRasterPart;

typedef struct _XwSMRasterRec
{
   CorePart       core;
#ifdef HP_WIDGETS
   XwPrimitivePart  primitive;
#endif /* HP_WIDGETS */
   SMRasterPart     smraster;
} SMRasterRec;


