/* static char TMNet.h[] = "<%W%	%D% %T%>"; */
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#ifndef _XtNet_h
#define _XtNet_h

/****************************************************************
 *
 * Net Widget
 *
 ****************************************************************/

/*
 * NAMING: All externally visible objects (typedefs and defines)
 * now begin with "net".  This was done to avoid name collision
 * problems in large applications.
 */

/*
 * drawing type - GXxor loses on 386's under 0L
 */
#ifdef OPENLOOK_SERVER
#define NET_GXXOR_OP	GXinvert
#else
#define NET_GXXOR_OP	GXxor
#endif

#ifndef XtRFloat
#define XtRFloat			"Float"
#endif

/*
 * pixels
 */
#define XtNnetSymbolForeground		"netSymbolForeground"
#define XtCNetSymbolForeground		"NetSymbolForeground"
#define XtNsymbolforeground		"netSymbolForeground" /* old form */
#define XtCSymbolforeground		"NetSymbolForeground"

#define XtNnetTitleForeground		"netTitleForeground"
#define XtCNetTitleForeground		"NetTitleForeground"
#define XtNtitleforeground		"netTitleForeground" /* old form */
#define XtCTitleforeground		"NetTitleForeground"

#define XtNnetLinkForeground		"netLinkForeground"
#define XtCNetLinkForeground		"NetLinkForeground"
#define XtNlinkforeground		"netLinkForeground" /* old form */
#define XtCLinkforeground		"NetLinkForeground"

/*
 * pixmaps
 */
#define XtNnetTitleBackgroundPixmap	"netTitleBackgroundPixmap"
#define XtCNetTitleBackgroundPixmap	"NetTitleBackgroundPixmap"
#define XtNtitlebackgroundPixmap	"netTitleBackgroundPixmap" /* old */
#define XtCTitlebackgroundPixmap	"NetTitleBackgroundPixmap"

#define XtNnetDrawTitleBackground	"netDrawTitleBackground"
#define XtCNetDrawTitleBackground	"NetDrawTitleBackground"
#define XtNdrawtitlebackground		"netDrawTitleBackground" /* old */
#define XtCDrawtitlebackground		"NetDrawTitleBackground"

#define XtNnetSymbolBackgroundPixmap	"netSymbolBackgroundPixmap"
#define XtCNetSymbolBackgroundPixmap	"NetSymbolBackgroundPixmap"
#define XtNsymbolbackgroundPixmap	"netSymbolBackgroundPixmap" /* old */
#define XtCSymbolbackgroundPixmap	"NetSymbolBackgroundPixmap"

#define XtNnetDrawSymbolBackground	"netDrawSymbolBackground"
#define XtCNetDrawSymbolBackground	"NetDrawSymbolBackground"
#define XtNdrawsymbolbackground		"netDrawSymbolBackground" /* old */
#define XtCDrawsymbolbackground		"NetDrawSymbolBackground"

/*
 * fonts
 */
#define XtNnetSymbolFont		"netSymbolFont"
#define XtCNetSymbolFont		"NetSymbolFont"
#define XtNsymbolfont			"netSymbolFont" /* old form */
#define XtCSymbolfont			"NetSymbolFont"

#define XtNnetTitleFont			"netTitleFont"
#define XtCNetTitleFont			"NetTitleFont"
#define XtNtitlefont			"netTitleFont" /* old form */
#define XtCTitlefont			"NetTitleFont"

/*
 * padding
 */
#define XtNnetTitleHorizSpace		"netTitleHorizSpace"
#define XtCNetTitleHorizSpace		"NetTitleHorizSpace"
#define XtNthSpace			"netTitleHorizSpace" /* old form */
#define XtCThSpace			"NetTitleHorizSpace"

#define XtNnetTitleVertSpace		"netTitleVertSpace"
#define XtCNetTitleVertSpace		"NetTitleVertSpace"
#define XtNtvSpace			"netTitleVertSpace" /* old form */
#define XtCTvSpace			"NetTitleVertSpace"

#define XtNnetSymbolHorizSpace		"netSymbolHorizSpace"
#define XtCNetSymbolHorizSpace		"NetSymbolHorizSpace"
#define XtNshSpace			"netSymbolHorizSpace" /* old form */
#define XtCShSpace			"NetSymbolHorizSpace"

#define XtNnetSymbolVertSpace		"netSymbolVertSpace"
#define XtCNetSymbolVertSpace		"NetSymbolVertSpace"
#define XtNsvSpace			"netSymbolVertSpace" /* old form */
#define XtCSvSpace			"NetSymbolVertSpace"

/*
 * constraints
 */
#define XtNnetConstrainX		"netConstrainX"
#define XtCnetConstrainX		"NetConstrainX"
#define XtNnetConstrainY		"netConstrainY"
#define XtCnetConstrainY		"NetConstrainY"

/*
 * callbacks
 */
#define XtNnetProcPoint			"netProcPoint"
#define XtNnetProcDrag			"netProcDrag"
#define XtNnetProcUpdate		"netProcUpdate"

/*
 * node, link and polygon data
 */
#define XtNnetNodeList			"netNodeList"
#define XtCNetNodeList			"NetNodeList"
#define XtNnodelist			"netNodeList" /* old form */
#define XtCNodelist			"NetNodeList"
#define XtRNetNodeList			"NetNodeList"

#define XtNnetLinkList			"netLinkList"
#define XtCNetLinkList			"NetLinkList"
#define XtNlinklist			"netLinkList" /* old form */
#define XtCLinklist			"NetLinkList"
#define XtRNetLinkList			"NetLinkList"

#define XtNnetMapPolygons		"netMapPolygons"
#define XtCNetMapPolygons		"NetMapPolygons"
#define XtNmappolygons			"netMapPolygons" /* old form */
#define XtCMappolygons			"NetMapPolygons"
#define XtRNetMapPolygons		"NetMapPolygons"

/*
 * background image
 */
#define XtNnetImage			"netImage"
#define XtCNetImage			"NetImage"
#define XtRNetImage			"Image"	  /* must match image in Xw */

#define XtNnetPolygonsAsLines		"netPolygonsAsLines"
#define XtCNetPolygonsAsLines		"NetPolygonsAsLines"
#define XtNpolygonsAsLines		"netPolygonsAsLines" /* old form */
#define XtCPolygonsAsLines		"NetPolygonsAsLines"

/*
 * start jsa additions - 10/11/90
 */
/*
 * disable background update
 */
#define XtNnetDoUpdates		"netDoUpdates"
#define XtCNetDoUpdates		"NetDoUpdates"

/*
 * node and link operations: append, update, remove
 */
#define XtNnetAddNodes			"netAddNodes"
#define XtCNetAddNodes			"NetAddNodes"

#define XtNnetUpdateNodes		"netUpdateNodes"
#define XtCNetUpdateNodes		"NetUpdateNodes"

#define XtNnetRemoveNodes		"netRemoveNodes"
#define XtCNetRemoveNodes		"NetRemoveNodes"

#define XtRNetNodeAddArray		"NetNodeAddArray"
#define XtRNetNodeRemoveArray		"NetNodeRemoveArray"
#define XtRNetNodeUpdateArray		"NetNodeUpdateArray"

#define XtNnetAddLinks			"netAddLinks"
#define XtCNetAddLinks			"NetAddLinks"

#define XtNnetUpdateLinks		"netUpdateLinks"
#define XtCNetUpdateLinks		"NetUpdateLinks"

#define XtNnetRemoveLinks		"netRemoveLinks"
#define XtCNetRemoveLinks		"NetRemoveLinks"

#define XtRNetLinkAddArray		"NetLinkAddArray"
#define XtRNetLinkRemoveArray		"NetLinkRemoveArray"
#define XtRNetLinkUpdateArray		"NetLinkUpdateArray"

/*
 * types for constructing nodes from the resource database
 */
#ifndef XtNtype
#define XtNtype				"type"
#define XtCType				"Type"
#endif
#define XtRNetNodeType			"NetNodeType"

#define XtNnodeX			"x"	/* x and y are XtRFloat's */
#define XtCNodeX			"X"

#define XtNnodeY			"y"
#define XtCNodeY			"Y"

#define XtNtitleName			"titleName"
#define XtCTitleName			"TitleName"

#define XtNtitleLabel			"titleLabel"
#define XtCTitleLabel			"TitleLabel"

#define XtNsymbolName			"symbolName"
#define XtCSymbolName			"SymbolName"

#define XtNsymbolLabel			"symbolLabel"
#define XtCSymbolLabel			"SymbolLabel"

#define XtNapplicationPtr		"applicationPtr"
#define XtCApplicationPtr		"ApplicationPtr"

/*
 * types for constructing labels from the resource database
 */
#ifndef XtNlabelType
#define XtNlabelType			"labelType"
#define XtCLabelType			"LabelType"
#endif
#define XtRNetLabelType			"NetLabelType"

#ifndef XtNname
#define XtNname				"name"
#endif
#ifndef XtCName
#define XtCName				"Name"
#endif

#ifndef XtNgraphicsFunction
#define XtNgraphicsFunction		"graphicsFunction"
#define XtCGraphicsFunction		"GraphicsFunction"
#endif
#define XtRNetGraphicsFunction		"NetGraphicsFunction"

#ifndef XtNforeground
#define XtNforeground			"foreground"
#define XtCForeground			"Foreground"
#endif

#ifndef XtNlineWidth
#define XtNlineWidth			"lineWidth"
#define XtCLineWidth			"LineWidth"
#endif

#ifndef XtNlineStyle
#define XtNlineStyle			"lineStyle"
#define XtCLineStyle			"LineStyle"
#define XtRNetLineStyle			"NetLineStyle"
#endif

#ifndef XtNsplinePoints
#define XtNsplinePoints			"splinePoints"
#define XtCSplinePoints			"SplinePoints"
#endif

#ifndef XtNfont
#define XtNfont				"font"
#define XtCFont				"Font"
#endif

#ifndef XtNboxHorizSpace
#define XtNboxHorizSpace		"boxHorizSpace"
#define XtCBoxHorizSpace		"BoxHorizSpace"
#endif

#ifndef XtNboxVertSpace
#define XtNboxVertSpace			"boxVertSpace"
#define XtCBoxVertSpace			"BoxVertSpace"
#endif

#ifndef XtNboxBackground
#define XtNboxBackground		"boxBackground"
#define XtCBoxBackground		"BoxBackground"
#endif

#ifndef XtNpixmapMask
#define XtNpixmapMask			"pixmapMask"
#define XtCPixmapMask			"PixmapMask"
#endif

/*
 * types for constructing links from the resource database
 */
#define XtNlinkType			"linkType"
#define XtCLinkType			"LinkType"
#define XtRNetLinkType			"NetLinkType"

#define XtNA				"A"	/* names for nodes of link */
#define XtNB				"B"

#define XtCNode				"Node"
#define XtRNetNode			"NetNode"

#define XtCLink				"Link"
#define XtRNetLink			"NetLink"

#define XtNline				"line"
#define XtCLine				"Line"

/*
 * types for constructing lines from the resource database
 */
#define XtNlineType			"lineType"
#define XtCLineType			"LineType"
#define XtRNetLineType			"NetLineType"

/*
 * access to live nodes and links and widget application pointer
 */
/* START HGK additions - 2/15/90 */
#define XtNnetAllNodes			"netAllNodes"
#define XtNnetAllLinks			"netAllLinks"
#define XtNallnodes			"netAllNodes" /* old form */
#define XtNalllinks			"netAllLinks"

#define XtNnetApplicationPtr		"netApplicationPtr"
#define XtCNetApplicationPtr		"NetApplicationPtr"
/* END HGK additions */

/*
 * access to callback data via resources
 */
#define XtNnetSelectionType		"netSelectionType"
#define XtCNetSelectionType		"NetSelectionType"
#define XtRNetSelectionType		"NetSelectionType"

#define XtNnetDataType			"netDataType"
#define XtCNetDataType			"NetDataType"
#define XtRNetDataType			"NetDataType"

#define XtNnetSelectedNode		"netSelectedNode"
#define XtCNetSelectedNode		"NetSelectedNode"

#define XtNnetSelectedLink		"netSelectedLink"
#define XtCNetSelectedLink		"NetSelectedLink"

#define XtNnetMouseX			"netMouseX"
#define XtCNetMouseX			"NetMouseX"

#define XtNnetMouseY			"netMouseY"
#define XtCNetMouseY			"NetMouseY"

#define XtNnetOldX			"netOldX"
#define XtCNetOldX			"NetOldX"

#define XtNnetOldY			"netOldY"
#define XtCNetOldY			"NetOldY"

/*
 * netwidget external declarations
 */
extern WidgetClass netWidgetClass;
typedef struct _NetClassRec *NetWidgetClass;
typedef struct _NetRec      *NetWidget;
extern WidgetClass netResourcesWidgetClass;

/*
 * bit macro for bit fields
 */
#define bit(n)			((unsigned long) 1 << n)

/*
 * link type field only
 */
#define NETLINKISLINE		bit(0)
#define NETLINEISPROC		bit(1)

/*
 * node type field and shared function link types
 */
#define NETTITLEISLABEL		bit(0)
#define NETTITLEISPROC		bit(1)
#define NETSYMBOLISLABEL	bit(2)
#define NETSYMBOLISPROC		bit(3)

#define NETGRAPHICS_FUNCTION	bit(4)
#define NETFOREGROUND		bit(5)
#define NETLINE_WIDTH		bit(6)
#define NETLINE_STYLE		bit(7)
#define NETFONT			bit(8)

#define NETBOXHORIZSPACE	bit(9)
#define NETBOXHSPACE		bit(9)	 /* old form */
#define NETBOXVERTSPACE		bit(10)
#define NETBOXVSPACE		bit(10)	 /* old form */
#define NETBGSUPPLIED		bit(11)
#define NETPIXMAP		bit(12)

#define NETBOXSYMBOL		bit(13)
#define NETELLIPSESYMBOL	bit(14)
#define NETCIRCLESYMBOL		bit(15)
#define NETOBLONGSYMBOL		bit(16)

#define NETBOXTITLE		bit(17)
#define NETELLIPSETITLE		bit(18)
#define NETCIRCLETITLE		bit(19)
#define NETOBLONGTITLE		bit(20)

#define NETSYMBOLSHAPE		(NETBOXSYMBOL | NETELLIPSESYMBOL | \
				 NETCIRCLESYMBOL | NETOBLONGSYMBOL)

#define NETTITLESHAPE		(NETBOXTITLE | NETELLIPSETITLE | \
				 NETCIRCLETITLE | NETOBLONGTITLE)

#define NETSHAPE		(NETSYMBOLSHAPE | NETTITLESHAPE)

#define NETSPLINELINK		bit(21)
#define NETARROWALINK		bit(22)
#define NETARROWBLINK		bit(23)
#define NETSPLINEPOINTS		bit(24)

#define NETCONSTRAINX		bit(25)
#define NETCONSTRAINY		bit(26)
#define NETUNCONSTRAINED	bit(27)

#define NETUNMOVEABLE		bit(28)
#define NETUNTOUCHABLE		bit(29)
#define NETMOVED		bit(30)
#define NETMARKBIT		bit(31)

/*
 * net procedure calling types
 */
#define NETPROCINIT		bit(1)
#define NETPROCSIZE		bit(2)
#define NETPROCDRAW		bit(3)
#define NETPROCPICK		bit(4)
#define NETPROCDESTROY		bit(5)

typedef struct			/* rectangle with signed width and height */
{
    short x;
    short y;
    short width;
    short height;
} netXSRectangle;

typedef struct
{
	float x;
	float y;
} netXFPoint;

typedef struct MapPolygon
{
	/* polygon color and points */
	char *color;
	netXFPoint *points;
	int npoints;

	/* the next element of the list */
	struct MapPolygon *next;

	/* private */
	GC gc;
	XPoint *p;
	netXSRectangle r;
} netMapPolygon;

typedef struct
{
	/* flags */
	unsigned long type;

	/* string to be displayed */
	char *name;

	/* GC related values */
	int graphics_function;
	Pixel foreground;
	int line_width;
	int line_style;
	char *font;

	/* display modifiers */
	int box_hspace;
	int box_vspace;
	Pixmap box_background;
	Pixmap pixmap;
	Pixmap pixmap_mask;

	/* private */
	netXSRectangle pixmap_rect;
	netXSRectangle string_rect;
	XFontStruct *font_struct;
	XCharStruct string_size;
	GC gc;
	GC background_gc;
	GC xor_gc;
} netLabel;
typedef netLabel * netLabelPtr;

typedef void netDrawProc;
typedef void NetDrawProc;	/* old form */

typedef struct netNode
{
	/* flags */
	unsigned long type;

	/* position in real world space */
	netXFPoint pf;

	/* title */
	union
	{
		char *name;
		netLabel *label;
		netDrawProc (*draw_proc) ();
	} title;

	/* symbol */
	union
	{
		char *name;
		netLabel *label;
		netDrawProc (*draw_proc) ();
	} symbol;

	/* pointer for application use */
	caddr_t application_ptr;

	/* extension fields */
	XPoint p;
	netXSRectangle t;
	netXSRectangle s;
	short t_width;
	short t_line_count;
	short s_width;
	short s_line_count;

	/* the next element of the list */
	struct netNode *next;
} netNode;
typedef netNode * netNodePtr;
typedef netNodePtr * netNodePtrPtr;
typedef netNodePtrPtr * netNodePtrPtrPtr;

typedef struct
{
	/* flags */
	unsigned long type;

	/* GC related values */
	int graphics_function;
	Pixel foreground;
	int line_width;
	int line_style;

	/* spline points */
	netXFPoint *spline_points;

	/* private */
	GC gc;
	GC xor_gc;
	XPoint *_spline_points;
	int _spline_count;	/* off by 2 */
} netLine;
typedef netLine * netLinePtr;

typedef struct netLink
{
	/* flags */
	unsigned long type;

	/* end points */
	netNode *A;
	netNode *B;

	/* line */
	union
	{
		netLine *line;
		netDrawProc (*draw_proc) ();
	} line;

	/* pointer for application use */
	caddr_t application_ptr;

	/* extension fields */
	netXSRectangle l;

	/* cache arrow heads */
	XPoint arrowA[3];
	XPoint arrowB[3];

	/* the next element of the list */
	struct netLink *next;
} netLink;
typedef netLink * netLinkPtr;
typedef netLinkPtr * netLinkPtrPtr;
typedef netLinkPtrPtr * netLinkPtrPtrPtr;

/*
 * select_type
 */
#define NETSELECTED		bit(1)
#define NETDRAGGED		bit(2)
#define NETRUBBERBAND		bit(3)
#define NETEXPENSIVERUBBERBAND	bit(4)
#define NETUPDATED		bit(5)

/*
 * data_type
 */
#define NETTITLE	bit(1)
#define NETSYMBOL	bit(2)
#define NETLINK		bit(3)

typedef struct
{
	int selection_type;
	int data_type;
	netNode *selected_node;
	netLink *selected_link;
	int mouse_x;
	int mouse_y;
	float old_x;
	float old_y;
	netNode *nodes;
	netLink *links;
} netCallbackData;
typedef netCallbackData NetCallbackData; /* old form */
/*
 * object selection argument block
 */
typedef struct
{
	XPoint *p;
	int return_value;
} netPickArgs;
typedef netPickArgs NetPickArgs; /* old form */

/*
 * node and link addition types - placement in the node and link lists
 */
#define NETADDFIRST	bit(1)
#define NETADDLAST	bit(2)
#define NETADDPREVIOUS	bit(3)

/*
 * begin function prototypes by file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

/*
 *  ExpandFile.c
 */
extern char *
ExpandFileName C_P_ARGS((char *string));

/*
 * Net.c
 */
/*
 * Net.c: utitity routines
 */
extern void
netCreateGCs C_P_ARGS((NetWidget w, int symbolgc, int titlegc, int linkgc,
		       int backgroundgc));

/* Boolean always_update */
extern void
netShowNetworkBackground C_P_ARGS((NetWidget w, XExposeEvent *event,
				   int always_update));

extern void
netShowNetwork C_P_ARGS((NetWidget w, XExposeEvent *event));

/*
 * Net.c: drawing support and structure maintenance
 */
extern void
netDrawLink C_P_ARGS((NetWidget w, netLink *link, Drawable d, int xor,
		      netXSRectangle *clip_rect));

extern void
netInitializeMap C_P_ARGS((NetWidget w));

extern void
netDestroyMap C_P_ARGS((NetWidget w));

extern void
netDestroyPolygon C_P_ARGS((NetWidget w, netMapPolygon *mpi));

extern void
netInitializeTitle C_P_ARGS((NetWidget w, netNode *node));

extern void
netInitializeSymbol C_P_ARGS((NetWidget w, netNode *node));

extern void
netInitializeLink C_P_ARGS((NetWidget w, netLink *link));

extern void
netDrawSpline C_P_ARGS((Display *display, Drawable d, GC gc,
			int offset_x, int offset_y, XPoint *p, int n));

extern int
netPickSpline C_P_ARGS((int x, int y, int offset_x, int offset_y, XPoint *p,
			int n));

extern void
netSplineLocateArrow C_P_ARGS((netXSRectangle *A_rect, netXSRectangle *B_rect,
			       int offset_x, int offset_y, XPoint *p,
			       int n, XPoint *a_vertex, XPoint *a_tail,
			       XPoint *b_tail, XPoint *b_vertex));

extern void
netArrowTails C_P_ARGS((int width, int height, XPoint *a, XPoint *b,
			XPoint *p1, XPoint *p2));

extern void
netSetTitleRect C_P_ARGS((NetWidget w, netNode *node));

extern void
netSetSymbolRect C_P_ARGS((NetWidget w, netNode *node));

extern void
netDrawTitle C_P_ARGS((NetWidget w, netNode *node, Drawable d, int xor,
		       netXSRectangle *clip_rect));

extern void
netDrawSymbol C_P_ARGS((NetWidget w, netNode *node, Drawable d, int xor,
			netXSRectangle *clip_rect));

extern void
netDestroyTitle C_P_ARGS((NetWidget w, netNode *node));

extern void
netDestroySymbol C_P_ARGS((NetWidget w, netNode *node));

extern void
netDestroyLabel C_P_ARGS((NetWidget w, netLabel *label));

extern void
netDestroyLink C_P_ARGS((NetWidget w, netLink *link));

extern void
netDestroyLine C_P_ARGS((NetWidget w, netLine *line));

extern void
netSetLinkRect C_P_ARGS((NetWidget w, netLink *link));

extern netXSRectangle *
netGetNodeRect C_P_ARGS((netNode *node, netXSRectangle *t));

/*
 * Net.c: support for selection
 */
extern netLink *
netPickLinks C_P_ARGS((NetWidget w, int x, int y));

extern int
netPickLink C_P_ARGS((NetWidget w, netLink *link, int x, int y));

extern void
netPickTitlesAndSymbols C_P_ARGS((NetWidget w, int x, int y,
				  int *return_type, netNode **return_node));

extern netNode *
netPickTitles C_P_ARGS((NetWidget w, int x, int y));

extern netNode *
netPickSymbols C_P_ARGS((NetWidget w, int x, int y));

/*
 * Net.c: cleanup after node movement
 */
extern void
netDragLinks C_P_ARGS((NetWidget w, netNode *node, Drawable d));

/*
 * Rectangles.c
 */
extern int
PtInRect C_P_ARGS((XPoint *p, netXSRectangle *r));

extern int
RectXRect C_P_ARGS((netXSRectangle *r, netXSRectangle *s));

extern int
RectInRect C_P_ARGS((netXSRectangle *r, netXSRectangle *s));

extern netXSRectangle *
MergeRects C_P_ARGS((netXSRectangle *r, netXSRectangle *s));

extern netXSRectangle *
MergeRectPt C_P_ARGS((netXSRectangle *r, XPoint *p));

extern XPoint
LineXRect C_P_ARGS((XPoint *p1, XPoint *p2, netXSRectangle *rect));

/*
 * SampleImg.c
 */
extern void
SampleImage C_P_ARGS((XImage *in, XImage *out));

/*
 * SetupPolys.c
 */
extern int
SetupPolygons C_P_ARGS((char *inputfile, netMapPolygon **maps));

/*
 * netAddLink.c
 */
extern void
netAddLink C_P_ARGS((NetWidget w, netLink *new_link, int add_type,
		     netLink *previous_link));

/*
 * netAddLinks.c
 */
extern void
netAddLinks C_P_ARGS((NetWidget w, int count, netLink **new_links,
		      int *add_types, netLink **previous_links));

/*
 * netAddNode.c
 */
extern void
netAddNode C_P_ARGS((NetWidget w, netNode *new_node, int add_type,
		     netNode *previous_node));

/*
 * netAddNodes.c
 */
extern void
netAddNodes C_P_ARGS((NetWidget w, int count, netNode **new_nodes,
		      int *add_types, netNode **previous_nodes));

/*
 * netCrtImg.c
 */
extern XImage *
netCreateImage C_P_ARGS((Display *display, int out_width, int out_height));

/*
 * netResources.c
 */
extern void
netResourcesInitialize C_P_NO_ARGS();

/*
 * netRmvLnk.c
 */
extern void
netRemoveLink C_P_ARGS((NetWidget w, netLink *old_link));

/*
 * netRmvLnks.c
 */
extern void
netRemoveLinks C_P_ARGS((NetWidget w, int count, netLink **old_links));

/*
 * netRmvNd.c
 */
extern void
netRemoveNode C_P_ARGS((NetWidget w, netNode *old_node));

/*
 * netRmvNds.c
 */
extern void
netRemoveNodes C_P_ARGS((NetWidget w, int count, netNode **old_nodes));

/*
 * netUpLnk.c
 */
extern void
netUpdateLink C_P_ARGS((NetWidget w, netLink *new_link, netLink *src_link));

/*
 * netUpLnks.c
 */
extern void
netUpdateLinks C_P_ARGS((NetWidget w, int count,
			 netLink *new_links, netLink **src_links));

extern void
netUpdateLinkPtrs C_P_ARGS((NetWidget w, int count,
			    netLink **new_links, netLink **src_link_ptrs));

/*
 * netUpNd.c
 */
extern void
netUpdateNode C_P_ARGS((NetWidget w, netNode *new_node, netNode *src_node));

/*
 * netUpNds.c
 */
extern void
netUpdateNodes C_P_ARGS((NetWidget w, int count,
			 netNode *new_nodes, netNode **src_nodes));

extern void
netUpdateNodePtrs C_P_ARGS((NetWidget w, int count, netNode **new_nodes,
			    netNode **src_nodes));

/*
 * end function prototypes by file
 */
C_PROTOS_END_EXTERN

#include <CreateTile.h>

#endif /* _XtNet_h */
