/*
 * File:	wx_tbar.h
 * Purpose:	
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_tbarh
#define wx_tbarh

#ifdef __GNUG__
#pragma interface
#endif

#include <common.h>

class wxToolBarTool: public wxObject
{
 public:
  wxObject *clientData;
  int index;
  float x;
  float y;
  Bool toggleState;
  Bool isToggle;
  Bool deleteSecondBitmap;
  wxBitmap *bitmap1;
  wxBitmap *bitmap2;
  
  wxToolBarTool(int theIndex, wxBitmap *bitmap1, wxBitmap *bitmap2,
                Bool toggle, wxCanvas *canvas, float xPos = -1, float yPos = -1);
  ~wxToolBarTool(void);
};

class wxToolBar: public wxCanvas
{
  wxList tools;
  int tilingDirection;
  int rowsOrColumns;
  int currentRowsOrColumns;
  float lastX;
  float lastY;
  float maxWidth;
  float maxHeight;
  float xMargin;
  float yMargin;
  int currentTool;  // Tool where mouse currently currently is
 public:

  /*
   * Public interface
   */

  wxToolBar(wxFrame *frame, int x = 0, int y = 0, int w = -1, int h = -1,
            long style = 0, int orientation = wxVERTICAL, int RowsOrColumns = 2);
  ~wxToolBar(void);

  // Handle wxWindows events
  void OnPaint(void);
  void OnSize(int w, int h);
  void OnEvent(wxMouseEvent& event);
  void OnKillFocus(void);

  // Handle wxToolBar events

  // Only allow toggle if returns TRUE
  virtual Bool OnLeftClick(int toolIndex, Bool toggleDown);
  virtual void OnRightClick(int toolIndex, float x, float y) {};

  // Called when the mouse cursor enters a tool bitmap (no button pressed).
  // Argument is -1 if mouse is exiting the toolbar.
  virtual void OnMouseEnter(int toolIndex);
  
  // If pushedBitmap is NULL, a reversed version of bitmap is
  // created and used as the pushed/toggled image.
  // If toggle is TRUE, the button toggles between the two states.
  Bool AddTool(int toolIndex, wxBitmap *bitmap, wxBitmap *pushedBitmap = NULL,
               Bool toggle = FALSE, float xPos = -1, float yPos = -1, wxObject *clientData = NULL);
  void ClearTools(void);

  void DrawTool(wxMemoryDC& memDC, wxToolBarTool *tool);
  void EnableTool(int toolIndex, Bool enable);
  void ToggleTool(int toolIndex, Bool toggle); // toggle is TRUE if toggled on
  wxObject *GetToolClientData(int index);
  inline wxList& GetTools(void) { return tools; }
  void Layout(void);

  // After the toolbar has initialized, this is the size the tools take up
  void GetMaxSize(float *w, float *h);
  Bool GetToolState(int toolIndex);
  void SetMargins(float x, float y);
  wxToolBarTool *FindToolForPosition(float x, float y);
};

#endif // wx_tbarh
