SIGN		[+-]
DIGIT		[0-9]
ALPHA		[a-zA-Z_]
ALPHADIGIT	[a-zA-Z_0-9]
STRINGCHAR	[^"\\]
WORDCHAR	[^'\\]

%{
/*
 * File:         lexer.l
 * Description:  Lexical analyser for PROLOGIO; can be used with
 *               either lex and flex.
 */
#include <string.h>
#include "expr.h"
#ifdef wx_x
extern char *malloc();
#endif
#define Return(x) return x;

static size_t lex_buffer_length = 0;
static const char *lex_buffer = NULL;
static size_t lex_string_ptr = 0;
static int lex_read_from_string = 0;


%}

%%

{SIGN}?{DIGIT}+			  {yylval.s = strdup(yytext); Return(INTEGER);}

"e"                               Return(EXP);

{ALPHA}{ALPHADIGIT}*		  {yylval.s = strdup(yytext); Return(WORD);}

"'"{WORDCHAR}*"'"	          {int len = strlen(yytext);
                                   yytext[len-1] = 0;
                                   yylval.s = strdup(yytext+1); 
                                   Return(WORD);}

\"({STRINGCHAR}|\\\"|\|\\\\|\\)*\"  {yylval.s = strdup(yytext); Return(STRING);}

"("				  Return(OPEN);

")"				  Return(CLOSE);

","				  Return(COMMA);

"["                               Return(OPEN_SQUARE);

"]"                               Return(CLOSE_SQUARE);

"="                               Return(EQUALS);

"."				  Return(PERIOD);

[ \t]				  ;

\n				  ;

"/*"    {       loop:
                          while (input() != '*');
                          switch (input())
                                  {
                                  case '/': break;
                                  case '*': unput('*');
                                  default: goto loop;
                                  }
                          }

.				  Return(ERROR);

%%

static int my_input(void);
static int my_unput(char);

#ifdef FLEX_SCANNER
#undef YY_INPUT
# define YY_INPUT(b,r,s) {int c = my_input(); r = (c == 0) ? YY_NULL : ((b)[0]=(c), 1); }
static int lex_input() {
  int ch;
  return (ch = getc(yyin)) == EOF ? 0 : ch;
}
#else	/* BSD/AT&T lex */
#ifndef input
# error "Sorry, but need either flex or AT&T lex"
#endif
static int lex_input() {
  return input();
}
# undef input
# define input() my_input()

static int my_unput(char c)
{
  if (lex_read_from_string) {
    /* Make sure we have something */
    if (lex_string_ptr) {
      if (c == '\n') yylineno--;
      lex_string_ptr--;
    }
  } else {
    unput(c);
  }
  return c;
}
# undef unput
# define unput(_c) my_unput(_c)

#endif

/* Public */ 
void LexFromFile(FILE *fd)
{
  lex_read_from_string = 0;
  yyin = fd;
  /* Don't know why this is necessary, but otherwise
   * lex only works _once_!
   */
#ifdef FLEX_SCANNER
  yy_init = 1;
#endif
}

void LexFromString(char *buffer)
{
  lex_read_from_string = 1;
  lex_buffer = buffer;
  lex_buffer_length = strlen(buffer);
  lex_string_ptr = 0;
  /* Don't know why this is necessary, but otherwise
   * lex only works _once_!
   */
#ifdef FLEX_SCANNER
  yy_init = 1;
#endif
}

static int my_input( void )
{
  if (lex_read_from_string) {
    if (lex_string_ptr == lex_buffer_length)
      return 0;
    else {
      char c = lex_buffer[lex_string_ptr++];
#ifndef FLEX_SCANNER
      if (c == '\n') yylineno++;
#endif
      return c;
    }
  } else {
    return lex_input();
  }
}


