/*
 * File:	wx_main.cc
 * Purpose:	wxApp implementation (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	August 1994
 * RCS_ID:      $Id: wx_main.cc,v 1.2 1994/08/14 21:28:43 edz Exp $
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "@(#)wx_main.cc	1.2 5/9/94";

#ifdef __GNUG__
#pragma implementation
#endif

#include <iostream.h>
#include <string.h>
#include <pwd.h>
#include <stdlib.h>

#include "common.h"
#include "wx_mgstr.h"
#include "wx_frame.h"
#include "wx_main.h"
#include "wx_utils.h"
#include "wx_gdi.h"
#include "wx_dialg.h"
#include "wx_privt.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

Colormap wxMainColormap = 0;
long wxMaxRequestSize = 0;
extern void wxFlushResources(void); // Defined in wx_utils.cc

#ifdef wx_xview
#include <xview/cms.h>
extern Xv_Server xv_default_server;
#endif

#ifdef wx_motif
#include <Xm/Xm.h>
#include <X11/Shell.h>
wxHashTable *wxWidgetHashTable = NULL;
#endif

void wxCleanUp(void);

#ifdef wx_xview
Xv_Server xview_server;
#endif

#ifdef _LINUX_DLL
#define main __linux_dll_main
#endif

int main(int argc, char *argv[])
{
  if (!wxTheApp) {
    cerr << "wxWindows error: You have to define an instance of wxApp!\n";
    exit(0);
  }

  if (!wxTheApp->wx_class)
    wxTheApp->wx_class = copystring(argv[0]);

#ifdef wx_xview
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
  xview_server = xv_default_server;
#elif defined(wx_motif)
  XtToolkitInitialize() ;
  wxTheApp->appContext = XtCreateApplicationContext() ;
  Display *dpy = XtOpenDisplay(wxTheApp->appContext,(String)NULL,NULL,
                            wxTheApp->wx_class,NULL,
# if XtSpecificationRelease < 5
                            0,(Cardinal*) &argc,argv) ;
# else
                            0,&argc,argv) ;
# endif
  if (!dpy) {
    cerr << "wxWindows could not open display for " << wxTheApp->wx_class << ": exiting.\n";
    exit(-1);
  }
  wxTheApp->topLevel = XtAppCreateShell((String)NULL,wxTheApp->wx_class,
                                     applicationShellWidgetClass,dpy,
                                     NULL,0) ;

  // Add general resize proc
  XtActionsRec rec;
  rec.string = "resize";
  rec.proc = (XtActionProc)wxWidgetResizeProc;
  XtAppAddActions(wxTheApp->appContext, &rec, 1);
  wxWidgetHashTable = new wxHashTable(wxKEY_INTEGER);
#endif
#ifdef wx_motif
  Display *display = XtDisplay(wxTheApp->topLevel);
#elif defined(wx_xview)
  Xv_Screen screen = xv_get(xview_server, SERVER_NTH_SCREEN, 0);
  Xv_opaque root_window = xv_get(screen, XV_ROOT);
  Display *display = (Display *)xv_get(root_window, XV_DISPLAY);
#endif
  wxMainColormap = DefaultColormapOfScreen(XScreenOfDisplay(display, DefaultScreen(display)));
  wxCommonInit();

  wxMaxRequestSize = XMaxRequestSize(display);

  wxTheApp->argc = argc;
  wxTheApp->argv = argv;

  wxTheApp->wx_frame = wxTheApp->OnInit();

  // In XView, must ALWAYS have a main window.
  if (wxTheApp->wx_frame)
    wxTheApp->MainLoop();

  int retValue = wxTheApp->OnExit();
  wxCleanUp();
  return retValue;
}

// Cleans up any wxWindows internal structures left lying around
void wxCleanUp(void)
{
  wxCommonCleanUp();

#ifdef wx_xview
  delete wxFontPool;
#endif
  wxFlushResources();
}

wxApp::wxApp(wxlanguage_t language):wxbApp(language)
{
  wx_frame = NULL;
  wxTheApp = this;
  death_processed = FALSE;
  work_proc = NULL ;
#ifdef wx_motif
  wx_class = NULL;
#endif
  wxSetLanguage(language);
}

wxApp::~wxApp(void)
{
}

Bool wxApp::Initialized(void)
{
  return (wx_frame != NULL);
}

/*
 * Keep trying to process messages until WM_QUIT
 * received
 */

int wxApp::MainLoop(void)
{
#ifdef wx_motif
//  XtRealizeWidget(wxTheApp->topLevel);
  if (work_proc)
    XtAppAddWorkProc(wxTheApp->appContext,(XtWorkProc)work_proc,(XtPointer)this) ;
//  XtAppMainLoop(wxTheApp->appContext);
  // Added by Hernon Otero to allow dropping out of the main loop.
  // Untested but looks ok. JACS 20/8/94
  XEvent event;
  keep_going = TRUE;
  // Use this flag to allow breaking the loop via wxApp::ExitMainLoop()
  while (keep_going) {
    XtAppNextEvent(wxTheApp->appContext, &event);
    XtDispatchEvent(&event);
  }
  return 0;
#elif defined(wx_xview)
  Frame frame = (Frame)(wx_frame->GetHandle());
  xv_main_loop(frame);
  return 0;
#endif
}

void wxApp::ExitMainLoop(void)
{
#ifdef wx_motif
  keep_going = FALSE;
#endif
#ifdef wx_xview
  notify_stop();
#endif
}

Bool wxApp::Pending(void)
{
#ifdef wx_motif
  XFlush(XtDisplay(wxTheApp->topLevel));
  return (XtAppPending(wxTheApp->appContext)) ;
#elif defined(wx_xview)
  return(FALSE) ; // Until I find what to do...
#endif
}

void wxApp::Dispatch(void)
{
#ifdef wx_motif
XEvent event;
  XtAppNextEvent(wxTheApp->appContext, &event);
  XtDispatchEvent(&event);
#elif defined(wx_xview)
  return ; // Until I found what to do...
#endif
}

void wxExit(void)
{
  int retValue = 0;
  if (wxTheApp)
    retValue = wxTheApp->OnExit();
  wxCleanUp();

  exit(retValue);
}

// Yield to incoming messages
Bool wxYield(void)
{
  while (wxTheApp && wxTheApp->Pending())
    wxTheApp->Dispatch();
  return TRUE;
}

