/*
 * File:      wx_item.cc
 * Purpose:     Panel items implementation (X version)
 * Author:      Julian Smart
 * Created:     1993
 * Updated:	August 1994
 * RCS_ID:      $Id: wx_item.cc,v 1.3 1994/08/14 21:28:43 edz Exp $
 * Copyright:   (c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "@(#)wx_item.cc	1.2 5/9/94";

#ifdef __GNUG__
#pragma implementation
#pragma implementation "wx_item.h"
#pragma implementation "wx_buttn.h"
#pragma implementation "wx_choic.h"
#pragma implementation "wx_lbox.h"
#pragma implementation "wx_rbox.h"
#pragma implementation "wx_check.h"
#pragma implementation "wx_messg.h"
#pragma implementation "wx_slidr.h"
#pragma implementation "wx_menu.h"
#pragma implementation "wx_mnuit.h"
#pragma implementation "wx_txt.h"
#pragma implementation "wx_mtxt.h"
#endif

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include "common.h"
#include "wx_mgstr.h"
#include "wx_stdev.h"
#include "wx_utils.h"
#include "wx_main.h"
#include "wx_frame.h"
#include "wx_canvs.h"
#include "wx_privt.h"

#include "wx_item.h"
#include "wx_lbox.h"
#include "wx_rbox.h"
#include "wx_buttn.h"
#include "wx_choic.h"
#include "wx_check.h"
#include "wx_messg.h"
#include "wx_slidr.h"
#include "wx_menu.h"
#include "wx_txt.h"
#include "wx_mtxt.h"

#ifdef wx_motif
// Convenience dialogs, only needed for FakePopupMenu
#include "wx_dialg.h"
#endif

#include <X11/Xutil.h>
#include <X11/keysym.h>

#ifdef wx_motif
#include <X11/IntrinsicP.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/RowColumn.h>
#include <Xm/MainW.h>
#include <Xm/DrawingA.h>
#include <Xm/CascadeBG.h>
#include <Xm/CascadeB.h>
#include <Xm/SeparatoG.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/List.h>
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/Scale.h>
#include <string.h>
extern int wxComputeColors (wxColour * backColour, wxColour * buttonColour);
void wxMenuItemCallback (Widget w, XtPointer clientData,
			 XtPointer ptr);
void wxMenuItemArmCallback (Widget w, XtPointer clientData,
			    XtPointer ptr);
void wxMenuItemDisarmCallback (Widget w, XtPointer clientData,
			       XtPointer ptr);
#endif

#ifdef wx_xview
#include <xview/panel.h>
#include <xview/openmenu.h>
#include <xview/svrimage.h>

// General purpose item notifier proc
void wxItemProc (Panel_item item, Event * event);

// Menu notifier proc
void wxMenuProc (Menu x_menu, Menu_item menu_item);
void wxMenuBarProc (Menu x_menu, Menu_item menu_item);
void wxCheckBoxProc (Panel_item item, int value, Event * x_event);
void wxChoiceProc (Panel_item item, int value, Event * event);
void wxRadioBoxProc (Panel_item item, int value, Event * event);

int wxListProc (Panel_item item, char *string, Xv_opaque client_data,
		Panel_list_op op, Event * event, int row);

Panel_setting wxTextProc (Panel_item item, Event * x_event);

void wxSliderProc (Panel_item item, int value, Event * event);

#define       checkKey        100
#define       checkString     101
#define       uncheckString   102
#define       checkState      103

#endif

#define MEANING_CHARACTER	'0'
// See above notes
static char *
fillCopy (const char *str)
{
  size_t len = strlen (str);
  char *ptr = new char[len + 1];
  // memset should be the fastest
  memset (ptr, MEANING_CHARACTER, len);
  ptr[len] = '\0';
  return ptr;
}

/* When implementing a new item, be sure to:

 * - add the item to the parent panel
 * - set window_parent to the parent
 * - NULL any extra child window pointers not created for this item
 *   (e.g. label control that wasn't needed)
 * - delete any extra child windows in the destructor (e.g. label control)
 * - implement GetSize and SetSize
 * - to find panel position if coordinates are (-1, -1), use GetPosition
 * - call AdvanceCursor after creation, for panel layout mechanism.
 *
 */

/*
   Motif notes

   A panel is a form.
   Each item is created on a RowColumn or Form of its own, to allow a label to
   be positioned. wxListBox and wxMultiText have forms, all the others have RowColumns.
   This is to allow labels to be positioned to the top left (can't do it with a
   RowColumn as far as I know).
   AttachWidget positions widgets relative to one another (left->right, top->bottom)
   unless the x, y coordinates are given (more than -1).
 */


// Item members
wxItem::wxItem (void)
{
#ifdef wx_motif
  formWidget = 0;
  labelWidget = 0;
  rowNumber = 0;
  colNumber = 0;
  itemOrientation = wxHORIZONTAL;
#endif
}

wxItem::~wxItem (void)
{
  // item may be a menu, so check.
  wxObject *obj = (wxObject *) GetParent ();
  if (!obj || !wxSubType (obj->__type, wxTYPE_PANEL))
    return;

  wxPanel *panel = (wxPanel *) GetParent ();
  // Must reset the panel since we may have dangling pointers, etc.
  if (panel)
    {
      panel->new_line = FALSE;
      panel->label_position = wxHORIZONTAL;

      panel->hSpacing = PANEL_HSPACING;
      panel->vSpacing = PANEL_VSPACING;
      panel->initial_hspacing = panel->hSpacing;
      panel->initial_vspacing = panel->vSpacing;
      panel->current_hspacing = panel->hSpacing;
      panel->current_vspacing = panel->vSpacing;
#ifdef wx_motif
      panel->cursor_x = PANEL_LEFT_MARGIN;
      panel->cursor_y = PANEL_TOP_MARGIN;
      panel->max_height = 0;
      panel->max_line_height = 0;
      panel->max_width = 0;
      panel->firstRowWidget = 0;
      panel->currentRow = 0;
      panel->currentCol = 0;
      panel->last_created = 0;
#endif
    }

#ifdef wx_motif
  if (labelWidget && (labelWidget != (Widget) handle))
    XtDestroyWidget (labelWidget);

  if (formWidget)
    {
      wxWidgetHashTable->Delete ((long) formWidget);
      if (formWidget)
	XtDestroyWidget (formWidget);

      // Necessary, to avoid ~wxWindow to (re)delete the Widget!!
      // (because all formWidget subtree has been deleted)
      handle = (char *) NULL;
    }
#endif
}

void wxItem::GetSize (int *width, int *height)
{
#ifdef wx_motif
  Dimension xx, yy;
  XtVaGetValues (formWidget, XmNwidth, &xx, XmNheight, &yy, NULL);
  *width = xx;
  *height = yy;
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  Rect *rect = (Rect *) xv_get (item, XV_RECT);

  *height = rect->r_height;
  *width = rect->r_width;
#endif
}

void wxItem::GetPosition (int *x, int *y)
{
#ifdef wx_motif
  Dimension xx, yy;
  XtVaGetValues (formWidget, XmNx, &xx, XmNy, &yy, NULL);
  *x = xx;
  *y = yy;
#endif
#ifdef wx_xview
  Xv_opaque x_win = (Xv_opaque) handle;

  *x = (int) xv_get (x_win, XV_X);
  *y = (int) xv_get (x_win, XV_Y);
#endif
}

void wxItem::SetSize (int x, int y, int width, int height)
{
#ifdef wx_motif
  XtUnmanageChild (formWidget);

  if (x > -1)
    XtVaSetValues (formWidget, XmNleftAttachment, XmATTACH_SELF,
		   XmNx, x,
		   NULL);
  if (y > -1)
    XtVaSetValues (formWidget, XmNtopAttachment, XmATTACH_SELF,
		   XmNy, y,
		   NULL);
  if (width > -1)
    XtVaSetValues (formWidget, XmNwidth, width, NULL);
  if (height > -1)
    XtVaSetValues (formWidget, XmNheight, height, NULL);

  XtManageChild (formWidget);

  OnSize (width, height);
#endif
#ifdef wx_xview
  Xv_opaque x_win = (Xv_opaque) handle;

  if (x > -1)
    (void) xv_set (x_win, XV_X, x, NULL);

  if (y > -1)
    (void) xv_set (x_win, XV_Y, y, NULL);

  if (width > -1)
    (void) xv_set (x_win, XV_WIDTH, width, NULL);

  if (height > -1)
    (void) xv_set (x_win, XV_HEIGHT, height, NULL);
  OnSize (width, height);
#endif
}

void wxItem::SetLabel (char *label)
{
#ifdef wx_motif
  if (!labelWidget)
    return;

  XmString text = XmStringCreateSimple (label);
  XtVaSetValues (labelWidget,
		 XmNlabelString, text,
		 NULL);
  XmStringFree (text);
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  xv_set (item, PANEL_LABEL_STRING, label, NULL);
#endif
}

char *wxItem::GetLabel (void)
{
#ifdef wx_motif
  if (!labelWidget)
    return NULL;

  XmString text;
  char *s;
  XtVaGetValues (labelWidget,
		 XmNlabelString, &text,
		 NULL);

  if (XmStringGetLtoR (text, XmSTRING_DEFAULT_CHARSET, &s))
    {
      strcpy (wxBuffer, s);
      XtFree (s);
      return wxBuffer;
    }
  else
    {
      return NULL;
    }
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  strcpy (wxBuffer, (char *) xv_get (item, PANEL_LABEL_STRING));
  return wxBuffer;
#endif
}


void wxItem::SetFocus (void)
{
#ifdef wx_motif
  wxWindow::SetFocus ();
#endif
#ifdef wx_xview
#endif
}

void wxItem::Show (Bool show)
{
#ifdef wx_motif
  if (formWidget)
    {
      if (show)
	XtManageChild (formWidget);
      else
	XtUnmanageChild (formWidget);
    }
#endif
#ifdef wx_xview
  Xv_opaque window = (Xv_opaque) handle;
  xv_set (window, XV_SHOW, show, NULL);
#endif
}

void wxItem::Enable (Bool enable)
{
#ifdef wx_motif
  wxWindow::Enable (enable);
#endif
#ifdef wx_xview
  Xv_opaque window = (Xv_opaque) handle;
  if (window)
    xv_set (window, PANEL_INACTIVE, !enable, NULL);
#endif
}

float wxItem::GetCharHeight (void)
{
#ifdef wx_motif
  return 0.0;
#endif
#ifdef wx_xview
  Xv_Font the_font;

  if (!(font && font->x_font))
    {
      Xv_opaque thing = (Xv_opaque) (GetParent ()->handle);
      the_font = (Xv_Font) xv_get (thing, XV_FONT);
    }
  else
    the_font = font->x_font;

  return (float) xv_get (the_font, FONT_DEFAULT_CHAR_HEIGHT);
#endif
}

float wxItem::GetCharWidth (void)
{
#ifdef wx_motif
  return 0.0;
#endif
#ifdef wx_xview
  Xv_Font the_font;

  if (!(font && font->x_font))
    {
      Xv_opaque thing = (Xv_opaque) (GetParent ()->handle);
      the_font = (Xv_Font) xv_get (thing, XV_FONT);
    }
  else
    the_font = font->x_font;

  return (float) xv_get (the_font, FONT_DEFAULT_CHAR_WIDTH);
#endif
}

void wxItem::GetTextExtent (const char *string, float *x, float *y,
	       float *descent, float *externalLeading,
	       wxFont * the_font)
{
#ifdef wx_motif
  if (!(font && font->xFont))
#endif
#ifdef wx_xview
    if (!(font && font->x_font))
#endif
      {
	cerr << "wxWindows warning - set a font before calling GetTextExtent!\n";
	*x = -1;
	*y = -1;
	return;
      }
#ifdef wx_motif
  XFontStruct *fontStruct = font->xFont;
#endif
#ifdef wx_xview
  XFontStruct *fontStruct = (XFontStruct *) xv_get (font->x_font, FONT_INFO);
#endif
  int direction, ascent, descent2;
  XCharStruct overall;
  XTextExtents (fontStruct, string, strlen (string), &direction, &ascent,
		&descent2, &overall);
  *x = overall.width;
  *y = ascent + descent2;
  if (descent)
    *descent = (float) descent2;
  if (externalLeading)
    *externalLeading = 0.0;
}

/*
 * Attach new widget to last widget, or below previous widget of
 * previous row if we've had a new line
 */

#ifdef wx_motif
void wxItem::AttachWidget (wxPanel * panel, Widget formWidget,
	      int x, int y, int width, int height)
{
  if ((x > -1) || (y > -1))
    panel->allRelative = FALSE;

  itemOrientation = panel->label_position;

  if (wxWidgetHashTable->Get ((long) formWidget))
    {
      wxError ("Widget table clash in wx_item.cc");
    }
  wxWidgetHashTable->Put ((long) formWidget, this);
  XtTranslations ptr;
  XtOverrideTranslations (formWidget,
		   ptr = XtParseTranslationTable ("<Configure>: resize()"));
  XtFree ((char *) ptr);

  panel->GetValidPosition (&x, &y);
  SetSize (x, y, width, height);
  panel->AdvanceCursor (this);

  panel->current_hspacing = panel->hSpacing;
  panel->current_vspacing = panel->vSpacing;
}

void wxPanel::OptimizeLayout (void)
{
/*
   // If all the Motif widgets are relatively-spaced, we may be able
   // to conform better to Motif standards by setting some bottom and right
   // widget attachments to the panel form.
   // This attachs the first widget in the last row to the bottom of the form
   // DOESN'T WORK, but maybe someone will think of an optimization that
   // could be done. Just elongates the first widget when you resize the panel.

   if (allRelative && (GetChildren()->Number() > 0)) {
     wxItem *lastItem = (wxItem *)(GetChildren()->Last()->Data());
     for(wxNode *node = GetChildren()->First(); node; node = node->Next()) {
       wxItem *item = (wxItem *)node->Data();
       if (item->rowNumber == lastItem->rowNumber) {
         XtVaSetValues(item->formWidget,
                     XmNbottomAttachment, XmATTACH_FORM,
                     XmNbottomOffset, vSpacing,
                     NULL);
         break;
       }
     }    // while
   }
 */
}
#endif

#ifdef wx_motif
void 
wxButtonCallback (Widget w, XtPointer clientData, XtPointer ptr)
{
  if (!wxWidgetHashTable->Get ((long) w))
    // Widget has been deleted!
    return;

  wxButton *item = (wxButton *) clientData;
  wxCommandEvent event (wxEVENT_TYPE_BUTTON_COMMAND);
  event.eventObject = item;
  item->ProcessCommand (event);
}
#endif

// Button item notifier

#ifdef wx_xview
void 
wxItemProc (Panel_item x_item, Event * x_event)
{
  wxButton *item = (wxButton *) xv_get (x_item, PANEL_CLIENT_DATA);

  wxCommandEvent event (wxEVENT_TYPE_BUTTON_COMMAND);
  event.eventObject = item;
  item->ProcessCommand (event);
}
#endif

wxButton::wxButton (void)
{
  buttonBitmap = NULL;
}

wxButton::wxButton (wxPanel * panel, wxFunction Function, char *label,
	  int x, int y, int width, int height, long style, char *name):
wxbButton (panel, Function, label, x, y, width, height, style, name)
{
  Create (panel, Function, label, x, y, width, height, style, name);
}

wxButton::wxButton (wxPanel * panel, wxFunction Function, wxBitmap * bitmap,
	  int x, int y, int width, int height, long style, char *name):
wxbButton (panel, Function, bitmap, x, y, width, height, style, name)
{
  Create (panel, Function, bitmap, x, y, width, height, style, name);
}

Bool wxButton::Create (wxPanel * panel, wxFunction Function, char *label,
	int x, int y, int width, int height, long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  buttonBitmap = NULL;
  window_parent = panel;
  windowStyle = style;

  Callback (Function);
  labelPosition = wxHORIZONTAL;

#ifdef wx_motif
  windowName = copystring (name);

  Widget panelForm = panel->panelWidget;
  if (!label)
    label = " ";
  XmString text = XmStringCreateSimple (label);

  formWidget = XtVaCreateManagedWidget (windowName,
					xmFormWidgetClass, panelForm,
					XmNmarginHeight, 0,
					XmNmarginWidth, 0,
					NULL);

  /*
   * Patch Note (important)
   * There is no major reason to put a defaultButtonThickness here.
   * Not requesting it give the ability to put wxButton with a spacing
   * as small as requested. However, if some button become a DefaultButton,
   * other buttons are no more aligned -- This is why we set
   * defaultButtonThickness of ALL buttons belonging to the same wxPanel,
   * in the ::SetDefaultButton method.
   */
  Widget buttonWidget = XtVaCreateManagedWidget ("button",
  // Gadget causes problems for default button operation.
  // Ah! But now you can create wxButton which have 'problems' with
  // the wxCOLOURED flag. And we are both happy!!
  // [It seems to me that it's better to use as MANY gadgets as possible...]
  // Now #ifdefed independently, JACS 25/4/93
#if (USE_GADGETS && USE_BUTTON_GADGET)
						 style & wxCOLOURED ?
			  xmPushButtonWidgetClass : xmPushButtonGadgetClass,
						 formWidget,
#else
					xmPushButtonWidgetClass, formWidget,
#endif
						 XmNlabelString, text,
//                  XmNdefaultButtonShadowThickness, 1, // See comment for wxButton::SetDefault
					    XmNtopAttachment, XmATTACH_FORM,
					   XmNleftAttachment, XmATTACH_FORM,
					 XmNbottomAttachment, XmATTACH_FORM,
					  XmNrightAttachment, XmATTACH_FORM,
						 NULL);

  // Record in case button callback gets called after the widget has
  // been deleted.
  wxWidgetHashTable->Put ((long) buttonWidget, this);

  if (buttonFont)
    XtVaSetValues (buttonWidget,
		   XmNfontList, buttonFont->GetInternalFont (),
		   NULL);

  handle = (char *) buttonWidget;

  XmStringFree (text);

  XtAddCallback (buttonWidget, XmNactivateCallback, (XtCallbackProc) wxButtonCallback,
		 (XtPointer) this);

  AttachWidget (panel, formWidget, x, y, width, height);
  ChangeColour ();
#endif
#ifdef wx_xview
  Panel x_panel = (Panel) (panel->GetHandle ());
  Panel_item x_button;

  if (panel->new_line)
    {
      x_button = (Panel_item) xv_create (x_panel, PANEL_BUTTON, PANEL_LAYOUT, PANEL_HORIZONTAL, PANEL_NEXT_ROW, -1, NULL);
      panel->new_line = FALSE;
    }
  else
    x_button = (Panel_item) xv_create (x_panel, PANEL_BUTTON, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL);

  xv_set (x_button,
	  PANEL_LABEL_STRING, label,
	  PANEL_NOTIFY_PROC, wxItemProc,
	  PANEL_CLIENT_DATA, (char *) this,
	  NULL);
/*
   Doesn't seem to works
   if (buttonFont)
   xv_set(x_button, XV_FONT, buttonFont->GetInternalFont(), NULL) ;
 */
  if (x > -1 && y > -1)
    (void) xv_set (x_button, XV_X, x, XV_Y, y, NULL);

  if (width > 0)
    {
      xv_set (x_button, PANEL_LABEL_WIDTH, (int) width, NULL);
    };

  handle = (char *) x_button;
#endif
  return TRUE;
}

Bool wxButton::Create (wxPanel * panel, wxFunction Function, wxBitmap * bitmap,
	int x, int y, int width, int height, long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  buttonBitmap = bitmap;
  window_parent = panel;
  windowStyle = style;

  Callback (Function);
  labelPosition = wxHORIZONTAL;

#ifdef wx_motif
  windowName = copystring (name);

  Widget panelForm = panel->panelWidget;

  formWidget = XtVaCreateManagedWidget (windowName,
					xmFormWidgetClass, panelForm,
					NULL);

  /*
   * Patch Note (important)
   * There is no major reason to put a defaultButtonThickness here.
   * Not requesting it give the ability to put wxButton with a spacing
   * as small as requested. However, if some button become a DefaultButton,
   * other buttons are no more aligned -- This is why we set
   * defaultButtonThickness of ALL buttons belonging to the same wxPanel,
   * in the ::SetDefaultButton method.
   */
  Widget buttonWidget = XtVaCreateManagedWidget ("button",
  // Gadget causes problems for default button operation.
  // Ah! But now you can create wxButton which have 'problems' with
  // the wxCOLOURED flag. And we are both happy!!
  // [It seems to me that it's better to use as MANY gadgets as possible...]
#if (USE_GADGETS && USE_BUTTON_GADGET)
						 style & wxCOLOURED ?
			  xmPushButtonWidgetClass : xmPushButtonGadgetClass,
						 formWidget,
#else
					xmPushButtonWidgetClass, formWidget,
#endif
//                  XmNdefaultButtonShadowThickness, 1, // See comment for wxButton::SetDefault
					    XmNtopAttachment, XmATTACH_FORM,
					   XmNleftAttachment, XmATTACH_FORM,
					 XmNbottomAttachment, XmATTACH_FORM,
					  XmNrightAttachment, XmATTACH_FORM,
						 NULL);

  // Record in case button callback gets called after the widget has
  // been deleted.
  wxWidgetHashTable->Put ((long) buttonWidget, this);

  handle = (char *) buttonWidget;

  // Yes, this is useful, even if we are setting a wxBitmap*, because
  // one can call ::SetLabel(char*) on this item!
  if (buttonFont)
    XtVaSetValues (buttonWidget,
		   XmNfontList, buttonFont->GetInternalFont (),
		   NULL);

  XtVaSetValues (buttonWidget,
		 XmNlabelPixmap, bitmap->GetLabelPixmap (buttonWidget),
	  XmNlabelInsensitivePixmap, bitmap->GetInsensPixmap (buttonWidget),
		 XmNarmPixmap, bitmap->GetArmPixmap (buttonWidget),
		 XmNlabelType, XmPIXMAP,
		 NULL);

  XtAddCallback (buttonWidget, XmNactivateCallback, (XtCallbackProc) wxButtonCallback,
		 (XtPointer) this);

  AttachWidget (panel, formWidget, x, y, width, height);
  ChangeColour ();
#endif
#ifdef wx_xview
  Panel x_panel = (Panel) (panel->GetHandle ());
  Panel_item x_button;

  if (panel->new_line)
    {
      x_button = (Panel_item) xv_create (x_panel, PANEL_BUTTON, PANEL_LAYOUT, PANEL_HORIZONTAL, PANEL_NEXT_ROW, -1, NULL);
      panel->new_line = FALSE;
    }
  else
    x_button = (Panel_item) xv_create (x_panel, PANEL_BUTTON, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL);

  xv_set (x_button,
	  PANEL_NOTIFY_PROC, wxItemProc,
	  PANEL_CLIENT_DATA, (char *) this,
	  NULL);
/*
   if (buttonFont)
   xv_set(x_button, XV_FONT, buttonFont->GetInternalFont(), NULL) ;
 */
  if (x > -1 && y > -1)
    (void) xv_set (x_button, XV_X, x, XV_Y, y, NULL);

  if (width > 0)
    {
      xv_set (x_button, PANEL_LABEL_WIDTH, (int) width, NULL);
    };

  xv_set (x_button, PANEL_LABEL_IMAGE, bitmap->x_image, NULL);

  handle = (char *) x_button;
#endif
  return TRUE;
}

wxButton::~wxButton (void)
{
#ifdef wx_motif
  wxWidgetHashTable->Delete ((long) handle);
#endif
}

void wxButton::ChangeColour (void)
{
#ifdef wx_motif
  int change;

  wxPanel *panel = (wxPanel *) window_parent;
  change = wxComputeColors (panel->backColour,
			    panel->buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues (formWidget,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues (formWidget,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  change = wxComputeColors (backColour, buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues ((Widget) handle,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues ((Widget) handle,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  if (buttonBitmap)
    XtVaSetValues ((Widget) handle,
	     XmNlabelPixmap, buttonBitmap->GetLabelPixmap ((Widget) handle),
		   XmNlabelInsensitivePixmap, buttonBitmap->GetInsensPixmap ((Widget) handle),
		 XmNarmPixmap, buttonBitmap->GetArmPixmap ((Widget) handle),
		   NULL);

#endif
}

void wxButton::SetSize (int x, int y, int width, int height)
{
  wxItem::SetSize (x, y, width, height);
#ifdef wx_motif
  if (width > -1)
    XtVaSetValues ((Widget) handle, XmNwidth, width,
		   NULL);
  if (height > -1)
    XtVaSetValues ((Widget) handle, XmNheight, height,
		   NULL);
#endif
#ifdef wx_xview
#endif
  OnSize (width, height);
}

void wxButton::SetLabel (char *label)
{
#ifdef wx_motif
  Widget widget = (Widget) handle;
  if (label)
    {
      XmString text = XmStringCreateSimple (label);
      XtVaSetValues (widget,
		     XmNlabelString, text,
		     XmNlabelType, XmSTRING,
		     NULL);
      XmStringFree (text);
    }
#endif
#ifdef wx_xview
  if (label)
    {
      Panel_item item = (Panel_item) handle;
      xv_set (item, PANEL_LABEL_STRING, label, NULL);
    }
#endif
}

void wxButton::SetLabel (wxBitmap * bitmap)
{
  buttonBitmap = bitmap;
#ifdef wx_motif
  Widget widget = (Widget) handle;
  if (bitmap)
    {
      XtVaSetValues (widget,
		     XmNlabelPixmap, bitmap->GetLabelPixmap (widget),
		XmNlabelInsensitivePixmap, bitmap->GetInsensPixmap (widget),
		     XmNarmPixmap, bitmap->GetArmPixmap (widget),
		     XmNlabelType, XmPIXMAP,
		     NULL);
    }
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  xv_set (item, PANEL_LABEL_IMAGE, bitmap->x_image, NULL);
#endif
}

char *wxButton::GetLabel (void)
{
#ifdef wx_motif
  Widget widget = (Widget) handle;
  XmString text;
  char *s;
  XtVaGetValues (widget,
		 XmNlabelString, &text,
		 NULL);

  if (XmStringGetLtoR (text, XmSTRING_DEFAULT_CHARSET, &s))
    {
      strcpy (wxBuffer, s);
      XtFree (s);
      return wxBuffer;
    }
  else
    {
      return NULL;
    }
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  strcpy (wxBuffer, (char *) xv_get (item, PANEL_LABEL_STRING));
  return wxBuffer;
#endif
}

void wxButton::SetDefault (void)
{
  wxPanel *panel = (wxPanel *) GetParent ();
  if (panel)
    panel->defaultItem = this;

#ifdef wx_motif			// BUGBUG: NB CHECK FOLLOWING WORKS
  // We initially do not set XmNdefaultShadowThickness, to have small buttons.
  // Unfortunattelly, buttons are now mis-aligned. We try to correct this
  // now -- setting this ressource to 1 for each button in the same row.
  // Because it's very hard to find wxButton in the same row,
  // correction is straighforward: we set resource for all wxButton
  // in this wxPanel (but not sub panels)
  for (wxNode * node = panel->GetChildren ()->First (); node; node = node->Next ())
    {
      wxButton *item = (wxButton *) node->Data ();
      if (wxSubType (item->__type, wxTYPE_BUTTON))
	{
          XtUnmanageChild (item->formWidget);

	  XtVaSetValues ((Widget) (item->handle),
			 XmNdefaultButtonShadowThickness, 1,
			 NULL);

          XtManageChild (item->formWidget);
	}
    }				// while

//  XtVaSetValues((Widget)handle, XmNshowAsDefault, 1, NULL);
  XtVaSetValues ((Widget) panel->handle, XmNdefaultButton, (Widget) handle, NULL);
#endif
#ifdef wx_xview
  if (panel)
    {
      xv_set ((Panel) panel->handle, PANEL_DEFAULT_ITEM, (Panel_item) handle, 0);
    }
#endif
}

void wxButton::Command (wxCommandEvent & event)
{
#ifdef wx_motif
  // How do we fill in this event structure.
  XButtonEvent buttonEvent;
  XtCallActionProc ((Widget) handle, "ArmAndActivate", (XEvent *) & buttonEvent, NULL, 0);
#endif
#ifdef wx_xview
  wxbButton::Command (event);
#endif
}

// Menus

// Construct a menu with optional title (then use append)
wxMenu::wxMenu (char *Title, wxFunction func): wxbMenu (Title, func)
{
  no_items = 0;
  menu_bar = NULL;
//  title = NULL; // Initialized by base class.
#ifdef wx_motif
  numColumns = 1;
  buttonWidget = NULL;
  handle = NULL;
  top_menu = NULL;
  menuId = 0;
  menuItems.DeleteContents (TRUE);

  if (title)
    {
      Append (-2, title);
      AppendSeparator ();
    }
#endif
#ifdef wx_xview
  panelItem = NULL;
  Menu x_menu = (Menu) xv_create ((Xv_opaque) NULL, MENU, MENU_CLIENT_DATA, (char *) this, NULL);
  if (title)
    {
      title = copystring (title);
      xv_set (x_menu, MENU_TITLE_ITEM, title, NULL);
    }
  handle = (char *) x_menu;
  top_level_menu = this;
#endif // wx_xview
  Callback (func);
}

// The wxWindow destructor will take care of deleting the submenus.
wxMenu::~wxMenu (void)
{
  for (wxNode * node = menuItems.First (); node; node = node->Next ())
    {
      wxMenuItem *item = (wxMenuItem *) node->Data ();
      item->menuBar = NULL;
#ifdef wx_motif
      if (item->itemId == -2)
	{
	  ;			// Nothing

	}
      else if (item->itemName && (!item->subMenu))
	{
	  if (item->buttonWidget)
	    {
	      if (item->checkable)
		XtRemoveCallback (item->buttonWidget, XmNvalueChangedCallback,
				  wxMenuItemCallback, (XtPointer) item);
	      else
		XtRemoveCallback (item->buttonWidget, XmNactivateCallback,
				  wxMenuItemCallback, (XtPointer) item);
	      XtRemoveCallback (item->buttonWidget, XmNarmCallback,
				wxMenuItemArmCallback, (XtPointer) item);
	      XtRemoveCallback (item->buttonWidget, XmNdisarmCallback,
				wxMenuItemDisarmCallback, (XtPointer) item);
	    }
	}
      else if (item->itemId == -1)
	{
	  ;			// Nothing

	}
      else if (item->subMenu)
	{
	  if (item->buttonWidget)
	    {
	      XtRemoveCallback (item->buttonWidget, XmNcascadingCallback,
				wxMenuItemArmCallback, (XtPointer) item);
//        XtRemoveCallback(item->buttonWidget, XmNdisarmCallback,
	      //                         wxMenuItemDisarmCallback, (XtPointer)item);

	    }
	}
#endif
//    delete item; // NO!!!! The wxList is DeleteContents(TRUE)
    }				// for()

}

void wxMenu:: Break (void)
{
#ifdef wx_motif
  numColumns++;
#endif
#ifdef wx_xview
  Menu menu = (Menu) handle;
  xv_set (menu, MENU_NCOLS, xv_get (menu, MENU_NCOLS) + 1, NULL);
#endif
}

// Ordinary menu item
void wxMenu:: Append (int Id, char *Label, char *helpString, Bool checkable)
{
  wxMenuItem *item = new wxMenuItem;
  item->checkable = checkable;
  item->itemId = Id;
  item->itemName = copystring (Label);
  item->subMenu = NULL;
  if (helpString)
    item->helpString = copystring (helpString);

  menuItems.Append (item);

#ifdef wx_motif
  item->buttonWidget = NULL;
  if (handle)
    item->CreateItem ((Widget) handle, menu_bar, top_menu);	// this is a dynamic Append
#endif
#ifdef wx_xview
  Menu menu = (Menu) handle;
  wxStripMenuCodes (Label, wxBuffer);
  char *p = copystring (wxBuffer);

  Menu_item mi = (Menu_item) xv_create ((Xv_opaque) NULL, MENUITEM,
					MENU_RELEASE,
					MENU_STRING, p,
					MENU_NOTIFY_PROC, wxMenuProc,
					MENU_CLIENT_DATA, (char *) Id,
					XV_KEY_DATA, checkKey, checkable,
					NULL);

  if (mi)
    xv_set (menu, MENU_APPEND_ITEM, mi, NULL);
  if (mi && checkable)
    {
      char *checked = new char[strlen (p) + 2];
      sprintf (checked, "%s*", p);
      xv_set (mi,
	      XV_KEY_DATA, checkString, checked,
	      XV_KEY_DATA, uncheckString, p,
	      NULL);
    }
#endif // wx_xview
  no_items++;
}

void wxMenu:: AppendSeparator (void)
{
  wxMenuItem *item = new wxMenuItem;
  item->itemId = -1;
  item->checkable = FALSE;
  menuItems.Append (item);

#ifdef wx_motif
  item->buttonWidget = NULL;
  if (handle)
    item->CreateItem ((Widget) handle, menu_bar, top_menu);	// this is a dynamic Append
#endif
#ifdef wx_xview
/* HOW DO WE GET A SEPARATOR IN XVIEW?!
 * This makes far too much space.
 */

  Menu menu = (Menu) handle;
  Menu_item mi = (Menu_item) xv_create ((Xv_opaque) NULL,
					MENUITEM_SPACE,
					XV_KEY_DATA, checkKey, FALSE,
					NULL);

  if (mi)
    xv_set (menu, MENU_APPEND_ITEM, mi, NULL);

/***
This was a try to get a line separator, using private attributes.
But that doesn't works...
  Menu menu = (Menu)handle ;
  int n = xv_get(menu,MENU_NITEMS) ;
  Menu_item mi = xv_get(menu,MENU_NTH_ITEM,n) ;
  xv_set(mi,MENU_LINE_AFTER_ITEM,MENU_HORIZONTAL_LINE,NULL) ;
***/

#endif
}

// Pullright item
void wxMenu:: Append (int Id, char *Label, wxMenu * SubMenu, char *helpString)
{
  SubMenu->top_level_menu = top_level_menu;
  SubMenu->window_parent = this;
  children->Append (SubMenu);	// Store submenu for later deletion

  wxMenuItem *item = new wxMenuItem;
  item->checkable = FALSE;
  item->itemId = Id;
  item->itemName = copystring (Label);
  if (helpString)
    item->helpString = copystring (helpString);

  item->subMenu = SubMenu;
  menuItems.Append (item);

#ifdef wx_motif
  item->buttonWidget = NULL;
  if (handle)
    item->CreateItem ((Widget) handle, menu_bar, top_menu);	// this is a dynamic Append
#endif
#ifdef wx_xview
  Menu menu = (Menu) handle;
  wxStripMenuCodes (Label, wxBuffer);

  Menu x_submenu = (Menu) (SubMenu->GetHandle ());
  char *p = copystring (wxBuffer);
  Menu_item mi = (Menu_item) xv_create ((Xv_opaque) NULL, MENUITEM,
					MENU_RELEASE,
					MENU_STRING, p,
					MENU_NOTIFY_PROC, wxMenuProc,
					MENU_PULLRIGHT, x_submenu,
					MENU_CLIENT_DATA, (char *) Id,
					XV_KEY_DATA, checkKey, FALSE,
					NULL);
  if (mi)
    xv_set (menu, MENU_APPEND_ITEM, mi, NULL);

#endif // wx_xview

  no_items++;
}

void wxMenu:: Enable (int Id, Bool Flag)
{
#ifdef wx_motif
  wxMenuItem *it = NULL;
  Widget w = FindMenuItem (Id, &it);

  if (it)
    it->isEnabled = Flag;

  if (w)
    {
      if (w)
	XtSetSensitive (w, Flag);
      return;
    }
#endif
#ifdef wx_xview
  Menu menu = (Menu) handle;
  int n = (int) xv_get (menu, MENU_NITEMS);
  for (int i = 1; i <= n; i++)
    {
      Menu_item item = FindMenuItem (Id);
      if (item)
	{
	  xv_set (item, MENU_INACTIVE, !Flag, NULL);
	}
    }
#endif
}

void wxMenu:: Check (int Id, Bool Flag)
{
#ifdef wx_motif
  wxMenuItem *it = NULL;
  Widget w = FindMenuItem (Id, &it);
  if (it)
    it->isChecked = Flag;

  if (w && XtIsSubclass (w, xmToggleButtonGadgetClass))
    {
      XtVaSetValues (w, XmNset, (Boolean) Flag, NULL);
    }
#endif
#ifdef wx_xview
// No checking in XView; perhaps could simulate it
  // with a bitmap?
  // Try to use XV_KEY_DATA attr...
  Menu menu = (Menu) handle;
  int n = (int) xv_get (menu, MENU_NITEMS);
  for (int i = 1; i <= n; i++)
    {
      Menu_item item = FindMenuItem (Id);
      if (item)
	{
	  Bool checkable = (Bool) xv_get (item, XV_KEY_DATA, checkKey);
	  if (checkable)
	    {
	      char *str = (char *) xv_get (item, XV_KEY_DATA, Flag ? checkString : uncheckString);
	      xv_set (item, XV_KEY_DATA, checkState, Flag, MENU_STRING, str, NULL);
	    }
	  return;
	}
    }
#endif
}

Bool wxMenu:: Checked (int Id)
{
#ifdef wx_motif
  wxMenuItem *it = NULL;
  Widget w = FindMenuItem (Id);
  Boolean Flag;
  if (it && !w)
    return it->isChecked;

  if (w && XtIsSubclass (w, xmToggleButtonGadgetClass))
    {
      XtVaGetValues (w,
		     XmNset, &Flag,
		     NULL);
      return (Bool) Flag;
    }
  return FALSE;
#endif
#ifdef wx_xview
// No checking in XView; perhaps could simulate it
  // with a bitmap?
  Menu menu = (Menu) handle;
  int n = (int) xv_get (menu, MENU_NITEMS);
  for (int i = 1; i <= n; i++)
    {
      Menu_item item = FindMenuItem (Id);
      if (item)
	{
	  Bool checkable = (Bool) xv_get (item, XV_KEY_DATA, checkKey);
	  if (checkable)
	    return (xv_get (item, XV_KEY_DATA, checkState) != 0);
	}
    }
  return FALSE;
#endif
}

void wxMenu:: SetTitle (char *label)
{
  if (title)
    delete title;
  if (label)
    title = copystring (label);
  else
    title = copystring (" ");

#ifdef wx_motif
  wxNode *node = menuItems.First ();
  if (!node)
    return;
  wxMenuItem *item = (wxMenuItem *) node->Data ();
  Widget widget = item->buttonWidget;
  if (!widget)
    return;

  XmString title_str = XmStringCreateSimple (title);
  XtVaSetValues (widget,
		 XmNlabelString, title_str,
		 NULL);
#endif
#ifdef wx_xview
  Menu menu = (Menu) handle;
  xv_set (menu, MENU_TITLE_ITEM, title, NULL);
#endif
}

char *wxMenu:: GetTitle ()
{
  return title;
}

void wxMenu:: SetLabel (int Id, char *label)
{
#ifdef wx_motif
  char mnem = wxFindMnemonic (label);
#endif
  wxStripMenuCodes (label, wxBuffer);
#ifdef wx_motif
  wxMenuItem *it = NULL;
  Widget w = FindMenuItem (Id, &it);
  if (w)
    {
      XmString label_str = XmStringCreateSimple (wxBuffer);
      XtVaSetValues (w,
		     XmNlabelString, label_str,
		     NULL);
      XmStringFree (label_str);
      if (mnem != 0)
	XtVaSetValues (w, XmNmnemonic, mnem, NULL);
      char *accel = wxFindAccelerator (label);
      if (accel)
	XtVaSetValues (w, XmNaccelerator, accel, NULL);

      XmString accel_str = wxFindAcceleratorText (label);
      if (accel_str)
	{
	  XtVaSetValues (w, XmNacceleratorText, accel_str, NULL);
	  XmStringFree (accel_str);
	}
    }
#endif
#ifdef wx_xview
  Menu menu = (Menu) handle;
  int n = (int) xv_get (menu, MENU_NITEMS);
  for (int i = 1; i <= n; i++)
    {
      Menu_item item = FindMenuItem (Id);
      if (item)
	{
	  if (xv_get (item, XV_KEY_DATA, checkKey))
	    {
	      char *chk = (char *) xv_get (item, XV_KEY_DATA, checkString);
	      delete[]chk;

	      char *p = copystring (wxBuffer);
	      xv_set (item, XV_KEY_DATA, uncheckString, p, NULL);

	      chk = strcpy (new char[strlen (wxBuffer) + 2], wxBuffer);
	      strcat (chk, "*");
	      xv_set (item, XV_KEY_DATA, checkString, chk, NULL);
	      if (xv_get (item, XV_KEY_DATA, checkState))
		xv_set (item, MENU_STRING, chk, NULL);
	      else
		xv_set (item, MENU_STRING, p, NULL);
	    }
	  else
	    {
	      char *p = copystring (wxBuffer);
	      xv_set (item, MENU_STRING, p, NULL);
	    }
	}
    }
#endif
}

char *wxMenu:: GetLabel (int Id)
{
#ifdef wx_motif
  wxMenuItem *it = NULL;
  Widget w = FindMenuItem (Id, &it);
  if (w)
    {
      XmString text;
      char *s;
      XtVaGetValues (w,
		     XmNlabelString, &text,
		     NULL);

      if (XmStringGetLtoR (text, XmSTRING_DEFAULT_CHARSET, &s))
	{
	  strcpy (wxBuffer, s);
	  XtFree (s);
	  return wxBuffer;
	}
      else
	{
	  XmStringFree (text);
	  return NULL;
	}
    }
  else
    return (NULL);
#endif
#ifdef wx_xview
  Menu menu = (Menu) handle;
  int n = (int) xv_get (menu, MENU_NITEMS);
  for (int i = 1; i <= n; i++)
    {
      Menu_item item = FindMenuItem (Id);
      if (item)
	{
	  if (xv_get (item, XV_KEY_DATA, checkKey))
	    {
	      char *p = (char *) xv_get (item, XV_KEY_DATA, uncheckString);
	      return (p);
	    }
	  else
	    {
	      char *p = (char *) xv_get (item, MENU_STRING);
	      return (p);
	    }
	}
    }
  return (NULL);
#endif
}

#ifdef wx_xview
Menu_item wxMenu:: FindMenuItem (int Id)
{
  Menu x_menu = (Menu) handle;

  int num = (int) xv_get (x_menu, MENU_NITEMS);

  for (int i = 1; i <= num; i++)
    {
      Menu_item item = (Menu_item) xv_get (x_menu, MENU_NTH_ITEM, i);
      int id = (int) xv_get (item, MENU_CLIENT_DATA);
      if (Id == id)
	return item;
    }

  for (wxNode * node = children->First (); node; node = node->Next ())
    {
      wxMenu *child = (wxMenu *) node->Data ();
      Menu_item item = child->FindMenuItem (Id);
      if (item)
	return item;
    }
  return 0;
}
#endif

#ifdef wx_motif
Widget wxMenu:: FindMenuItem (int Id, wxMenuItem ** it)
{
  if (Id == menuId)
    {
      if (it)
	*it = NULL;
      return buttonWidget;
    }

  for (wxNode * node = menuItems.First (); node; node = node->Next ())
    {
      wxMenuItem *item = (wxMenuItem *) node->Data ();
      if (item->itemId == Id)
	{
	  if (it)
	    *it = item;
	  return item->buttonWidget;
	}

      if (item->subMenu)
	{
	  Widget w = item->subMenu->FindMenuItem (Id, it);
	  if (w)
	    {
	      return w;
	    }
	}
    }				// for()

  if (it)
    *it = NULL;
  return NULL;
}
#endif


#ifdef wx_xview
void 
wxMenuProc (Menu x_menu, Menu_item menu_item)
{

  wxMenu *item = (wxMenu *) xv_get (x_menu, MENU_CLIENT_DATA);
//  char *label = (char *)xv_get(menu_item, MENU_STRING);
  int index = (int) xv_get (menu_item, MENU_CLIENT_DATA);

  // Should find top-level menu and use ITS callback
  wxMenu *top_level_menu = item->top_level_menu;

  wxFrame *frame = NULL;

  wxMenuItem *mitem = item->FindItemForId (index);
  if (mitem && mitem->checkable)
    {
//wxDebugMsg("Toggling id %d\n",index) ;
      item->Check (index, !item->Checked (index));
    }

  // If a menu bar, send a message to the frame
  if (top_level_menu && top_level_menu->menu_bar)
    {
      frame = top_level_menu->menu_bar->menu_bar_frame;
      frame->OnMenuCommand (index);
    }
  else if (top_level_menu && top_level_menu->callback)
    {
      wxCommandEvent event (wxEVENT_TYPE_MENU_COMMAND);
      event.eventObject = item;
      event.commandInt = index;
      (void) (*(top_level_menu->callback)) (*item, event);
    }
}

#endif

// Menu Bar

wxMenuBar::wxMenuBar (void)
{
}

wxMenuBar::wxMenuBar (int N, wxMenu * Menus[], char *Titles[]):
wxbMenuBar (N, Menus, Titles)
{
}

wxMenuBar::~wxMenuBar (void)
{
#ifdef wx_motif
#endif
#ifdef wx_xview
  wxFrame *frame = menu_bar_frame;
  if (frame)
    {
      frame->wx_menu_bar = 0;
      delete frame->menu_bar_panel;
      frame->y_offset = 0;
    }
#endif
  int i;
  for (i = 0; i < n; i++)
    {
      delete menus[i];
      delete[]titles[i];
    }
  delete[]menus;
  delete[]titles;
}

// Must only be used AFTER menu has been attached to frame,
// otherwise use individual menus to enable/disable items
void wxMenuBar::Enable (int Id, Bool Flag)
{
#ifdef wx_motif
  for (int j = 0; j < n; j++)
    {
      wxMenuItem *it = NULL;
      Widget w = menus[j]->FindMenuItem (Id, &it);
      if (w)
	{
	  XtSetSensitive (w, Flag);
	  return;
	}
      else if (it)
	{
	  it->isEnabled = Flag;
	  return;
	}
    }
#endif
#ifdef wx_xview
  for (int j = 0; j < n; j++)
    {
      Menu_item item = menus[j]->FindMenuItem (Id);
      if (item)
	{
	  xv_set (item, MENU_INACTIVE, !Flag, NULL);
	  return;
	}
    }
#endif
}

// Must only be used AFTER menu has been attached to frame,
// otherwise use individual menus
void wxMenuBar::Check (int Id, Bool Flag)
{
#ifdef wx_motif
  for (int j = 0; j < n; j++)
    {
      wxMenuItem *it = NULL;
      Widget w = menus[j]->FindMenuItem (Id, &it);
      if (w && XtIsSubclass (w, xmToggleButtonGadgetClass))
	{
	  XtVaSetValues (w, XmNset, (Boolean) Flag, NULL);
	  return;
	}
      else if (it)
	{
	  it->isChecked = Flag;
	  return;
	}
    }
#endif
#ifdef wx_xview
  for (int j = 0; j < n; j++)
    {
      Menu_item item = menus[j]->FindMenuItem (Id);
      if (item)
	{
	  Bool checkable = (Bool) xv_get (item, XV_KEY_DATA, checkKey);
	  if (checkable)
	    {
	      char *str = Flag ? (char *) xv_get (item, XV_KEY_DATA, checkString)
	      : (char *) xv_get (item, XV_KEY_DATA, uncheckString);
	      xv_set (item, XV_KEY_DATA, checkState, Flag, MENU_STRING, str, NULL);
	    }
	  return;
	}
    }
#endif
}

Bool wxMenuBar::Checked (int Id)
{
#ifdef wx_motif
  Boolean Flag;
  for (int j = 0; j < n; j++)
    {
      Widget w = menus[j]->FindMenuItem (Id);
      if (w && XtIsSubclass (w, xmToggleButtonGadgetClass))
	{
	  XtVaGetValues (w,
			 XmNset, &Flag,
			 NULL);
	  return (Bool) Flag;
	}
    }
  return FALSE;
#endif
#ifdef wx_xview
  for (int j = 0; j < n; j++)
    {
      Menu_item item = menus[j]->FindMenuItem (Id);
      if (item)
	{
	  Bool checkable = (Bool) xv_get (item, XV_KEY_DATA, checkKey);
	  if (checkable)
	    return (xv_get (item, XV_KEY_DATA, checkState) != 0);
	}
    }
  return FALSE;
#endif
}

void wxMenuBar::SetLabel (int Id, char *label)
{
#ifdef wx_motif
  char mnem = wxFindMnemonic (label);
#endif
  wxStripMenuCodes (label, wxBuffer);
#ifdef wx_motif
  for (int j = 0; j < n; j++)
    {
      Widget w = menus[j]->FindMenuItem (Id);
      if (w)
	{
	  XmString label_str = XmStringCreateSimple (wxBuffer);
	  XtVaSetValues (w,
			 XmNlabelString, label_str,
			 NULL);
	  XmStringFree (label_str);
	  if (mnem != 0)
	    XtVaSetValues (w, XmNmnemonic, mnem, NULL);
	  char *accel = wxFindAccelerator (label);
	  if (accel)
	    XtVaSetValues (w, XmNaccelerator, accel, NULL);

	  XmString accel_str = wxFindAcceleratorText (label);
	  if (accel_str)
	    {
	      XtVaSetValues (w, XmNacceleratorText, accel_str, NULL);
	      XmStringFree (accel_str);
	    }
	  return;
	}
    }
#endif
#ifdef wx_xview
  for (int i = 0; i < n; i++)
    {
      Menu_item item = menus[i]->FindMenuItem (Id);
      if (item)
	{
	  if (xv_get (item, XV_KEY_DATA, checkKey))
	    {
	      char *chk = (char *) xv_get (item, XV_KEY_DATA, checkString);
	      delete[]chk;
	      char *p = copystring (wxBuffer);
	      xv_set (item, XV_KEY_DATA, uncheckString, p, NULL);
	      chk = strcpy (new char[strlen (wxBuffer) + 2], wxBuffer);
	      strcat (chk, "*");
	      xv_set (item, XV_KEY_DATA, checkString, chk, NULL);
	      if (xv_get (item, XV_KEY_DATA, checkState))
		xv_set (item, MENU_STRING, chk, NULL);
	      else
		xv_set (item, MENU_STRING, p, NULL);
	    }
	  else
	    {
	      char *p = copystring (wxBuffer);
	      xv_set (item, MENU_STRING, p, NULL);
	    }
	}
    }
#endif
}

char *wxMenuBar::GetLabel (int Id)
{
#ifdef wx_motif
  for (int j = 0; j < n; j++)
    {
      Widget w = menus[j]->FindMenuItem (Id);
      if (w)
	{
	  XmString text;
	  char *s;
	  XtVaGetValues (w,
			 XmNlabelString, &text,
			 NULL);

	  if (XmStringGetLtoR (text, XmSTRING_DEFAULT_CHARSET, &s))
	    {
	      strcpy (wxBuffer, s);
	      XtFree (s);
	      return wxBuffer;
	    }
	  else
	    {
	      return NULL;
	    }
	}
    }
  return (NULL);
#endif
#ifdef wx_xview
  for (int i = 0; i < n; i++)
    {
      Menu_item item = menus[i]->FindMenuItem (Id);
      if (item)
	{
	  if (xv_get (item, XV_KEY_DATA, checkKey))
	    {
	      char *p = (char *) xv_get (item, XV_KEY_DATA, uncheckString);
	      return (copystring (p));
	    }
	  else
	    {
	      char *p = (char *) xv_get (item, MENU_STRING);
	      return (copystring (p));
	    }
	}
    }
  return (NULL);
#endif
}

void wxMenuBar::SetLabelTop (int pos, char *label)
{
#ifdef wx_motif
  Widget w = menus[pos]->buttonWidget;
  if (w)
    {
      XmString label_str = XmStringCreateSimple (label);
      XtVaSetValues (w,
		     XmNlabelString, label_str,
		     NULL);
      XmStringFree (label_str);
      return;
    }
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) (menus[pos]->panelItem);
  char *p = copystring (label);
  xv_set (item, PANEL_LABEL_STRING, p, NULL);
#endif
}

char *wxMenuBar::GetLabelTop (int pos)
{
#ifdef wx_motif
  Widget w = menus[pos]->buttonWidget;
  if (w)
    {
      XmString text;
      char *s;
      XtVaGetValues (w,
		     XmNlabelString, &text,
		     NULL);

      if (XmStringGetLtoR (text, XmSTRING_DEFAULT_CHARSET, &s))
	{
	  strcpy (wxBuffer, s);
	  XtFree (s);
	  return wxBuffer;
	}
      else
	{
	  return NULL;
	}
    }
  else
    return (NULL);
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) (menus[pos]->panelItem);
  char *p = (char *) xv_get (item, PANEL_LABEL_STRING);
  return p;
#endif
}

void wxMenuBar::EnableTop (int pos, Bool flag)
{
#ifdef wx_motif
  Widget w = menus[pos]->buttonWidget;
  if (w)
    {
      XtSetSensitive (w, flag);
      return;
    }
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) (menus[pos]->panelItem);
  xv_set (item, PANEL_INACTIVE, !flag, NULL);
#endif
}

#ifdef wx_motif
void 
wxMenuItemCallback (Widget w, XtPointer clientData,
		    XtPointer ptr)
{
  wxMenuItem *item = (wxMenuItem *) clientData;
  if (item)
    {
      if (item->menuBar && item->menuBar->menu_bar_frame)
	{
//       cout << "Id = " << item->itemId << "\n";
	  item->menuBar->menu_bar_frame->OnMenuCommand (item->itemId);
	}
      else if (item->topMenu)
	{
	  wxCommandEvent event (wxEVENT_TYPE_MENU_COMMAND);
	  event.eventObject = item->topMenu;
	  event.commandInt = item->itemId;
	  item->topMenu->ProcessCommand (event);
	}
    }
}

void 
wxMenuItemArmCallback (Widget w, XtPointer clientData,
		       XtPointer ptr)
{
  wxMenuItem *item = (wxMenuItem *) clientData;
  if (item)
    {
      if (item->menuBar && item->menuBar->menu_bar_frame)
	{
	  item->menuBar->menu_bar_frame->OnMenuSelect (item->itemId);
	}
    }
}

void 
wxMenuItemDisarmCallback (Widget w, XtPointer clientData,
			  XtPointer ptr)
{
  wxMenuItem *item = (wxMenuItem *) clientData;
  if (item)
    {
      if (item->menuBar && item->menuBar->menu_bar_frame)
	{
	  item->menuBar->menu_bar_frame->OnMenuSelect (-1);
	}
    }
}

/*
 * Create a popup or pulldown menu.
 * Submenus of a popup will be pulldown.
 *
 */

Widget wxMenu::CreateMenu (wxMenuBar * menuBar, Widget parent, wxMenu * topMenu, char *title, Bool pullDown)
{
  Widget menu;
  Widget ButtonWidget = 0;
  Arg args[5];
  XtSetArg (args[0], XmNnumColumns, numColumns);
  XtSetArg (args[1], XmNpacking, XmPACK_COLUMN);

  if (!pullDown)
    {
      menu = XmCreatePopupMenu (parent, "popup", args, 2);
    }
  else
    {
      char mnem = wxFindMnemonic (title);
      wxStripMenuCodes (title, wxBuffer);

      menu = XmCreatePulldownMenu (parent, "pulldown", args, 2);

      XmString label_str = XmStringCreateSimple (wxBuffer);
      ButtonWidget = XtVaCreateManagedWidget (wxBuffer,
#if USE_GADGETS
					 xmCascadeButtonGadgetClass, parent,
#else
					 xmCascadeButtonWidgetClass, parent,
#endif
					      XmNlabelString, label_str,
					      XmNsubMenuId, menu,
					      NULL);

      if (mnem != 0)
	XtVaSetValues (ButtonWidget, XmNmnemonic, mnem, NULL);

      XmStringFree (label_str);
    }

  // XtVaSetValues(menu, XmNnumColumns, numColumns, NULL) ;
  handle = (char *) menu;

  menu_bar = menuBar;
  top_menu = topMenu;

  for (wxNode * node = menuItems.First (); node; node = node->Next ())
    {
      wxMenuItem *item = (wxMenuItem *) node->Data ();
      item->CreateItem (menu, menu_bar, top_menu);
    }

  return ButtonWidget;
}

// Destroys the Motif implementation of the menu,
// but maintains the wxWindows data structures so we can
// do a CreateMenu again. 
void wxMenu::DestroyMenu (void)
{
  for (wxNode * node = menuItems.First (); node; node = node->Next ())
    {
      wxMenuItem *item = (wxMenuItem *) node->Data ();
      item->menuBar = NULL;

      if (item->itemId == -2)
	{
	  ;			// Nothing

	}
      else if (item->itemName && (!item->subMenu))
	{
	  if (item->buttonWidget)
	    {
	      if (item->checkable)
		XtRemoveCallback (item->buttonWidget, XmNvalueChangedCallback,
				  wxMenuItemCallback, (XtPointer) item);
	      else
		XtRemoveCallback (item->buttonWidget, XmNactivateCallback,
				  wxMenuItemCallback, (XtPointer) item);
	      XtRemoveCallback (item->buttonWidget, XmNarmCallback,
				wxMenuItemArmCallback, (XtPointer) item);
	      XtRemoveCallback (item->buttonWidget, XmNdisarmCallback,
				wxMenuItemDisarmCallback, (XtPointer) item);
	    }
	}
      else if (item->itemId == -1)
	{
	  ;			// Nothing

	}
      else if (item->subMenu)
	{
	  if (item->buttonWidget)
	    {
	      XtRemoveCallback (item->buttonWidget, XmNcascadingCallback,
				wxMenuItemArmCallback, (XtPointer) item);
	      // Is this right, or should we not delete the Motif submenus, just
	      // null the pointers?
	      item->subMenu->DestroyMenu ();
	    }
	}
      item->buttonWidget = 0;

    }				// for()

  if (buttonWidget)
    {
      XtDestroyWidget (buttonWidget);
      buttonWidget = 0;
    }
}

void wxMenuItem::CreateItem (Widget menu, wxMenuBar * menu_bar, wxMenu * top_menu)
{
  menuBar = menu_bar;
  topMenu = top_menu;

  if (itemId == -2)
    {
      // Id=-2 identifies a Title item.
      wxStripMenuCodes (itemName, wxBuffer);
      buttonWidget = XtVaCreateManagedWidget (wxBuffer,
					    xmLabelGadgetClass, menu, NULL);
    }
  else if (itemName && (!subMenu))
    {
      wxStripMenuCodes (itemName, wxBuffer);
      if (checkable)
	{
	  buttonWidget = XtVaCreateManagedWidget (wxBuffer,
					    xmToggleButtonGadgetClass, menu,
						  NULL);
	  XtVaSetValues (buttonWidget, XmNset, (Boolean) isChecked, NULL);
	}
      else
	buttonWidget = XtVaCreateManagedWidget (wxBuffer,
					      xmPushButtonGadgetClass, menu,
						NULL);
      char mnem = wxFindMnemonic (itemName);
      if (mnem != 0)
	XtVaSetValues (buttonWidget, XmNmnemonic, mnem, NULL);

      char *accel = wxFindAccelerator (itemName);
      if (accel)
	XtVaSetValues (buttonWidget, XmNaccelerator, accel, NULL);

      XmString accel_str = wxFindAcceleratorText (itemName);
      if (accel_str)
	{
	  XtVaSetValues (buttonWidget, XmNacceleratorText, accel_str, NULL);
	  XmStringFree (accel_str);
	}

      if (checkable)
	XtAddCallback (buttonWidget,
		       XmNvalueChangedCallback,
		       (XtCallbackProc) wxMenuItemCallback,
		       (XtPointer) this);
      else
	XtAddCallback (buttonWidget,
		       XmNactivateCallback,
		       (XtCallbackProc) wxMenuItemCallback,
		       (XtPointer) this);
      XtAddCallback (buttonWidget,
		     XmNarmCallback,
		     (XtCallbackProc) wxMenuItemArmCallback,
		     (XtPointer) this);
      XtAddCallback (buttonWidget,
		     XmNdisarmCallback,
		     (XtCallbackProc) wxMenuItemDisarmCallback,
		     (XtPointer) this);
    }
  else if (itemId == -1)
    {
      buttonWidget = XtVaCreateManagedWidget ("separator",
					xmSeparatorGadgetClass, menu, NULL);
    }
  else if (subMenu)
    {
      buttonWidget = subMenu->CreateMenu (menu_bar, menu, topMenu, itemName, TRUE);
      XtAddCallback (buttonWidget,
		     XmNcascadingCallback,
		     (XtCallbackProc) wxMenuItemArmCallback,
		     (XtPointer) this);
//      XtAddCallback(buttonWidget,
      //                    XmNdisarmCallback,
      //                    (XtCallbackProc)wxMenuItemDisarmCallback,
      //                    (XtPointer)this);
    }
  if (buttonWidget)
    XtSetSensitive (buttonWidget, isEnabled);
}

#endif

#ifdef wx_motif
void 
wxCheckBoxCallback (Widget w, XtPointer clientData,
		    XtPointer ptr)
{
  wxCheckBox *item = (wxCheckBox *) clientData;
  wxCommandEvent event (wxEVENT_TYPE_CHECKBOX_COMMAND);
  event.commandInt = item->GetValue ();
  event.eventObject = item;
  item->ProcessCommand (event);
}
#endif


// Single check box item

wxCheckBox::wxCheckBox (void)
{
  buttonBitmap = NULL;
}

wxCheckBox::wxCheckBox (wxPanel * panel, wxFunction func, char *Title,
	    int x, int y, int width, int height, long style, char *name):
wxbCheckBox (panel, func, Title, x, y, width, height, style, name)
{
  Create (panel, func, Title, x, y, width, height, style, name);
}

wxCheckBox::wxCheckBox (wxPanel * panel, wxFunction func, wxBitmap * bitmap,
	    int x, int y, int width, int height, long style, char *name):
wxbCheckBox (panel, func, bitmap, x, y, width, height, style, name)
{
  Create (panel, func, bitmap, x, y, width, height, style, name);
}

Bool wxCheckBox::
Create (wxPanel * panel, wxFunction func, char *Title,
	int x, int y, int width, int height, long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  buttonBitmap = NULL;
  window_parent = panel;
  labelPosition = panel->label_position;
  windowStyle = style;
#ifdef wx_motif
  windowName = copystring (name);

  Widget panelForm = panel->panelWidget;
  if (!Title)
    Title = "";
  XmString text = XmStringCreateSimple (Title);

  formWidget = XtVaCreateManagedWidget (windowName,
					xmFormWidgetClass, panelForm,
					XmNmarginHeight, 0,
					XmNmarginWidth, 0,
					NULL);

  Widget buttonWidget = XtVaCreateManagedWidget ("toggle",
#if USE_GADGETS
						 style & wxCOLOURED ?
		      xmToggleButtonWidgetClass : xmToggleButtonGadgetClass,
						 formWidget,
#else
				      xmToggleButtonWidgetClass, formWidget,
#endif
						 XmNlabelString, text,
					    XmNtopAttachment, XmATTACH_FORM,
					   XmNleftAttachment, XmATTACH_FORM,
					 XmNbottomAttachment, XmATTACH_FORM,
					  XmNrightAttachment, XmATTACH_FORM,
						 NULL);

  handle = (char *) buttonWidget;

  if (buttonFont)
    XtVaSetValues (buttonWidget,
		   XmNfontList, buttonFont->GetInternalFont (),
		   NULL);

  XmStringFree (text);

  XtAddCallback (buttonWidget, XmNvalueChangedCallback, (XtCallbackProc) wxCheckBoxCallback,
		 (XtPointer) this);

  AttachWidget (panel, formWidget, x, y, width, height);
  ChangeColour ();

  XmToggleButtonSetState (buttonWidget, FALSE, TRUE);
#endif
#ifdef wx_xview
  Panel x_panel = (Panel) panel->GetHandle ();
  Panel_item x_choice;

  int label_position;

  if (panel->label_position == wxVERTICAL)
    label_position = PANEL_VERTICAL;
  else
    label_position = PANEL_HORIZONTAL;

  if (panel->new_line)
    {
      x_choice = (Panel_item) xv_create (x_panel, PANEL_CHECK_BOX, PANEL_LAYOUT, label_position, PANEL_NEXT_ROW, -1, NULL);
      panel->new_line = FALSE;
    }
  else
    x_choice = (Panel_item) xv_create (x_panel, PANEL_CHECK_BOX, PANEL_LAYOUT, label_position, NULL);

  xv_set (x_choice,
//                          PANEL_LABEL_STRING, Title,
	  PANEL_NOTIFY_PROC, wxCheckBoxProc,
	  PANEL_CLIENT_DATA, (char *) this,
	  PANEL_VALUE, 0,
	  PANEL_CHOICE_STRING, 0, Title,
	  NULL);
/*
   if (buttonFont)
   xv_set(x_choice, XV_FONT, buttonFont->GetInternalFont(), NULL) ;
 */

  if (x > -1 && y > -1)
    (void) xv_set (x_choice, XV_X, x, XV_Y, y, NULL);

  handle = (char *) x_choice;
#endif

  Callback (func);

  return TRUE;
}

Bool wxCheckBox::
Create (wxPanel * panel, wxFunction func, wxBitmap * bitmap,
	int x, int y, int width, int height, long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  buttonBitmap = bitmap;
  window_parent = panel;
  labelPosition = panel->label_position;
  windowStyle = style;
#ifdef wx_motif
  windowName = copystring (name);

  Widget panelForm = panel->panelWidget;

  formWidget = XtVaCreateManagedWidget (windowName,
					xmFormWidgetClass, panelForm,
					XmNmarginHeight, 0,
					XmNmarginWidth, 0,
					NULL);

  Widget buttonWidget = XtVaCreateManagedWidget ("toggle",
#if USE_GADGETS
						 style & wxCOLOURED ?
		      xmToggleButtonWidgetClass : xmToggleButtonGadgetClass,
						 formWidget,
#else
				      xmToggleButtonWidgetClass, formWidget,
#endif
					    XmNtopAttachment, XmATTACH_FORM,
					   XmNleftAttachment, XmATTACH_FORM,
					 XmNbottomAttachment, XmATTACH_FORM,
					  XmNrightAttachment, XmATTACH_FORM,
						 NULL);

  handle = (char *) buttonWidget;

  if (buttonFont)
    XtVaSetValues (buttonWidget,
		   XmNfontList, buttonFont->GetInternalFont (),
		   NULL);

  XtVaSetValues (buttonWidget,
		 XmNlabelPixmap, bitmap->GetLabelPixmap (buttonWidget),
		 XmNselectPixmap, bitmap->GetLabelPixmap (buttonWidget),
	  XmNlabelInsensitivePixmap, bitmap->GetInsensPixmap (buttonWidget),
	 XmNselectInsensitivePixmap, bitmap->GetInsensPixmap (buttonWidget),
		 XmNarmPixmap, bitmap->GetArmPixmap (buttonWidget),
		 XmNlabelType, XmPIXMAP,
		 NULL);

  XtAddCallback (buttonWidget, XmNvalueChangedCallback, wxCheckBoxCallback,
		 this);

  AttachWidget (panel, formWidget, x, y, width, height);
  ChangeColour ();

  XmToggleButtonSetState (buttonWidget, FALSE, TRUE);
#endif
#ifdef wx_xview
  Panel x_panel = (Panel) panel->GetHandle ();
  Panel_item x_choice;

  int label_position;

  if (panel->label_position == wxVERTICAL)
    label_position = PANEL_VERTICAL;
  else
    label_position = PANEL_HORIZONTAL;

  if (panel->new_line)
    {
      x_choice = (Panel_item) xv_create (x_panel, PANEL_CHECK_BOX, PANEL_LAYOUT, label_position, PANEL_NEXT_ROW, -1, NULL);
      panel->new_line = FALSE;
    }
  else
    x_choice = (Panel_item) xv_create (x_panel, PANEL_CHECK_BOX, PANEL_LAYOUT, label_position, NULL);

  xv_set (x_choice,
//                          PANEL_LABEL_STRING, Title,
	  PANEL_NOTIFY_PROC, wxCheckBoxProc,
	  PANEL_CLIENT_DATA, (char *) this,
	  PANEL_VALUE, 0,
	  PANEL_CHOICE_IMAGE, 0, bitmap->x_image,
	  NULL);
/*
   if (buttonFont)
   xv_set(x_choice, XV_FONT, buttonFont->GetInternalFont(), NULL) ;
 */

  if (x > -1 && y > -1)
    (void) xv_set (x_choice, XV_X, x, XV_Y, y, NULL);

  handle = (char *) x_choice;
#endif

  Callback (func);

  return TRUE;
}

wxCheckBox::~wxCheckBox (void)
{
}

void wxCheckBox::ChangeColour (void)
{
#ifdef wx_motif
  int change;

  wxPanel *panel = (wxPanel *) window_parent;
  change = wxComputeColors (panel->backColour,
			    panel->buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues (formWidget,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues (formWidget,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);


  change = wxComputeColors (backColour, buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues ((Widget) handle,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues ((Widget) handle,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  if (buttonBitmap)
    XtVaSetValues ((Widget) handle,
	     XmNlabelPixmap, buttonBitmap->GetLabelPixmap ((Widget) handle),
		   XmNlabelInsensitivePixmap, buttonBitmap->GetInsensPixmap ((Widget) handle),
		 XmNarmPixmap, buttonBitmap->GetArmPixmap ((Widget) handle),
		   NULL);
#endif
}

char *wxCheckBox::GetLabel ()
{
#ifdef wx_motif
  Widget widget = (Widget) handle;
  XmString text;
  char *s;
  XtVaGetValues (widget,
		 XmNlabelString, &text,
		 NULL);

  if (XmStringGetLtoR (text, XmSTRING_DEFAULT_CHARSET, &s))
    {
//    XmStringFree(text);
      char *val = copystring (s);
      XtFree (s);
      return val;
    }
  else
    {
//    XmStringFree(text);
      return NULL;
    }
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  return ((char *) xv_get (item, PANEL_CHOICE_STRING, 0));
#endif
}

void wxCheckBox::SetLabel (char *label)
{
#ifdef wx_motif
  Widget widget = (Widget) handle;
  if (label)
    {
      XmString text = XmStringCreateSimple (label);
      XtVaSetValues (widget,
		     XmNlabelString, text,
		     XmNlabelType, XmSTRING,
		     NULL);
      XmStringFree (text);
    }
#endif
#ifdef wx_xview
  if (label)
    {
      Panel_item item = (Panel_item) handle;
      xv_set (item, PANEL_CHOICE_STRING, 0, label, NULL);
    }
#endif
}

void wxCheckBox::SetLabel (wxBitmap * bitmap)
{
  buttonBitmap = bitmap;
#ifdef wx_motif
  Widget widget = (Widget) handle;
  if (bitmap)
    {
      XtVaSetValues (widget,
		     XmNlabelPixmap, bitmap->GetLabelPixmap (widget),
		     XmNselectPixmap, bitmap->GetLabelPixmap (widget),
		XmNlabelInsensitivePixmap, bitmap->GetInsensPixmap (widget),
	       XmNselectInsensitivePixmap, bitmap->GetInsensPixmap (widget),
		     XmNarmPixmap, bitmap->GetArmPixmap (widget),
		     XmNlabelType, XmPIXMAP,
		     NULL);
    }
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  xv_set (item, PANEL_CHOICE_IMAGE, 0, bitmap->x_image, NULL);
#endif
}

void wxCheckBox::SetValue (Bool val)
{
#ifdef wx_motif
  Widget buttonWidget = (Widget) handle;
  XmToggleButtonSetState (buttonWidget, val, TRUE);
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  int the_val = 0;
  if (val)
    the_val = 1;

  xv_set (item, PANEL_VALUE, the_val, NULL);
#endif
}

Bool wxCheckBox::GetValue (void)
{
#ifdef wx_motif
  Widget buttonWidget = (Widget) handle;
  return XmToggleButtonGetState (buttonWidget);
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  return (Bool) xv_get (item, PANEL_VALUE);
#endif
}

#ifdef wx_xview
void 
wxCheckBoxProc (Panel_item item, int value, Event * x_event)
{
  wxCheckBox *box = (wxCheckBox *) xv_get (item, PANEL_CLIENT_DATA);
  wxCommandEvent event (wxEVENT_TYPE_CHECKBOX_COMMAND);

  event.commandString = (char *) xv_get (item, PANEL_LABEL_STRING);
  event.commandInt = value;
  event.eventObject = box;
  box->ProcessCommand (event);
}
#endif

#ifdef wx_motif
void 
wxChoiceCallback (Widget w, XtPointer clientData,
		  XtPointer ptr)
{
  wxChoice *item = (wxChoice *) clientData;
  if (item)
    {
      char *s = NULL;
      XtVaGetValues (w, XmNuserData, &s, NULL);
      if (s)
	{
	  wxCommandEvent event (wxEVENT_TYPE_CHOICE_COMMAND);
	  event.commandInt = item->FindString (s);
	  event.commandString = s;
	  item->ProcessCommand (event);
	}
    }
}

#endif

wxChoice::wxChoice (void)
{
  no_strings = 0;
#ifdef wx_motif
  labelWidget = NULL;
  buttonWidget = NULL;
  menuWidget = NULL;
  widgetList = NULL;
#endif
#ifdef wx_xview
#endif
}

wxChoice::wxChoice (wxPanel * panel, wxFunction func, char *Title,
	  int x, int y, int width, int height, int N, char **Choices,
	  long style, char *name):
wxbChoice (panel, func, Title, x, y, width, height, N, Choices, style, name)
{
  Create (panel, func, Title, x, y, width, height, N, Choices, style, name);
}

Bool wxChoice::
Create (wxPanel * panel, wxFunction func, char *Title,
	int x, int y, int width, int height, int N, char **Choices,
	long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  window_parent = panel;
  labelPosition = panel->label_position;
  windowStyle = style;
#ifdef wx_motif
  no_strings = 0;
  buttonWidget = NULL;
  windowName = copystring (name);
  widgetList = NULL;

//  char mnem = wxFindMnemonic(Title);
  if (!Title)
    Title = "";
  wxStripMenuCodes (Title, wxBuffer);

  Widget panelForm = panel->panelWidget;
  formWidget = XtVaCreateManagedWidget (windowName,
					xmRowColumnWidgetClass, panelForm,
					XmNmarginHeight, 0,
					XmNmarginWidth, 0,
					XmNpacking, XmPACK_TIGHT,
					XmNorientation, panel->label_position == wxHORIZONTAL ? XmHORIZONTAL : XmVERTICAL,
					NULL);

  if (labelPosition == wxHORIZONTAL)
    XtVaSetValues (formWidget, XmNspacing, 0, NULL);

  if (Title)
    {
      char *the_label = (style & wxFIXED_LENGTH) ? fillCopy (Title) : copystring (Title);

      XmString text = XmStringCreateSimple (the_label);
      labelWidget = XtVaCreateManagedWidget ("choiceLabel",
#ifdef USE_GADGETS
					     style & wxCOLOURED ?
				    xmLabelWidgetClass : xmLabelGadgetClass,
					     formWidget,
#else
					     xmLabelWidgetClass, formWidget,
#endif
					     XmNlabelString, text,
					     NULL);
      if (labelFont)
	XtVaSetValues (labelWidget,
		       XmNfontList, labelFont->GetInternalFont (),
		       NULL);

      XmStringFree (text);
      delete[]the_label;
    }

  /*
   * Create the popup menu
   */
  menuWidget = XmCreatePulldownMenu (formWidget, "choiceMenu", NULL, 0);

  no_strings = 0;
  if (N > 0)
    for (int i = 0; i < N; i++)
      Append (Choices[i]);

  /*
   * Create button
   */
  Arg args[10];
  Cardinal argcnt = 0;

  XtSetArg (args[argcnt], XmNsubMenuId, menuWidget);
  argcnt++;
  XtSetArg (args[argcnt], XmNmarginWidth, 0);
  argcnt++;
  XtSetArg (args[argcnt], XmNmarginHeight, 0);
  argcnt++;
  XtSetArg (args[argcnt], XmNpacking, XmPACK_TIGHT);
  argcnt++;
  buttonWidget = XmCreateOptionMenu (formWidget, "choiceButton", args, argcnt);
  if (buttonFont)
    XtVaSetValues (buttonWidget,
		   XmNfontList, buttonFont->GetInternalFont (),
		   NULL);

  handle = (char *) buttonWidget;

  XtManageChild (buttonWidget);

  // Want to get rid of the label by unmanaging it
/***
ALS writes: WHY?????
JACS writes: because this just appears as 'OptionLabel' under the
actual label. What's the use of that, eh? :-)
It can't be set, it just sits there.
***/
 
#if XmVersion >= 1002
  /*
   ALS:
	In fact, this seems to be a 1.2 problem: with 1.1.4, I've no
	'OptionLabel' under the actual label.
	More, if I execute this code, later access to the widget via
	wxChoice::SetSelection() or wxChoice::SetSize() give me
	many errors under purify, about uninitialized memory read,
	unallocated memory write and so on...
	Because I don't want these warnings (they occult mines), and
	since I've no real reason to unmanage the widget, I do not
	execute these 2 instructions. :-))

	BTW, I've looked RowColumn.c code for 1.2 and 1.1, and there
	is diffs in the part which deals with the XmOpttionLabelGadget :-)))
  */
  Widget optionLabel = XmOptionLabelGadget (buttonWidget);
  XtUnmanageChild (optionLabel);
#endif

  AttachWidget (panel, formWidget, x, y, width, height);
  ChangeColour ();

  /* After creating widgets, no more resizes. */
  if (style & wxFIXED_LENGTH)
    {
      XtVaSetValues (formWidget,
		     XmNpacking, XmPACK_NONE,
		     NULL);

      if (labelWidget)
	{
/**
Doesn't seem to work... Bad boy, Motif!!
      if (labelPosition==wxHORIZONTAL)
      {
      Position y_label;
      Dimension h_label,h_option ;
        XtVaGetValues(labelWidget,XmNy,&y_label,XmNheight,&h_label,NULL) ;
        XtVaGetValues(buttonWidget,XmNheight,&h_option,NULL) ;
        XtVaSetValues(labelWidget,XmNy,y_label+(h_option-h_label)/2,NULL) ;
      }
**/
	  XmString text = XmStringCreateSimple (Title);
	  XtVaSetValues (labelWidget,
			 XmNlabelString, text,
			 NULL);
	  XmStringFree (text);
	}
    }

#endif
#ifdef wx_xview
  no_strings = N;
  char *title = NULL;
  if (Title)
    title = Title;

  Panel x_panel = (Panel) panel->GetHandle ();
  Panel_item x_choice;

  int label_position;
  if (panel->label_position == wxVERTICAL)
    label_position = PANEL_VERTICAL;
  else
    label_position = PANEL_HORIZONTAL;

  if (panel->new_line)
    {
      x_choice = (Panel_item) xv_create (x_panel, PANEL_CHOICE_STACK, PANEL_LAYOUT, label_position, PANEL_NEXT_ROW, -1, NULL);
      panel->new_line = FALSE;
    }
  else
    x_choice = (Panel_item) xv_create (x_panel, PANEL_CHOICE_STACK, PANEL_LAYOUT, label_position, NULL);

  if (Title)
    {
      xv_set (x_choice,
	      PANEL_LABEL_STRING, title,
	      PANEL_NOTIFY_PROC, wxChoiceProc,
	      PANEL_CLIENT_DATA, (char *) this,
	      NULL);
    }
  else
    {
      xv_set (x_choice,
	      PANEL_LABEL_STRING, "",
	      PANEL_NOTIFY_PROC, wxChoiceProc,
	      PANEL_CLIENT_DATA, (char *) this,
	      NULL);
    }

  if (Title && (style & wxFIXED_LENGTH))
    {
      char *the_label = fillCopy (Title);
      xv_set (x_choice, PANEL_LABEL_STRING, the_label, NULL);

      int label_x = (int) xv_get (x_choice, PANEL_LABEL_X);
      int item_x = (int) xv_get (x_choice, PANEL_ITEM_X);
      xv_set (x_choice, PANEL_LABEL_STRING, Title,
	      PANEL_LABEL_X, label_x,
	      PANEL_ITEM_X, item_x,
	      NULL);
    }

/*
   if (buttonFont)
   xv_set(x_choice, XV_FONT, buttonFont->GetInternalFont(), NULL) ;
 */

  if (x > -1 && y > -1)
    (void) xv_set (x_choice, XV_X, x, XV_Y, y, NULL);

  for (int i = 0; i < N; i++)
    {
      char *label = Choices[i];
      xv_set (x_choice, PANEL_CHOICE_STRING, i, label, NULL);
    }
  handle = (char *) x_choice;

#endif

  Callback (func);
  return TRUE;
}

wxChoice::~wxChoice (void)
{
#ifdef wx_motif
  XtDestroyWidget (menuWidget);
  if (widgetList)
    delete[]widgetList;
#endif
}

void wxChoice::ChangeColour (void)
{
#ifdef wx_motif
  int change;

  wxPanel *panel = (wxPanel *) window_parent;
  change = wxComputeColors (panel->backColour,
			    panel->buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues (formWidget,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues (formWidget,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  change = wxComputeColors (backColour, buttonColour);
  if (change == wxBACK_COLORS)
    {
      XtVaSetValues (menuWidget,
		     XmNbackground, itemColors[wxBACK_INDEX].pixel,
		     XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		     XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		     XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      for (int i = 0; i < no_strings; i++)
	XtVaSetValues (widgetList[i],
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      XtVaSetValues (buttonWidget,
		     XmNbackground, itemColors[wxBACK_INDEX].pixel,
		     XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		     XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		     XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
    }
  else if (change == wxFORE_COLORS)
    {
      for (int i = 0; i < no_strings; i++)
	XtVaSetValues (widgetList[i],
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      XtVaSetValues (menuWidget,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      XtVaSetValues (buttonWidget,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
    }

  if (labelWidget)
    {
      change = wxComputeColors (panel->backColour, labelColour);
      if (change == wxBACK_COLORS)
	XtVaSetValues (labelWidget,
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      else if (change == wxFORE_COLORS)
	XtVaSetValues (labelWidget,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }

#endif
}

void wxChoice::SetSize (int x, int y, int width, int height)
{
#ifdef wx_motif
  XtUnmanageChild (formWidget);

  Dimension labelWidth = 0, labelHeight = 0;
  int actualWidth = width, actualHeight = height;

  if (labelWidget)
    XtVaGetValues (labelWidget, XmNwidth, &labelWidth, XmNheight, &labelHeight, NULL);

  if (itemOrientation == wxHORIZONTAL)
    {
      actualWidth = width - labelWidth;
      actualHeight = height;
    }
  else
    {
      actualWidth = width;
      actualHeight = height - labelHeight;
    }

  if (width > -1)
    {
      for (int i = 0; i < no_strings; i++)
	XtVaSetValues (widgetList[i], XmNwidth, actualWidth, NULL);
      XtVaSetValues ((Widget) handle, XmNwidth, actualWidth,
		     NULL);
    }
  if (height > -1)
    {
      for (int i = 0; i < no_strings; i++)
	XtVaSetValues (widgetList[i], XmNheight, actualHeight, NULL);
      XtVaSetValues ((Widget) handle, XmNheight, actualHeight,
		     NULL);
    }

  XtManageChild (formWidget);

  wxItem::SetSize (x, y, width, height);
  OnSize (width, height);
#endif
#ifdef wx_xview
  wxItem::SetSize (x, y, width, height);
  OnSize (width, height);
#endif
}

void wxChoice::Append (char *Item)
{
#ifdef wx_motif
  wxStripMenuCodes (Item, wxBuffer);
  Widget w = XtVaCreateManagedWidget (wxBuffer,
#if USE_GADGETS
				      xmPushButtonGadgetClass, menuWidget,
#else
				      xmPushButtonWidgetClass, menuWidget,
#endif
				      NULL);
  if (buttonFont)
    XtVaSetValues (w,
		   XmNfontList, buttonFont->GetInternalFont (),
		   NULL);


  Widget *new_widgetList = new Widget[no_strings + 1];
  for (int i = 0; i < no_strings; i++)
    new_widgetList[i] = widgetList[i];
  new_widgetList[no_strings] = w;
  if (widgetList)
    delete[]widgetList;
  widgetList = new_widgetList;

  char mnem = wxFindMnemonic (Item);
  if (mnem != 0)
    XtVaSetValues (w, XmNmnemonic, mnem, NULL);

  XtAddCallback (w, XmNactivateCallback, (XtCallbackProc) wxChoiceCallback, (XtPointer) this);

  if (no_strings == 0 && buttonWidget)
    {
      XtVaSetValues (buttonWidget, XmNmenuHistory, w, NULL);
      Widget label = XmOptionButtonGadget (buttonWidget);
      XmString text = XmStringCreateSimple (Item);
      XtVaSetValues (label,
		     XmNlabelString, text,
		     NULL);
      XmStringFree (text);
    }
  wxNode *node = stringList.Add (Item);
  XtVaSetValues (w, XmNuserData, node->Data (), NULL);
#endif
#ifdef wx_xview
  Panel_item choice_item = (Panel_item) handle;

  xv_set (choice_item, PANEL_CHOICE_STRING, no_strings, Item, NULL);
#endif
  no_strings++;
}

// Unfortunately, under XView it doesn't redisplay until user resizes
// window. Any suggestions folks?
void wxChoice::Clear (void)
{
#ifdef wx_motif
  stringList.Clear ();
  for (int i = 0; i < no_strings; i++)
    {
      XtUnmanageChild (widgetList[i]);
      XtDestroyWidget (widgetList[i]);
    }
  if (no_strings)
    delete[]widgetList;
  widgetList = NULL;
  if (buttonWidget)
    XtVaSetValues (buttonWidget, XmNmenuHistory, (Widget) NULL, NULL);
#endif
#ifdef wx_xview
  Panel_item choice_item = (Panel_item) handle;
  Rect *rect = (Rect *) xv_get (choice_item, XV_RECT);

  int height = rect->r_height;
  int width = rect->r_width;
  int x = (int) xv_get (choice_item, XV_X);
  int y = (int) xv_get (choice_item, XV_Y);
  char *label = GetLabel ();

  xv_destroy_safe (choice_item);
  Panel panel = (Panel) GetParent ()->handle;
  choice_item = (Panel_item) xv_create (panel, PANEL_CHOICE_STACK,
					PANEL_LABEL_STRING, label,
					PANEL_NOTIFY_PROC, wxChoiceProc,
					PANEL_CLIENT_DATA, (char *) this,
		       XV_X, x, XV_Y, y, XV_WIDTH, width, XV_HEIGHT, height,
					XV_SHOW, TRUE,
					NULL);

  handle = (char *) choice_item;
#endif
  no_strings = 0;
}


int wxChoice::GetSelection (void)
{
#ifdef wx_motif
  XmString text;
  char *s;
  Widget label = XmOptionButtonGadget (buttonWidget);
  XtVaGetValues (label,
		 XmNlabelString, &text,
		 NULL);

  if (XmStringGetLtoR (text, XmSTRING_DEFAULT_CHARSET, &s))
    {
      int i = 0;
      for (wxNode * node = stringList.First (); node; node = node->Next ())
	{
	  char *s1 = (char *) node->Data ();
	  if (s1 == s || strcmp (s1, s) == 0)
	    {
              XmStringFree(text) ;
	      XtFree (s);
	      return i;
	    }
	  else
	    i++;
	}			// for()

      XmStringFree(text) ;
      XtFree (s);
      return -1;
    }
  XmStringFree(text) ;
  return -1;
#endif
#ifdef wx_xview
  Panel_item x_choice = (Panel_item) handle;

  return xv_get (x_choice, PANEL_VALUE);
#endif
}

void wxChoice::SetSelection (int n)
{
#ifdef wx_motif
  wxNode *node = stringList.Nth (n);
  if (node)
    {
      char *s = (char *) node->Data ();
      XmString text = XmStringCreateSimple (s);
      Widget label = XmOptionButtonGadget (buttonWidget);
      XtVaSetValues (label,
		     XmNlabelString, text,
		     NULL);
      XmStringFree (text);
      XtVaSetValues (buttonWidget, XmNmenuHistory, widgetList[n], NULL);
    }
#endif
#ifdef wx_xview
  Panel_item x_choice = (Panel_item) handle;

  (void) xv_set (x_choice, PANEL_VALUE, n, NULL);
#endif
}

int wxChoice::FindString (char *s)
{
#ifdef wx_motif
  int i = 0;
  for (wxNode * node = stringList.First (); node; node = node->Next ())
    {
      char *s1 = (char *) node->Data ();
      if (s1 == s || strcmp (s1, s) == 0)
	{
	  return i;
	}
      else
	i++;
    }
  return -1;
#endif
#ifdef wx_xview
  Panel_item choice = (Panel_item) handle;

  int max1 = no_strings;

  int i = 0;
  int found = -1;
  while (found == -1 && i < max1)
    {
      char *label = (char *) xv_get (choice, PANEL_CHOICE_STRING, i);
      if (label && strcmp (label, s) == 0)
	found = i;
      else
	i++;
    }
  return found;
#endif
}

char *wxChoice::GetString (int n)
{
#ifdef wx_motif
  wxNode *node = stringList.Nth (n);
  if (node)
    return (char *) node->Data ();
  else
    return NULL;
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  return (char *) xv_get (item, PANEL_CHOICE_STRING, n);
#endif
}

void wxChoice::SetColumns(int n)
{
  if (n<1) n = 1 ;

#ifdef wx_motif
  short numColumns = n ;
  Arg args[3];

  XtSetArg(args[0], XmNnumColumns, numColumns);
  XtSetArg(args[1], XmNpacking, XmPACK_COLUMN);
  XtSetValues(menuWidget,args,2) ;
#endif
#ifdef wx_xview
  xv_set((Xv_opaque)handle,PANEL_CHOICE_NCOLS,n,NULL) ;
#endif
}

int  wxChoice::GetColumns(void)
{
#ifdef wx_motif
  short numColumns ;

  XtVaGetValues(menuWidget,XmNnumColumns,&numColumns,NULL) ;
  return numColumns ;
#endif
#ifdef wx_xview
  return xv_get((Xv_opaque)handle,PANEL_CHOICE_NCOLS) ;
#endif
}

#ifdef wx_xview
void 
wxChoiceProc (Panel_item item, int value, Event * x_event)
{
  wxChoice *choice = (wxChoice *) xv_get (item, PANEL_CLIENT_DATA);
  wxCommandEvent event (wxEVENT_TYPE_CHOICE_COMMAND);

  event.commandString = (char *) xv_get (item, PANEL_CHOICE_STRING, value);
  event.commandInt = value;
  event.eventObject = choice;

  choice->ProcessCommand (event);
}
#endif

#ifdef wx_motif
void 
wxListBoxCallback (Widget w, XtPointer clientData,
		   XmListCallbackStruct * cbs)
{
/*
   if (cbs->reason == XmCR_EXTENDED_SELECT)
   cout << "*** Extend select\n";
   else if (cbs->reason == XmCR_SINGLE_SELECT)
   cout << "*** Single select\n";
   else if (cbs->reason == XmCR_MULTIPLE_SELECT)
   cout << "*** Multiple select\n";
   else if (cbs->reason == XmCR_BROWSE_SELECT)
   cout << "*** Browse select\n";

   if (cbs->selection_type == XmMODIFICATION)
   cout << "*** Modification\n";
   else if (cbs->selection_type == XmINITIAL)
   cout << "*** Initial\n";
   else if (cbs->selection_type == XmADDITION)
   cout << "*** Addition\n";
 */

  wxListBox *item = (wxListBox *) clientData;

  wxCommandEvent event (wxEVENT_TYPE_LISTBOX_COMMAND);
  switch (cbs->reason)
    {
    case XmCR_MULTIPLE_SELECT:
    case XmCR_BROWSE_SELECT:
      {
	event.clientData = item->GetClientData (cbs->item_position - 1);
	//event.commandString = item->GetStringSelection();
	event.commandInt = cbs->item_position - 1;
	event.commandString = item->GetString (event.commandInt);
	event.extraLong = TRUE;
	event.eventObject = item;
	item->ProcessCommand (event);
	// NO! result of GetStringSelection is wxBuffer
	//delete[] event.commandString;
	break;
      }
    case XmCR_EXTENDED_SELECT:
      {
	switch (cbs->selection_type)
	  {
	  case XmINITIAL:
	  case XmADDITION:
	  case XmMODIFICATION:
	    {
	      event.clientData = item->GetClientData (cbs->item_position - 1);
	      //event.commandString = item->GetStringSelection();
	      event.commandInt = cbs->item_position - 1;
	      event.commandString = item->GetString (event.commandInt);
	      event.extraLong = TRUE;
	      event.eventObject = item;
	      item->ProcessCommand (event);
	      break;
	    }
	  }
      }
    }
}

/* Respond by getting the
 * designated "default button" in the action area and activate it
 * as if the user had selected it.
 */
void 
wxListBoxDefaultActionProc (Widget list_w, XtPointer client_data, XmListCallbackStruct * cbs)
{
  wxListBox *lbox = (wxListBox *) client_data;
  wxPanel *panel = (wxPanel *) lbox->GetParent ();
  if (panel)
    panel->OnDefaultAction (lbox);
}

#endif

// Listbox item
wxListBox::wxListBox (void)
#ifdef wx_motif
: clientDataList (wxKEY_INTEGER)
#endif
{
  selected = -1;
  selections = 0;
  multiple = wxSINGLE;
  no_items = 0;
#ifdef wx_motif
  labelWidget = NULL;
#endif
#ifdef wx_xview
#endif
}

wxListBox::wxListBox (wxPanel * panel, wxFunction func,
	   char *Title, Bool Multiple,
	   int x, int y, int width, int height,
	   int N, char **Choices, long style, char *name):
wxbListBox (panel, func, Title, Multiple, x, y, width, height, N, Choices,
	    style, name)
#ifdef wx_motif
,clientDataList (wxKEY_INTEGER)
#endif
{
  Create (panel, func, Title, Multiple, x, y, width, height, N, Choices,
	  style, name);
}

Bool wxListBox::
Create (wxPanel * panel, wxFunction func,
	char *Title, Bool Multiple,
	int x, int y, int width, int height,
	int N, char **Choices, long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  selected = -1;
  selections = 0;
  multiple = Multiple & wxMULTIPLE_MASK;
  window_parent = panel;
  no_items = 0;
  labelPosition = panel->label_position;
  windowStyle = style;
#ifdef wx_motif
  windowName = copystring (name);

  Widget panelForm = panel->panelWidget;
  formWidget = XtVaCreateManagedWidget (windowName,
					xmFormWidgetClass, panelForm,
					XmNmarginHeight, 0,
					XmNmarginWidth, 0,
					NULL);

  if (Title)
    {
      char *the_label = (style & wxFIXED_LENGTH) ? fillCopy (Title) : copystring (Title);
      XmString text = XmStringCreateSimple (the_label);
      labelWidget = XtVaCreateManagedWidget (Title,
#ifdef USE_GADGETS
					     style & wxCOLOURED ?
				    xmLabelWidgetClass : xmLabelGadgetClass,
					     formWidget,
#else
					     xmLabelWidgetClass, formWidget,
#endif
					     XmNlabelString, text,
					     NULL);
      if (labelFont)
	XtVaSetValues (labelWidget,
		       XmNfontList, labelFont->GetInternalFont (),
		       NULL);

      XmStringFree (text);
      delete[]the_label;
    }

  Widget listWidget;
  Arg args[3];
  int count;
  XtSetArg (args[0], XmNlistSizePolicy, XmCONSTANT);
//  XtSetArg(args[0], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE);
  //  XtSetArg(args[0], XmNlistSizePolicy, XmVARIABLE);
  if (multiple == wxMULTIPLE)
    XtSetArg (args[1], XmNselectionPolicy, XmMULTIPLE_SELECT);
  else if (multiple == wxEXTENDED)
    XtSetArg (args[1], XmNselectionPolicy, XmEXTENDED_SELECT);
  else
    XtSetArg (args[1], XmNselectionPolicy, XmBROWSE_SELECT);
//  XtSetArg(args[2], XmNscrollBarDisplayPolicy, XmSTATIC);
  if ((Multiple & wxALWAYS_SB) || (style & wxALWAYS_SB))
    {
      XtSetArg (args[2], XmNscrollBarDisplayPolicy, XmSTATIC);
      count = 3;
    }
  else
    count = 2;


  listWidget = XmCreateScrolledList (formWidget, "listWidget", args, count);

  if (buttonFont)
    XtVaSetValues (listWidget,
		   XmNfontList, buttonFont->GetInternalFont (),
		   NULL);

  handle = (char *) listWidget;

  if (panel->label_position == wxHORIZONTAL)
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNalignment, XmALIGNMENT_BEGINNING,
		       NULL);
      XtVaSetValues (XtParent (listWidget),
		     XmNleftOffset, 4,
		     XmNtopAttachment, XmATTACH_FORM,
		     XmNbottomAttachment, XmATTACH_FORM,
	   XmNleftAttachment, labelWidget ? XmATTACH_WIDGET : XmATTACH_FORM,
		     XmNleftWidget, labelWidget ? labelWidget : formWidget,
		     XmNrightAttachment, XmATTACH_FORM,
		     NULL);
    }
  else
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNalignment, XmALIGNMENT_BEGINNING,
		       NULL);

      XtVaSetValues (XtParent (listWidget),
	    XmNtopAttachment, labelWidget ? XmATTACH_WIDGET : XmATTACH_FORM,
		     XmNtopWidget, labelWidget ? labelWidget : formWidget,
		     XmNbottomAttachment, XmATTACH_FORM,
		     XmNleftAttachment, XmATTACH_FORM,
		     XmNrightAttachment, XmATTACH_FORM,
		     NULL);
    }


  XtManageChild (listWidget);

  if (width == -1)
    width = 150;
  if (height == -1)
    height = 80;

  XtAddCallback (listWidget, XmNbrowseSelectionCallback, (XtCallbackProc) wxListBoxCallback,
		 (XtPointer) this);
  XtAddCallback (listWidget, XmNextendedSelectionCallback, (XtCallbackProc) wxListBoxCallback,
		 (XtPointer) this);
  XtAddCallback (listWidget, XmNmultipleSelectionCallback, (XtCallbackProc) wxListBoxCallback,
		 (XtPointer) this);

  XtAddCallback (listWidget, XmNdefaultActionCallback, (XtCallbackProc) wxListBoxDefaultActionProc,
		 (XtPointer) this);

  AttachWidget (panel, formWidget, x, y, width, height);
  ChangeColour ();

  if (N > 0)
    for (int i = 0; i < N; i++)
      Append (Choices[i]);

  /* After creating widgets, no more resizes. */
  if (style & wxFIXED_LENGTH)
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_SELF,
		       XmNleftAttachment, XmATTACH_SELF,
		       NULL);

      XtVaSetValues (XtParent (listWidget),
		     XmNtopAttachment, XmATTACH_SELF,
		     XmNbottomAttachment, XmATTACH_SELF,
		     XmNleftAttachment, XmATTACH_SELF,
		     XmNrightAttachment, XmATTACH_SELF,
		     NULL);
      if (labelWidget)
	{
	  XmString text = XmStringCreateSimple (Title);
	  XtVaSetValues (labelWidget,
			 XmNlabelString, text,
			 NULL);
	  XmStringFree (text);
	}
    }
#endif
#ifdef wx_xview
  // char *title = NULL;

  int choose_one = ((Multiple & wxMULTIPLE_MASK) == wxSINGLE);
  Panel x_panel = (Panel) panel->GetHandle ();
  Panel_item x_list;

  int label_position;
  if (panel->label_position == wxVERTICAL)
    label_position = PANEL_VERTICAL;
  else
    label_position = PANEL_HORIZONTAL;

  if (panel->new_line)
    {
      x_list = (Panel_item) xv_create (x_panel, PANEL_LIST, PANEL_LAYOUT, label_position, PANEL_NEXT_ROW, -1, NULL);
      panel->new_line = FALSE;
    }
  else
    x_list = (Panel_item) xv_create (x_panel, PANEL_LIST, PANEL_LAYOUT, label_position, NULL);

  if (Title)
    {
      if (style & wxFIXED_LENGTH)
	{
	  char *the_label = fillCopy (Title);
	  xv_set (x_list, PANEL_LABEL_STRING, the_label, NULL);

	  int label_x = (int) xv_get (x_list, PANEL_LABEL_X);
	  int item_x = (int) xv_get (x_list, PANEL_ITEM_X);
	  xv_set (x_list, PANEL_LABEL_STRING, Title,
		  PANEL_LABEL_X, label_x,
		  PANEL_ITEM_X, item_x,
		  NULL);
	}
      else
	xv_set (x_list, PANEL_LABEL_STRING, Title, NULL);
    }

  xv_set (x_list,
	  PANEL_CHOOSE_ONE, choose_one,
	  PANEL_NOTIFY_PROC, wxListProc,
	  PANEL_CLIENT_DATA, (char *) this,
	  PANEL_ITEM_MENU, NULL,
	  NULL);
  if (x > -1 && y > -1)
    (void) xv_set (x_list, XV_X, x, XV_Y, y, NULL);

  handle = (char *) x_list;

  SetSize (x, y, width, height);

/*
   if (buttonFont)
   xv_set(x_list, XV_FONT, buttonFont->GetInternalFont(), NULL) ;
 */


  if (N > 0)
    Set (N, Choices);

#endif

  Callback (func);
  return TRUE;
}

wxListBox::~wxListBox (void)
{
  if (selections)
    delete[]selections;
}

void wxListBox::ChangeColour (void)
{
#ifdef wx_motif
  int change;

  wxPanel *panel = (wxPanel *) window_parent;
  change = wxComputeColors (panel->backColour,
			    panel->buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues (formWidget,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues (formWidget,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  change = wxComputeColors (backColour, buttonColour);
  if (change == wxBACK_COLORS)
    {
      XtVaSetValues ((Widget) handle,
		     XmNbackground, itemColors[wxBACK_INDEX].pixel,
		     XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		     XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		     XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      Widget parent = XtParent ((Widget) handle);
      XtVaSetValues (parent,
		     XmNbackground, itemColors[wxBACK_INDEX].pixel,
		     XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		     XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		     XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      Widget hsb, vsb;
      XtVaGetValues (parent,
		     XmNhorizontalScrollBar, &hsb,
		     XmNverticalScrollBar, &vsb,
		     NULL);
      if (hsb)
	XtVaSetValues (hsb,
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      if (vsb)
	XtVaSetValues (vsb,
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }
  else if (change == wxFORE_COLORS)
    {
      XtVaSetValues ((Widget) handle,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      Widget parent = XtParent ((Widget) handle);
      XtVaSetValues (parent,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      Widget hsb, vsb;
      XtVaGetValues (parent,
		     XmNhorizontalScrollBar, &hsb,
		     XmNverticalScrollBar, &vsb,
		     NULL);
      if (hsb)
	XtVaSetValues (hsb,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      if (vsb)
	XtVaSetValues (vsb,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }

  if (labelWidget)
    {
      change = wxComputeColors (panel->backColour, labelColour);

      if (change == wxBACK_COLORS)
	XtVaSetValues (labelWidget,
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      else if (change == wxFORE_COLORS)
	XtVaSetValues (labelWidget,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }
#endif
}


void wxListBox::SetFirstItem (int N)
{
#ifdef wx_motif
  int count, length;

  if (N < 0)
    return;
  XtVaGetValues ((Widget) handle,
		 XmNvisibleItemCount, &count,
		 XmNitemCount, &length,
		 NULL);
  if ((N + count) >= length)
    N = length - count;
  XmListSetPos ((Widget) handle, N + 1);
#endif
#ifdef wx_xview
#endif
}

void wxListBox::SetFirstItem (char *s)
{
  int N = FindString (s);

  if (N >= 0)
    SetFirstItem (N);
}

void wxListBox::Delete (int N)
{
#ifdef wx_motif
  XmListDeletePos ((Widget) handle, N + 1);
  // (JDH) need to add code here to take care of clientDataList
  wxNode *node = clientDataList.Find((long)N);  // get item from list
  if (node) clientDataList.DeleteNode(node);    // if existed then delete from list
  node = clientDataList.First();                // we now have to adjust all keys that 
  while (node)                                  // are >=N+1
   { if (node->key.integer >= (long)(N+1))      // very ugly C++ wise but no other way 
       node->key.integer--;                     // to look at or change key value
     node = node->Next();
   }

#endif
#ifdef wx_xview
  Panel_item list_item = (Panel_item) handle;

  xv_set (list_item, PANEL_LIST_DELETE, N, NULL);
#endif
  no_items--;
}

void wxListBox::Append (char *Item)
{
#ifdef wx_motif
  int width1, height1;
  int width2, height2;

  Widget listBox = (Widget) handle;
  GetSize (&width1, &height1);

  XtUnmanageChild (formWidget);
  int n;
  XtVaGetValues (listBox, XmNitemCount, &n, NULL);
  XmString text = XmStringCreateSimple (Item);
//  XmListAddItem(listBox, text, n + 1);
  XmListAddItemUnselected (listBox, text, 0);
  XmStringFree (text);

  // It seems that if the list is cleared, we must re-ask for
  // selection policy!!
  Arg args[3];
  XtSetArg (args[0], XmNlistSizePolicy, XmCONSTANT);
  if (multiple == wxMULTIPLE)
    XtSetArg (args[1], XmNselectionPolicy, XmMULTIPLE_SELECT);
  else if (multiple == wxEXTENDED)
    XtSetArg (args[1], XmNselectionPolicy, XmEXTENDED_SELECT);
  else
    XtSetArg (args[1], XmNselectionPolicy, XmBROWSE_SELECT);
  XtSetValues (listBox, args, 2);

  XtManageChild (formWidget);

  GetSize (&width2, &height2);
  // Correct for randomly resized listbox - bad boy, Motif!
  if (width1 != width2 || height1 != height2)
    SetSize (-1, -1, width1, height1);

#endif
#ifdef wx_xview
  char *label = Item;
  Panel_item list_item = (Panel_item) handle;

  int n = (int) xv_get (list_item, PANEL_LIST_NROWS);

  xv_set (list_item, PANEL_LIST_INSERT, n,
	  PANEL_LIST_STRING, n, label,
	  PANEL_LIST_CLIENT_DATA, n, n,
	  NULL);

#endif
  no_items++;
}

void wxListBox::Append (char *Item, char *Client_data)
{
#ifdef wx_motif
  int width1, height1;
  int width2, height2;

  Widget listBox = (Widget) handle;

  GetSize (&width1, &height1);
  XtUnmanageChild (formWidget);

  int n;
  XtVaGetValues (listBox, XmNitemCount, &n, NULL);
  XmString text = XmStringCreateSimple (Item);
//  XmListAddItem(listBox, text, n + 1);
  XmListAddItemUnselected (listBox, text, 0);
  XmStringFree (text);

  // It seems that if the list is cleared, we must re-ask for
  // selection policy!!
  Arg args[3];
  XtSetArg (args[0], XmNlistSizePolicy, XmCONSTANT);
  if (multiple == wxMULTIPLE)
    XtSetArg (args[1], XmNselectionPolicy, XmMULTIPLE_SELECT);
  else if (multiple == wxEXTENDED)
    XtSetArg (args[1], XmNselectionPolicy, XmEXTENDED_SELECT);
  else
    XtSetArg (args[1], XmNselectionPolicy, XmBROWSE_SELECT);
  XtSetValues (listBox, args, 2);

  clientDataList.Append ((long) n, (wxObject *) Client_data);

  XtManageChild (formWidget);
  GetSize (&width2, &height2);

  // Correct for randomly resized listbox - bad boy, Motif!
  if (width1 != width2 || height1 != height2)
    SetSize (-1, -1, width1, height1);

#endif
#ifdef wx_xview
  char *label = Item;
  Panel_item list_item = (Panel_item) handle;

  int n = (int) xv_get (list_item, PANEL_LIST_NROWS);

  xv_set (list_item, PANEL_LIST_INSERT, n,
	  PANEL_LIST_STRING, n, label,
	  PANEL_LIST_CLIENT_DATA, n, Client_data,
	  NULL);

#endif
  no_items++;
}

void wxListBox::Set (int n, char *choices[])
{
#ifdef wx_motif
  //for (int i = 0; i < n; i++)
  //  Append(choices[i]);
  //
  // To avoid flickering, we do only one Manage/Unmanage.

  int width1, height1;
  int width2, height2;

  Widget listBox = (Widget) handle;
  GetSize (&width1, &height1);

  XtUnmanageChild (formWidget);
/***
  for (int i=0; i<n; i++)
  {
    XmString text = XmStringCreateSimple(choices[i]);
    XmListAddItemUnselected(listBox, text, 0);
    XmStringFree(text);
  }
***/
//wxDebugMsg("Start add\n") ;
  XmString *text = new XmString[n];
  for (int i = 0; i < n; i++)
    text[i] = XmStringCreateSimple (choices[i]);
  XmListAddItems (listBox, text, n, 0);
  for (i = 0; i < n; i++)
    XmStringFree (text[i]);
  delete[]text;
//wxDebugMsg("End Add\n") ;

  // It seems that if the list is cleared, we must re-ask for
  // selection policy!!
  Arg args[3];
  XtSetArg (args[0], XmNlistSizePolicy, XmCONSTANT);
  if (multiple == wxMULTIPLE)
    XtSetArg (args[1], XmNselectionPolicy, XmMULTIPLE_SELECT);
  else if (multiple == wxEXTENDED)
    XtSetArg (args[1], XmNselectionPolicy, XmEXTENDED_SELECT);
  else
    XtSetArg (args[1], XmNselectionPolicy, XmBROWSE_SELECT);
  XtSetValues (listBox, args, 2);

  XtManageChild (formWidget);

  GetSize (&width2, &height2);
  // Correct for randomly resized listbox - bad boy, Motif!
  if (width1 != width2 || height1 != height2)
    SetSize (-1, -1, width1, height1);

#endif
#ifdef wx_xview
  Panel_item list = (Panel_item) handle;
  if (selections)
    {
      delete[]selections;
      selections = NULL;
    }

  int max1 = (int) xv_get (list, PANEL_LIST_NROWS);
  xv_set (list, PANEL_LIST_DELETE_ROWS, 0, max1, NULL);

  int i;
  for (i = 0; i < n; i++)
    {
      char *label = choices[i];
      xv_set (list, PANEL_LIST_INSERT, i,
	      PANEL_LIST_STRING, i, label,
	      PANEL_LIST_CLIENT_DATA, i, i,
	      NULL);
    }
#endif
  no_items = n;
}

int wxListBox::FindString (char *s)
{
#ifdef wx_motif
  XmString str = XmStringCreateSimple (s);
  int *positions = NULL;
  int no_positions = 0;
  Bool success = XmListGetMatchPos ((Widget) handle, str, &positions, &no_positions);
  XmStringFree (str);
  if (success)
    {
      int pos = positions[0];
      if (positions)
	XtFree ((char *) positions);
      return pos - 1;
    }
  else
    return -1;
#endif
#ifdef wx_xview
  Panel_item list = (Panel_item) handle;

  int max1 = (int) xv_get (list, PANEL_LIST_NROWS);

  int i = 0;
  int found = -1;
  while (found == -1 && i < max1)
    {
      char *label = (char *) xv_get (list, PANEL_LIST_STRING, i);
      if (label && strcmp (label, s) == 0)
	found = i;
      else
	i++;
    }
  return found;
#endif
}

void wxListBox::Clear (void)
{
  if (no_items <= 0)
    return;
#ifdef wx_motif
  XmListDeleteAllItems ((Widget) handle);
  clientDataList.Clear ();
#endif
#ifdef wx_xview
  Panel_item list_item = (Panel_item) handle;
  xv_set (list_item, PANEL_LIST_DELETE_ROWS, 0, no_items, NULL);
#endif
  no_items = 0;
}

void wxListBox::SetSelection (int N, Bool select)
{
#ifdef wx_motif
  if (select)
    {
/*
      if (multiple)
	{
	  int *selections = NULL;
	  int n = GetSelections (&selections);

	  // This hack is supposed to work, to make it possible to select more
	  // than one item, but it DOESN'T under Motif 1.1.

	  XtVaSetValues ((Widget) handle, XmNselectionPolicy, XmMULTIPLE_SELECT, NULL);

	  for (int i = 0; i < n; i++)
	    XmListSelectPos ((Widget) handle, selections[i] + 1, FALSE);

	  XmListSelectPos ((Widget) handle, N + 1, FALSE);

	  XtVaSetValues ((Widget) handle, XmNselectionPolicy, XmEXTENDED_SELECT, NULL);
	}
      else
*/
	XmListSelectPos ((Widget) handle, N + 1, FALSE);

    }
  else
    XmListDeselectPos ((Widget) handle, N + 1);
#endif
#ifdef wx_xview
  Panel_item list_item = (Panel_item) handle;
  xv_set (list_item, PANEL_LIST_SELECT, N, select, NULL);
#endif
}

Bool wxListBox::Selected (int N)
{
#ifdef wx_motif
  // In Motif, no simple way to determine if the item is selected.
  int *theSelections;
  int count = GetSelections (&theSelections);
  if (count == 0)
    return FALSE;
  else
    for (int j = 0; j < count; j++)
      if (theSelections[j] == N)
	return TRUE;
  return FALSE;
#endif
#ifdef wx_xview
  Panel_item list_item = (Panel_item) handle;
  return (Bool) xv_get (list_item, PANEL_LIST_SELECTED, N);
#endif
}

void wxListBox::Deselect (int N)
{
#ifdef wx_motif
  XmListDeselectPos ((Widget) handle, N + 1);
#endif
#ifdef wx_xview
  Panel_item list_item = (Panel_item) handle;
  xv_set (list_item, PANEL_LIST_SELECT, N, FALSE, NULL);
#endif
}

char *wxListBox::GetClientData (int N)
{
#ifdef wx_motif
  wxNode *node = clientDataList.Find ((long) N);
  if (node)
    return (char *) node->Data ();
  else
    return NULL;
#endif
#ifdef wx_xview
  Panel_item list_item = (Panel_item) handle;
  char *data = (char *) xv_get (list_item, PANEL_LIST_CLIENT_DATA, N);
  return data;
#endif
}

// Return number of selections and an array of selected integers
// Use selections field to store data, which will be cleaned up
// by destructor if necessary.
int wxListBox::GetSelections (int **list_selections)
{
#ifdef wx_motif
  Widget listBox = (Widget) handle;
  int *posList = NULL;
  int posCnt = 0;
  Bool flag = XmListGetSelectedPos (listBox, &posList, &posCnt);
  if (flag)
    {
      if (posCnt > 0)
	{
	  if (selections)
	    delete[]selections;
	  selections = new int[posCnt];
	  for (int i = 0; i < posCnt; i++)
	    selections[i] = posList[i] - 1;

	  XtFree ((char *) posList);
	  *list_selections = selections;
	  return posCnt;
	}
      else
	return FALSE;
    }
  else
    return FALSE;
#endif
#ifdef wx_xview
  Panel_item x_list = (Panel_item) handle;

  int i = 0;
  int j = 0;

  if (selections)
    {
      delete[]selections;
      selections = NULL;
    }

  for (j = 0; j < no_items; j++)
    if (xv_get (x_list, PANEL_LIST_SELECTED, j))
      {
	i++;
      }
  if (i > 0)
    {
      selections = new int[i];
      int k = 0;
      for (j = 0; j < no_items; j++)
	if (xv_get (x_list, PANEL_LIST_SELECTED, j))
	  {
	    selections[k] = j;
	    k++;
	  }
    }

  *list_selections = selections;
  return i;
#endif
}

// Get single selection, for single choice list items
int wxListBox::GetSelection (void)
{
#ifdef wx_motif
  Widget listBox = (Widget) handle;
  int *posList = NULL;
  int posCnt = 0;
  Bool flag = XmListGetSelectedPos (listBox, &posList, &posCnt);
  if (flag)
    {
      int id = -1;
      if (posCnt > 0)
	id = posList[0] - 1;
      XtFree ((char *) posList);
      return id;
    }
  else
    return -1;
#endif
#ifdef wx_xview
  Panel_item x_list = (Panel_item) handle;

  int i = 0;
  if (selections)
    {
      delete[]selections;
      selections = NULL;
    }

  int found = -1;
  while (found == -1 && i < no_items)
    {
      if (xv_get (x_list, PANEL_LIST_SELECTED, i))
	found = i;
      else
	i++;
    }

  return found;
#endif
}

// Find string for position
char *wxListBox::GetString (int N)
{
#ifdef wx_motif
  Widget listBox = (Widget) handle;
  XmString *strlist;
  int n;
  XtVaGetValues (listBox, XmNitemCount, &n, XmNitems, &strlist, NULL);
  if (N <= n)
    {
      char *txt;
      if (XmStringGetLtoR (strlist[N], XmSTRING_DEFAULT_CHARSET, &txt))
	{
	  strcpy (wxBuffer, txt);
	  XtFree (txt);
	  return wxBuffer;
	}
      else
	return NULL;
    }
  else
    return NULL;

#endif
#ifdef wx_xview
  Panel_item x_list = (Panel_item) handle;
  return (char *) xv_get (x_list, PANEL_LIST_STRING, N);
#endif
}

void wxListBox::SetSize (int x, int y, int width, int height)
{
#ifdef wx_motif
  XtUnmanageChild (formWidget);

  if (x > -1)
    XtVaSetValues (formWidget, XmNleftAttachment, XmATTACH_SELF,
		   XmNx, x, NULL);
  if (y > -1)
    XtVaSetValues (formWidget, XmNtopAttachment, XmATTACH_SELF,
		   XmNy, y, NULL);

  // Must set the actual listbox to be desired size MINUS label size
  Dimension labelWidth = 0, labelHeight = 0, actualWidth = width, actualHeight = height;

  if (labelWidget)
    XtVaGetValues (labelWidget, XmNwidth, &labelWidth, XmNheight, &labelHeight, NULL);

  if (itemOrientation == wxHORIZONTAL)
    {
      actualWidth = width - labelWidth;
      actualHeight = height;
    }
  else
    {
      actualWidth = width;
      actualHeight = height - labelHeight;
    }

  if (width > -1)
    {
      int scrollWidthX = 0;
      // width - 10 is a fudge factor for taking the scroll bar into account.
      // A better way anybody?
      XtVaSetValues (formWidget, XmNwidth, width - scrollWidthX, XmNrightAttachment, XmATTACH_SELF, NULL);
    }
  if (height > -1)
    {
      XtVaSetValues (formWidget, XmNheight, height, XmNbottomAttachment, XmATTACH_SELF, NULL);
    }

  XtManageChild (formWidget);

  // Check resulting size is correct
  int tempW, tempH;
  GetSize (&tempW, &tempH);

  OnSize (width, height);
#endif
#ifdef wx_xview
  // Unfortunately, XView doesn't allow us to
  // set the height in pixels explicitly. Bummer!
//  wxItem::SetSize(x, y, width, height);
//  return;

  // Fudge factor for slider width
  int listBoxSliderWidth = 15;

  Xv_opaque x_win = (Xv_opaque) handle;
  int labelWidth = 0;
  int panelLayout = (int)xv_get(x_win, PANEL_LAYOUT);
  if (panelLayout == PANEL_HORIZONTAL)
    labelWidth = (int)xv_get(x_win, PANEL_LABEL_WIDTH);

  Panel_item list_item = (Panel_item) handle;

  int row_height = (int) xv_get (list_item, PANEL_LIST_ROW_HEIGHT);

  if (x > -1)
    xv_set (list_item, XV_X, x, NULL);

  if (y > -1)
    xv_set (list_item, XV_Y, y, NULL);

  if (width == -1 || height == -1)
    {
      int ww, hh;
      GetSize (&ww, &hh);
      if (width == -1)
	width = ww;
      if (height == -1)
	height = hh;
    }

  int actual_width = width;

  // Not quite sure whether this is needed: is PANEL_LIST_WIDTH
  // the whole thing incl. label or just the list?
  if (panelLayout == PANEL_HORIZONTAL)
    actual_width = width - labelWidth;

  if (width > -1)
    xv_set (list_item,
	    PANEL_LIST_WIDTH, max ((actual_width - listBoxSliderWidth), 60), NULL);
  else
    xv_set (list_item,
	    PANEL_LIST_WIDTH, 0, NULL);

  Xv_Font labelFont = (Xv_Font) xv_get (list_item, PANEL_LABEL_FONT);
  int labelHeight =  (int) xv_get (labelFont, FONT_DEFAULT_CHAR_HEIGHT);

  // Subtract the label height if we're in vertical label mode.
  int actual_height = height;
  if (panelLayout == PANEL_VERTICAL)
    actual_height -= labelHeight;

  if (height > -1)
  {
    int noRows = max ((int) (actual_height / row_height), 4);
//    wxDebugMsg("actual_height = %d, row_height = %d, labelHeight = %d, height = %d, noRows = %d\n",
//      actual_height, row_height, labelHeight, height, noRows);
    xv_set (list_item,
	PANEL_LIST_DISPLAY_ROWS, noRows,
	    NULL);
  }
  else
    xv_set (list_item,
	    PANEL_LIST_DISPLAY_ROWS, 4,
	    NULL);
  OnSize (width, height);

  // Debugging
/*
  Rect *rect = (Rect *) xv_get (list_item, XV_RECT);

  int hh = rect->r_height;
  int ww = rect->r_width;
  wxDebugMsg("Size after setting = %d, %d\n", ww, hh);
*/
#endif
}

#ifdef wx_xview
int 
wxListProc (Panel_item item, char *string, Xv_opaque client_data,
	    Panel_list_op op, Event * x_event, int row)
{
  if (op == PANEL_LIST_OP_SELECT || op == PANEL_LIST_OP_DESELECT)
//  if (op == PANEL_LIST_OP_SELECT)
    {
      wxListBox *list = (wxListBox *) xv_get (item, PANEL_CLIENT_DATA);
      if ((op == PANEL_LIST_OP_SELECT) || (list->multiple != wxSINGLE))
	{
	  wxCommandEvent event (wxEVENT_TYPE_LISTBOX_COMMAND);
	  event.commandString = string;
	  event.commandInt = row;
	  event.extraLong = (op == PANEL_LIST_OP_SELECT);
	  event.clientData = (char *) client_data;
	  event.eventHandle = (char *) x_event;
	  event.eventObject = list;
	  list->ProcessCommand (event);
	}
    }
  return XV_OK;
}
#endif

#ifdef wx_motif
void 
wxRadioBoxCallback (Widget w, XtPointer clientData,
		    XmToggleButtonCallbackStruct * cbs)
{
  if (!cbs->set)
    return;

  wxRadioBox *item = (wxRadioBox *) clientData;
  int sel = -1;
  for (int i = 0; i < item->no_items; i++)
    if (item->radioButtons && (item->radioButtons[i] == w))
      sel = i;
  item->selected = sel;

  wxCommandEvent event (wxEVENT_TYPE_RADIOBOX_COMMAND);
  event.commandInt = sel;
  event.eventHandle = (char *) cbs->event;
  event.eventObject = item;
  item->ProcessCommand (event);
}
#endif

#ifdef wx_xview
void 
wxRadioBoxProc (Panel_item item, int value, Event * x_event)
{
  wxRadioBox *box = (wxRadioBox *) xv_get (item, PANEL_CLIENT_DATA);

  wxCommandEvent event (wxEVENT_TYPE_RADIOBOX_COMMAND);

  event.commandString = (char *) xv_get (item, PANEL_CHOICE_STRING, value);
  event.commandInt = value;
  event.eventHandle = (char *) x_event;
  event.eventObject = box;
  box->ProcessCommand (event);
}
#endif


// Radiobox item
wxRadioBox::wxRadioBox (void)
{
  selected = -1;
  no_items = 0;
  buttonBitmap = NULL;
#ifdef wx_motif
  radioButtons = NULL;
  radioButtonLabels = NULL;
  labelWidget = NULL;
#endif
#ifdef wx_xview
#endif
}

wxRadioBox::wxRadioBox (wxPanel * panel, wxFunction func,
	    char *Title,
	    int x, int y, int width, int height,
	    int N, char **Choices,
	    int majorDim, long Style, char *name):
wxbRadioBox (panel, func, Title, x, y, width, height, N, Choices,
	     majorDim, Style, name)
{
  Create (panel, func, Title, x, y, width, height, N, Choices, majorDim, Style, name);
}

wxRadioBox::wxRadioBox (wxPanel * panel, wxFunction func,
	    char *Title,
	    int x, int y, int width, int height,
	    int N, wxBitmap ** Choices,
	    int majorDim, long Style, char *name):
wxbRadioBox (panel, func, Title, x, y, width, height, N, Choices,
	     majorDim, Style, name)
{
  Create (panel, func, Title, x, y, width, height, N, Choices, majorDim, Style, name);
}

Bool wxRadioBox::
Create (wxPanel * panel, wxFunction func,
	char *Title,
	int x, int y, int width, int height,
	int N, char **Choices,
	int majorDim, long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  buttonBitmap = new wxBitmap *[N];
  for (int i = 0; i < N; i++)
    buttonBitmap[i] = NULL;
  selected = -1;
  window_parent = panel;
  no_items = N;
  labelPosition = panel->label_position;
  if (majorDim == 0)
    majorDim = N;
  windowStyle = style;
#ifdef wx_motif
  windowName = copystring (name);
  Widget panelForm = panel->panelWidget;
  formWidget = XtVaCreateManagedWidget (windowName,
					xmFormWidgetClass, panelForm,
					XmNmarginHeight, 0,
					XmNmarginWidth, 0,
					NULL);

  XmString text = 0;

  if (Title)
    {
      char *the_label = (style & wxFIXED_LENGTH) ? fillCopy (Title) : copystring (Title);
      text = XmStringCreateSimple (the_label);
      labelWidget = XtVaCreateManagedWidget (Title,
#ifdef USE_GADGETS
					     style & wxCOLOURED ?
				    xmLabelWidgetClass : xmLabelGadgetClass,
					     formWidget,
#else
					     xmLabelWidgetClass, formWidget,
#endif
					     XmNlabelString, text,
					     NULL);
      if (labelFont)
	XtVaSetValues (labelWidget,
		       XmNfontList, labelFont->GetInternalFont (),
		       NULL);

      XmStringFree (text);
      delete[]the_label;
    }

  Arg args[3];
  //XtSetArg(args[0], XmNorientation, XmVERTICAL);
  //XtSetArg(args[1], XmNnumColumns, (panel->label_position == wxHORIZONTAL) ? N : 1);

  majorDim = (N + majorDim - 1) / majorDim;
  XtSetArg (args[0], XmNorientation, panel->label_position == wxHORIZONTAL ?
	    XmHORIZONTAL : XmVERTICAL);
  XtSetArg (args[1], XmNnumColumns, majorDim);

  Widget radioBoxWidget = XmCreateRadioBox (formWidget, "radioBoxWidget", args, 2);

  handle = (char *) radioBoxWidget;

  if (panel->label_position == wxHORIZONTAL)
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNbottomAttachment, XmATTACH_FORM,
		       XmNalignment, XmALIGNMENT_BEGINNING,
		       NULL);
      XtVaSetValues (radioBoxWidget,
		     XmNleftOffset, 4,
		     XmNtopAttachment, XmATTACH_FORM,
		     XmNbottomAttachment, XmATTACH_FORM,
	   XmNleftAttachment, labelWidget ? XmATTACH_WIDGET : XmATTACH_FORM,
		     XmNleftWidget, labelWidget ? labelWidget : formWidget,
		     NULL);
    }
  else
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNalignment, XmALIGNMENT_BEGINNING,
		       NULL);

      XtVaSetValues (radioBoxWidget,
	    XmNtopAttachment, labelWidget ? XmATTACH_WIDGET : XmATTACH_FORM,
		     XmNtopWidget, labelWidget ? labelWidget : formWidget,
		     XmNbottomAttachment, XmATTACH_FORM,
		     XmNleftAttachment, XmATTACH_FORM,
		     NULL);
    }

  if (style & wxFLAT)
    XtVaSetValues (radioBoxWidget, XmNborderWidth, 1, NULL);

  radioButtons = new Widget[N];
  radioButtonLabels = new char *[N];
  for (i = 0; i < N; i++)
    {
      radioButtonLabels[i] = copystring (Choices[i]);
      radioButtons[i] = XtVaCreateManagedWidget (Choices[i],
#if USE_GADGETS
						 style & wxCOLOURED ?
		      xmToggleButtonWidgetClass : xmToggleButtonGadgetClass,
						 radioBoxWidget,
#else
				  xmToggleButtonWidgetClass, radioBoxWidget,
#endif
						 NULL);
      XtAddCallback (radioButtons[i], XmNvalueChangedCallback, (XtCallbackProc) wxRadioBoxCallback,
		     (XtCallbackProc) this);

      if (buttonFont)
	XtVaSetValues (radioButtons[i],
		       XmNfontList, buttonFont->GetInternalFont (),
		       NULL);
    }
  SetSelection (0);

  XtManageChild (radioBoxWidget);

  if (width == -1)
    width = 150;
  if (height == -1)
    height = 80;

  AttachWidget (panel, formWidget, x, y, width, height);
  ChangeColour ();

  /* After creating widgets, no more resizes. */
  if (style & wxFIXED_LENGTH)
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_SELF,
		       XmNleftAttachment, XmATTACH_SELF,
		       NULL);

      XtVaSetValues (radioBoxWidget,
		     XmNtopAttachment, XmATTACH_SELF,
		     XmNbottomAttachment, XmATTACH_SELF,
		     XmNleftAttachment, XmATTACH_SELF,
		     XmNrightAttachment, XmATTACH_SELF,
		     NULL);
      if (labelWidget)
	{
	  XmString text = XmStringCreateSimple (Title);
	  XtVaSetValues (labelWidget,
			 XmNlabelString, text,
			 NULL);
	  XmStringFree (text);
	}
    }
#endif
#ifdef wx_xview
  char *title = NULL;
  if (Title)
    title = Title;

  Panel x_panel = (Panel) panel->GetHandle ();
  Panel_item x_choice;

  int label_position;
  if (panel->label_position == wxVERTICAL)
    label_position = PANEL_VERTICAL;
  else
    label_position = PANEL_HORIZONTAL;

  if (panel->new_line)
    {
      x_choice = (Panel_item) xv_create (x_panel, PANEL_CHOICE, PANEL_LAYOUT, label_position, PANEL_NEXT_ROW, -1, NULL);
      panel->new_line = FALSE;
    }
  else
    x_choice = (Panel_item) xv_create (x_panel, PANEL_CHOICE, PANEL_LAYOUT, label_position, NULL);

/*
   if (buttonFont)
   xv_set(x_choice, XV_FONT, buttonFont->GetInternalFont(), NULL) ;
 */
  xv_set (x_choice,
	  PANEL_LABEL_STRING, title,
	  PANEL_NOTIFY_PROC, wxRadioBoxProc,
	  PANEL_CLIENT_DATA, (char *) this,
	  NULL);
  if (majorDim != N)
    {
      majorDim = (N + majorDim - 1) / majorDim;
      xv_set (x_choice,
	      PANEL_CHOICE_NCOLS, majorDim,
	      NULL);
    }

  if (x > -1 && y > -1)
    (void) xv_set (x_choice, XV_X, x, XV_Y, y, NULL);

  for (i = 0; i < N; i++)
    {
      char *label = Choices[i];
      xv_set (x_choice, PANEL_CHOICE_STRING, i, label, NULL);
    }
  handle = (char *) x_choice;
  xv_set (x_choice, PANEL_VALUE, 0, NULL);

  if (Title && (style & wxFIXED_LENGTH))
    {
      char *the_label = fillCopy (Title);
      xv_set (x_choice, PANEL_LABEL_STRING, the_label, NULL);
      int label_x = (int) xv_get (x_choice, PANEL_LABEL_X);
      int item_x = (int) xv_get (x_choice, PANEL_ITEM_X);
      xv_set (x_choice, PANEL_LABEL_STRING, Title,
	      PANEL_LABEL_X, label_x,
	      PANEL_ITEM_X, item_x,
	      NULL);
    }

#endif

  Callback (func);
  return TRUE;
}

Bool wxRadioBox::
Create (wxPanel * panel, wxFunction func,
	char *Title,
	int x, int y, int width, int height,
	int N, wxBitmap ** Choices,
	int majorDim, long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  selected = -1;
  window_parent = panel;
  no_items = N;
  labelPosition = panel->label_position;
  if (majorDim == 0)
    majorDim = N;
  buttonBitmap = new wxBitmap *[N];
  for (int i = 0; i < N; i++)
    buttonBitmap[i] = Choices[i];
  windowStyle = style;
#ifdef wx_motif
  windowName = copystring (name);
  Widget panelForm = panel->panelWidget;
  formWidget = XtVaCreateManagedWidget (windowName,
					xmFormWidgetClass, panelForm,
					XmNmarginHeight, 0,
					XmNmarginWidth, 0,
					NULL);

  if (Title)
    {
      char *the_label = (style & wxFIXED_LENGTH) ? fillCopy (Title) : copystring (Title);
      XmString text = XmStringCreateSimple (the_label);
      labelWidget = XtVaCreateManagedWidget (Title,
#ifdef USE_GADGETS
					     style & wxCOLOURED ?
				    xmLabelWidgetClass : xmLabelGadgetClass,
					     formWidget,
#else
					     xmLabelWidgetClass, formWidget,
#endif
					     XmNlabelString, text,
					     NULL);
      if (labelFont)
	XtVaSetValues (labelWidget,
		       XmNfontList, labelFont->GetInternalFont (),
		       NULL);

      XmStringFree (text);
      delete[]the_label;
    }

  Arg args[3];
  //XtSetArg(args[0], XmNorientation, XmVERTICAL);
  //XtSetArg(args[1], XmNnumColumns, (panel->label_position == wxHORIZONTAL) ? N : 1);

  majorDim = (N + majorDim - 1) / majorDim;
  XtSetArg (args[0], XmNorientation, panel->label_position == wxHORIZONTAL ?
	    XmHORIZONTAL : XmVERTICAL);
  XtSetArg (args[1], XmNnumColumns, majorDim);

  Widget radioBoxWidget = XmCreateRadioBox (formWidget, "radioBoxWidget", args, 2);

  handle = (char *) radioBoxWidget;

  if (panel->label_position == wxHORIZONTAL)
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNbottomAttachment, XmATTACH_FORM,
		       XmNalignment, XmALIGNMENT_BEGINNING,
		       NULL);
      XtVaSetValues (radioBoxWidget,
		     XmNleftOffset, 4,
		     XmNtopAttachment, XmATTACH_FORM,
		     XmNbottomAttachment, XmATTACH_FORM,
	   XmNleftAttachment, labelWidget ? XmATTACH_WIDGET : XmATTACH_FORM,
		     XmNleftWidget, labelWidget ? labelWidget : formWidget,
		     NULL);
    }
  else
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNalignment, XmALIGNMENT_BEGINNING,
		       NULL);

      XtVaSetValues (radioBoxWidget,
	    XmNtopAttachment, labelWidget ? XmATTACH_WIDGET : XmATTACH_FORM,
		     XmNtopWidget, labelWidget ? labelWidget : formWidget,
		     XmNbottomAttachment, XmATTACH_FORM,
		     XmNleftAttachment, XmATTACH_FORM,
		     NULL);
    }

  if (style & wxFLAT)
    XtVaSetValues (radioBoxWidget, XmNborderWidth, 1, NULL);

  radioButtons = new Widget[N];
  radioButtonLabels = new char *[N];
  for (i = 0; i < N; i++)
    {
      char tmp[20];
      sprintf (tmp, "Toggle%d", i);
      radioButtonLabels[i] = copystring (tmp);
      radioButtons[i] = XtVaCreateManagedWidget (tmp,
#if USE_GADGETS
						 style & wxCOLOURED ?
		      xmToggleButtonWidgetClass : xmToggleButtonGadgetClass,
						 radioBoxWidget,
#else
				  xmToggleButtonWidgetClass, radioBoxWidget,
#endif
						 NULL);
      Widget buttonWidget = radioButtons[i];
      XtVaSetValues (buttonWidget,
		  XmNlabelPixmap, Choices[i]->GetLabelPixmap (buttonWidget),
		 XmNselectPixmap, Choices[i]->GetLabelPixmap (buttonWidget),
      XmNlabelInsensitivePixmap, Choices[i]->GetInsensPixmap (buttonWidget),
      XmNselectInsensitivePixmap, Choices[i]->GetInsensPixmap (buttonWidget),
		     XmNarmPixmap, Choices[i]->GetArmPixmap (buttonWidget),
		     XmNlabelType, XmPIXMAP,
		     NULL);

      XtAddCallback (buttonWidget, XmNvalueChangedCallback, (XtCallbackProc) wxRadioBoxCallback, (XtPointer) this);
      if (buttonFont)
	XtVaSetValues (buttonWidget,
		       XmNfontList, buttonFont->GetInternalFont (),
		       NULL);
    }
  SetSelection (0);

  XtManageChild (radioBoxWidget);

  if (width == -1)
    width = 150;
  if (height == -1)
    height = 80;

  AttachWidget (panel, formWidget, x, y, width, height);
  ChangeColour ();


  /* After creating widgets, no more resizes. */
  if (style & wxFIXED_LENGTH)
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_SELF,
		       XmNleftAttachment, XmATTACH_SELF,
		       NULL);

      XtVaSetValues (radioBoxWidget,
		     XmNtopAttachment, XmATTACH_SELF,
		     XmNbottomAttachment, XmATTACH_SELF,
		     XmNleftAttachment, XmATTACH_SELF,
		     XmNrightAttachment, XmATTACH_SELF,
		     NULL);
      if (labelWidget)
	{
	  XmString text = XmStringCreateSimple (Title);
	  XtVaSetValues (labelWidget,
			 XmNlabelString, text,
			 NULL);
	  XmStringFree (text);
	}
    }
#endif
#ifdef wx_xview
  char *title = NULL;
  if (Title)
    title = Title;

  Panel x_panel = (Panel) panel->GetHandle ();
  Panel_item x_choice;

  int label_position;
  if (panel->label_position == wxVERTICAL)
    label_position = PANEL_VERTICAL;
  else
    label_position = PANEL_HORIZONTAL;

  if (panel->new_line)
    {
      x_choice = (Panel_item) xv_create (x_panel, PANEL_CHOICE, PANEL_LAYOUT, label_position, PANEL_NEXT_ROW, -1, NULL);
      panel->new_line = FALSE;
    }
  else
    x_choice = (Panel_item) xv_create (x_panel, PANEL_CHOICE, PANEL_LAYOUT, label_position, NULL);

/*
   if (buttonFont)
   xv_set(x_choice, XV_FONT, buttonFont->GetInternalFont(), NULL) ;
 */
  xv_set (x_choice,
	  PANEL_LABEL_STRING, title,
	  PANEL_NOTIFY_PROC, wxRadioBoxProc,
	  PANEL_CLIENT_DATA, (char *) this,
	  NULL);
  if (majorDim != N)
    {
      majorDim = (N + majorDim - 1) / majorDim;
      xv_set (x_choice,
	      PANEL_CHOICE_NCOLS, majorDim,
	      NULL);
    }

  if (x > -1 && y > -1)
    (void) xv_set (x_choice, XV_X, x, XV_Y, y, NULL);

  for (i = 0; i < N; i++)
    {
      wxBitmap *bitmap = Choices[i];
      xv_set (x_choice, PANEL_CHOICE_IMAGE, i, bitmap->x_image, NULL);
    }
  handle = (char *) x_choice;
  xv_set (x_choice, PANEL_VALUE, 0, NULL);
#endif

  Callback (func);
  return TRUE;
}

wxRadioBox::~wxRadioBox (void)
{
#ifdef wx_motif
  if (radioButtons)
    delete[]radioButtons;
  if (radioButtonLabels)
    {
      for (int i = 0; i < no_items; i++)
	delete[]radioButtonLabels[i];
      delete[]radioButtonLabels;
    }
#endif
  if (buttonBitmap)
    delete[]buttonBitmap;
}

void wxRadioBox::ChangeColour (void)
{
#ifdef wx_motif
  int change;

  wxPanel *panel = (wxPanel *) window_parent;
  change = wxComputeColors (panel->backColour,
			    panel->buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues (formWidget,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues (formWidget,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  change = wxComputeColors (backColour, buttonColour);
  if (change == wxBACK_COLORS)
    {
      XtVaSetValues ((Widget) handle,
		     XmNbackground, itemColors[wxBACK_INDEX].pixel,
		     XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		     XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		     XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     XmNborderColor, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      for (int i = 0; i < no_items; i++)
	XtVaSetValues (radioButtons[i],
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }
  else if (change == wxFORE_COLORS)
    {
      XtVaSetValues ((Widget) handle,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     XmNborderColor, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      for (int i = 0; i < no_items; i++)
	XtVaSetValues (radioButtons[i],
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }

  if (labelWidget)
    {
      change = wxComputeColors (panel->backColour, labelColour);
      if (change == wxBACK_COLORS)
	XtVaSetValues (labelWidget,
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      else if (change == wxFORE_COLORS)
	XtVaSetValues (labelWidget,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }
  if (buttonBitmap)
    for (int i = 0; i < no_items; i++)
      if (buttonBitmap[i])
	XtVaSetValues (radioButtons[i],
		       XmNlabelPixmap,
		       buttonBitmap[i]->GetLabelPixmap (radioButtons[i]),
		       XmNlabelInsensitivePixmap,
		       buttonBitmap[i]->GetInsensPixmap (radioButtons[i]),
		       XmNarmPixmap,
		       buttonBitmap[i]->GetArmPixmap (radioButtons[i]),
		       NULL);

#endif
}

char *wxRadioBox::GetLabel (int item)
{
  if (item < 0 || item >= no_items)
    return NULL;
#ifdef wx_motif
  Widget widget = (Widget) radioButtons[item];
  XmString text;
  char *s;
  XtVaGetValues (widget,
		 XmNlabelString, &text,
		 NULL);

  if (XmStringGetLtoR (text, XmSTRING_DEFAULT_CHARSET, &s))
    {
//    XmStringFree(text);
      char *val = copystring (s);
      XtFree (s);
      return val;
    }
  else
    {
//    XmStringFree(text);
      return NULL;
    }
#endif
#ifdef wx_xview
  Panel_item x_choice = (Panel_item) handle;
  return ((char *) xv_get (x_choice, PANEL_CHOICE_STRING, item));
#endif
}

void wxRadioBox::SetLabel (int item, char *label)
{
  if (item < 0 || item >= no_items)
    return;
#ifdef wx_motif
  Widget widget = (Widget) radioButtons[item];
  if (label)
    {
      XmString text = XmStringCreateSimple (label);
      XtVaSetValues (widget,
		     XmNlabelString, text,
		     XmNlabelType, XmSTRING,
		     NULL);
      XmStringFree (text);
    }
#endif
#ifdef wx_xview
  Panel_item x_choice = (Panel_item) handle;
  if (label)
    xv_set (x_choice, PANEL_CHOICE_STRING, item, label, NULL);
#endif
}

void wxRadioBox::SetLabel (int item, wxBitmap * bitmap)
{
  if (item < 0 || item >= no_items)
    return;
  buttonBitmap[item] = bitmap;
#ifdef wx_motif
  Widget widget = (Widget) radioButtons[item];
  if (bitmap)
    {
      XtVaSetValues (widget,
		     XmNlabelPixmap, bitmap->GetLabelPixmap (widget),
		     XmNselectPixmap, bitmap->GetLabelPixmap (widget),
		XmNlabelInsensitivePixmap, bitmap->GetInsensPixmap (widget),
	       XmNselectInsensitivePixmap, bitmap->GetInsensPixmap (widget),
		     XmNarmPixmap, bitmap->GetArmPixmap (widget),
		     XmNlabelType, XmPIXMAP,
		     NULL);
    }
#endif
#ifdef wx_xview
  Panel_item x_choice = (Panel_item) handle;
  if (bitmap)
    xv_set (x_choice, PANEL_CHOICE_IMAGE, item, bitmap->x_image, NULL);
#endif
}

int wxRadioBox::FindString (char *s)
{
#ifdef wx_motif
  for (int i = 0; i < no_items; i++)
    if (strcmp (s, radioButtonLabels[i]) == 0)
      return i;
  return -1;
#endif
#ifdef wx_xview
  Panel_item choice = (Panel_item) handle;

  int max1 = no_items;

  int i = 0;
  int found = -1;
  while (found == -1 && i < max1)
    {
      char *label = (char *) xv_get (choice, PANEL_CHOICE_STRING, i);
      if (label && strcmp (label, s) == 0)
	found = i;
      else
	i++;
    }
  return found;
#endif
}

void wxRadioBox::SetSelection (int N)
{
  if ((N < 0) || (N >= no_items))
    return;

#ifdef wx_motif
  selected = N;
  XmToggleButtonSetState (radioButtons[N], TRUE, FALSE);
  for (int i = 0; i < no_items; i++)
    if (i != N)
      XmToggleButtonSetState (radioButtons[i], FALSE, FALSE);
#endif
#ifdef wx_xview
  Panel_item choice_item = (Panel_item) handle;
  xv_set (choice_item, PANEL_VALUE, N, NULL);
#endif
}

// Get selection
int wxRadioBox::GetSelection (void)
{
#ifdef wx_motif
  return selected;
#endif
#ifdef wx_xview
  return xv_get ((Panel_item) handle, PANEL_VALUE, NULL);
#endif
}

// Find string for position
char *wxRadioBox::GetString (int N)
{
  if ((N < 0) || (N >= no_items))
    return NULL;

#ifdef wx_motif

  return radioButtonLabels[N];
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  return (char *) xv_get (item, PANEL_CHOICE_STRING, N);
#endif
}

void wxRadioBox::SetSize (int x, int y, int width, int height)
{
#ifdef wx_motif
  Widget widget = (Widget) handle;

  XtUnmanageChild (formWidget);

  if (x > -1)
    XtVaSetValues (formWidget, XmNleftAttachment, XmATTACH_SELF,
		   XmNx, x, NULL);
  if (y > -1)
    XtVaSetValues (formWidget, XmNtopAttachment, XmATTACH_SELF,
		   XmNy, y, NULL);

  // Must set the actual RadioBox to be desired size MINUS label size
  Dimension labelWidth = 0, labelHeight = 0, actualWidth = 0, actualHeight = 0;

  if (labelWidget)
    XtVaGetValues (labelWidget, XmNwidth, &labelWidth, XmNheight, &labelHeight, NULL);

  if (itemOrientation == wxHORIZONTAL)
    {
      actualWidth = width - labelWidth;
      actualHeight = height;
    }
  else
    {
      actualWidth = width;
      actualHeight = height - labelHeight;
    }

  if (width > -1)
    {
      XtVaSetValues (widget, XmNwidth, actualWidth, NULL);
    }
  if (height > -1)
    {
      XtVaSetValues (widget, XmNheight, actualHeight, NULL);
    }
  XtManageChild (formWidget);

  OnSize (width, height);
#endif
#ifdef wx_xview
  wxItem::SetSize (x, y, width, height);
#endif
}

#ifdef wx_motif
void wxRadioBox::Enable (Bool enable)
{
  for (int i = 0; i < no_items; i++)
    XtSetSensitive (radioButtons[i], enable);
}
#endif

void wxRadioBox::Enable (int item, Bool enable)
{
#ifdef wx_motif
  if (item < 0)
    wxRadioBox::Enable (enable);
  else if (item < no_items)
    XtSetSensitive (radioButtons[item], enable);
#endif
#ifdef wx_xview
  wxWindow::Enable (enable);
#endif
}

void wxRadioBox::Show (int item, Bool show)
{
  // This method isn't complete, and we try do do our best...
  // It's main purpose isn't for allowing Show/Unshow dynamically,
  // but rather to provide a way to design wxRadioBox such:
  //
  //        o Val1  o Val2   o Val3 
  //        o Val4           o Val6 
  //        o Val7  o Val8   o Val9 
  //
  // In my case, this is a 'direction' box, and the Show(5,False) is
  // coupled with an Enable(5,False)
  //
#ifdef wx_motif
  if (item < 0)
    wxItem::Show (show);
  else if (item < no_items)
    {
      XtVaSetValues (radioButtons[item],
		     XmNindicatorOn, (unsigned char) show,
		     NULL);
      // Please note that this is all we can do: removing the label
      // if switching to unshow state. However, when switching
      // to the on state, it's the prog. resp. to call SetLabel(item,...)
      // after this call!!
      if (!show)
        wxRadioBox::SetLabel (item, " ");
    }
#endif
#ifdef wx_xview
  //No way...
#endif
}

// Message
wxMessage::wxMessage (void)
{
}

wxMessage::wxMessage (wxPanel * panel, char *label, int x, int y, long style, char *name):
wxbMessage (panel, label, x, y, style, name)
{
  Create (panel, label, x, y, style, name);
}

Bool wxMessage::
Create (wxPanel * panel, char *label, int x, int y, long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  window_parent = panel;
  labelPosition = panel->label_position;
  windowStyle = style;
#ifdef wx_motif
  windowName = copystring (name);

  if (!label)
    label = "";
  Widget panelForm = panel->panelWidget;
  XmString text = XmStringCreateSimple (label);

  formWidget = XtVaCreateManagedWidget (windowName,
					xmFormWidgetClass, panelForm,
					XmNmarginHeight, 0,
					XmNmarginWidth, 0,
					NULL);

  labelWidget = XtVaCreateManagedWidget ("messageLabel",
#if USE_GADGETS
					 style & wxCOLOURED ?
				    xmLabelWidgetClass : xmLabelGadgetClass,
					 formWidget,
#else
					 xmLabelWidgetClass, formWidget,
#endif
					 XmNlabelString, text,
					 XmNalignment, XmALIGNMENT_BEGINNING,
					 XmNtopAttachment, XmATTACH_FORM,
					 XmNleftAttachment, XmATTACH_FORM,
					 XmNbottomAttachment, XmATTACH_FORM,
					 XmNrightAttachment, XmATTACH_FORM,
					 NULL);

  XmStringFree (text);

  handle = (char *) labelWidget;

  if (labelFont)
    XtVaSetValues (labelWidget,
		   XmNfontList, labelFont->GetInternalFont (),
		   NULL);

  AttachWidget (panel, formWidget, x, y, -1, -1);
  ChangeColour ();
#endif
#ifdef wx_xview
  Panel x_panel = (Panel) (panel->GetHandle ());
  Panel_item x_message;

  if (panel->new_line)
    {
      x_message = (Panel_item) xv_create (x_panel, PANEL_MESSAGE, PANEL_LAYOUT, PANEL_HORIZONTAL, PANEL_NEXT_ROW, -1, NULL);
      panel->new_line = FALSE;
    }
  else
    x_message = (Panel_item) xv_create (x_panel, PANEL_MESSAGE, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL);

  xv_set (x_message,
	  PANEL_LABEL_STRING, label,
	  PANEL_CLIENT_DATA, (char *) this,
	  NULL);
/*
   if (labelFont)
   xv_set(x_message, XV_FONT, labelFont->GetInternalFont(), NULL) ;
 */

  if (x > -1 && y > -1)
    (void) xv_set (x_message, XV_X, x, XV_Y, y, NULL);

  handle = (char *) x_message;
#endif
  return TRUE;
}

wxMessage::~wxMessage (void)
{
}

void wxMessage::ChangeColour (void)
{
#ifdef wx_motif
  int change;

  wxPanel *panel = (wxPanel *) window_parent;
  change = wxComputeColors (panel->backColour,
			    panel->labelColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues (formWidget,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues (formWidget,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  change = wxComputeColors (backColour, labelColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues (labelWidget,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues (labelWidget,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

#endif
}

#ifdef wx_xview
Panel_setting 
wxTextProc (Panel_item item, Event * x_event)
{
  Panel_setting ret_code = panel_text_notify (item, x_event);
  if (ret_code == PANEL_NONE)
    return (PANEL_NONE);
  // So, ret_code is PANEL_INSERT,PANEL_NEXT or PANEL_PREVIOUS
  wxText *text = (wxText *) xv_get (item, PANEL_CLIENT_DATA);
  int event_type;
  if (ret_code != PANEL_INSERT)
    event_type = wxEVENT_TYPE_TEXT_ENTER_COMMAND;
  else
    event_type = wxEVENT_TYPE_TEXT_COMMAND;

  wxCommandEvent event (event_type);
  event.commandString = (char *) xv_get (item, PANEL_VALUE);
  event.eventHandle = (char *) x_event;
  event.eventObject = text;
  text->ProcessCommand (event);
  return (Panel_setting) ret_code;
}
#endif

#ifdef wx_motif
void 
wxTextCallback (Widget w, XtPointer clientData,
		XmAnyCallbackStruct * ptr)
{
  wxText *item = (wxText *) clientData;
  int type_event;
  if (ptr->reason == XmCR_ACTIVATE)
    type_event = wxEVENT_TYPE_TEXT_ENTER_COMMAND;
  else
    type_event = wxEVENT_TYPE_TEXT_COMMAND;
  wxCommandEvent event (type_event);
  event.commandString = item->GetValue ();
  event.eventObject = item;
  item->ProcessCommand (event);
}
#endif

// Text item
wxText::wxText (void)
{
}

wxText::wxText (wxPanel * panel, wxFunction Function, char *label, char *value,
	int x, int y, int width, int height, long style, char *name):
wxbText (panel, Function, label, value, x, y, width, height, style, name)
{
  Create (panel, Function, label, value, x, y, width, height, style, name);
}

Bool wxText::
Create (wxPanel * panel, wxFunction Function, char *label, char *value,
	int x, int y, int width, int height, long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  window_parent = panel;
  labelPosition = panel->label_position;
  windowStyle = style;
#ifdef wx_motif
  windowName = copystring (name);
  Widget panelForm = panel->panelWidget;
  formWidget = XtVaCreateManagedWidget (windowName,
					xmFormWidgetClass, panelForm,
					XmNmarginHeight, 0,
					XmNmarginWidth, 0,
					NULL);

  Widget textWidget;

  if (buttonFont)
    textWidget = XtVaCreateManagedWidget ("text",
					  xmTextWidgetClass, formWidget,
				XmNfontList, buttonFont->GetInternalFont (),
					  NULL);
  else
    textWidget = XtVaCreateManagedWidget ("text",
					  xmTextWidgetClass, formWidget,
					  NULL);

  int noCols = 10;
  if (value && (strlen (value) > noCols))
    noCols = strlen (value);

  XtVaSetValues (textWidget,
		 XmNcolumns, noCols,
		 NULL);

  if (label)
    {
      char *the_label = (style & wxFIXED_LENGTH) ? fillCopy (label) : copystring (label);
      XmString text = XmStringCreateSimple (the_label);
      labelWidget = XtVaCreateManagedWidget (label,
#if USE_GADGETS
					     style & wxCOLOURED ?
				    xmLabelWidgetClass : xmLabelGadgetClass,
					     formWidget,
#else
					     xmLabelWidgetClass, formWidget,
#endif
					     XmNlabelString, text,
					     NULL);
      if (labelFont)
	XtVaSetValues (labelWidget,
		       XmNfontList, labelFont->GetInternalFont (),
		       NULL);

      XmStringFree (text);
      delete[]the_label;
    }

  if (panel->label_position == wxHORIZONTAL)
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNbottomAttachment, XmATTACH_FORM,
		       XmNalignment, XmALIGNMENT_BEGINNING,
		       NULL);

      XtVaSetValues (textWidget,
		     XmNleftOffset, 4,
		     XmNtopAttachment, XmATTACH_FORM,
		     XmNbottomAttachment, XmATTACH_FORM,
	   XmNleftAttachment, labelWidget ? XmATTACH_WIDGET : XmATTACH_FORM,
		     XmNleftWidget, labelWidget ? labelWidget : formWidget,
		     XmNrightAttachment, XmATTACH_FORM,
		     NULL);
    }
  else
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNalignment, XmALIGNMENT_BEGINNING,
		       NULL);

      XtVaSetValues (textWidget,
	    XmNtopAttachment, labelWidget ? XmATTACH_WIDGET : XmATTACH_FORM,
		     XmNtopWidget, labelWidget ? labelWidget : formWidget,
		     XmNbottomAttachment, XmATTACH_FORM,
		     XmNleftAttachment, XmATTACH_FORM,
		     XmNrightAttachment, XmATTACH_FORM,
		     XmNalignment, XmALIGNMENT_BEGINNING,
		     NULL);
    }

  handle = (char *) textWidget;

  XtAddCallback (textWidget, XmNactivateCallback, (XtCallbackProc) wxTextCallback,
		 (XtPointer) this);
  XtAddCallback (textWidget, XmNvalueChangedCallback, (XtCallbackProc) wxTextCallback,
		 (XtPointer) this);

  AttachWidget (panel, formWidget, x, y, width, height);
  ChangeColour ();

  if (value)
    XmTextSetString (textWidget, value);

  /* After creating widgets, no more resizes. */
  if (style & wxFIXED_LENGTH)
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_SELF,
		       XmNleftAttachment, XmATTACH_SELF,
		       NULL);

      XtVaSetValues (textWidget,
		     XmNtopAttachment, XmATTACH_SELF,
		     XmNbottomAttachment, XmATTACH_SELF,
		     XmNleftAttachment, XmATTACH_SELF,
		     XmNrightAttachment, XmATTACH_SELF,
		     NULL);
      if (labelWidget)
	{
	  XmString text = XmStringCreateSimple (label);
	  XtVaSetValues (labelWidget,
			 XmNlabelString, text,
			 NULL);
	  XmStringFree (text);
	}
    }
#endif
#ifdef wx_xview
  Panel x_panel = (Panel) (panel->GetHandle ());
  Panel_item x_text;

  int label_position;
  if (panel->label_position == wxVERTICAL)
    label_position = PANEL_VERTICAL;
  else
    label_position = PANEL_HORIZONTAL;

  if (panel->new_line)
    {
      x_text = (Panel_item) xv_create (x_panel, PANEL_TEXT,
				       PANEL_VALUE_DISPLAY_WIDTH, 30,
		    PANEL_LAYOUT, label_position, PANEL_NEXT_ROW, -1, NULL);
      panel->new_line = FALSE;
    }
  else
    x_text = (Panel_item) xv_create (x_panel, PANEL_TEXT,
				     PANEL_VALUE_DISPLAY_WIDTH, 30,
				     PANEL_LAYOUT, label_position, NULL);

  xv_set (x_text,
	  PANEL_NOTIFY_PROC, wxTextProc,
	  PANEL_NOTIFY_LEVEL, PANEL_ALL,
	  PANEL_CLIENT_DATA, (char *) this,
	  NULL);

  if (x > -1 && y > -1)
    (void) xv_set (x_text, XV_X, x, XV_Y, y, NULL);

  if (value && strlen (value) && (width == -1))
    {
      width = strlen (value);
      if (width < 4)
	width = 4;
      xv_set (x_text, PANEL_VALUE_DISPLAY_LENGTH, (int) width, NULL);
    }
  else
    {
      if (width <= 0)
	width = 80;
      xv_set (x_text, PANEL_VALUE_DISPLAY_WIDTH, (int) width, NULL);
    }

/*
   if (buttonFont)
   xv_set(x_text, XV_FONT, buttonFont->GetInternalFont(), NULL) ;
 */
  if (label)
    {
      if (style & wxFIXED_LENGTH)
	{
	  char *the_label = fillCopy (label);
	  xv_set (x_text, PANEL_LABEL_STRING, the_label, NULL);

	  int label_x = (int) xv_get (x_text, PANEL_LABEL_X);
	  int item_x = (int) xv_get (x_text, PANEL_VALUE_X);
	  xv_set (x_text, PANEL_LABEL_STRING, label,
		  PANEL_VALUE_X, item_x,
		  PANEL_LABEL_X, label_x,
		  NULL);
	}
      else
	xv_set (x_text, PANEL_LABEL_STRING, label, NULL);
    }

  if (value)
    {
      xv_set (x_text, PANEL_VALUE, value, NULL);
    };

  handle = (char *) x_text;
#endif
  Callback (Function);

  return TRUE;
}

wxText::~wxText (void)
{
}

void wxText::ChangeColour (void)
{
#ifdef wx_motif
  int change;

  wxPanel *panel = (wxPanel *) window_parent;
  change = wxComputeColors (panel->backColour,
			    panel->buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues (formWidget,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues (formWidget,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  change = wxComputeColors (backColour, buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues ((Widget) handle,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues ((Widget) handle,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  if (labelWidget)
    {
      change = wxComputeColors (panel->backColour, labelColour);

      if (change == wxBACK_COLORS)
	XtVaSetValues (labelWidget,
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      else if (change == wxFORE_COLORS)
	XtVaSetValues (labelWidget,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }
#endif
}

char *wxText::GetValue (void)
{
#ifdef wx_motif
  char *s = XmTextGetString ((Widget) handle);
  if (s)
    {
      strcpy (wxBuffer, s);
      XtFree (s);
      return wxBuffer;
    }
  else
    return NULL;
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  return (char *) xv_get (item, PANEL_VALUE);
#endif
}

void wxText::SetValue (char *value)
{
#ifdef wx_motif
  if (value)
    XmTextSetString ((Widget) handle, value);
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  xv_set (item, PANEL_VALUE, value, NULL);
#endif
}

void wxText::SetSize (int x, int y, int width, int height)
{
#ifdef wx_motif
  XtUnmanageChild (formWidget);

  if (x > -1)
    XtVaSetValues (formWidget, XmNleftAttachment, XmATTACH_SELF,
		   XmNx, x,
		   NULL);
  if (y > -1)
    XtVaSetValues (formWidget, XmNtopAttachment, XmATTACH_SELF,
		   XmNy, y,
		   NULL);

  Dimension labelWidth = 0, labelHeight = 0;
  int actualWidth = width, actualHeight = height;

  if (labelWidget)
    XtVaGetValues (labelWidget, XmNwidth, &labelWidth, XmNheight, &labelHeight, NULL);

  if (itemOrientation == wxHORIZONTAL)
    {
      actualWidth = width - labelWidth;
      actualHeight = height;
    }
  else
    {
      actualWidth = width;
      actualHeight = height - labelHeight;
    }

  if (width > -1)
    XtVaSetValues ((Widget) handle, XmNwidth, actualWidth,
		   NULL);
  if (height > -1)
    XtVaSetValues ((Widget) handle, XmNheight, actualHeight,
		   NULL);

  XtManageChild (formWidget);

  OnSize (width, height);
#endif
#ifdef wx_xview
  Xv_opaque x_win = (Xv_opaque) handle;
  int labelWidth = 0;
  int panelLayout = (int)xv_get(x_win, PANEL_LAYOUT);
  if (panelLayout == PANEL_HORIZONTAL)
    labelWidth = (int)xv_get(x_win, PANEL_LABEL_WIDTH);

  if (x > -1)
    (void) xv_set (x_win, XV_X, x, NULL);

  if (width == -1)
    {
      int ww, hh;
      GetSize (&ww, &hh);
      width = ww;
    }

  if (y > -1)
    (void) xv_set (x_win, XV_Y, y, NULL);

  if (width <= 0)
    width = 80;

  (void) xv_set (x_win, PANEL_VALUE_DISPLAY_WIDTH, max(width-labelWidth, 10), NULL);
  OnSize (width, height);
#endif
}

void wxText::SetFocus (void)
{
#ifdef wx_motif
#endif
#ifdef wx_xview
  wxPanel *panel = (wxPanel *) GetParent ();
  if (panel)
    {
      Panel p = (Panel) panel->handle;
      xv_set (p, PANEL_CARET_ITEM, (Panel_item) handle, 0);
    }
#endif
}

// Clipboard operations
void wxText::Copy(void)
{
#ifdef wx_motif
  XmTextCopy((Widget)handle, CurrentTime);
#endif
}

void wxText::Cut(void)
{
#ifdef wx_motif
  XmTextCut((Widget)handle, CurrentTime);
#endif
}

void wxText::Paste(void)
{
#ifdef wx_motif
  XmTextPaste((Widget)handle);
#endif
}

// Multi-line Text item
wxMultiText::wxMultiText (void)
{
}

wxMultiText::wxMultiText (wxPanel * panel, wxFunction Function, char *label, char *value,
	     int x, int y, int width, int height, long style, char *name):
wxbMultiText (panel, Function, label, value, x, y, width, height, style, name)
{
  Create (panel, Function, label, value, x, y, width, height, style, name);
}

Bool wxMultiText::
Create (wxPanel * panel, wxFunction Function, char *label, char *value,
	int x, int y, int width, int height, long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  if (height == -1)
    height = 100;

  window_parent = panel;
  labelPosition = panel->label_position;
  windowStyle = style;
#ifdef wx_motif
  windowName = copystring (name);

  Widget panelForm = panel->panelWidget;
  formWidget = XtVaCreateManagedWidget (windowName,
					xmFormWidgetClass, panelForm,
					XmNmarginHeight, 0,
					XmNmarginWidth, 0,
					NULL);

  if (label)
    {
      char *the_label = (style & wxFIXED_LENGTH) ? fillCopy (label) : copystring (label);

      XmString text = XmStringCreateSimple (the_label);
      labelWidget = XtVaCreateManagedWidget (label,
#ifdef USE_GADGETS
					     style & wxCOLOURED ?
				    xmLabelWidgetClass : xmLabelGadgetClass,
					     formWidget,
#else
					     xmLabelWidgetClass, formWidget,
#endif
					     XmNlabelString, text,
					     NULL);
      if (labelFont)
	XtVaSetValues (labelWidget,
		       XmNfontList, labelFont->GetInternalFont (),
		       NULL);

      XmStringFree (text);
      delete[]the_label;
    }

  Bool wantHorizScrolling = ((windowStyle & wxHSCROLL) != 0);
  // If we don't have horizontal scrollbars, we want word wrap.
  Bool wantWordWrap = !wantHorizScrolling;

  Arg args[2];
  XtSetArg (args[0], XmNscrollHorizontal, wantHorizScrolling ? True : False);
  XtSetArg (args[1], XmNwordWrap, wantWordWrap ? True : False);

  Widget textWidget = XmCreateScrolledText (formWidget, "multiTextWidget",
     args, 2);

  if (buttonFont)
    XtVaSetValues (textWidget,
		   XmNfontList, buttonFont->GetInternalFont (),
		   NULL);

  handle = (char *) textWidget;

  XtVaSetValues (textWidget,
		 XmNeditMode, XmMULTI_LINE_EDIT,
//                 XmNscrollHorizontal, wantHorizScrolling ? True : False,
//                 XmNwordWrap, wantWordWrap ? True : False,
		 NULL);
  XtManageChild (textWidget);

  if (panel->label_position == wxHORIZONTAL)
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNalignment, XmALIGNMENT_BEGINNING,
		       NULL);

      XtVaSetValues (XtParent (textWidget),
		     XmNleftOffset, 4,
		     XmNtopAttachment, XmATTACH_FORM,
		     XmNbottomAttachment, XmATTACH_FORM,
	   XmNleftAttachment, labelWidget ? XmATTACH_WIDGET : XmATTACH_FORM,
		     XmNleftWidget, labelWidget ? labelWidget : formWidget,
		     XmNrightAttachment, XmATTACH_FORM,
		     NULL);
    }
  else
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_FORM,
		       XmNleftAttachment, XmATTACH_FORM,
		       XmNalignment, XmALIGNMENT_BEGINNING,
		       NULL);

      XtVaSetValues (XtParent (textWidget),
	    XmNtopAttachment, labelWidget ? XmATTACH_WIDGET : XmATTACH_FORM,
		     XmNtopWidget, labelWidget ? labelWidget : formWidget,
		     XmNbottomAttachment, XmATTACH_FORM,
		     XmNleftAttachment, XmATTACH_FORM,
		     XmNrightAttachment, XmATTACH_FORM,
		     XmNalignment, XmALIGNMENT_BEGINNING,
		     NULL);
    }



  XtAddCallback (textWidget, XmNactivateCallback, (XtCallbackProc) wxTextCallback,
		 (XtPointer) this);

  XtAddCallback (textWidget, XmNvalueChangedCallback, (XtCallbackProc) wxTextCallback,
		 (XtPointer) this);

  AttachWidget (panel, formWidget, x, y, width, height);
  ChangeColour ();

  if (value)
    XmTextSetString (textWidget, value);


  /* After creating widgets, no more resizes. */
  if (style & wxFIXED_LENGTH)
    {
      if (labelWidget)
	XtVaSetValues (labelWidget,
		       XmNtopAttachment, XmATTACH_SELF,
		       XmNleftAttachment, XmATTACH_SELF,
		       NULL);

      XtVaSetValues (textWidget,
		     XmNtopAttachment, XmATTACH_SELF,
		     XmNbottomAttachment, XmATTACH_SELF,
		     XmNleftAttachment, XmATTACH_SELF,
		     XmNrightAttachment, XmATTACH_SELF,
		     NULL);
      if (labelWidget)
	{
	  XmString text = XmStringCreateSimple (label);
	  XtVaSetValues (labelWidget,
			 XmNlabelString, text,
			 NULL);
	  XmStringFree (text);
	}
    }
#endif
#ifdef wx_xview
  Panel x_panel = (Panel) (panel->GetHandle ());
  Panel_item x_text;

  int label_position;
  if (panel->label_position == wxVERTICAL)
    label_position = PANEL_VERTICAL;
  else
    label_position = PANEL_HORIZONTAL;

  if (panel->new_line)
    {
      x_text = (Panel_item) xv_create (x_panel, PANEL_MULTILINE_TEXT,
				       PANEL_VALUE_DISPLAY_WIDTH, 120,
		    PANEL_LAYOUT, label_position, PANEL_NEXT_ROW, -1, NULL);
      panel->new_line = FALSE;
    }
  else
    x_text = (Panel_item) xv_create (x_panel, PANEL_MULTILINE_TEXT,
				     PANEL_VALUE_DISPLAY_WIDTH, 120,
				     PANEL_LAYOUT, label_position, NULL);

  xv_set (x_text,
	  PANEL_NOTIFY_PROC, wxTextProc,
	  PANEL_NOTIFY_LEVEL, PANEL_ALL,
	  PANEL_CLIENT_DATA, (char *) this,
	  NULL);

/*
   if (buttonFont)
   xv_set(x_text, XV_FONT, buttonFont->GetInternalFont(), NULL) ;
 */

  if (label)
    {
      if (style & wxFIXED_LENGTH)
	{
	  char *the_label = fillCopy (label);

	  xv_set (x_text, PANEL_LABEL_STRING, the_label, NULL);

	  int label_x = (int) xv_get (x_text, PANEL_LABEL_X);
	  int item_x = (int) xv_get (x_text, PANEL_ITEM_X);
	  xv_set (x_text, PANEL_LABEL_STRING, label,
		  PANEL_LABEL_X, label_x,
		  PANEL_ITEM_X, item_x,
		  NULL);
	}
      else
	xv_set (x_text, PANEL_LABEL_STRING, label, NULL);
    }

//  if (x > -1 && y > -1)
//    (void) xv_set (x_text, XV_X, x, XV_Y, y, NULL);
  handle = (char *) x_text;

  SetSize(x, y, width, height);

  if (value)
    {
      xv_set (x_text, PANEL_VALUE, value, NULL);
    };

#endif
  Callback (Function);
  return TRUE;
}

void wxMultiText::ChangeColour (void)
{
#ifdef wx_motif
  int change;

  wxPanel *panel = (wxPanel *) window_parent;
  change = wxComputeColors (panel->backColour,
			    panel->buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues (formWidget,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues (formWidget,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  change = wxComputeColors (backColour, buttonColour);
  if (change == wxBACK_COLORS)
    {
      XtVaSetValues ((Widget) handle,
		     XmNbackground, itemColors[wxBACK_INDEX].pixel,
		     XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		     XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		     XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      Widget parent = XtParent ((Widget) handle);
      XtVaSetValues (parent,
		     XmNbackground, itemColors[wxBACK_INDEX].pixel,
		     XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		     XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		     XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      Widget hsb, vsb;
      XtVaGetValues (parent,
		     XmNhorizontalScrollBar, &hsb,
		     XmNverticalScrollBar, &vsb,
		     NULL);
      if (hsb)
	XtVaSetValues (hsb,
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      if (vsb)
	XtVaSetValues (vsb,
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }
  else if (change == wxFORE_COLORS)
    {
      XtVaSetValues ((Widget) handle,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      Widget parent = XtParent ((Widget) handle);
      XtVaSetValues (parent,
		     XmNforeground, itemColors[wxFORE_INDEX].pixel,
		     NULL);
      Widget hsb, vsb;
      XtVaGetValues (parent,
		     XmNhorizontalScrollBar, &hsb,
		     XmNverticalScrollBar, &vsb,
		     NULL);
      if (hsb)
	XtVaSetValues (hsb,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      if (vsb)
	XtVaSetValues (vsb,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }

  if (labelWidget)
    {
      change = wxComputeColors (panel->backColour, labelColour);

      if (change == wxBACK_COLORS)
	XtVaSetValues (labelWidget,
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      else if (change == wxFORE_COLORS)
	XtVaSetValues (labelWidget,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }
#endif
}

char *wxMultiText::GetValue (void)
{
#ifdef wx_motif
  return wxText::GetValue ();
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  return (char *) xv_get (item, PANEL_VALUE);
#endif
}

void wxMultiText::GetValue (char *buffer, int maxSize)
{
  buffer[0] = 0;
#ifdef wx_motif
  char *s = XmTextGetString ((Widget) handle);
  if (s)
    {
      if (strlen (s) > (maxSize - 1))
	{
	  strncpy (buffer, s, maxSize - 1);
	  buffer[maxSize - 1] = 0;
	}
      else
	strcpy (buffer, s);
      XtFree (s);
    }
  else
    buffer[0] = 0;
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  char *s = (char *) xv_get (item, PANEL_VALUE);
  strncpy (buffer, s, strlen (s));
#endif
}

void wxMultiText::SetSize (int x, int y, int width, int height)
{
#ifdef wx_motif
  XtUnmanageChild (formWidget);

  if (x > -1)
    XtVaSetValues (formWidget, XmNleftAttachment, XmATTACH_SELF,
		   XmNx, x,
		   NULL);
  if (y > -1)
    XtVaSetValues (formWidget, XmNtopAttachment, XmATTACH_SELF,
		   XmNy, y,
		   NULL);

  Dimension labelWidth = 0, labelHeight = 0;
  int actualWidth = width, actualHeight = height;

  if (labelWidget)
    XtVaGetValues (labelWidget, XmNwidth, &labelWidth, XmNheight, &labelHeight, NULL);

  if (itemOrientation == wxHORIZONTAL)
    {
      actualWidth = width - labelWidth;
      actualHeight = height;
    }
  else
    {
      actualWidth = width;
      actualHeight = height - labelHeight;
    }

  if (width > -1)
    {
      // width - 10 is a fudge factor for taking the scroll bar into account.
      // A better way anybody?
      XtVaSetValues (formWidget, XmNwidth, width - 10, XmNrightAttachment, XmATTACH_SELF, NULL);
    }
  if (height > -1)
    {
      XtVaSetValues (formWidget, XmNheight, height, XmNbottomAttachment, XmATTACH_SELF, NULL);
    }

/*
   if (width > -1)
   XtVaSetValues(XtParent(widget), XmNwidth, width - 15,
   NULL);
   if (height > -1)
   XtVaSetValues(XtParent(widget), XmNheight, height - 15,
   NULL);
 */

  XtManageChild (formWidget);

  OnSize (width, height);
#endif
#ifdef wx_xview
  Xv_opaque x_win = (Xv_opaque) handle;
  int labelWidth = 0;
  int panelLayout = (int)xv_get(x_win, PANEL_LAYOUT);
  if (panelLayout == PANEL_HORIZONTAL)
    labelWidth = (int)xv_get(x_win, PANEL_LABEL_WIDTH);

  if (x > -1)
    (void) xv_set (x_win, XV_X, x, NULL);

  if (width == -1)
    {
      int ww, hh;
      GetSize (&ww, &hh);
      width = ww;
    }

  if (y > -1)
    (void) xv_set (x_win, XV_Y, y, NULL);

  if (width <= 0)
    width = 120;

  (void) xv_set (x_win, PANEL_VALUE_DISPLAY_WIDTH, max(width-labelWidth, 10), NULL);

  Panel panel = (Panel) (GetParent ()->handle);
  Xv_Font font = (Xv_Font) xv_get (panel, XV_FONT);
  Xv_Font labelFont = (Xv_Font) xv_get (x_win, PANEL_LABEL_FONT);
  int pixel_height = (int) xv_get (font, FONT_DEFAULT_CHAR_HEIGHT);
  int labelHeight =  (int) xv_get (labelFont, FONT_DEFAULT_CHAR_HEIGHT);

  // Subtract the label height if we're in vertical label mode.
  int actual_height = height;
  if (panelLayout == PANEL_VERTICAL)
    actual_height -= labelHeight;

  if (actual_height > -1)
    (void) xv_set (x_win, PANEL_DISPLAY_ROWS, (int) (actual_height / pixel_height), NULL);
  OnSize (width, height);
#endif
}


// Slider

#ifdef wx_xview
void 
wxSliderProc (Panel_item item, int value, Event * x_event)
{
  wxSlider *slider = (wxSlider *) xv_get (item, PANEL_CLIENT_DATA);
  wxCommandEvent event (wxEVENT_TYPE_SLIDER_COMMAND);
  event.commandInt = value;
  event.eventHandle = (char *) x_event;
  event.eventObject = slider;
  slider->ProcessCommand (event);
}
#endif

#ifdef wx_motif
void 
wxSliderCallback (Widget widget, XtPointer clientData, XmScaleCallbackStruct * cbs)
{
  wxSlider *slider = (wxSlider *) clientData;
  wxCommandEvent event (wxEVENT_TYPE_SLIDER_COMMAND);
  XtVaGetValues (widget, XmNvalue, &event.commandInt, NULL);
  event.eventHandle = (char *) cbs->event;
  event.eventObject = slider;
  slider->ProcessCommand (event);
}
#endif

wxSlider::wxSlider (void)
{
}

wxSlider::wxSlider (wxPanel * panel, wxFunction func, char *label, int value,
	  int min_value, int max_value, int width, int x, int y,
	  long style, char *name):
wxbSlider (panel, func, label, value, min_value, max_value, width, x, y, style, name)
{
  Create (panel, func, label, value, min_value, max_value, width, x, y, style, name);
}

Bool wxSlider::
Create (wxPanel * panel, wxFunction func, char *label, int value,
	int min_value, int max_value, int width, int x, int y,
	long style, char *name)
{
  if (panel)
    panel->AddChild (this);
  buttonFont = panel->buttonFont;
  labelFont = panel->labelFont;
  backColour = panel->backColour;
  labelColour = panel->labelColour;
  buttonColour = panel->buttonColour;
  window_parent = panel;
  labelPosition = panel->label_position;
  windowStyle = style;
#ifdef wx_motif
  windowName = copystring (name);
  Widget panelForm = panel->panelWidget;

  formWidget = XtVaCreateManagedWidget (windowName,
					xmRowColumnWidgetClass, panelForm,
					XmNorientation, XmHORIZONTAL,
					XmNmarginHeight, 0,
					XmNmarginWidth, 0,
					NULL);

  if (label)
    {
      char *the_label = (style & wxFIXED_LENGTH) ? fillCopy (label) : copystring (label);

      XmString text = XmStringCreateSimple (the_label);
      labelWidget = XtVaCreateManagedWidget ("choiceLabel",
#ifdef USE_GADGETS
					     style & wxCOLOURED ?
				    xmLabelWidgetClass : xmLabelGadgetClass,
					     formWidget,
#else
					     xmLabelWidgetClass, formWidget,
#endif
					     XmNlabelString, text,
					     NULL);
      if (labelFont)
	XtVaSetValues (labelWidget,
		       XmNfontList, labelFont->GetInternalFont (),
		       NULL);

      XmStringFree (text);
      delete[]the_label;
    }

  Widget sliderWidget = XtVaCreateManagedWidget ("sliderWidget",
					     xmScaleWidgetClass, formWidget,
					       XmNorientation, XmHORIZONTAL,
				     XmNprocessingDirection, XmMAX_ON_RIGHT,
						 XmNmaximum, max_value,
						 XmNminimum, min_value,
						 XmNvalue, value,
						 XmNshowValue, True,
						 NULL);

  if (buttonFont)
    XtVaSetValues (sliderWidget,
		   XmNfontList, buttonFont->GetInternalFont (),
		   NULL);

  handle = (char *) sliderWidget;

  XtAddCallback (sliderWidget, XmNvalueChangedCallback, (XtCallbackProc) wxSliderCallback, (XtPointer) this);

  AttachWidget (panel, formWidget, x, y, width, -1);
  ChangeColour ();

  /* After creating widgets, no more resizes. */
  if (style & wxFIXED_LENGTH)
    {
      XtVaSetValues (formWidget,
		     XmNpacking, XmPACK_NONE,
		     NULL);

      if (labelWidget)
	{
	  XmString text = XmStringCreateSimple (label);
	  XtVaSetValues (labelWidget,
			 XmNlabelString, text,
			 NULL);
	  XmStringFree (text);
	}
    }
#endif
#ifdef wx_xview
  Panel x_panel = (Panel) (panel->GetHandle ());
  Panel_item x_slider;

  int label_position;
  if (panel->label_position == wxVERTICAL)
    label_position = PANEL_VERTICAL;
  else
    label_position = PANEL_HORIZONTAL;

  if (x > -1 && y > -1)
    {
      if (panel->new_line)
	{
	  x_slider = (Panel_item) xv_create (x_panel, PANEL_SLIDER, PANEL_LAYOUT, label_position, PANEL_NEXT_ROW, -1,
					     XV_X, x, XV_Y, y, NULL);
	  panel->new_line = FALSE;
	}
      else
	x_slider = (Panel_item) xv_create (x_panel, PANEL_SLIDER, PANEL_LAYOUT, label_position, XV_X, x, XV_Y, y, NULL);

    }
  else
    {
      if (panel->new_line)
	{
	  x_slider = (Panel_item) xv_create (x_panel, PANEL_SLIDER, PANEL_LAYOUT, PANEL_HORIZONTAL, PANEL_NEXT_ROW, -1,
					     NULL);
	  panel->new_line = FALSE;
	}
      else
	x_slider = (Panel_item) xv_create (x_panel, PANEL_SLIDER, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL);
    }

  if (label)
    {
      if (style & wxFIXED_LENGTH)
	{
	  char *the_label = fillCopy (label);
	  xv_set (x_slider, PANEL_LABEL_STRING, the_label, NULL);

	  int label_x = (int) xv_get (x_slider, PANEL_LABEL_X);
	  int item_x = (int) xv_get (x_slider, PANEL_ITEM_X);
	  xv_set (x_slider, PANEL_LABEL_STRING, label,
		  PANEL_LABEL_X, label_x,
		  PANEL_ITEM_X, item_x,
		  NULL);
	}
      else
	xv_set (x_slider, PANEL_LABEL_STRING, label, NULL);
    }

  xv_set (x_slider,
	  PANEL_MIN_VALUE, min_value,
	  PANEL_MAX_VALUE, max_value,
	  PANEL_NOTIFY_PROC, wxSliderProc,
	  PANEL_CLIENT_DATA, (char *) this,
	  PANEL_VALUE, value,
	  NULL);

/*
   if (buttonFont)
   xv_set(x_slider, XV_FONT, buttonFont->GetInternalFont(), NULL) ;
 */

  if (width > 0)
    {
      xv_set (x_slider, PANEL_SLIDER_WIDTH, (int) width, NULL);
    };


  handle = (char *) x_slider;
#endif

  Callback (func);
  return TRUE;
}


wxSlider::~wxSlider (void)
{
}

void wxSlider::ChangeColour (void)
{
#ifdef wx_motif
  int change;

  wxPanel *panel = (wxPanel *) window_parent;
  change = wxComputeColors (panel->backColour,
			    panel->buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues (formWidget,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues (formWidget,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  change = wxComputeColors (backColour, buttonColour);
  if (change == wxBACK_COLORS)
    XtVaSetValues ((Widget) handle,
		   XmNbackground, itemColors[wxBACK_INDEX].pixel,
		   XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		   XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		   XmNarmColor, itemColors[wxSELE_INDEX].pixel,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);
  else if (change == wxFORE_COLORS)
    XtVaSetValues ((Widget) handle,
		   XmNforeground, itemColors[wxFORE_INDEX].pixel,
		   NULL);

  if (labelWidget)
    {
      change = wxComputeColors (panel->backColour, labelColour);
      if (change == wxBACK_COLORS)
	XtVaSetValues (labelWidget,
		       XmNbackground, itemColors[wxBACK_INDEX].pixel,
		       XmNtopShadowColor, itemColors[wxTOPS_INDEX].pixel,
		       XmNbottomShadowColor, itemColors[wxBOTS_INDEX].pixel,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
      else if (change == wxFORE_COLORS)
	XtVaSetValues (labelWidget,
		       XmNforeground, itemColors[wxFORE_INDEX].pixel,
		       NULL);
    }
#endif
}

int wxSlider::GetValue (void)
{
#ifdef wx_motif
  int val;
  XtVaGetValues ((Widget) handle, XmNvalue, &val, NULL);
  return val;
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  return (int) xv_get (item, PANEL_VALUE);
#endif
}

void wxSlider::SetValue (int value)
{
#ifdef wx_motif
  XtVaSetValues ((Widget) handle, XmNvalue, value, NULL);
#endif
#ifdef wx_xview
  Panel_item item = (Panel_item) handle;
  xv_set (item, PANEL_VALUE, value, NULL);
#endif
}

void wxSlider::GetSize (int *width, int *height)
{
#ifdef wx_motif
/*
  Widget sliderWidget = (Widget) handle;
//  Dimension x, y;
//  XtVaGetValues (sliderWidget, XmNscaleWidth, &x, XmNscaleHeight, &y, NULL);
  Dimension xx, yy;
  XtVaGetValues (sliderWidget, XmNwidth, &xx, XmNheight, &yy, NULL);
  *width = xx;
  *height = yy;
*/
  wxItem::GetSize (width, height);
#endif
#ifdef wx_xview
  wxItem::GetSize (width, height);
#endif
}

void wxSlider::SetSize (int x, int y, int width, int height)
{
#ifdef wx_motif
  Widget sliderWidget = (Widget) handle;

  XtUnmanageChild (formWidget);

  if (width > -1)
    {
      Dimension labelWidth = 0;
      if (labelWidget)
	XtVaGetValues (labelWidget, XmNwidth, &labelWidth, NULL);

      XtVaSetValues (sliderWidget, XmNscaleWidth, max (width - labelWidth, 10), NULL);
    }

  if (x > -1)
    XtVaSetValues (formWidget, XmNleftAttachment, XmATTACH_SELF, XmNx, x, NULL);
  if (y > -1)
    XtVaSetValues (formWidget, XmNtopAttachment, XmATTACH_SELF, XmNy, y, NULL);

  XtManageChild (formWidget);

  OnSize (width, height);
#endif
#ifdef wx_xview
  wxItem::SetSize (x, y, width, height);
#endif
}

#ifdef wx_xview
extern Notify_value wxDummyFrameInterposer (Frame x_frame, Event * x_event, Notify_arg arg,
					    Notify_event_type type);
#endif

// Find the letter corresponding to the mnemonic, for Motif
char wxFindMnemonic (char *s)
{
  char mnem = 0;
  int len = strlen (s);
  for (int i = 0; i < len; i++)
    {
      if (s[i] == '&')
	{
	  // Carefully handle &&
	  if ((i + 1) <= len && s[i + 1] == '&')
	    i++;
	  else
	    {
	      mnem = s[i + 1];
	      break;
	    }
	}
    }
  return mnem;
}

#ifdef wx_xview
void wxPanelEventProc (Panel x_panel, Event * x_event)
{
  wxPanel *panel = (wxPanel *) xv_get (x_panel, WIN_CLIENT_DATA);
  if (panel)
    {
      if (event_id (x_event) == KBD_USE)
	panel->OnSetFocus ();
      else if (event_id (x_event) == KBD_DONE)
	panel->OnKillFocus ();
      else if (x_event->ie_xevent->xany.type == KeyPress)
      {
        KeySym keySym;
        XComposeStatus compose;
        (void) XLookupString ((XKeyEvent *) x_event->ie_xevent, wxBuffer, 20, &keySym, &compose);
        int id = panel->CharCodeXToWX (keySym);

        // Find the default item, if any, and execute its callback
	Panel_item item = (Panel_item) xv_get (x_panel, PANEL_DEFAULT_ITEM);
	wxButton *wx_item = NULL;
	if (item)
	  wx_item = (wxButton *) xv_get (item, PANEL_CLIENT_DATA);

        if ((id == 13) && wx_item)
        {
          wxCommandEvent event (wxEVENT_TYPE_BUTTON_COMMAND);
          event.eventObject = wx_item;
          wx_item->ProcessCommand (event);
	}
        else if ((id > -1) && (id != WXK_SHIFT) && (id != WXK_CONTROL))
	{
          wxKeyEvent event (wxEVENT_TYPE_CHAR);
          if (event_shift_is_down (x_event))
            event.shiftDown = TRUE;
          if (event_ctrl_is_down (x_event))
            event.controlDown = TRUE;
          event.keyCode = id;
          event.eventObject = panel;

          event.x = event_x (x_event);
          event.y = event_y (x_event);
        }
      }
      else
	{
	  WXTYPE eventType = 0;

	  if ((event_id (x_event) == LOC_DRAG) || (event_id (x_event) == LOC_MOVE))
	    eventType = wxEVENT_TYPE_MOTION;
	  else if (event_is_button (x_event))
	    {
	      if (event_is_down (x_event))
		{
		  if (event_id (x_event) == BUT (1))
		    eventType = wxEVENT_TYPE_LEFT_DOWN;
		  else if (event_id (x_event) == BUT (2))
		    eventType = wxEVENT_TYPE_MIDDLE_DOWN;
		  else if (event_id (x_event) == BUT (3))
		    eventType = wxEVENT_TYPE_RIGHT_DOWN;
		}
	      else if (event_is_up (x_event))
		{
		  if (event_id (x_event) == BUT (1))
		    eventType = wxEVENT_TYPE_LEFT_UP;
		  else if (event_id (x_event) == BUT (2))
		    eventType = wxEVENT_TYPE_MIDDLE_UP;
		  else if (event_id (x_event) == BUT (3))
		    eventType = wxEVENT_TYPE_RIGHT_UP;
		}
	    }
	  wxMouseEvent event (eventType);

	  event.eventObject = panel;
	  event.controlDown = event_ctrl_is_down (x_event);
	  event.shiftDown = event_shift_is_down (x_event);
	  event.altDown = event_alt_is_down (x_event);
	  event.leftDown = event_left_is_down (x_event);
	  event.middleDown = event_middle_is_down (x_event);
	  event.rightDown = event_right_is_down (x_event);
	  event.eventHandle = (char *) x_event;

	  event.x = event_x (x_event);
	  event.y = event_y (x_event);

	  panel->OnEvent (event);
	}
    }
}
#endif

#ifdef wx_motif
char * wxFindAccelerator (char *s)
{
// The accelerator text is after the \t char.
  while (*s && *s != '\t')
    s++;
  if (*s == '\0')
    return (NULL);
  s++;
/*
   Now we need to format it as X standard:

   input            output

   F7           --> <Key>F7
   Ctrl+N       --> Ctrl<Key>N
   Alt+k        --> Meta<Key>k
   Ctrl+Shift+A --> Ctrl Shift<Key>A

 */

  wxBuffer[0] = '\0';
  char *tmp = copystring (s);
  s = tmp;
  char *p = s;

  while (1)
    {
      while (*p && *p != '+')
	p++;
      if (*p)
	{
	  *p = '\0';
	  if (wxBuffer[0])
	    strcat (wxBuffer, " ");
	  if (strcmp (s, "Alt"))
	    strcat (wxBuffer, s);
	  else
	    strcat (wxBuffer, "Meta");
	  s = p + 1;
	  p = s;
	}
      else
	{
	  strcat (wxBuffer, "<Key>");
	  strcat (wxBuffer, s);
	  break;
	}
    }
  delete[]tmp;
  return wxBuffer;
}

XmString wxFindAcceleratorText (char *s)
{
// The accelerator text is after the \t char.
  while (*s && *s != '\t')
    s++;
  if (*s == '\0')
    return (NULL);
  s++;
  XmString text = XmStringCreateSimple (s);
  return text;
}
#endif
