/*
 * File:	wx_panel.cc
 * Purpose:	wxPanel class implementation
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	August 1994
 * RCS_ID:      $Id: wx_panel.cc,v 1.1 1994/08/14 21:59:17 edz Exp $
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include "wx.h"
#pragma hdrstop
#include "wx_privt.h"
#include <iostream.h>

/*
#include <windows.h>
#include "common.h"
#include "wx_panel.h"
#include "wx_frame.h"
#include "wx_utils.h"
*/

class wxPanelWnd : public wxSubWnd
{
public:
  wxPanelWnd(wxWnd *parent, char *winClass, wxWindow *wx_win,
              int x, int y, int width, int height, DWORD flags);

  // Handlers
  LONG DefWindowProc(UINT nMsg, UINT wParam, LONG lParam);
  BOOL ProcessMessage(MSG* pMsg);
  BOOL OnEraseBkgnd(HDC pDC);
};

wxPanelWnd::wxPanelWnd(wxWnd *parent, char *winClass, wxWindow *wx_win,
              int x, int y, int width, int height, DWORD flags):
  wxSubWnd(parent, winClass, wx_win, x, y, width, height, flags)
{
}

LONG wxPanelWnd::DefWindowProc(UINT nMsg, UINT wParam, LONG lParam)
{
  return ::DefWindowProc(handle, nMsg, wParam, lParam);
}

BOOL wxPanelWnd::ProcessMessage(MSG* pMsg)
{
  return ::IsDialogMessage(handle, pMsg);
}

BOOL wxPanelWnd::OnEraseBkgnd(HDC pDC)
{
  if (background_brush)
  {
    RECT rect;
    GetClientRect(handle, &rect);
    int mode = SetMapMode(pDC, MM_TEXT);
    FillRect(pDC, &rect, background_brush);
    SetMapMode(pDC, mode);
    return TRUE;
  }
  else return FALSE;
}

wxPanel::wxPanel(void)
{
  window_parent = NULL;
  cursor_x = PANEL_LEFT_MARGIN;
  cursor_y = PANEL_TOP_MARGIN;
  max_height = 0;
  max_line_height = 0;
  max_width = 0;
  hSpacing = PANEL_HSPACING;
  vSpacing = PANEL_VSPACING;
  initial_hspacing = hSpacing ;
  initial_vspacing = vSpacing ;
  current_hspacing = hSpacing ;
  current_vspacing = vSpacing ;

  new_line = FALSE;
  label_position = wxHORIZONTAL;
  wxWinType = wxTYPE_XWND;
  handle = NULL;
  has_child = FALSE ;
  last_created = 0 ;
  labelFont = NULL ;
  buttonFont = NULL ;
  backColour = NULL ;
  labelColour = NULL ;
  buttonColour = NULL ;

}

// Constructor
wxPanel::wxPanel(wxFrame *frame, int x, int y, int width, int height,
                 long style, char *name):
  wxbPanel(frame, x, y, width, height, style, name)
{
  Create(frame, x, y, width, height, style, name);
}

wxPanel::wxPanel(wxPanel *panel, int x, int y, int width, int height,
                 long style, char *name):
  wxbPanel(panel, x, y, width, height, style)
{
  Create(panel, x, y, width, height, style);
}

// Constructor
Bool wxPanel::Create(wxFrame *frame, int x, int y, int width, int height, long style,
                     char *name)
{
  cursor_x = PANEL_LEFT_MARGIN;
  cursor_y = PANEL_TOP_MARGIN;
  max_height = 0;
  max_line_height = 0;
  max_width = 0;
  hSpacing = PANEL_HSPACING;
  vSpacing = PANEL_VSPACING;
  initial_hspacing = hSpacing ;
  initial_vspacing = vSpacing ;
  current_hspacing = hSpacing ;
  current_vspacing = vSpacing ;
  new_line = FALSE;
  label_position = wxHORIZONTAL;
  wxWinType = wxTYPE_XWND;
  windowStyle = style;
  has_child = FALSE ;
  last_created = 0 ;

  labelFont = NULL ;
  buttonFont = NULL ;
  backColour = NULL ;
  labelColour = NULL ;
  buttonColour = NULL ;

  if (!frame)
    return FALSE;

  window_parent = frame;

  wxWnd *cparent = NULL;
  if (frame)
    cparent = (wxWnd *)frame->handle;

  DWORD msflags = 0;
  if (style & wxBORDER)
    msflags |= WS_BORDER;
  msflags |= WS_CHILD | WS_VISIBLE;

//  wxSubWnd *wnd = new wxSubWnd(cparent, "wxPanelClass", this, x, y, width, height, msflags);
  wxPanelWnd *wnd = new wxPanelWnd(cparent, "wxPanelClass", this, x, y, width, height, msflags);

  handle = (char *)wnd;
  if (frame) frame->AddChild(this);

  return TRUE;
}

Bool wxPanel::Create(wxPanel *frame, int x, int y, int width, int height, long style,
                     char *name)
{
  if (frame) frame->AddChild(this);
  has_child = FALSE ;
  new_line = FALSE;
  label_position = wxHORIZONTAL;
 
  last_created = 0 ;
  cursor_x = PANEL_LEFT_MARGIN;
  cursor_y = PANEL_TOP_MARGIN;
  max_height = 0;
  max_line_height = 0;
  max_width = 0;
  hSpacing = PANEL_HSPACING;
  vSpacing = PANEL_VSPACING;
 
  initial_hspacing = hSpacing ;
  initial_vspacing = vSpacing ;
  current_hspacing = hSpacing ;
  current_vspacing = vSpacing ;
 
  if (!frame)
    return FALSE;
 
  labelFont = frame->labelFont ;
  buttonFont = frame->buttonFont ;
  backColour = frame->backColour ;
  labelColour = frame->labelColour ;
  buttonColour = frame->buttonColour ;

  window_parent = frame;
 
  wxWinType = wxTYPE_XWND;
  wxWnd *cparent = NULL;
  if (frame)
    cparent = (wxWnd *)frame->handle;
 
  frame->GetValidPosition(&x,&y) ;

  DWORD msflags = 0;
  if (style & wxBORDER)
    msflags |= WS_BORDER;
  msflags |= WS_CHILD | WS_VISIBLE;

  wxPanelWnd *wnd = new wxPanelWnd(cparent, "wxPanelClass", this, x, y, width, height, msflags);

  handle = (char *)wnd;
  frame->AdvanceCursor(this) ;

  return TRUE;

}

wxPanel::~wxPanel(void)
{
}

void wxPanel::SetLabelPosition(int pos)  // wxHORIZONTAL or wxVERTICAL
{
  label_position = pos;
}

void wxPanel::SetSize(int x, int y, int w, int h)
{
  int currentX, currentY;
  GetPosition(&currentX, &currentY);
  if (x == -1)
    x = currentX;
  if (y == -1)
    y = currentY;

  int currentW,currentH;
  GetSize(&currentW, &currentH);
  if (w == -1)
    w = currentW ;
  if (h == -1)
    h = currentH ;

  wxWnd *wnd = (wxWnd *)handle;
  if (wnd)
    MoveWindow(wnd->handle, x, y, w, h, TRUE);

  OnSize(w, h);
}

/*****************************************************************
 * ITEM PLACEMENT FUNCTIONS
 *****************************************************************/

 // Start a new line
void wxPanel::RealNewLine(void)
{
  //cursor_x = PANEL_LEFT_MARGIN;
  cursor_x = initial_hspacing;
  if (max_line_height == 0)
  {
    cursor_y += current_vspacing;
  }
  else
    cursor_y += current_vspacing + max_line_height;
  max_line_height = 0;
  new_line = FALSE ;
}
  
void wxPanel::NewLine(int pixels)
{
  if (new_line)
    current_vspacing += pixels ;
  else
    current_vspacing = pixels ;
  new_line = TRUE ;
}

void wxPanel::NewLine(void)
{
  if (new_line)
    current_vspacing += vSpacing ;
  else
    current_vspacing = vSpacing ;
  new_line = TRUE ;
}

/*
// Start a new line, OLD VERSION
void wxPanel::NewLine(void)
{
  cursor_x = PANEL_LEFT_MARGIN;
  if (max_line_height == 0)
  {
    cursor_y += vspacing;
  }
  else
    cursor_y += vspacing + max_line_height;
  max_line_height = 0;
}
*/

void wxPanel::Tab(void)
{
  cursor_x += hSpacing;
  if (cursor_x > max_width)
    max_width = cursor_x;
}

void wxPanel::Tab(int pixels)
{
  cursor_x += pixels;
  if (cursor_x > max_width)
    max_width = cursor_x;
}

void wxPanel::GetCursor(int *x, int *y)
{
  *x = cursor_x;
  *y = cursor_y;
}

// Set/get horizontal spacing
void wxPanel::SetHorizontalSpacing(int sp)
{
  hSpacing = sp;
  current_hspacing = sp ;
}

int wxPanel::GetHorizontalSpacing(void)
{
  return hSpacing;
}

// Set/get vertical spacing
void wxPanel::SetVerticalSpacing(int sp)
{
  vSpacing = sp;
  current_vspacing = sp ;
}

int wxPanel::GetVerticalSpacing(void)
{
  return vSpacing;
}

// Fits the panel around the items
void wxPanel::Fit(void)
{
  RealAdvanceCursor() ;
  SetClientSize(max_width + initial_hspacing,
                max_height + initial_vspacing);
/*
  SetClientSize(max_width + PANEL_HSPACING,
                max_height + PANEL_VSPACING);
*/
}

// Update next cursor position
void wxPanel::RealAdvanceCursor(void)
{
  wxWindow *item = last_created ;
  if (item)
  {
    int width, height;
    int x, y;
    item->GetSize(&width, &height);
    item->GetPosition(&x, &y);

    if ((x + width) > max_width)
      max_width = x + width;
    if ((y + height) > max_height)
      max_height = y + height;
    if (height > max_line_height)
      max_line_height = height;

    cursor_x = x + width + current_hspacing;
    cursor_y = y;
    last_created = NULL ;
  }
  if (new_line)
    RealNewLine() ;
}


// Update next cursor position
void wxPanel::AdvanceCursor(wxWindow *item)
{
/*
  int width, height;
  int x, y;
  item->GetSize(&width, &height);
  item->GetPosition(&x, &y);

  if ((x + width) > max_width)
    max_width = x + width;
  if ((y + height) > max_height)
    max_height = y + height;
  if (height > max_line_height)
    max_line_height = height;

  cursor_x = x + width + hspacing;
  cursor_y = y;
*/
   last_created = item ;
}

// If x or y are not specified (i.e. < 0), supply
// values based on left to right, top to bottom layout.
// Internal use only.
void wxPanel::GetValidPosition(int *x, int *y)
{
  if (*x < 0)
    *x = cursor_x;

  if (*y < 0)
    *y = cursor_y;
}

void wxPanel::Centre(int direction)
{
  int x, y, width, height, panel_width, panel_height, new_x, new_y;

  wxPanel *father = (wxPanel *)GetParent();
  if (!father)
    return;

  father->GetClientSize(&panel_width, &panel_height);
  GetSize(&width, &height);
  GetPosition(&x, &y);

  new_x = -1;
  new_y = -1;

  if (direction & wxHORIZONTAL)
    new_x = (int)((panel_width - width)/2);

  if (direction & wxVERTICAL)
    new_y = (int)((panel_height - height)/2);

  SetSize(new_x, new_y, -1, -1);

}

void wxPanel::Enable(Bool Flag)
{
  wxWnd *sub = (wxWnd*)handle ;
  EnableWindow(sub->handle,(BOOL)Flag) ;
}

void wxPanel::AddChild(wxObject *child)
{
  if (!has_child)
  {
    initial_hspacing = hSpacing ;
    initial_vspacing = vSpacing ;
  }
  has_child = TRUE ;

  cursor_x = hSpacing ;
  cursor_y = vSpacing ;
  RealAdvanceCursor() ;
  current_hspacing = hSpacing ;
  current_vspacing = vSpacing ;

  children->Append(child) ;
}

void wxPanel::SetBackgroundColour(wxColour*col)
{
}

void wxPanel::SetLabelColour(wxColour*col) 
{
}

void wxPanel::SetButtonColour(wxColour*col)
{
}

