#!/binb/wmake.exe
#
# File:		makefile.wat
# Author:	Edward C. Zimmermann <edz@crg.net>
# Created:	1994
# Updated:	
# RCS_ID        $Id$
#
# Makefile : Builds wxWindows library for Windows 3.1
# and Watcom C++ 

FINAL=0

LEVEL       = 386
CCC         = wpp$(LEVEL)
OS_TARGET   = windows

WXDIR = ..\..
WXLIB = $(WXDIR)\lib
WXINC = $(WXDIR)\include\msw
WXBASEINC = $(WXDIR)\include\base
OPT         = -ot -3
DEBUG_FLAGS = -d2
CFG         = -bt=$(OS_TARGET) -ze -Dwx_msw -D__turboc
IFLAGS      = -i=$(WXINC) -i=$(WXBASEINC) -i=$(WXDIR)\contrib\fafa -i=$(WXDIR)\contrib\itsybits
CPPFLAGS    = $(IFLAGS) $(CFG) $(DEBUG_FLAGS)
LIBTARGET   = $(WXLIB)\wx$(LEVEL).lib
DUMMY=dummydll

.cc.obj: .AUTODEPEND
        $(CCC) $(CPPFLAGS) $<

SOURCES = $(DUMMY).cc wx_win.cc wx_frame.cc wx_panel.cc wx_utils.cc wx_main.cc &
  wx_item.cc wx_text.cc wx_gdi.cc wx_dialg.cc wx_canvs.cc wx_dc.cc &
  wx_ipc.cc wx_timer.cc wx_mf.cc

OBJECTS = wx_win.obj wx_frame.obj wx_panel.obj wx_utils.obj wx_main.obj &
  wx_item.obj wx_text.obj wx_gdi.obj wx_dialg.obj wx_canvs.obj wx_dc.obj &
  wx_mf.obj wx_ipc.obj wx_timer.obj wx_clipb.obj

all:        $(LIBTARGET)

$(LIBTARGET) : $(OBJECTS)
    %create tmp.lbc
    @for %i in ( $(OBJECTS) ) do @%append tmp.lbc +%i
    wlib /b /c /n /p=512 $^@ @tmp.lbc
	
clean:
    -erase *.obj *.bak *.err
	-erase $(LIBTARGET)

