/*
 * File:        wb_utils.cc
 * Purpose:     Miscellaneous utilities
 * Author:      Julian Smart
 * Created:     1993
 * Updated:     August 1994
 * RCS_ID:      $Id: wb_utils.cc,v 1.5 1994/08/15 21:53:50 edz Exp edz $
 * Copyright:   (c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#ifdef __GNUG__
#pragma implementation
#endif

#include "common.h"
#include "wx_utils.h"
#include "wx_win.h"
#include "wx_menu.h"

// If not MS C++, don't include wx.h: we'll just include
// the minimum set of files.
// If MS C++, we'll use a precompiled header instead.
#if !defined(_MSC_VER) && !defined(wx_wxh)
#define wx_wxh
#endif

#include "wx.h"

#include <iostream.h>
#include <fstream.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/stat.h>

#define _MAXPATHLEN 500

extern char *wxBuffer;

#ifdef wx_msw

#define   _wxToLower(_c)     (char)lcharmap[(unsigned char)(_c)]

#define strcasecmp stricmp
#define strncasecmp strnicmp

// Lower case filename map
static unsigned char lcharmap[] =
{
  '\000', '\001', '\002', '\003', '\004', '\005', '\006', '\007',
  '\010', '\011', '\012', '\013', '\014', '\015', '\016', '\017',
  '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027',
  '\030', '\031', '\032', '\033', '\034', '\035', '\036', '\037',
  '\040', '\041', '\042', '\043', '\044', '\045', '\046', '\047',
  '\050', '\051', '\052', '\053', '\054', '\055', '\056', '\057',
  '\060', '\061', '\062', '\063', '\064', '\065', '\066', '\067',
  '\070', '\071', '\072', '\073', '\074', '\075', '\076', '\077',
  '\100', '\141', '\142', '\143', '\144', '\145', '\146', '\147',
  '\150', '\151', '\152', '\153', '\154', '\155', '\156', '\157',
  '\160', '\161', '\162', '\163', '\164', '\165', '\166', '\167',
  '\170', '\171', '\172', '\133', '\134', '\135', '\136', '\137',
  '\140', '\141', '\142', '\143', '\144', '\145', '\146', '\147',
  '\150', '\151', '\152', '\153', '\154', '\155', '\156', '\157',
  '\160', '\161', '\162', '\163', '\164', '\165', '\166', '\167',
  '\170', '\171', '\172', '\173', '\174', '\175', '\176', '\177',
  '\200', '\201', '\202', '\203', '\204', '\205', '\206', '\207',
  '\210', '\211', '\212', '\213', '\214', '\215', '\216', '\217',
  '\220', '\221', '\222', '\223', '\224', '\225', '\226', '\227',
  '\230', '\231', '\232', '\233', '\234', '\235', '\236', '\237',
  '\240', '\241', '\242', '\243', '\244', '\245', '\246', '\247',
  '\250', '\251', '\252', '\253', '\254', '\255', '\256', '\257',
  '\260', '\261', '\262', '\263', '\264', '\265', '\266', '\267',
  '\270', '\271', '\272', '\273', '\274', '\275', '\276', '\277',
  '\300', '\341', '\342', '\343', '\344', '\345', '\346', '\347',
  '\350', '\351', '\352', '\353', '\354', '\355', '\356', '\357',
  '\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
  '\370', '\371', '\372', '\333', '\334', '\335', '\336', '\337',
  '\340', '\341', '\342', '\343', '\344', '\345', '\346', '\347',
  '\350', '\351', '\352', '\353', '\354', '\355', '\356', '\357',
  '\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
  '\370', '\371', '\372', '\373', '\374', '\375', '\376', '\377',
};

#else
// This declaration is missing in SunOS!
// (Yes, I know it is NOT ANSI-C but its in BSD libc)
#ifdef __GNUG__
extern "C"
{
  int strcasecmp (const char *, const char *);
  int strncasecmp (const char *, const char *, size_t);
}
#endif
#endif				/* wx_msw */


char *
copystring (const char *s)
{
  if (s == NULL) s = "";
  size_t len = strlen (s) + 1;

  char *news = new char[len];
  memcpy (news, s, len);	// Should be the fastest

  return news;
}

/////////////////////////////////////////////////////////////////////////////
//
#ifdef DEBUGLOG
//

wxLogClass::wxLogClass (const char *file)
{
  log_file = copystring (file);
  the_stream = new ofstream (log_file);
  delete the_stream;
}

wxLogClass::~wxLogClass ()
{
  delete log_file;
}

void wxLogClass::Open (void)
{
  the_stream = new ofstream (log_file, ios::app);
}

void wxLogClass::Close (void)
{
  delete the_stream;
}

wxLogClass & wxLogClass::operator <<(char *s)
{
  this->Open ();
  *the_stream << s;
  the_stream->flush ();
  this->Close ();
  return *this;
}

wxLogClass & wxLogClass::operator <<(int i)
{
  this->Open ();
  *the_stream << i;
  the_stream->flush ();
  this->Close ();
  return *this;
}

wxLogClass & wxLogClass::operator <<(double i)
{
  this->Open ();
  *the_stream << i;
  the_stream->flush ();
  this->Close ();
  return *this;
}

wxLogClass wxLog ("log");
#endif /* DEBUGLOG */
/////////////////////////////////////////////////////////////////////////////

// Id generation
static long wxCurrentId = 100;

long 
NewId (void)
{
  return wxCurrentId++;
}

void 
RegisterId (long id)
{
  if (id >= wxCurrentId)
    wxCurrentId = id + 1;
}


void 
StringToFloat (char *s, float *number)
{
  if (s && *s && number)
    *number = (float) strtod (s, NULL);
}

void 
StringToDouble (char *s, double *number)
{
  if (s && *s && number)
    *number = strtod (s, NULL);
}

char *
FloatToString (float number)
{
  static char buf[20];

  sprintf (buf, "%.2f", number);
  return buf;
}

char *
DoubleToString (double number)
{
  static char buf[20];

  sprintf (buf, "%.2lf", number);
  return buf;
}

void 
StringToInt (char *s, int *number)
{
  if (s && *s && number)
    *number = (int) strtol (s, NULL, 10);
}

void 
StringToLong (char *s, long *number)
{
  if (s && *s && number)
    *number = strtol (s, NULL, 10);
}

char *
IntToString (int number)
{
  static char buf[20];

  sprintf (buf, "%d", number);
  return buf;
}

char *
LongToString (long number)
{
  static char buf[20];

  sprintf (buf, "%ld", number);
  return buf;
}


// Match a string INDEPENDENT OF CASE
Bool 
StringMatch (char *str1, char *str2, Bool subString, Bool exact)
{
  if (str1 == NULL || str2 == NULL)
    return FALSE;
  if (str1 == str2)
    return TRUE;

  if (subString)
    {
      size_t len1 = strlen (str1);
      size_t len2 = strlen (str2);
      size_t i;

      // Search for str1 in str2
      // Slow .... but acceptable for short strings
      for (i = 0; i <= len2 - len1; i++)
	{
	  if (strncasecmp (str1, str2 + i, len1) == 0)
	    return TRUE;
	}
    }
  else if (exact)
    {
      if (strcasecmp (str1, str2) == 0)
	return TRUE;
    }
  else
    {
      size_t len1 = strlen (str1);
      size_t len2 = strlen (str2);

      if (strncasecmp (str1, str2, min (len1, len2)) == 0)
	return TRUE;
    }

  return FALSE;
}


/****** FILE UTILITIES ******/

void wxPathList::Add (char *path)
{
  Append ((wxObject *) path);
}

// Add paths e.g. from the PATH environment variable
void wxPathList::AddEnvList (char *envVariable)
{
  static const char PATH_TOKS[] =
#ifdef wx_msw
	" ;"; // Don't seperate with colon in DOS (used for drive)
#else
	" :;";
#endif

  char *val = getenv (envVariable);
  if (val && *val)
    {
      char *s = copystring (val);
      char *token = strtok (s, PATH_TOKS);

      if (token)
	{
	  Add (copystring (token));
	  while (token)
	    {
	      if ((token = strtok (NULL, PATH_TOKS)) != NULL)
		Add (copystring (token));
	    }
	}
      delete[]s;
    }
}

// Given a full filename (with path), ensure that that file can
// be accessed again USING FILENAME ONLY by adding the path
// to the list if not already there.
void wxPathList::EnsureFileAccessible (char *path)
{
  char *path_only = PathOnly (path);
  if (path_only)
    {
      if (!Member (path_only))
	Add (path_only);
    }
}

// BugFIX @@@@ Unix is case sensitive!
Bool wxPathList::Member (char *path)
{
  for (wxNode * node = First (); node != NULL; node = node->Next ())
    {
      char *path2 = (char *) node->Data ();
      if (path2 &&
#ifdef wx_msw
      // Case INDEPENDENT
	  strcasecmp (path, path2) == 0
#else
      // Case sensitive File System 
	  strcmp (path, path2) == 0
#endif
	)
	return TRUE;
    }
  return FALSE;
}

char *wxPathList::FindValidPath (char *file)
{
  if (FileExists (file))
    return file;

  char *filename = IsAbsolutePath (file) ?
  FileNameFromPath (file) :
  file;

  for (wxNode * node = First (); node; node = node->Next ())
    {
      char *path = (char *) node->Data ();
      strcpy (wxBuffer, path);
      strcat (wxBuffer, "/");
      strcat (wxBuffer, filename);
#ifdef wx_msw
      Unix2DosFilename (wxBuffer);
#endif
      if (FileExists (wxBuffer))
	return wxBuffer;	// Found!

    }				// for()

  return NULL;			// Not found

}

Bool 
FileExists (const char *filename)
{
  struct stat stbuf;

  if (filename && stat (filename, &stbuf) == 0)
    return TRUE;
  return FALSE;
}

Bool 
IsAbsolutePath (const char *filename)
{
  if (filename)
    {
      if (*filename == '/'
#ifdef wx_msw
      /* MSDOS */
      || *filename == '\\' || (isalpha (*filename) && *(filename + 1) == ':')
#endif
	)
	return TRUE;
    }
  return FALSE;
}

// Destructive removal of /./ and /../ stuff

// CAUSES PROBLEMS FOR GNU COMPILER
#ifndef __GNUG__
char *
wxRealpath( char *path )
{
#ifdef wx_msw
    const char *slash = "\\";
#else
    const char *slash = "/";
#endif

    if ( path == NULL || *path == '\0' )
	return path;

    char file_name[_MAXPATHLEN];
    strcpy(file_name, path);

    char dest[_MAXPATHLEN];
    dest[0] = '\0';

    for(char *tok = strtok(file_name, slash); tok; tok = strtok(NULL, slash) ) {
	if ( tok[0] == '\0' || ( tok[0] == '.' && tok[1] == '\0') ) {
	    ; // Nothing
	} else if ( tok[0] == '.' && tok[1] == '.' && tok[2] == '\0' ) {
	    char *last = strrchr(dest, slash[0]);

	    if ( last == NULL )
		strcpy(dest, last);
	    else if ( last != dest )
		*last = '\0';
	    else
		dest[1] = '\0';
	} else {
	    if ( dest[strlen(dest) -1] != slash[0] )
		strcat(dest, slash);
	    strcat(dest, tok);
	}
    }

    strcpy(path, dest);
    return path;
}
#endif

// Return just the filename, not the path
// (basename)
char *
FileNameFromPath (char *path)
{
  if (path)
    {
      register char *tcp;

      tcp = path + strlen (path);
      while (--tcp >= path)
	{
	  if (*tcp == '/' || *tcp == '\\')
	    return tcp + 1;
	}			/* while */
#ifdef wx_msw
      if (isalpha (*path) && *(path + 1) == ':')
	return path + 2;
#endif
    }
  return path;
}

// Return just the directory, or NULL if no directory
char *
PathOnly (char *path)
{
  if (path && *path)
    {
      static char buf[_MAXPATHLEN];

      // Local copy
      strcpy (buf, path);

      int l = strlen(path);
      Bool done = FALSE;

      int i = l - 1;

      // Search backward for a backward or forward slash
      while (!done && i > -1)
      {
        if (path[i] == '/' || path[i] == '\\')
        {
          done = TRUE;
          buf[i] = 0;
          return buf;
        }
        else i --;
      }

/* there's a bug here somewhere, so replaced with my original code.
      char *tcp;
      // scan back
      for (tcp = &buf[strlen (buf) - 1]; tcp >= buf; tcp--)
	{
	  // Search for Unix or Dos path sep {'\\', '/'}
	  if (*tcp == '\\' || *tcp == '/')
	    {
	      *tcp = '\0';
	      return buf;
	    }
	}			// for()
*/
#ifdef wx_msw
      // Try Drive specifier
      if (isalpha (buf[0]) && buf[1] == ':')
	{
	  // A:junk --> A:. (since A:.\junk Not A:\junk)
	  buf[2] = '.';
	  buf[3] = '\0';
	  return buf;
	}
#endif
    }

  return NULL;
}

// Utility for converting delimiters in DOS filenames to UNIX style
// and back again - or we get nasty problems with delimiters.
// Also, convert to lower case, since case is significant in UNIX.

void 
Dos2UnixFilename (char *s)
{
  if (s)
    while (*s)
      {
	if (*s == '\\')
	  *s = '/';
#ifdef wx_msw
	else
	  *s = _wxToLower (*s);	// Case INDEPENDENT
#endif
	s++;
      }
}

void 
Unix2DosFilename (char *s)
{
// Yes, I really mean this to happen under DOS only! JACS
#ifdef wx_msw
  if (s)
    while (*s)
      {
	if (*s == '/')
	  *s = '\\';
	s++;
      }
#endif
}

/* Get Full RFC822 style email address */
Bool
wxGetEmailAddress (char *address, int maxSize)
{
  char host[65];
  char user[65];

  if (wxGetHostName(host, 64) == FALSE)
    return FALSE;
  if (wxGetUserId(user, 64) == FALSE)
    return FALSE;

  char tmp[130];
  strcpy(tmp, user);
  strcat(tmp, "@");
  strcat(tmp, host);

  strncpy(address, tmp, maxSize - 1);
  address[maxSize] = '\0';
  return TRUE;
}

/*************************************************************************
 *
 * wxIsWild checks whether the pattern contains wildcards, and
 * returns TRUE if it does, and FALSE if it does not (or if the 
 * pattern is NULL -- i.e. no string).
 *
 * The argument is:
 *   
 * 1) pattern - a character string
 */
Bool 
wxIsWild (const char *pattern)
{
  while (*pattern)
    {
      switch (*pattern++)
	{
	case '?':
	case '*':
#ifdef wx_x
	case '[':
	case '{':		/* } */
#endif
	  return TRUE;
#ifdef wx_x
	case '\\':
	  if (!*pattern++)
	    return FALSE;
#endif
	}			/* switch() */
    }				/* while() */
  return FALSE;
}


/*************************************************************************
 *
 *  wxMatchWild matches the given pattern string against 
 *  a text string, and returns TRUE if it matches, FALSE otherwise.
 *
 *  A match means that the entire text string is used up in the matching.
 *  The pattern can contain the following wildcards.
 * 
 *  * -- matches any sequence of characters
 *  ? -- matches one character
 *
 * If one or other or both of the string arguments to wxMatchWild function is  
 * NULL (i.e. there isn't a string), then the function returns FALSE.
 *
 */
static Bool wxPatternMatch (const char *pattern, const char *text, size_t i, size_t j);

// @@@@ dotSpecial is NOT YET IMPLEMENTED!
Bool 
wxMatchWild (const char *pattern, const char *text, Bool /* dotSpecial */ )
{
  if (pattern == NULL || text == NULL || *pattern == '\0' || *text == '\0')
    return FALSE;
  return wxPatternMatch (pattern, text, 0, 0);
}

/*************************************************************************
 *
 *  wxPatternMatch does the work for wxMatchWild. wxPatternMatch  matches 
 *  the given pattern string against a text string, and returns TRUE if 
 *  it matches, FALSE otherwise. It is assumed that the string arguments
 *  to wxPatternMatch exist.
 *
 *  A match means that the entire text string is used up in the matching.
 *  The pattern can contain the following wildcards.
 * 
 *  * -- matches any sequence of characters
 *  ? -- matches one character
 *
 *  wxPatternMatch works by going down the pattern trying to match the
 *  the same index character in the pattern and string arrays, and stops
 *  when the end of the pattern or text string is reached. However, if a
 *  '*' wildcard is met, the algorithm checks to see whether the remaining 
 *  pattern (after the wildcard) matches the rest of the text (i.e. the 
 *  wxPatternMatch function is called recursively).
 */
// Recursive
static Bool 
wxPatternMatch (const char *pattern, const char *text, size_t i, size_t j)
{
  size_t pattern_length = strlen (pattern);
  size_t text_length = strlen (text);
  Bool match = FALSE;

  while (j < pattern_length && i < text_length)
    {
      if (text[i] == pattern[j] || pattern[j] == '?')
	{
	  match = TRUE;
	  i++, j++;
	}
      else if (pattern[j] == '*')
	{
	  // If pattern ends in '*'
	  if (++j == pattern_length)
	    {
	      match = TRUE;
	      i = text_length;
	    }
	  else
	    {
	      match = FALSE;
// after wildcard check to see whether rest of pattern matches 
	      // up with rest of text
	      while (i < text_length && match != TRUE)
		{
		  match = wxPatternMatch (pattern, text, i, j);
		  i++;
		}
// text index is decremented so that it points to where 
	      // the text string starts to match the rest of the pattern
	      i--;
	    }
	}
      else if (text[i] != pattern[j])
	{
	  j = pattern_length;
	  match = FALSE;
	}
    }
  if (j == pattern_length && i == text_length && match == TRUE)
    {
      return TRUE;
    }
  else
// special case where pattern and text are the same except that pattern
    // also only has '*' wildcards on the end
  if (i == text_length && pattern[j] == '*' && match == TRUE)
    {
      for (; j < pattern_length; j++)
	{
	  if (pattern[j] != '*')
	    return FALSE;
	}
      return TRUE;
    }
  else
    {
      return FALSE;
    }
}
//-----------------------------------------------------------------------------

// Concatenate two files to form third
Bool 
wxConcatFiles (const char *file1, const char *file2, const char *file3)
{
  char *outfile = wxGetTempFileName("cat");

  FILE *fp1 = NULL;
  FILE *fp2 = NULL;
  FILE *fp3 = NULL;
  // Open the inputs and outputs
  if ((fp1 = fopen (file1, "rb")) == NULL ||
      (fp2 = fopen (file2, "rb")) == NULL ||
      (fp3 = fopen (outfile, "wb")) == NULL)
    {
      if (fp1)
	fclose (fp1);
      if (fp2)
	fclose (fp2);
      if (fp3)
	fclose (fp3);
      return FALSE;
    }

  int ch;
  while ((ch = getc (fp1)) != EOF)
    putc (ch, fp3);
  fclose (fp1);

  while ((ch = getc (fp2)) != EOF)
    putc (ch, fp3);
  fclose (fp2);

  fclose (fp3);
  Bool result = wxRenameFile(outfile, file3);
  delete[] outfile;
  return result;
}

// Copy files
Bool 
wxCopyFile (const char *file1, const char *file2)
{
  FILE *fd1;
  FILE *fd2;
  int ch;

  if ((fd1 = fopen (file1, "rb")) == NULL)
    return FALSE;
  if ((fd2 = fopen (file2, "wb")) == NULL)
    {
      fclose (fd1);
      return FALSE;
    }

  while ((ch = getc (fd1)) != EOF)
    putc (ch, fd2);

  fclose (fd1);
  fclose (fd2);
  return TRUE;
}

Bool 
wxRenameFile (const char *file1, const char *file2)
{
  // Normal system call
  if (0 == rename (file1, file2))
    return TRUE;
  // Try to copy
  if (wxCopyFile(file1, file2)) {
    wxRemoveFile(file1);
    return TRUE;
  }
  // Give up
  return FALSE;
}

/*
 * Strip out any menu codes
 */
void 
wxStripMenuCodes (char *in, char *out)
{
#if 1
  while (*in)
    {
      if (*in == '&')
	{
	  // Check && -> &, &x -> x
	  if (*++in == '&')
	    *out++ = *in++;
	}
      else if (*in == '\t')
	{
// Remove all stuff after \t in X mode, and let the stuff as is
	  // in Windows mode.
	  // Accelerators are handled in wx_item.cc for Motif, and are not
	  // YET supported in XView
	  break;
	}
      else
	*out++ = *in++;
    }				// while

  *out = '\0';

#else /* Old Code (soon to vanish) */
  size_t len = strlen (in);
  size_t j = 0;

  for (size_t i = 0; i < len; i++)
    {
      if (in[i] == '&')
	{
	  // && must be handled!
	  if ((i + 1) <= len && in[i + 1] == '&')
	    {
	      i++;
	      out[j] = '&';
	      j++;
	    }
	}
/*
   What is your intention? If you want to remove Tab char, that doesn't work...
   What you remove is "\" then "t" sequence, and I can't figure out why.
   else if (in[i] == '\\' && (i + 1) <= len && in[i+1] == 't')
   {
   i ++;
   out[j] = ' ';
   j ++;
   }
   Nevertheless, I remove all stuff after \t in X mode, and let the stuff as is
   in Windows mode. Accelerators are handled in wx_item.cc for Motif, and not
   supported in XView
 */
      else if (in[i] == '\t')
	{
	  out[j] = '\0';
	  return;
	}
      else
	{
	  out[j] = in[i];
	  j++;
	}
    }
  out[j] = 0;
#endif
}


/*
 * Window search functions
 *
 */

/*
 * If parent is non-NULL, look through children for a label or title
 * matching the specified string. If NULL, look through all top-level windows.
 *
 */

static wxWindow *wxFindWindowByLabel1 (wxWindow * parent, char *title);

wxWindow *
wxFindWindowByLabel (wxWindow * parent, char *title)
{
  if (parent)
    {
      return wxFindWindowByLabel1 (parent, title);
    }
  else
    {
      for (wxNode * node = wxTopLevelWindows.First (); node; node = node->Next ())
	{
	  wxWindow *win = (wxWindow *) node->Data ();
	  wxWindow *retwin = wxFindWindowByLabel1 (win, title);
	  if (retwin)
	    return retwin;
	}			// for()

    }
  return NULL;
}

// Recursive
static wxWindow *
wxFindWindowByLabel1 (wxWindow * parent, char *title)
{
  if (parent)
    {
      char *lab = parent->GetLabel ();
      if (lab && StringMatch (title, lab))
	return parent;
    }

  if (parent)
    {
      for (wxNode * node = parent->children->First (); node; node = node->Next ())
	{
	  wxWindow *win = (wxWindow *) node->Data ();
	  wxWindow *retwin = wxFindWindowByLabel1 (win, title);
	  if (retwin)
	    return retwin;
	}			// for()

    }

  return NULL;			// Not found

}

// Returns menu item id or -1 if none.
int 
wxFindMenuItemId (wxFrame * frame, char *menuString, char *itemString)
{
  wxMenuBar *menuBar = frame->GetMenuBar ();
  if (!menuBar)
    return -1;
  return menuBar->FindMenuItem (menuString, itemString);
}
