/*
 * File:	wx_win.h
 * Purpose:	wxWindow class declaration (X version).
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "@(#)wx_win.h	1.2 5/9/94" */

#ifndef wx_winh
#define wx_winh

#ifdef __GNUG__
#pragma interface
#endif

#include "common.h"
#include "wx_obj.h"
#include "wx_stdev.h"
#include "wx_list.h"
#include "wx_gdi.h"
#include "wb_win.h"

#include <X11/X.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

/*
 * Base class for frame, panel, canvas, panel items, dialog box.
 *
 */

#ifdef IN_CPROTO
typedef       void    *wxWindow ;
#else

class wxWindow: public wxbWindow
{
 public:
  // When doing globale cursor changes, the current cursor
  // may need to be saved for each window @@@@
  Cursor currentWindowCursor;
#ifdef wx_xview
  Xv_opaque dropSite;
#endif
  // Constructors/Destructors
  wxWindow(void);
  ~wxWindow(void);

  void GetSize(int *width, int *height);
  void GetPosition(int *x, int *y);
  void GetClientSize(int *width, int *height); // Size client can use
  void SetSize(int x, int y, int width, int height);
  void SetClientSize(int width, int size);
  void ClientToScreen(int *x, int *y);
  void ScreenToClient(int *x, int *y);
  void Refresh(void);
  void SetFocus(void);
  void CaptureMouse(void);
  void ReleaseMouse(void);
  void Enable(Bool enable);
  void DragAcceptFiles(Bool accept);
  void Fit(void) {};
  void Centre(int direction) {};
  void SetTitle(char *title) {};
  void SetFont(wxFont *f);
  Bool PopupMenu(wxMenu *menu, float x, float y);

  // Sometimes in Motif there are problems popping up a menu
  // (for unknown reasons); use this instead when this happens.
#ifdef wx_motif
  Bool FakePopupMenu(wxMenu *menu, float x, float y);
#endif

  void Show(Bool show);
  wxCursor *SetCursor(wxCursor *cursor);
  void SetColourMap(wxColourMap *cmap);

  float GetCharHeight(void);
  float GetCharWidth(void);
  void GetTextExtent(const char *string, float *x, float *y,
                     float *descent = NULL, float *externalLeading = NULL);

  int CharCodeXToWX(KeySym keySym);
  KeySym CharCodeWXToX(int id);

#ifdef wx_motif 
  virtual Bool PreResize(void);
  virtual void PostDestroyChildren(void);
  int wxType;
#endif
  // Get the underlying X window
  virtual Window GetXWindow(void);
  virtual Display *GetXDisplay(void);
};

#endif // IN_CPROTO
#endif
