/*
 * File:	wx_gdi.h
 * Purpose:	Declaration of various graphics objects - fonts, pens, icons etc.
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "@(#)wx_gdi.h	1.2 5/9/94" */


#ifndef wx_gdih
#define wx_gdih

#ifdef __GNUG__
#pragma interface
#endif

#include "wb_gdi.h"

#ifdef wx_motif
#include <Xm/Xm.h>
#endif

#ifdef wx_xview
#include <xview/font.h>
#include <xview/icon.h>
#include <xview/cursor.h>
#endif

#ifdef IN_CPROTO
typedef       void    *wxFont ;
typedef       void    *wxColourMap;
typedef       void    *wxPen;
typedef       void    *wxBrush;
typedef       void    *wxIcon;
typedef       void    *wxCursor;
typedef       void    *wxBitmap;
typedef       void    *XFontInfo;
typedef       void    *XFontPool;
#else

// Font
class wxFont: public wxbFont
{
 public:
#ifdef wx_motif
  XFontStruct *xFont;
  XmFontList  mFont ;
#endif
#ifdef wx_xview
  Xv_Font x_font;
#endif

  wxFont(void);
  wxFont(int PointSize, int Family, int Style, int Weight, Bool underlined = FALSE);
  ~wxFont(void);
#ifdef wx_motif
  XmFontList GetInternalFont() ;
#endif
#ifdef wx_xview
  Xv_Font GetInternalFont() ;
#endif

};

class wxColourMap: public wxbColourMap
{
 public:
  Bool destroyable;
  Colormap cmap;

  wxColourMap(void);
  ~wxColourMap(void);
  Bool Create(const int n, const unsigned char *red, const unsigned char *green, const unsigned char *blue);
  int GetPixel(const unsigned char red, const unsigned char green, const unsigned char blue);
  Bool GetRGB(const int pixel, unsigned char *red, unsigned char *green, unsigned char *blue);
};

#define wxColorMap wxColourMap

// Pen
class wxPen: public wxbPen
{
 public:
  wxPen(void);
  wxPen(wxColour& col, int width, int style);
  wxPen(char *col, int width, int style);
  ~wxPen(void);

};

// Brush
class wxBrush: public wxbBrush
{
 public:
  wxBrush(void);
  wxBrush(wxColour& col, int style);
  wxBrush(char *col, int style);
  ~wxBrush(void);

};

// Icon
class wxIcon: public wxbIcon
{
 public:
#ifdef wx_motif
  int iconWidth;
  int iconHeight;
  Pixmap x_pixmap;
#endif
#ifdef wx_xview
  Server_image x_image;
  Icon x_icon;
#endif
  wxIcon(void);
  wxIcon(char bits[], int width, int height);
  wxIcon(const char *name);
  ~wxIcon(void);
};

// Cursor
class wxCursor: public wxbCursor
{
 public:
#ifdef wx_motif
  Cursor x_cursor;
  Bool use_raw_x_cursor;
#endif
#ifdef wx_xview
  Xv_Cursor x_cursor;
  Bool use_raw_x_cursor;
#endif
  wxCursor(void);
  wxCursor(char bits[], int width, int height);
  wxCursor(const char *name);
  wxCursor(int cursor_type);
  ~wxCursor(void);
};

// Bitmap
class wxBitmap: public wxbBitmap
{
 public:
  Pixmap x_pixmap;
  Bool freePixmap;

#ifdef wx_motif
  // This 5 variables are for wxItem
  Pixmap insensPixmap ;
  Pixmap labelPixmap ;
  Pixmap armPixmap ;
  XImage *image ;
  XImage *insensImage ;
#endif

#ifdef wx_xview
  Server_image x_image;
#endif

  wxBitmap(void) ;
  wxBitmap(char bits[], int width, int height, int depth = 1);
  wxBitmap(char *name);
  // If depth is omitted, will create a bitmap compatible with the display
  wxBitmap(int width, int height, int depth = -1);
  ~wxBitmap(void);
#ifdef wx_motif
  // For wxItem
  virtual Pixmap GetLabelPixmap(Widget w) ;
  virtual Pixmap GetArmPixmap(Widget w) ;
  virtual Pixmap GetInsensPixmap(Widget w) ;
#endif

};

#ifdef wx_x
// X-specific font matching mechanism
class XFontInfo: public wxObject
{
 public:
  int family;
  int style;
  int weight;
  int point_size; // Points in XView, 10ths of a point in Motif
  Bool underlined;
#ifdef wx_xview
  Xv_Font font;
#endif
#ifdef wx_motif
  XFontStruct *font;
#endif
  XFontInfo(int the_family, int the_style, int the_weight, int the_point_size,
             Bool underlined,
#ifdef wx_xview
            Xv_Font the_font);
#endif
#ifdef wx_motif
            XFontStruct *the_font);
#endif
};

class XFontPool: public wxList
{
  XFontInfo *cache;
 public:
  XFontPool(void);
  void AddFont(int family, int style, int weight, int point_size, Bool underlined,
#ifdef wx_xview
               Xv_Font font);
#endif
#ifdef wx_motif
               XFontStruct *font);
#endif
#ifdef wx_xview
  Xv_Font
#endif
#ifdef wx_motif
  XFontStruct *
#endif
    FindFont(int family, int style, int weight, int point_size, Bool underlined);

#ifdef wx_xview
  Xv_Font
#endif
#ifdef wx_motif
  XFontStruct *
#endif
    FindOrCreateFont(int family, int style, int weight, int point_size, Bool underlined, int point_size_to_store, int xres, int yres);

#ifdef wx_xview
  Xv_Font FindNearestFont(int family, int style, int weight, int point_size, Bool underlined, int xres, int yres);
#endif
#ifdef wx_motif
  XFontStruct *FindNearestFont(int family, int style, int weight, int point_size, Bool underlined, int xres, int yres);
#endif
};

extern XFontPool *wxFontPool;
#endif

#endif // IN_CPROTO
#endif // wx_gdih
