/*
 * File:	wx_dialg.h
 * Purpose:	wxDialogBox and common dialog declarations (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#ifndef wx_dialgh
#define wx_dialgh

#ifdef __GNUG__
#pragma interface
#endif

#include "common.h"
#include "wx_item.h"
#include "wx_check.h"
#include "wx_messg.h"
#include "wb_dialg.h"

#ifdef wx_xview
#include <xview/frame.h>
#endif

#ifdef IN_CPROTO
typedef void    *wxDialogBox ;
#else

// Dialog boxes
class wxDialogBox: public wxbDialogBox
{
  char *dialogTitle;
 public:
  Bool modal_showing;
#ifdef wx_motif
  Bool invisibleResize ;
  Widget dialogShell;
  void PostDestroyChildren(void);
#endif
#ifdef wx_xview
  Frame frame;
#endif
  wxDialogBox(void);
  wxDialogBox(wxWindow *parent, char *title, Bool modal = FALSE,
              int x = -1, int y = -1,
              int width = -1, int height = -1, long style = wxDEFAULT_DIALOG_STYLE,
              char *name = "dialogBox");
  ~wxDialogBox();

  Bool Create(wxWindow *parent, char *title, Bool modal=FALSE,
              int x=-1, int y=-1,
              int width=-1, int height=-1, long style=wxDEFAULT_DIALOG_STYLE,
              char *name="dialogBox");
  void SetSize(int x, int y, int width, int height);
  void SetClientSize(int width, int height);
  void GetPosition(int *x, int *y);
  void Show(Bool show);
  Bool IsShown(void);
  void Iconize(Bool iconize);
  Bool Iconized(void);
  void Fit(void);
  void SetTitle(char *title);
  char *GetTitle(void);
};

#define ORPHAN_PARENT NULL

int wxMessageBox(char *message, char *caption = "Message", long style = wxOK|wxCENTRE,
  wxWindow *parent = ORPHAN_PARENT, int x = -1, int y = -1);

#endif // IN_CPROTO
#endif // wx_dialgh
