/*
 * File:	wb_frame.h
 * Purpose:	wxFrame declaration
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "@(#)wb_frame.h	1.2 5/9/94" */

#ifndef wxb_frameh
#define wxb_frameh

#ifdef __GNUG__
#pragma interface
#endif

#include "common.h"
#include "wx_win.h"

#define wxMAX_STATUS   5

#ifdef IN_CPROTO
typedef       void    *wxbFrame ;
#else

class wxMenuBar;
class wxPanel ;
class wxStatusWnd;
class wxFrame;
class wxbFrame: public wxWindow
{
 public:
  Bool modal_showing;
  wxMenuBar *wx_menu_bar;
  wxIcon *icon;
  Bool status_line_exists;
  long frame_type;  // SDI, MDI parent/child
  int nb_status;

  int toolPosition ;
  wxPanel *toolPanel ;
  Bool toolVisible;

  wxbFrame(void);
  wxbFrame(wxFrame *parent, char *title,
          int x=-1, int y=-1, int width=-1, int height=-1,
          long type = wxSDI | wxDEFAULT_FRAME, char *name = "frame");

  ~wxbFrame(void);

  Bool Create(wxFrame *parent, char *title,
          int x=-1, int y=-1, int width=-1, int height=-1,
          long type = wxSDI | wxDEFAULT_FRAME, char *name = "frame");

  // Override, e.g. to resize subwindows
  void OnSize(int x, int y);

  // The default thing is to set the focus for the first child window.
  // Override for your own behaviour.
  void OnActivate(Bool flag);

  // Default behaviour is to display a help string for the menu item.
  virtual void OnMenuSelect(int id);
  virtual void OnMenuCommand(int /* Id */) {};         // Called on frame menu command

  // Set menu bar
  virtual void SetMenuBar(wxMenuBar *menu_bar);
  virtual wxMenuBar *GetMenuBar(void);

  // Set icon
  virtual void SetIcon(wxIcon *icon) = 0;

  // Create status line
  virtual void CreateStatusLine(int number = 1, char *name = "status_line") = 0;

  // Set status line text
  virtual void SetStatusText(char *text, int number = 0) = 0;
  virtual Bool StatusLineExists(void);

  void Centre(int direction = wxBOTH);

  // Iconize
  virtual void Iconize(Bool iconize) = 0;
  virtual Bool Iconized(void) = 0;
  // Windos 3.x maximize/restore
  virtual void Maximize(Bool maximize) = 0;

  virtual void LoadAccelerators(char *table) = 0;

  // Call this to simulate a menu command
  virtual void Command(int id);
  virtual void ProcessCommand(int id);

  // tool panel
  virtual wxPanel* CreateToolPanel(int position=wxTOOL_TOP) = 0 ;
  virtual void FitToolPanel(void) = 0 ;
  virtual void ShowToolPanel(Bool show) = 0 ;
};

#endif // IN_CPROTO
#endif // wxb_frameh
