#include "window.h"
#include "palette.h"

unsigned palette_popup::palind(int min, int max, int i) {
  float f = (((float) i) * (max-min)) / ncolors;  
  int xi =  min + (int) f;
  if (xi < 0) return 0;
  if (xi > 0xffff) return 0xffff; else return xi;
}
  
void palette_popup::paint() { int i;
  for (i = 0; i <ncolors; i++) {
  color_cells[i].red   = palind(smin[0]->value,smax[0]->value,i);
  color_cells[i].blue  = palind(smin[1]->value,smax[1]->value,i);
  color_cells[i].green = palind(smin[2]->value,smax[2]->value,i);
  }
  XStoreColors(display,def_cmap,color_cells,ncolors);
}

class palette_display : public window {
  GC gc;  
  XGCValues values; 
  palette_popup *pp;
public:
  palette_display(window &parent, int w, int h, int x, int y, palette_popup *pp) : 
    window(parent,w,h,x,y), pp(pp) { 
      values.foreground = 0;
      gc = CreateGC(GCForeground, &values); }
  virtual void redraw() { 
    int i, x = 0, nc = pp->ncolors, dx = width/nc + 1;
    for (i = 0; i < nc; i++) { 
      values.foreground = pp->color_cells[i].pixel; 
      XChangeGC(display,gc, GCForeground, &values); 
      x = int(i*width/float(nc));
      XFillRectangle(display,Win,gc,x,0,dx,height); 
    }
  }
};

char * colstr[] = { "red","blue","green"};

class pal_text_win : public window {
public: 
  pal_text_win(window &parent, int h, int x, int y) : 
    window(parent, 70,h ,x,y,0) {}
  virtual void redraw() { 
    int x = 5, y = 15, i;
    for (i = 0; i<3; i++) { 
      DrawString(x+30,y+12,colstr[i]);
      DrawString(x,y,"xmin"); y+= 25; 
      DrawString(x,y,"xmax"); y+= 40; 
    } }
};
 
void set_pal(palette_popup * pp, int limits[2][3])
{ int i; 
  for (i=0; i< 3; i++) { 
    pp->smin[i]->change(limits[0][i]*1000); 
    pp->smax[i]->change(limits[1][i]*1000); }
}

struct palstr { char * Name; int limits[2][3];  };

// muss static sein !
struct palstr fbar[] = { { "brown ", { {21, 4, 80 }, { 65, 65, 55} } },
			 { "rainbow", { { 0, 65, 0}, { 65, 0 , 22} } },
			 { "yellow", { {0,0,0}, { 65, 0, 65} } },
			 { "steel",  { {0,0,0}, {0,65,65} } },
			 { "violet", { {37,37,0}, {65,65,65} } },
			 { "gray", { {0,0,0}, {65,65,65} } }
                       };

static void pal_paint( palette_popup * pp) { pp->paint(); };

// 1. Konstruktor fuer palette_popup : erzeugt eine Farbpalette und
// ein Popup zur Darstellung und Manipulation der Paletten
palette_popup::palette_popup(int ncol) : main_window("palette",375,330) {
  init_palette(ncol);
  long unsigned plane_mask,i;
  for (i = 0; i < ncolors; i++) {
    // printf(" %d",i); fflush(stdout);
    if (0 == XAllocColorCells(display,def_cmap,TRUE,&plane_mask,0,
			      &(color_cells[i].pixel),1))
      error("palette.c : No more color cells on display");
    color_cells[i].flags = DoRed | DoGreen | DoBlue;
    // cout << color_cells[i].pixel <<" "; 
  }
  set_pal(this,fbar[0].limits);  // initialization
}
// 2. Konstruktor : die ColorCells sind schon vorhanden (pixels)
palette_popup::palette_popup(int ncol, long unsigned *pixels) : 
  main_window("palette",375,330) {
  init_palette(ncol);
  unsigned i;
  for (i = 0; i < ncolors; i++) {
    color_cells[i].pixel = pixels[i];
    color_cells[i].flags = DoRed | DoGreen | DoBlue;
    // cout << color_cells[i].pixel <<" "; 
  }
//  set_pal(this,fbar[0].limits);  // initialization
}

// von den Konstruktoren benutzt
palette_popup::init_palette(int ncol) {
  ncolors = ncol;

  int ci,i,y = 5, w = 300, x= 5; 
  window * text = new pal_text_win(*this,180,w+x,y);
  for (ci = 0; ci<3; ci++) {
    smin[ci] = new scrollbar(*this,pal_paint,this,w,20,x,y,0,0xffff); y+= 25;
    smax[ci] = new scrollbar(*this,pal_paint,this,w,20,x,y,0,0xffff); 
    y+= 40;
  }

  menu_bar *mb = new menu_bar(*this,370,20,x,y,50,100,0); y+= 25;
  int nbar = sizeof(fbar)/sizeof(palstr); // Elementzahl von fbar
  function_button *fb[nbar];
  for (i=0; i < nbar; i++)
    new function_button(*mb,fbar[i].Name,(CB) set_pal, this, fbar[i].limits);

  palette_display *sh = new palette_display(*this,370,50,x,y,this); y+= 60;
  unmap_button * ub = new unmap_button(*this,"close",100,20,130,y);
  color_cells = new XColor[ncolors];

}

