#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/PanedW.h>
#include <Xm/Label.h>
#include <Xfwf/XmTabs.h>

static String fallback_resources[] = {
    "XmTabsT.geometry:		450x250",
    "*board*background:		#bdbdbdbdbdbd",
    "*tabs.height:		29",
    "*tabs.font:		*-helvetica-medium-r-*-120-*",
    "*tabs.tabcolor:		#a5a5a5a5a5a5",
    "*board.separatorOn:	no",
    "*board.spacing:		0",
    NULL,
};

static Widget toplevel, board, label, tabs;
static XtAppContext app_context;

static String texts[] = {
    "This is a test for the XmTabs widget.\n\
Click on any of the tabs to display the\n\
corresponding text.",
    "A click on a tab results in a callback\n\
that is used by the test program to\n\
change the text in this label\n\
and to change the number of tabs.",
    "This is just filler text.",
    "The last tab on the right is the\n\
`Quit' button. The test program will\n\
exit when you click that one.",
    "This is more filler text",
    "In the PanedWindow that holds\n\
both the tabs and the label,\n\
the spacing is set to 0,\n\
and the separator is omitted.\n\
This way the tabs and the label seem\n\
to be in one piece.",
    "This won't get displayed",
};

static String labels[] = {
    "Introduction",
    "Clicks",
    "Just filler",
    "About the `Quit' tab",
    "More filler",
    "Pixel trick",
    "Quit",
};

static int cur = 0;				/* Current label/text */


/* ARGSUSED */
static void handle_click(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    int tab = (int) call_data;

    if (tab == 0) return;
    cur += tab;

    if (cur == XtNumber(labels) - 1) exit(0);	/* Quit button? */

    /* Change tabs */
    XtVaSetValues(tabs, 
		  XtNlefttabs, cur,
		  XtNrighttabs, XtNumber(labels) - cur - 1,
		  NULL);
    /* Change text */
    XtVaSetValues(label, XtVaTypedArg, XmNlabelString,
		  XtRString, texts[cur], strlen(texts[cur]) + 1, NULL);
}


void main(argc, argv)
    int argc;
    String *argv;
{
    toplevel = XtVaAppInitialize(&app_context, argv[0], NULL, 0,
				  &argc, argv, fallback_resources, NULL);
    board = XtVaCreateManagedWidget
	("board", xmPanedWindowWidgetClass, toplevel, NULL);
    tabs = XtVaCreateManagedWidget
	("tabs", xmTabsWidgetClass, board,
	 XtNlabels, labels,
	 XtNlefttabs, cur,
	 XtNrighttabs, XtNumber(labels) - 1 - cur,
	 NULL);
    label = XtVaCreateManagedWidget
	("label", xmLabelWidgetClass, board,
	 XtVaTypedArg, XmNlabelString, XmRString,
	 texts[cur], strlen(texts[cur]) + 1, NULL);
    XtRealizeWidget(toplevel);
    XtAddCallback(tabs, XtNactivateCallback, handle_click, NULL);
    XtAppMainLoop(app_context);
}
