.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfPieMenu
.SH DESCRIPTION
A PieMenu is normally used as a pop-up menu. It is a circular menu
with labeled pie segements. The menu pops up with the mouse pointer in
the center. The user moves the mouse into one of the segments and
releases the mouse button. The advantage of this kind of menu is that
-- after some practice -- it can be used without having to look at the
screen. The disadvantage is that there is only room for a few items.
This implementation works with up to 6 items.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfPieMenu
Name	Class	Type	Default
XtNholeRadius	XtCHoleRadius	Dimension 	8 
XtNmenu	XtCMenu	String 	NULL 
XtNbackground1	XtCBackground1	Pixel 	copy_bg 
XtNbackground2	XtCBackground2	Pixel 	copy_bg 
XtNbackground3	XtCBackground3	Pixel 	copy_bg 
XtNbackground4	XtCBackground4	Pixel 	copy_bg 
XtNbackground5	XtCBackground5	Pixel 	copy_bg 
XtNbackground6	XtCBackground6	Pixel 	copy_bg 
XtNforeground	XtCForeground	Pixel 	XtDefaultForeground 
XtNforeground1	XtCForeground1	Pixel 	copy_fg 
XtNforeground2	XtCForeground2	Pixel 	copy_fg 
XtNforeground3	XtCForeground3	Pixel 	copy_fg 
XtNforeground4	XtCForeground4	Pixel 	copy_fg 
XtNforeground5	XtCForeground5	Pixel 	copy_fg 
XtNforeground6	XtCForeground6	Pixel 	copy_fg 
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNfont1	XtCFont1	FontStruct	copy_font 
XtNfont2	XtCFont2	FontStruct	copy_font 
XtNfont3	XtCFont3	FontStruct	copy_font 
XtNfont4	XtCFont4	FontStruct	copy_font 
XtNfont5	XtCFont5	FontStruct	copy_font 
XtNfont6	XtCFont6	FontStruct	copy_font 
XtNframeWidth	XtCFrameWidth	Dimension 	4 

.TE
.ps +2

.TP
.I "XtNholeRadius"
The size of the menu is determined with \fIwidth\fP and \fIheight\fP. If
they are unequal, the widget tries to set the smallest equal to the
largest, to arrive at a circle. In the middle of the circle is a
`hole' (an inactive area), the size of which is set with \fIholeRadius\fP.
When the \fIwidth\fP is less than the diameter of the hole plus 10, the
width is automatically increased.

	

.hi
Dimension  holeRadius = 8 
.eh

.TP
.I "XtNmenu"
The labels and the corresponding actions are contained in the \fImenu\fP
String. The menu looks like this (example):

	\fIOpen...    -> open()\\n\\\fP

	\fISave       -> save()\\n\\\fP

	\fIOptions    -> set(options)\\n\\\fP

	\fIExit       -> quit(0)\fP

Each newline-seperated item has a label and an action. NB. the current
implementation only supports up to six items, up to 6 actions per item
and up to 6 arguments per action.

	

.hi
String  menu = NULL 
.eh

.TP
.I "XtNbackground1"
The background of the pie segments can be set individually for each
of the segments. If some are left unspecified, the color of core
resource \fIbackground\fP is used. Note that there is currently no support
for stippled backgrounds or background pixmaps.

	

.hi
Pixel  background1 = <CallProc>copy_bg 
.eh

.TP
.I "XtNbackground2"

.hi
Pixel  background2 = <CallProc>copy_bg 
.eh

.TP
.I "XtNbackground3"

.hi
Pixel  background3 = <CallProc>copy_bg 
.eh

.TP
.I "XtNbackground4"

.hi
Pixel  background4 = <CallProc>copy_bg 
.eh

.TP
.I "XtNbackground5"

.hi
Pixel  background5 = <CallProc>copy_bg 
.eh

.TP
.I "XtNbackground6"

.hi
Pixel  background6 = <CallProc>copy_bg 
.eh

.TP
.I "XtNforeground"
The foreground colors are set similarly. The resource \fIforeground\fP
is used for the lines between the segments and the central `hole'.
When the other colors are left unspecified, the \fIforeground\fP color is
used.

	

.hi
Pixel  foreground = <String>XtDefaultForeground 
.eh

.TP
.I "XtNforeground1"

.hi
Pixel  foreground1 = <CallProc>copy_fg 
.eh

.TP
.I "XtNforeground2"

.hi
Pixel  foreground2 = <CallProc>copy_fg 
.eh

.TP
.I "XtNforeground3"

.hi
Pixel  foreground3 = <CallProc>copy_fg 
.eh

.TP
.I "XtNforeground4"

.hi
Pixel  foreground4 = <CallProc>copy_fg 
.eh

.TP
.I "XtNforeground5"

.hi
Pixel  foreground5 = <CallProc>copy_fg 
.eh

.TP
.I "XtNforeground6"

.hi
Pixel  foreground6 = <CallProc>copy_fg 
.eh

.TP
.I "XtNfont"
For the fonts the same technique is used, although in this case
\fIfont\fP is purely used as the default for the other fonts, since
nothing is drawnd directly with it.

	

.hi
<FontStruct> XFontStruct * font = <String>XtDefaultFont 
.eh

.TP
.I "XtNfont1"

.hi
<FontStruct> XFontStruct * font1 = <CallProc>copy_font 
.eh

.TP
.I "XtNfont2"

.hi
<FontStruct> XFontStruct * font2 = <CallProc>copy_font 
.eh

.TP
.I "XtNfont3"

.hi
<FontStruct> XFontStruct * font3 = <CallProc>copy_font 
.eh

.TP
.I "XtNfont4"

.hi
<FontStruct> XFontStruct * font4 = <CallProc>copy_font 
.eh

.TP
.I "XtNfont5"

.hi
<FontStruct> XFontStruct * font5 = <CallProc>copy_font 
.eh

.TP
.I "XtNfont6"

.hi
<FontStruct> XFontStruct * font6 = <CallProc>copy_font 
.eh

.TP
.I "XtNframeWidth"
The widget can be given a 3D shadow with the \fIframeWidth\fP resource.
Note that there is currently no way to influence the colors chosen for
the shadow.

	

.hi
Dimension  frameWidth = 4 
.eh

.TP
.I "XtNborder_width"
Because the widget has its own decoration, the border width is by
default set to 0.

	

.hi
 border_width = 0 
.eh

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Shell
Name	Class	Type	Default
allowShellResize	XtCAllowShellResize	Boolean 	False 
createPopupChildProc	XtCCreatePopupChildProc	XTCreatePopupChildProc 	NULL 
XtNgeometry	XtCGeometry	String 	NULL 
overrideRedirect	XtCOverrideRedirect	Boolean 	False 
popdownCallback	XtCPopdownCallback	Callback	NULL 
popupCallback	XtCPopupCallback	Callback	NULL 
saveUnder	XtCSaveUnder	Boolean 	False 
XtNvisual	XtCVisual	Visual *	CopyFromParent 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Translations"

The only translation is for a mouse button release. The mouse press
would have popped up the widget. The release calls the action
associated with the segment and then pops the widget down again.

.nf
<BtnUp>: select_item() XtMenuPopdown() 
.fi

.hi
.SS "Actions"

.TP
.I "select_item

The \fIselect_item\fP action is normally called when the mouse button is
released. It checks where the mouse is released and if it is inside
the widget and not over the central hole, it calls the action function
that is associated with that segment of the menu.

The \fIaction\fP string is not yet parsed. It is copied to a temporary
string and split into action name and parameter list. The
implementation currently assumes that there are no more than 100
arguments and that the length of the original \fIaction\fP string does not
exceed 500 characters.

.hi

.nf
void select_item($, XEvent* event, String* params, Cardinal* num_params)
{
    int n, i, dx, dy, dist, nparm;
    double angle;

    dx = event->xbutton.x - $width/2;
    dy = $height/2 - event->xbutton.y;
    dist = dx * dx + dy * dy;
    if (dist > $width * $width/4) return;	/* Outside */
    if (dist <= $holeRadius * $holeRadius) return; /* In hole */
    angle = atan2((double) dy, (double) dx) - M_PI/4;
    if (angle < 0.0) angle += 2 * M_PI;
    n = (int) (angle / (2 * M_PI/$nitems));
    for (i = 0; i < $items[n].nactions; i++)
	XtCallActionProc($, $items[n].action[i], event, $items[n].params[i],
			 $items[n].num_params[i]);
}
.fi

.eh

.hi

.hi
.SH "Importss"

.nf

.B incl
 <stdio.h>
.fi

.nf

.B incl
 <ctype.h>
.fi

.nf

.B incl
 <string.h>
.fi

.nf

.B incl
 <math.h>
.fi

.nf

.B incl
 <X11/Xmu/Converters.h>
.fi

.hi

.hi
.SS "Private variables"

The \fImenu\fP string is converted to an array of items and stored in
the private variable \fIitems\fP. Currently there is a hardcoded limit of
6 items, with up to 6 actions, each with up to 6 parameters. The
strings in this array are pointers into the string variable
\fImenu_copy\fP.

	

.nf
 MAXITEMS
.fi

.nf
 MAXACTIONS
.fi

.nf
 MAXPARAMS
.fi

.nf
struct {
	    char *label;
	    int nactions;
	    char *action[MAXACTIONS];
	    int num_params[MAXACTIONS];
	    char *params[MAXACTIONS][MAXPARAMS];
	} LabelAction
.fi

.nf
String  menu_copy
.fi

.nf
LabelAction  items[MAXACTIONS]
.fi

The GCs for each of the segments

	

.nf
GC  gc[MAXITEMS]
.fi

The GC for drawing the lines and the `hole'.

	

.nf
GC  linegc
.fi

The GC for drawing the light parts of the shadow frame:

	

.nf
GC  lightgc
.fi

The GC for drawing the dark parts of the shadow frame:

	

.nf
GC  darkgc
.fi

The number of items in the menu

	

.nf
int  nitems
.fi

The empty stipple that is used to fill the segments with.

	

.nf
Pixmap  emptystip
.fi

A 50 percent stipple that is used for the shadows if there are
insufficient colors.

	

.nf
Pixmap  stip4
.fi

.hi

.hi
.SS "Methods"

The \fIinitialize\fP method tries to set the \fIwidth\fP and \fIheight\fP to
equal values and checks if the \fIwidth\fP is larger than the central
hole. It creates six GCs, one for each segment. The \fImenu\fP is
translated and stored in the \fIitems\fP array with the help of the
\fIparse_menu\fP function.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    int i;

    if ($width < $holeRadius + 10)
	$width = $holeRadius + 10;
    if ($height < $width)
	$height = $width;
    else if ($width < $height)
	$width = $height;

    $emptystip = XCreateBitmapFromData
	(XtDisplay($), RootWindowOfScreen(XtScreen($)), emptybm_bits,
	 emptybm_width, emptybm_height);
    $stip4 = XCreateBitmapFromData
	(XtDisplay($), RootWindowOfScreen(XtScreen($)), stip4_bits,
	 stip4_width, stip4_height);

    $lightgc = NULL; create_lightgc($);
    $darkgc = NULL; create_darkgc($);
    $linegc = NULL; create_linegc($);

    $gc[0] = NULL; create_gc($, $gc[0], $font1, $background1, $foreground1);
    $gc[1] = NULL; create_gc($, $gc[1], $font2, $background2, $foreground2);
    $gc[2] = NULL; create_gc($, $gc[2], $font3, $background3, $foreground3);
    $gc[3] = NULL; create_gc($, $gc[3], $font4, $background4, $foreground4);
    $gc[4] = NULL; create_gc($, $gc[4], $font5, $background5, $foreground5);
    $gc[5] = NULL; create_gc($, $gc[5], $font6, $background6, $foreground6);

    $menu = XtNewString($menu);
    $menu_copy = XtNewString($menu);
    parse_menu($menu_copy, $items, $nitems);
}
.fi

The \fIrealize\fP methods first calls the \fIrealize\fP method of the
superclass to create a window and then uses \fIXmuReshapeWidget\fP to
change the shape of the widget to a circle.

.nf
realize($, XtValueMask * mask, XSetWindowAttributes * attributes)
{
    #realize($, mask, attributes);
    (void) XmuReshapeWidget($, XmuShapeEllipse, -1, -1);
}
.fi

The \fIexpose\fP methods draws each of the pie segments. It counts the
number of items and then draws each of the segments.  \fIangle\fP is the
angle of each of the segments in 64th of a degree. \fIangle1\fP is the
starting angle of the segment. Segments are drawn starting at 45
degrees and drawn counterclockwise. 0 Degrees is 3 o'clock.
The position of the label is in the middle of its segment.

.nf
expose($, XEvent * event, Region  region)
{
    int i, x, y, len, angle, angle1;
    XFontStruct *fn;
    double a;

    if (! XtIsRealized($)) return;

    /*
     * Draw the segments and the labels
     */
    angle = 360 * 64/$nitems;
    for (i = 0, angle1 = 45 * 64; i < $nitems; i++, angle1 += angle) {
	XFillArc(XtDisplay($), XtWindow($), $gc[i], 0, 0, $width, $height,
		 angle1, angle);
	fn = (i == 0 ? $font1
	      : (i == 1 ? $font2
		 : (i == 2 ? $font3
		    : (i == 3 ? $font4
		       : (i == 4 ? $font5
			  : $font6)))));
	len = strlen($items[i].label);
	a = (angle1 + angle/2) * 2 * M_PI/360/64;
	x = $width/2 - XTextWidth(fn, $items[i].label, len)/2
	    + (int) (cos(a) * $width * 0.3);
	y = $height/2 - (fn->ascent + fn->descent)/2 + fn->ascent
	    - (int) (sin(a) * $height * 0.3);
	XDrawImageString(XtDisplay($), XtWindow($), $gc[i], x, y,
		    $items[i].label, len);
    }
    /*
     * Draw central `hole'
     */
    XFillArc(XtDisplay($), XtWindow($), $linegc, $width/2 - $holeRadius,
	     $height/2 - $holeRadius, 2 * $holeRadius, 2 * $holeRadius,
	     0, 360 * 64);

    /*
     * Draw lines separating the segments
     */
    for (i = 0, angle1 = 45 * 64; i < $nitems; i++, angle1 += angle) {
	a = angle1 * 2 * M_PI/360/64;
	x = (int) (cos(a) * $width/2) + $width/2;
	y = $height/2 - (int) (sin(a) * $height/2);
	XDrawLine(XtDisplay($), XtWindow($), $linegc, $width/2, $height/2,
		  x, y);
    }
    /*
     * Draw shadow border
     */
    XDrawArc(XtDisplay($), XtWindow($), $lightgc, 0, 0, $width, $height,
	     45 * 64, 180 * 64);
    XDrawArc(XtDisplay($), XtWindow($), $darkgc, 0, 0, $width, $height,
	     225 * 64, 180 * 64);
}
.fi

There should be a \fIset_values\fP method here...

The \fIdestroy\fP method frees memory allocated by the widget.

.nf
destroy($)
{
    int i;

    for (i = 0; i < MAXITEMS; i++)
	XtReleaseGC($, $gc[i]);
    XFreePixmap(XtDisplay($), $emptystip);
    XtFree($menu_copy);
    XtFree($menu);
}
.fi

.hi

.hi
.SH "Utilities"

The resource default proc \fIcopy_bg\fP copies the value of the
\fIbackground_pixel\fP resource to the specified resource (\fIbackground2\fP
to \fIbackground6\fP).

.nf
copy_bg($, int  offset, XrmValue * value)
{
    value->addr = (XtPointer) $background_pixel;
}
.fi

The \fIcopy_fg\fP function is similar, but it copies the \fIforeground\fP
resource.

.nf
copy_fg($, int  offset, XrmValue * value)
{
    value->addr = (XtPointer) $foreground;
}
.fi

The \fIcopy_font\fP function is similar, but it copies the \fIfont\fP
resource.

.nf
copy_font($, int  offset, XrmValue * value)
{
    value->addr = (XtPointer) $font;
}
.fi

The empty bitmap that is used a a stipple is defined here. A Pixmap
is created from it in the \fIinitialize\fP method. The stip4 bitmap is a
50 percent bitmaps used for the shadows when there are insufficient
colors.

	

\fBdef\fP emptybm_width = 1 

\fBdef\fP emptybm_height = 1 

.nf
char  emptybm_bits[] = { 0x00 }
.fi

\fBdef\fP stip4_width = 2 

\fBdef\fP stip4_height = 2 

.nf
char  stip4_bits[] = { 0x01, 0x02 }
.fi

Create a new GC for one of the segments, release the previous one.
The fill style is set to \fIFillOpaqueStippled\fP with a stipple without
any foreground. This is done so that the same GC can be used both to
draw the text with the foreground color and to fill the segment with
the background color.

.nf
create_gc($, GC * gc, XFontStruct * fn, Pixel  bg, Pixel  fg)
{
    XGCValues values;

    if (*gc != NULL) XtReleaseGC($, *gc);
    values.font = fn->fid;
    values.background = bg;
    values.foreground = fg;
    values.fill_style = FillOpaqueStippled;
    values.stipple = $emptystip;
    *gc = XtGetGC($, GCFont | GCBackground | GCForeground | GCFillStyle
		  | GCStipple, values);
}
.fi

The \fIlinegc\fP private variable holds the GC that is used for drawing
the lines between the segments and the central `hole'.

.nf
create_linegc($)
{
    XGCValues values;

    if ($linegc != NULL) XtReleaseGC($, $linegc);
    values.background = $background_pixel;
    values.foreground = $foreground;
    values.line_width = 2;
    $linegc = XtGetGC($, GCBackground | GCForeground | GCLineWidth, values);
}
.fi

The \fIcreate_darkgc\fP function creates the GC for the dark parts of
the shadow frame.

.nf
create_darkgc($)
{
    XtGCMask mask;
    XGCValues values;

    if ($darkgc != NULL) XtReleaseGC($, $darkgc);
    if (DefaultDepthOfScreen(XtScreen($)) > 4
	 choose_color($, 0.5, $background_pixel, values.foreground)) {
	mask = GCForeground;
    } else {
	mask = GCFillStyle | GCBackground | GCForeground | GCStipple;
	values.fill_style = FillOpaqueStippled;
	values.background = $background_pixel;
	values.foreground = WhitePixelOfScreen(XtScreen($));
	values.stipple = $stip4;
    }
    mask |= GCLineWidth;
    values.line_width = $frameWidth;
    $darkgc = XtGetGC($, mask, values);
}
.fi

\fIcreate_lightgc\fP does the same for the light parts of the shadow frame.

.nf
create_lightgc($)
{
    XtGCMask mask;
    XGCValues values;

    if ($lightgc != NULL) XtReleaseGC($, $lightgc);
    if (DefaultDepthOfScreen(XtScreen($)) > 4
	 choose_color($, 1.35, $background_pixel, values.foreground)) {
	mask = GCForeground;
    } else {
	mask = GCFillStyle | GCBackground | GCForeground | GCStipple;
	values.fill_style = FillOpaqueStippled;
	values.background = $background_pixel;
	values.foreground = WhitePixelOfScreen(XtScreen($));
	values.stipple = $stip4;
    }
    mask |= GCLineWidth;
    values.line_width = $frameWidth;
    $lightgc = XtGetGC($, mask, values);
}
.fi

The function \fItrim\fP is called by the type converter to remove
leading and trailing blanks from a string.

.nf
Boolean  trim(String  s)
{
    int i, j;

    for (i = strlen(s); i > 0  isspace(s[i-1]); i--) ;
    s[i] = '\\0';
    for (i = 0; isspace(s[i]); i++) ;
    if (i != 0) {
	for (j = 0; s[i]; i++, j++) s[j] = s[i];
	s[j] = '\\0';
    }
    return s[0] != '\\0';
}
.fi

The function \fIparse_menu\fP splits the string \fImenu\fP into items by
inserting NUL bytes and then splits each of the items into a label
part and an action part. The action is further subdivided into a list
of action functions, and each action function can have a list of
arguments.

When the function is done, the contents of the string \fImenu\fP have been
changed.

In the algorithm below, \fImenu\fP = start of current item; \fIp\fP = start of
the next item (i.e., immediately after the next newline); \fIq\fP = start
of current action; \fIr\fP = start of next action; \fIs\fP = start of current
parameter; \fIt\fP = start of next parameter.

.nf
parse_menu(String  menu, LabelAction * items, int * nitems)
{
    int n, act, parm;
    String p, q, r, s, t;

    if (! menu) {
	*nitems = 0;
	return;
    }

    /* Loop over all items */

    for (n = 0; menu  n < MAXITEMS; n++) {
	if ((p = strchr(menu, '\\n'))) *(p++) = '\\0'; /* Mark end of item */
	if ((q = strstr(menu, "->"))) *q = '\\0', q += 2; /* Start of actions */

	/* Loop over all actions for this item */

	for (act = 0; q  act < MAXACTIONS; act++) {
	    if ((r = strchr(q, ')'))) *(r++) = '\\0'; /* End of action */
	    if ((s = strchr(q, '('))) *(s++) = '\\0'; /* Start of params */

	    /* Loop over all parameters for this action */

	    for (parm = 0; s  parm < MAXPARAMS; parm++) {
		if ((t = strchr(s, ','))) *(t++) = '\\0'; /* End of param */
		if (! trim(s)) parm--;		/* Remove empty param */
		else items[n].params[act][parm] = s;
		s = t;
	    }
	    items[n].num_params[act] = parm;

	    if (! trim(q)) act--;		/* Remove empty action */
	    else items[n].action[act] = q;
	    q = r;				/* Start next action loop */
	}
	items[n].nactions = act;

	if (! trim(menu)) n--;			/* Remove empty item */
	else items[n].label = menu;
	menu = p;				/* Start next item loop */
    }
    *nitems = n;
}
.fi

.hi
