.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfOptionButton
.SH DESCRIPTION
The option button is very much like a PullDown button, except that
the label of the button is automatically set to the label of the last
selected menu item.

There are two ways to specify the menu: with the \fIpopup\fP
resource, or with the \fImenu\fP resource.
When the \fIpopup\fP resource is used, the option button cannot update
its own label, so it becomes the responsibility of the application
that created the pop up widget to set the label.

For more explanation of \fImenu\fP and \fIpopup\fP, see the XfwfPullDown
class.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfOptionButton
Name	Class	Type	Default

.TE
.ps +2

.TP
.I "XtNframeWidth"
The frame width is again set to a default of 2 pixels.

	

.hi
 frameWidth = 2 
.eh

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfPullDown
Name	Class	Type	Default
XtNpopup	XtCPopup	Widget 	NULL 
XtNmenu	XtCMenu	String 	NULL 
XtNcascaded	XtCCascaded	Boolean 	False 
XtNhotkey	XtCHotkey	String 	NULL 
XtNmenuCursor	XtCMenuCursor	Cursor 	"arrow"
XtNprepare	XtCPrepare	Callback	NULL 
XtNchangeSelection	XtCChangeSelection	Callback	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfButton
Name	Class	Type	Default
XtNactivate	XtCActivate	Callback	NULL 
XtNenter	XtCEnter	Callback	NULL 
XtNleave	XtCLeave	Callback	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfLabel
Name	Class	Type	Default
XtNlabel	XtCLabel	String 	NULL 
XtNtablist	XtCTablist	String 	NULL 
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNforeground	XtCForeground	Pixel 	XtDefaultForeground 
XtNhlForeground	XtCHlForeground	Pixel 	XtDefaultForeground 
XtNalignment	XtCAlignment	Alignment 	0 
XtNtopMargin	XtCTopMargin	Dimension 	2 
XtNbottomMargin	XtCBottomMargin	Dimension 	2 
XtNleftMargin	XtCLeftMargin	Dimension 	2 
XtNrightMargin	XtCRightMargin	Dimension 	2 
XtNshrinkToFit	XtCShrinkToFit	Boolean 	False 
XtNrvStart	XtCRvStart	Int 	0 
XtNrvLength	XtCRvLength	Int 	0 
XtNhlStart	XtCHlStart	Int 	0 
XtNhlLength	XtCHlLength	Int 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Translations"

Since wbuild cannot yet inherit translations, they must be
given again.

	

.nf
<Btn1Down>: prepare() open_menu() 
.fi

.nf
Button1<Enter>: prepare() open_menu() 
.fi

.nf
<Key>Return: prepare() open_menu() 
.fi

.nf
<Btn1Up>: popdown_maybe() 
.fi

.hi
.SH "Importss"

.nf

.B incl
 <stdio.h>
.fi

.nf

.B incl
 <Xfwf/TextMenu.h>
.fi

.hi

.hi
.SS "Methods"

The \fIinitialize\fP method adds a callback to the menu, but only if it
has been created in the PullDown widget.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    if ($own_popup)
	XtAddCallback($popup, XtNactivate, set_label_cb, $);
}
.fi

Similarly, the \fIset_values\fP methods adds the same callback if a new
menu has been created in the \fIset_values\fP method of XfwfPullDown.

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
    if ($old$popup != $popup  $own_popup)
	XtAddCallback($popup, XtNactivate, set_label_cb, $);
    return False;
}
.fi

.hi

.hi
.SH "Utilities"

The \fIset_label_cb\fP routine is called when an option from the options
menu is selected. It will set the label of the option button.

.nf
set_label_cb(Widget  menu, XtPointer  client_data, XtPointer  call_data)
{
    Widget $ = (Widget) client_data;
    XfwfTextMenuData *data = (XfwfTextMenuData *) call_data;

    if ($label  strcmp($label, data->label) == 0) return;
    XtVaSetValues($, XtNlabel, data->label, NULL);
}
.fi

.hi
