.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfEntry
.SH DESCRIPTION
The \fIXfwfEntry\fP widget is used to read a single line of text.
You can restrict the total length of the input string using the 
variable \fImax\fP . The default value is 0 (characters).
Using the \fIvalid\fP resource it is possible to control the users input.
The user can only enter the specified characters.
Setting this ressource to NULL (default) let the users imput all
characters between 0x20 (SPACE) and 0xff.
The \fIecho\fP resource enables/disables displaying of the entered text.
You can use this for things like password boxes.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfEntry
Name	Class	Type	Default
XtNtext	XtCText	String 	NULL 
XtNvalid	XtCValid	String 	NULL 
XtNmax	XtCMax	int 	0 
XtNecho	XtCEcho	Boolean 	True 
XtNactivate	XtCActivate	Callback	NULL 
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNforeground	XtCForeground	Pixel 	XtDefaultForeground 

.TE
.ps +2

.TP
.I "XtNtext"
The variable \fItext\fP holds the string modified by the user.

	

.hi
String  text = NULL 
.eh

.TP
.I "XtNvalid"
Using the \fIvalid\fP ressource it is possible to limit the characters the user 
is allowed to enter. With a value of NULL the allowed characters ranges
from 0x20 (SPACE) to 0xff.

	

.hi
String  valid = NULL 
.eh

.TP
.I "XtNmax"
The \fImax\fP ressource holds the number of maximal allowed characters.
It defaults to 0.

	

.hi
int  max = 0 
.eh

.TP
.I "XtNecho"
The \fIecho\fP flag enables/disables displaying of the entered text.

	

.hi
Boolean  echo = True 
.eh

.TP
.I "XtNactivate"
The \fIactivate\fP callback is called if the activate action is executed,
bound by default to the <Return> key. entered text is passed in the 
\fIcall_data\fP argument.

	

.hi
<Callback> XtCallbackList  activate = NULL 
.eh

.TP
.I "XtNfont"
The text is drawn using the font given in the \fIfont\fP resource.

	

.hi
<FontStruct> XFontStruct * font = <String>XtDefaultFont 
.eh

.TP
.I "XtNforeground"
The \fIforeground\fP resource specifies the color used for drawing the text.

	

.hi
Pixel  foreground = <String>XtDefaultForeground 
.eh

.TP
.I "XtNcursor"
The \fIcursor\fP ressource is by default a vertical bar.

	

.hi
 cursor = <String>"xterm"
.eh

.TP
.I "XtNtraversalOn"
this widget receives keyboard events, \fItraversalOn\fP is set to \fITrue\fP.

	

.hi
 traversalOn = True 
.eh

.TP
.I "XtNframeWidth"
The default frame width is set to 2

	

.hi
 frameWidth = 2 
.eh

.TP
.I "XtNframeType"
the \fIframeType\fP resource defaults to \fI"sunken"\fP.

	

.hi
 frameType = XfwfSunken 
.eh

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Exports"

.nf
void  XfwfEntryClear( $)
.fi

.hi
{
	Position x,y;
	Dimension h,w;
	
	if($text != NULL)
	{
		get_pos($,x,y);
		w=++$text_len*$font->min_bounds.width;
		h=$font->ascent+$font->descent;
#ifdef DEBUG		
		fprintf(stderr,"clear(%s,%d) %dx%d @%d,%d,[%dx%d]\\n",$text,$text_len,\\
				w,h,x,y,$width,$height);
#endif		
		$text_pos=$text_len=0;
		$text[0]='\\0';
		XClearArea(XtDisplay($),XtWindow($),x,y-$font->ascent,w,h,False);
		if($traversal_focus == True)
			set_cursor($,True);
	}
}
.eh

.SS "Translations"

.nf
<FocusIn>: focusIn() mouse_in() 
.fi

.nf
<FocusOut>: mouse_out() focusOut() 
.fi

.nf
<Btn1Down>: traverseCurrent() mclick() 
.fi

.nf
<Key>Up: traverseUp() 
.fi

.nf
<Key>Down: traverseDown() 
.fi

.nf
Shift<Key>Tab: traversePrev() 
.fi

.nf
~Shift<Key>Tab: traverseNext() 
.fi

.nf
<Key>BackSpace: backspace() 
.fi

.nf
<Key>Right: right() 
.fi

.nf
<Key>Left: left() 
.fi

.nf
<Key>Home: bol() 
.fi

.nf
<Key>End: eol() 
.fi

.nf
Ctrl<Key>a: bol() 
.fi

.nf
Ctrl<Key>d: del_char() 
.fi

.nf
Ctrl<Key>e: eol() 
.fi

.nf
Ctrl<Key>b: left() 
.fi

.nf
Ctrl<Key>f: right() 
.fi

.nf
Ctrl<Key>h: backspace() 
.fi

.nf
Ctrl<Key>k: kill() 
.fi

.nf
Ctrl<Key>l: redraw() 
.fi

.nf
<Key>Return: activate() 
.fi

.nf
~Ctrl<Key>: self_insert() 
.fi

.hi
.SS "Actions"

.TP
.I "activate

The \fIactivate\fP action calls the \fIactivate\fP callback with the current
\fItext\fP as \fIcall_data\fP.

.hi

.nf
void activate($, XEvent* event, String* params, Cardinal* num_params)
{
    XtCallCallbackList($, $activate, $text);
}
.fi

.eh

.TP
.I "self_insert

.hi

.nf
void self_insert($, XEvent* event, String* params, Cardinal* num_params)
{
    KeySym keysym;
    int n,k,i;
    char buf[100];

    if (event->type != KeyPress  event->type != KeyRelease) 
	{
		XtWarning("action <self_insert> can only handle keyboard events");
		return;
    }

    n = XLookupString(event->xkey, buf, sizeof(buf), keysym, $compose_stat);
	set_cursor($,False);
	for(k=i=0;i < n;i++)
		k+=insert_char($,buf[i]);
	set_text($,$text_pos-k);
	set_cursor($,True);

#ifdef DEBUG	
	fprintf(stderr,"self_insert()\\t%d ->%s<\\n",keysym,$text);
#endif	
}
.fi

.eh

.TP
.I "del_char

.hi

.nf
void del_char($, XEvent* event, String* params, Cardinal* num_params)
{
    int i;

	if($text_pos < $text_len)
	{
		set_cursor($,False);
		$text_len--;
		for(i=$text_pos;i < $text_len;)
			$text[i]=$text[++i];
		$text[$text_len]='\\0';
		if($text_pos > $text_len)
			$text_pos=$text_len;
		set_text($,$text_pos);
		set_cursor($,True);
	}	
}
.fi

.eh

.TP
.I "backspace

.hi

.nf
void backspace($, XEvent* event, String* params, Cardinal* num_params)
{
    int i;

    if($text_len > 0  $text_pos > 0)
	{
		set_cursor($,False);
		for(i=$text_pos-1;i < $text_len;)
			$text[i]=$text[++i];
		$text_len--;
		$text_pos--;
		set_text($,$text_pos);
		set_cursor($,True);
	}
}
.fi

.eh

.TP
.I "kill

.hi

.nf
void kill($, XEvent* event, String* params, Cardinal* num_params)
{
	Position x,y;
	Dimension w,h;
	
	if($text_pos < $text_len)
	{
		get_pos($,x,y);
		x+=($text_pos*$font->min_bounds.width);
		w=(1+$text_len-$text_pos)*$font->min_bounds.width;
		h=$font->ascent+$font->descent;
		
#ifdef DBEUG		
		fprintf(stderr,"kill(%s,%d,%d) %dx%d @%d,%d\\n",$text,$text_pos,\\
				$text_len,w,h,x,y);
#endif
		
		XClearArea(XtDisplay($),XtWindow($),x,y-$font->ascent,w,h,False);
		$text[$text_pos]='\\0';
		$text_len=$text_pos;
		set_text($,$text_pos);
		set_cursor($,True);
	}
}
.fi

.eh

.TP
.I "redraw

.hi

.nf
void redraw($, XEvent* event, String* params, Cardinal* num_params)
{
	set_text($,0);
	set_cursor($,True);
}
.fi

.eh

.TP
.I "mclick

.hi

.nf
void mclick($, XEvent* event, String* params, Cardinal* num_params)
{
	Position x,y;
	XButtonEvent xbutton;
	
	if(event->type != ButtonPress)
	{
		fprintf(stderr,"mclick called with invalid event type\\n");
		XBell(XtDisplay($),100);
		return ;
	}
	xbutton= event->xbutton;
	set_cursor($,False);
	get_pos($,x,y);

	$text_pos=(xbutton.x-x)/$font->min_bounds.width;
	if($text_pos > $text_len)
		$text_pos=$text_len;
	set_cursor($,True);

#ifdef DEBUG
	fprintf(stderr,"mclick @%d,%d -> %d\\n",xbutton.x,xbutton.y,$text_pos);
#endif	
}
.fi

.eh

.TP
.I "mouse_in

.hi

.nf
void mouse_in($, XEvent* event, String* params, Cardinal* num_params)
{
	set_cursor($,True);	
}
.fi

.eh

.TP
.I "mouse_out

.hi

.nf
void mouse_out($, XEvent* event, String* params, Cardinal* num_params)
{
	set_cursor($,False);	
}
.fi

.eh

.TP
.I "bol

.hi

.nf
void bol($, XEvent* event, String* params, Cardinal* num_params)
{
	if ($text_pos != 0)
	{
		set_cursor($,False);		
		$text_pos = 0;
		set_cursor($,True);		
	}
}
.fi

.eh

.TP
.I "eol

.hi

.nf
void eol($, XEvent* event, String* params, Cardinal* num_params)
{
	if ($text_pos < $text_len)
	{
		set_cursor($,False);
		$text_pos = $text_len;
		set_cursor($,True);
	}
}
.fi

.eh

.TP
.I "left

.hi

.nf
void left($, XEvent* event, String* params, Cardinal* num_params)
{
	if($text_pos > 0)
	{
		set_cursor($,False);
		$text_pos--;
		set_cursor($,True);
	}
}
.fi

.eh

.TP
.I "right

.hi

.nf
void right($, XEvent* event, String* params, Cardinal* num_params)
{
	if($text_pos < $text_len)
	{
		set_cursor($,False);
		$text_pos++;
		set_cursor($,True);
	}
}
.fi

.eh

.hi

.hi
.SH "Importss"

.nf

.B incl
 <ctype.h>
.fi

.nf

.B incl
 <stdio.h>
.fi

.nf

.B incl
 <string.h>
.fi

.nf

.B incl
 <X11/Xatom.h>
.fi

.nf

.B incl
 <X11/Xmu/Atoms.h>
.fi

.hi

.hi
.SS "Private variables"

The current length of the text

	

.nf
int  text_len
.fi

current cursor position	

	

.nf
int  text_pos
.fi

The \fItext_start\fP ressource indicates the first displayed character , 
if the whole exceeds the width . needed for horizontal scrolling.

	

.nf
int  text_start
.fi

The maximum number of chars displayed at once is stored in \fItext_width\fP

	

.nf
int  text_width
.fi

Between keypresses, the \fIXComposeStatus\fP is retained.

	

.nf
XComposeStatus  compose_stat
.fi

For normal text, ngc is used

	

.nf
GC  ngc
.fi

For drawing text in reverse color (like the cursor) rgc is used

	

.nf
GC  rgc
.fi

should i use a third gc for drawing highlighted text (selected ?)
a grayed one or a stippled ?

.hi

.hi
.SS "Methods"

The \fIinitialize\fP method sets the private variables to default values

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
	String tmp;
	int i;

#ifdef DEBUG	
	fprintf(stderr,"init(%s) [%s,%d,%s]\\n",XtName($),$valid,$max,\\
			$echo ? "true" : "false");
#endif
	
	$text_pos=$text_len=0;

	$ngc=$rgc=NULL;
	make_gc($);
	
	if($valid != NULL)
		$valid=XtNewString($valid);
	tmp=XtMalloc((1+$max)*sizeof(char));
	tmp[0]='\\0';

	if($text != NULL)
	{
		for(i=0;$text[i]  i < $max;i++)
			tmp[i]=$text[i];
		tmp[i]='\\0';
		$text_pos=$text_len=i;
	}
	$text=tmp;
#ifdef DEBUG	
	fprintf(stderr,"entry.init(%s)\\n",$text);
#endif	
}
.fi

The \fIset_values\fP method copies all changed string ressources 

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
	String tmp;
	int i;

#ifdef DEBUG	
	fprintf(stderr,"set_values(%s) '%s'\\n",XtName($),$text);
#endif
	
	if($old$text != $text)
	{
		XtFree($old$text);
		tmp=XtMalloc((1+$max)*sizeof(char));
		for(i=0;$text[i]  i < $max;i++)
			tmp[i]=$text[i];
		tmp[i]='\\0';
		$text_pos=$text_len=i;
		$text=tmp;
	}

	return True;	
}
.fi

The \fIexpose\fP method is called if the widget was overlapped and became
	visible again
	

.nf
expose($, XEvent * event, Region  region)
{
	if(! XtIsRealized($))
		return ;
	
	#expose($,event,region);
	set_text($,0);
	if($traversal_focus == True)
		set_cursor($,True);
	
#ifdef DEBUG	
	fprintf(stderr,"expose(%s)\\t,%s,len %d, max %d, pos %d\\n",XtName($),\\
				$text,$text_len,$max,$text_pos);
#endif	
}
.fi

.hi

.hi
.SH "Utilities"

create the GC's used for drawing text

.nf
make_gc($)
{
	XtGCMask mask;
	XGCValues values;

	if($ngc != NULL)				/* GC for normal text */
		XtReleaseGC($,$ngc);

	values.foreground=$foreground;
	values.background=$background_pixel;
	values.font=$font->fid;
	mask=GCFont|GCBackground|GCForeground;
	$ngc=XtGetGC($,mask,values);

	if($rgc != NULL)				/* GC for reverse text */
		XtReleaseGC($,$rgc);

	values.foreground=$background_pixel;	
	values.background=$foreground;			
	values.font=$font->fid;
	mask=GCFont|GCBackground|GCForeground;
	$rgc=XtGetGC($,mask,values);

}
.fi

Get the Position of the first char

.nf
get_pos($, Position * x, Position * y)
{
	Dimension baseline;
	XRectangle rect;
	
	baseline = $font->ascent + $font->descent;
	$compute_inside($, rect.x, rect.y, rect.width, rect.height);

	rect.x += 2;	rect.width -= 4;
	rect.y += 2;	rect.height -= 4;

	*y = rect.y + (rect.height - baseline)/2 + $font->ascent;
	*x = rect.x;
}
.fi

.nf
set_cursor($, Bool  flag)
{
	Position x,y;
	Dimension pos,w;
	GC gc;

	/* cursor position is always 0 if echo disabled */
	pos = ($echo == False ? 0 : $text_pos);
	
	gc = (flag == True ? $rgc : $ngc);
	get_pos($,x,y);
	w=pos*$font->min_bounds.width;
					  
	if($text_pos == $text_len || $echo == False)
		XDrawImageString(XtDisplay($),XtWindow($),gc,x+w,y," ",1);
	else
		XDrawImageString(XtDisplay($),XtWindow($),gc,x+w,y,$text+$text_pos,1);
}
.fi

.nf
set_text($, int  pos)
{
	Position x,y;
	Dimension w;
	
	get_pos($,x,y);

	w = ($echo == True ? $text_len : 0)*$font->min_bounds.width;
	XDrawImageString(XtDisplay($),XtWindow($),$ngc,x+w,y," ",1);

	w=pos*$font->min_bounds.width;
	
#ifdef DEBUG 	
	fprintf(stderr,"set_text(%s,%d) @%d,%d\\n",$text+pos,$text_len-pos,x+w,y);
#endif
	
	if($echo == True)
	{
		XDrawImageString(XtDisplay($),XtWindow($),$ngc,x+w,y,$text+pos,
						 $text_len-pos);
	}
}
.fi

.nf
int  insert_char($, int  c)
{
	int i,n=0;
	Boolean flag=False;

	if($text_len == $max)
	{
		XBell(XtDisplay($),100);
		return n;
	}
	
	if($valid == NULL)			/* all printable chars are allowed */
	{
		if(' ' <= c  c <= '~')
			flag=True;
	}
	else					/* check if c is a valid char */
	{
		for(i=0;$valid[i];i++)
			if(c == $valid[i])
			{
				flag=True;
				break ;
			}
	}

	if(flag == True)
	{
		$text_len++;
		for(i=$text_len;i > $text_pos;)
			$text[i]=$text[--i];
		$text[$text_pos++]=c;
		n++;
	}
	return n;
}
.fi

.hi
