/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* ToggleB.C,v 1.3 1994/10/27 23:26:59 pgw Exp */
#include <Xarm/ToggleB.h>
/* ToggleButtonClass Members */
/* callbacks */
void
ToggleButtonClass::armCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNarmCallback,funcp,data);
}

void
ToggleButtonClass::disarmCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNdisarmCallback,funcp,data);
}

void
ToggleButtonClass::valueChangedCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNvalueChangedCallback,funcp,data);
}

/* convenience routines */
Boolean 
ToggleButtonClass::getState()
{
   return XmToggleButtonGetState(widget());
}

void 
ToggleButtonClass::setState(Boolean state, Boolean notify)
{
   XmToggleButtonSetState(widget(), state, notify);
}

/* resources */
void
ToggleButtonClass::fillOnSelect(Boolean b)
{
   XtVaSetValues(widget(), XmNfillOnSelect, b, NULL);
}

Boolean
ToggleButtonClass::fillOnSelect()
{
   Boolean b;
   XtVaGetValues(widget(), XmNfillOnSelect, &b, NULL);
   return b;
}

void
ToggleButtonClass::indicatorOn(Boolean b)
{
   XtVaSetValues(widget(), XmNindicatorOn, b, NULL);
}

Boolean
ToggleButtonClass::indicatorOn()
{
   Boolean b;
   XtVaGetValues(widget(), XmNindicatorOn, &b, NULL);
   return b;
}

void
ToggleButtonClass::indicatorSize(Dimension d)
{
   XtVaSetValues(widget(), XmNindicatorSize, d, NULL);
}

Dimension
ToggleButtonClass::indicatorSize()
{
   Dimension d;
   XtVaGetValues(widget(), XmNindicatorSize, &d, NULL);
   return d;
}

void
ToggleButtonClass::indicatorType(unsigned char c)
{
   XtVaSetValues(widget(), XmNindicatorType, c, NULL);
}

unsigned char
ToggleButtonClass::indicatorType()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNindicatorType, &c, NULL);
   return c;
}

void
ToggleButtonClass::selectColor(Pixel p)
{
   XtVaSetValues(widget(), XmNselectColor, p, NULL);
}

Pixel
ToggleButtonClass::selectColor()
{
   Pixel p;
   XtVaGetValues(widget(), XmNselectColor, &p, NULL);
   return p;
}

void
ToggleButtonClass::selectInsensitivePixmap(Pixmap p)
{
   XtVaSetValues(widget(), XmNselectInsensitivePixmap, p, NULL);
}

Pixmap
ToggleButtonClass::selectInsensitivePixmap()
{
   Pixmap p;
   XtVaGetValues(widget(), XmNselectInsensitivePixmap, &p, NULL);
   return p;
}

void
ToggleButtonClass::set(Boolean b)
{
   XtVaSetValues(widget(), XmNset, b, NULL);
}

Boolean
ToggleButtonClass::set()
{
   Boolean b;
   XtVaGetValues(widget(), XmNset, &b, NULL);
   return b;
}

void
ToggleButtonClass::spacing(Dimension d)
{
   XtVaSetValues(widget(), XmNspacing, d, NULL);
}

Dimension
ToggleButtonClass::spacing()
{
   Dimension d;
   XtVaGetValues(widget(), XmNspacing, &d, NULL);
   return d;
}

void
ToggleButtonClass::visibleWhenOff(Boolean b)
{
   XtVaSetValues(widget(), XmNvisibleWhenOff, b, NULL);
}

Boolean 
ToggleButtonClass::visibleWhenOff()
{
   Boolean b;
   XtVaGetValues(widget(), XmNvisibleWhenOff, &b, NULL);
   return b;
}

/* constructors */
ToggleButton::ToggleButton(Widget parent, char *str, KeySym mn,
                           String acc, char *accText) 
{
   Widget w = XtVaCreateWidget("XmToggleButton",
                               xmToggleButtonWidgetClass,
                               parent,
                               NULL);
   widget(w);
   labelString(str);
   manage();

   alignment(XmALIGNMENT_BEGINNING);
   if(mn != 0) mnemonic(mn);
   if(acc) accelerator(acc);
   if(accText) acceleratorText(accText);
}

ToggleButton::ToggleButton(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateToggleButton(parent, "XmToggleButton", arglist, cnt);
   widget(w);
   manage();
}

