/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* TextF.C,v 1.4 1994/10/27 23:26:58 pgw Exp */
#include <Xarm/TextF.h>
/* TextFieldClass member functions */

/* callbacks */
void 
TextFieldClass::activateCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNactivateCallback,funcp,data);
}

void 
TextFieldClass::focusCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNfocusCallback,funcp,data);
}

void 
TextFieldClass::gainPrimaryCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNgainPrimaryCallback,funcp,data);
}

void 
TextFieldClass::losingFocusCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNlosingFocusCallback,funcp,data);
}

void 
TextFieldClass::losePrimaryCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNlosePrimaryCallback,funcp,data);
}

void 
TextFieldClass::modifyVerifyCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNmodifyVerifyCallback,funcp,data);
}

void 
TextFieldClass::modifyVerifyCallbackWcs(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNmodifyVerifyCallbackWcs,funcp,data);
}

void 
TextFieldClass::motionVerifyCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNmotionVerifyCallback,funcp,data);
}

void 
TextFieldClass::valueChangedCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNvalueChangedCallback,funcp,data);
}

/* convenience routines */

void
TextFieldClass::clearSelection(Time time)
{
   XmTextFieldClearSelection(widget(), time);
}

Boolean
TextFieldClass::copy(Time time)
{
   return XmTextFieldCopy(widget(),time);
}

Boolean
TextFieldClass::cut(Time time)
{
   return XmTextFieldCut(widget(),time);
}

int
TextFieldClass::getBaseline()
{
   return XmTextFieldGetBaseline(widget());
}

XmTextPosition
TextFieldClass::getCursorPosition()
{
   return XmTextFieldGetCursorPosition(widget());
}

Boolean
TextFieldClass::getEditable()
{
   return XmTextFieldGetEditable(widget());
}

XmTextPosition
TextFieldClass::getInsertionPosition()
{
   return XmTextFieldGetInsertionPosition(widget());
}

XmTextPosition
TextFieldClass::getLastPosition()
{
   return XmTextFieldGetLastPosition(widget());
}

int
TextFieldClass::getMaxLength()
{
   return XmTextFieldGetMaxLength(widget());
}

char *
TextFieldClass::getSelection()
{
   return XmTextFieldGetSelection(widget());
}

Boolean
TextFieldClass::getSelectionPosition(XmTextPosition *left, XmTextPosition *right)
{
   return XmTextFieldGetSelectionPosition(widget(), left, right);
}

wchar_t *
TextFieldClass::getSelectionWcs()
{
   return XmTextFieldGetSelectionWcs(widget());
}

String 
TextFieldClass::getString()
{
   return XmTextFieldGetString(widget());
}

wchar_t * 
TextFieldClass::getStringWcs()
{
   return XmTextFieldGetStringWcs(widget());
}

int
TextFieldClass::getSubstring(XmTextPosition start, int no_chars, int buf_sz, 
                             char *buf)
{
   return XmTextFieldGetSubstring(widget(), start, no_chars, buf_sz, buf);
}

int
TextFieldClass::getSubstringWcs(XmTextPosition start, int no_chars, int buf_sz,
                                wchar_t *buf)
{
   return XmTextFieldGetSubstringWcs(widget(), start, no_chars, buf_sz, buf);
}

void
TextFieldClass::insert(XmTextPosition pos, char *str)
{
   XmTextFieldInsert(widget(), pos, str);
}

void
TextFieldClass::insertWcs(XmTextPosition pos, wchar_t *str)
{
   XmTextFieldInsertWcs(widget(), pos, str);
}

Boolean
TextFieldClass::paste()
{
   return XmTextFieldPaste(widget());
}

Boolean
TextFieldClass::posToXY(XmTextPosition pos, Position *x, Position *y)
{
   return XmTextFieldPosToXY(widget(),pos,x,y);
}

Boolean
TextFieldClass::remove()
{
   return XmTextFieldRemove(widget());
}

void
TextFieldClass::replace(XmTextPosition from, XmTextPosition to, char *value)
{
   XmTextFieldReplace(widget(), from, to, value);
}

void
TextFieldClass::replaceWcs(XmTextPosition from, XmTextPosition to, wchar_t *value)
{
   XmTextFieldReplaceWcs(widget(), from, to, value);
}

void
TextFieldClass::setAddMode(Boolean state)
{
   XmTextFieldSetAddMode(widget(), state);
}

void
TextFieldClass::setCursorPosition(XmTextPosition position)
{
   XmTextFieldSetCursorPosition(widget(), position);
}

void
TextFieldClass::setEditable(Boolean editable)
{
   XmTextFieldSetEditable(widget(), editable);
}

void
TextFieldClass::setHighlight(XmTextPosition left, XmTextPosition right, XmHighlightMode mode)
{
   XmTextFieldSetHighlight(widget(), left, right, mode);
}

void 
TextFieldClass::setInsertionPosition(XmTextPosition pos)
{
   XmTextFieldSetInsertionPosition(widget(), pos);
}

void 
TextFieldClass::setMaxLength(int max)
{
   XmTextFieldSetMaxLength(widget(), max);
}

void 
TextFieldClass::setSelection(XmTextPosition first, XmTextPosition last, Time t)
{
   XmTextFieldSetSelection(widget(), first, last, t);
}

void 
TextFieldClass::setString(char *str)
{
   XmTextFieldSetString(widget(), str);
}

void 
TextFieldClass::setStringWcs(wchar_t *str)
{
   XmTextFieldSetStringWcs(widget(), str);
}

void 
TextFieldClass::showPosition(XmTextPosition pos)
{
   XmTextFieldShowPosition(widget(), pos);
}

XmTextPosition
TextFieldClass::xyToPos(Position x, Position y)
{
   return XmTextFieldXYToPos(widget(), x, y);
}

/* resources */
void 
TextFieldClass::blinkRate(int b)
{
   XtVaSetValues(widget(), XmNblinkRate, b, NULL);
}

int
TextFieldClass::blinkRate()
{
   int b;
   XtVaGetValues(widget(), XmNblinkRate, &b, NULL);
   return b;
}

void 
TextFieldClass::columns(short c)
{
   XtVaSetValues(widget(), XmNcolumns, c, NULL);
}

short
TextFieldClass::columns()
{
   short c;
   XtVaGetValues(widget(), XmNcolumns, &c, NULL);
   return c;
}

void 
TextFieldClass::cursorPosition(XmTextPosition pos)
{
   XtVaSetValues(widget(), XmNcursorPosition, pos, NULL);
}

XmTextPosition
TextFieldClass::cursorPosition()
{
   XmTextPosition pos;
   XtVaGetValues(widget(), XmNcursorPosition, &pos, NULL);
   return pos;
}

void 
TextFieldClass::cursorPositionVisible(Boolean b)
{
   XtVaSetValues(widget(), XmNcursorPositionVisible, b, NULL);
}

Boolean
TextFieldClass::cursorPositionVisible()
{
   Boolean b;
   XtVaGetValues(widget(), XmNcursorPositionVisible, &b, NULL);
   return b;
}

void 
TextFieldClass::editable(Boolean b)
{
   XtVaSetValues(widget(), XmNeditable, b, NULL);
}

Boolean
TextFieldClass::editable()
{
   Boolean b;
   XtVaGetValues(widget(), XmNeditable, &b, NULL);
   return b;
}

void 
TextFieldClass::fontList(XmFontList f)
{
   XtVaSetValues(widget(),XmNfontList, f, NULL);
}

XmFontList
TextFieldClass::fontList()
{
   XmFontList f;
   XtVaGetValues(widget(),XmNfontList, &f, NULL);
   return f;
}

void 
TextFieldClass::marginHeight(Dimension h)
{
   XtVaSetValues(widget(),XmNmarginHeight,h, NULL);
}

Dimension
TextFieldClass::marginHeight()
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginHeight, &d, NULL);
   return d;
}

void 
TextFieldClass::marginWidth(Dimension w)
{
   XtVaSetValues(widget(),XmNmarginWidth,w, NULL);
}

Dimension
TextFieldClass::marginWidth()
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginWidth, &d, NULL);
   return d;
}

void 
TextFieldClass::maxLength(int l)
{
   XtVaSetValues(widget(),XmNmaxLength,l, NULL);
}

int
TextFieldClass::maxLength()
{
   int l;
   XtVaGetValues(widget(),XmNmaxLength, &l, NULL);
   return l;
}

void 
TextFieldClass::pendingDelete(Boolean b)
{
   XtVaSetValues(widget(),XmNpendingDelete,b, NULL);
}

Boolean
TextFieldClass::pendingDelete()
{
   Boolean b;
   XtVaGetValues(widget(),XmNpendingDelete, &b, NULL);
   return b;
}

void 
TextFieldClass::resizeWidth(Boolean b)
{
   XtVaSetValues(widget(),XmNresizeWidth,b, NULL);
}

Boolean
TextFieldClass::resizeWidth()
{
   Boolean b;
   XtVaGetValues(widget(),XmNresizeWidth, &b, NULL);
   return b;
}

void 
TextFieldClass::selectionArray(XmTextScanType *p)
{
   XtVaSetValues(widget(),XmNselectionArray, p, NULL);
}

XmTextScanType *
TextFieldClass::selectionArray()
{
   XmTextScanType *s;
   XtVaGetValues(widget(),XmNselectionArray, &s, NULL);
   return s;
}

void 
TextFieldClass::selectionArrayCount(int cnt)
{
   XtVaSetValues(widget(),XmNselectionArrayCount, cnt, NULL);
}

int
TextFieldClass::selectionArrayCount()
{
   int i;
   XtVaGetValues(widget(),XmNselectionArrayCount, &i, NULL);
   return i;
}

void 
TextFieldClass::selectThreshold(int h)
{
   XtVaSetValues(widget(),XmNselectThreshold, h, NULL);
}

int
TextFieldClass::selectThreshold()
{
   int i;
   XtVaGetValues(widget(),XmNselectThreshold, &i, NULL);
   return i;
}

void 
TextFieldClass::value(String v)
{
   XtVaSetValues(widget(),XmNvalue,v, NULL);
}

String
TextFieldClass::value()
{
   String s;
   XtVaGetValues(widget(),XmNvalue, &s, NULL);
   return s;
}

void 
TextFieldClass::valueWcs(wchar_t *v)
{
   XtVaSetValues(widget(),XmNvalueWcs, v, NULL);
}

wchar_t *
TextFieldClass::valueWcs()
{
   wchar_t *w;
   XtVaGetValues(widget(),XmNvalueWcs, w, NULL);
   return w;
}

void 
TextFieldClass::verifyBell(Boolean b)
{
   XtVaSetValues(widget(),XmNverifyBell,b, NULL);
}

Boolean
TextFieldClass::verifyBell()
{
   Boolean b;
   XtVaGetValues(widget(),XmNverifyBell, &b, NULL);
   return b;
}

/* constructor */
TextField::TextField(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateTextField(parent,"XmTextField", arglist, cnt);
   widget(wid);
   manage();
}

