/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Shell.C,v 1.2 1994/10/27 23:26:56 pgw Exp */
#include <Xarm/Shell.h>

/* callbacks */
void 
ShellClass::popdownCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNpopdownCallback,fp,data);
}

void 
ShellClass::popupCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNpopupCallback,fp,data);
}

/* convenience routines */
void
ShellClass::activateProtocol(Atom property, Atom protocol)
{
   XmActivateProtocol(widget(),property, protocol);
}

void
ShellClass::activateWMProtocol(Atom protocol)
{
   XmActivateWMProtocol(widget(), protocol);
}

/* resources */
Boolean
ShellClass::allowShellResize()
{
   Boolean b;
   XtVaGetValues(widget(),XmNallowShellResize, &b, NULL);
   return b;
}

void
ShellClass::createPopupChildProc(XtCreatePopupChildProc fp)
{
   XtVaSetValues(widget(),XmNcreatePopupChildProc, fp, NULL);
}

XtCreatePopupChildProc
ShellClass::createPopupChildProc()
{
   XtCreatePopupChildProc fp;
   XtVaGetValues(widget(),XmNcreatePopupChildProc, &fp, NULL);
   return fp;
}

void
ShellClass::geometry(String s)
{
   XtVaSetValues(widget(), XmNgeometry, s, NULL);
}

String
ShellClass::geometry()
{
   String s;
   XtVaGetValues(widget(), XmNgeometry, &s, NULL);
   return s;
}

void
ShellClass::overrideRedirect(Boolean b)
{
   XtVaSetValues(widget(), XmNoverrideRedirect, b, NULL);
}

Boolean
ShellClass::overrideRedirect()
{
   Boolean b;
   XtVaGetValues(widget(), XmNoverrideRedirect, &b, NULL);
   return b;
}

void
ShellClass::saveUnder(Boolean b)
{
   XtVaSetValues(widget(), XmNsaveUnder, b, NULL);
}

Boolean
ShellClass::saveUnder()
{
   Boolean b;
   XtVaGetValues(widget(), XmNsaveUnder, &b, NULL);
   return b;
}

void
ShellClass::visual(Visual *v)
{
   XtVaSetValues(widget(), XmNvisual, v, NULL);
}

Visual *
ShellClass::visual()
{
   Visual *v;
   XtVaGetValues(widget(), XmNvisual, &v, NULL);
   return v;
}

