/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Separator.C,v 1.3 1994/10/27 23:26:55 pgw Exp */
#include <Xarm/Separator.h>
/* SeparatorClass member functions */

void 
SeparatorClass::margin(Dimension m)
{
   XtVaSetValues(widget(), XmNmargin, m, NULL);
}

Dimension
SeparatorClass::margin()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmargin, &d, NULL);
   return d;
}

void 
SeparatorClass::orientation(unsigned char o)
{
   XtVaSetValues(widget(), XmNorientation, o, NULL);
}

unsigned char
SeparatorClass::orientation()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNorientation, &c, NULL);
   return c;
}

void 
SeparatorClass::separatorType(unsigned char s)
{
   XtVaSetValues(widget(), XmNseparatorType, s, NULL);
}

unsigned char
SeparatorClass::separatorType()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNseparatorType, &c, NULL);
   return c;
}

/* constructors */
Separator::Separator(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateSeparator(parent,"XmSeparator", arglist, cnt); 
   widget(w);
   manage();
}

/* */
