/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* SelectioB.C,v 1.3 1994/10/27 23:26:53 pgw Exp */
#include <Xarm/SelectioB.h>
/* SelectionBoxClass Members */
/* callbacks */
void
SelectionBoxClass::applyCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNapplyCallback,funcp,data);
}
void
SelectionBoxClass::cancelCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNcancelCallback,funcp,data);
}
void
SelectionBoxClass::noMatchCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNnoMatchCallback,funcp,data);
}
void
SelectionBoxClass::okCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNokCallback,funcp,data);
}

/* convenience routines */
Widget 
SelectionBoxClass::getChild(unsigned char c)
{
   return XmSelectionBoxGetChild(widget(),c);
}

/* resources */

void 
SelectionBoxClass::applyLabelString(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNapplyLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
SelectionBoxClass::applyLabelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNapplyLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void 
SelectionBoxClass::cancelLabelString(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNcancelLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}


char *
SelectionBoxClass::cancelLabelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNcancelLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void 
SelectionBoxClass::childPlacement(unsigned char c)
{
   XtVaSetValues(widget(), XmNchildPlacement, c, NULL);
}


unsigned char 
SelectionBoxClass::childPlacement()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNchildPlacement, &c, NULL);
   return c;
}

void 
SelectionBoxClass::dialogType(unsigned char c)
{
   XtVaSetValues(widget(), XmNdialogType, c, NULL);
}


unsigned char 
SelectionBoxClass::dialogType()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNdialogType, &c, NULL);
   return c;
}

void 
SelectionBoxClass::helpLabelString(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNhelpLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
SelectionBoxClass::helpLabelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNhelpLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void 
SelectionBoxClass::listItemCount(int i)
{
   XtVaSetValues(widget(), XmNlistItemCount, i, NULL);
}


int 
SelectionBoxClass::listItemCount()
{
   int i;
   XtVaGetValues(widget(), XmNlistItemCount, &i, NULL);
   return i;
}


void 
SelectionBoxClass::listItems(XmStringTable st)
{
   XtVaSetValues(widget(), XmNlistItems, st, NULL);
}

XmStringTable 
SelectionBoxClass::listItems()
{
   XmStringTable st;
   XtVaGetValues(widget(), XmNlistItems, &st, NULL);
   return st;
}

void 
SelectionBoxClass::listLabelString(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNlistLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}
   
char *
SelectionBoxClass::listLabelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNlistLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}
   
void 
SelectionBoxClass::listVisibleItemCount(int i)
{
   XtVaSetValues(widget(), XmNlistVisibleItemCount, i, NULL);
}
   
int 
SelectionBoxClass::listVisibleItemCount()
{
   int i;
   XtVaGetValues(widget(), XmNlistVisibleItemCount, &i, NULL);
   return i;
}

void 
SelectionBoxClass::minimizeButtons(Boolean b)
{
   XtVaSetValues(widget(), XmNminimizeButtons, b, NULL);
}
   
Boolean 
SelectionBoxClass::minimizeButtons()
{
   Boolean b;
   XtVaGetValues(widget(), XmNminimizeButtons, &b, NULL);
   return b;
}
   
void 
SelectionBoxClass::mustMatch(Boolean b)
{
   XtVaSetValues(widget(), XmNmustMatch, b, NULL);
}
   
Boolean 
SelectionBoxClass::mustMatch()
{
   Boolean b;
   XtVaGetValues(widget(), XmNmustMatch, &b, NULL);
   return b;
}
   
void 
SelectionBoxClass::okLabelString(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNokLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}
   
char *
SelectionBoxClass::okLabelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNokLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}
   
void
SelectionBoxClass::selectionLabelString(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNselectionLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
SelectionBoxClass::selectionLabelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNselectionLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}
   
void 
SelectionBoxClass::textColumns(short s)
{
   XtVaSetValues(widget(), XmNtextColumns, s, NULL);
}
   
short 
SelectionBoxClass::textColumns()
{
   short s;
   XtVaGetValues(widget(), XmNtextColumns, &s, NULL);
   return s;
}

void
SelectionBoxClass::textString(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNtextString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
SelectionBoxClass::textString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNtextString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

/* constructors */

SelectionBox::SelectionBox(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateSelectionBox(parent,"XmSelectionBox",arglist,cnt); 
   widget(w);
}

SelectionDialog::SelectionDialog(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateSelectionDialog(parent,"XmSelectionDialog",
                                      arglist, cnt);
   widget(w);
}


PromptDialog::PromptDialog(Widget parent, char *mesg)
{
   Widget w = XmCreatePromptDialog(parent,"XmPromptDialog",
                                          NULL,0); 
   widget(w);
   selectionLabelString(mesg);
}

PromptDialog::PromptDialog(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreatePromptDialog(parent,"XmPromptDialog",
                                          arglist, cnt); 
   widget(w);
}

