/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* ScrolledW.C,v 1.4 1994/10/29 18:34:43 pgw Exp */
#include <Xarm/ScrolledW.h>
/* ScrolledWindowClass members */

/* callbacks */
void
ScrolledWindowClass::traverseObscuredCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNtraverseObscuredCallback,fp,udata);
}

/* resources */
Widget
ScrolledWindowClass::horizontalScrollBar()
{
   Widget w;
   XtVaGetValues(widget(),XmNhorizontalScrollBar, &w, NULL);
   return w;
}

void
ScrolledWindowClass::horizontalScrollBar(Widget w)
{
   XtVaSetValues(widget(),XmNhorizontalScrollBar, w, NULL);
}

void
ScrolledWindowClass::scrollBarDisplayPolicy(unsigned char c)
{
   XtVaSetValues(widget(),XmNscrollBarDisplayPolicy, c, NULL);
}

unsigned char
ScrolledWindowClass::scrollBarDisplayPolicy()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNscrollBarDisplayPolicy, &c, NULL);
   return c;
}

void
ScrolledWindowClass::scrollBarPlacement(unsigned char c)
{
   XtVaSetValues(widget(),XmNscrollBarPlacement, c, NULL);
}

unsigned char
ScrolledWindowClass::scrollBarPlacement()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNscrollBarPlacement, &c, NULL);
   return c;
}

Dimension
ScrolledWindowClass::scrolledWindowMarginHeight()
{
   Dimension d;
   XtVaGetValues(widget(),XmNscrolledWindowMarginHeight, &d, NULL);
   return d;
}

void
ScrolledWindowClass::scrolledWindowMarginHeight(Dimension d)
{
   XtVaSetValues(widget(),XmNscrolledWindowMarginHeight, d, NULL);
}

Dimension
ScrolledWindowClass::scrolledWindowMarginWidth()
{
   Dimension d;
   XtVaGetValues(widget(),XmNscrolledWindowMarginWidth, &d, NULL);
   return d;
}

void
ScrolledWindowClass::scrolledWindowMarginWidth(Dimension d)
{
   XtVaSetValues(widget(),XmNscrolledWindowMarginWidth, d, NULL);
}

unsigned char
ScrolledWindowClass::scrollingPolicy()
{
   unsigned char policy;
   XtVaGetValues(widget(),XmNscrollingPolicy, &policy, NULL);
   return policy;
}

void
ScrolledWindowClass::spacing(int space)
{
   XtVaSetValues(widget(),XmNspacing, space, NULL);
}

int
ScrolledWindowClass::spacing()
{
   int space;
   XtVaGetValues(widget(),XmNspacing, &space, NULL);
   return space;
}

Widget
ScrolledWindowClass::verticalScrollBar()
{
   Widget w;
   XtVaGetValues(widget(),XmNverticalScrollBar, &w, NULL);
   return w;
}

void
ScrolledWindowClass::verticalScrollBar(Widget w)
{
   XtVaSetValues(widget(),XmNverticalScrollBar, w, NULL);
}

unsigned char
ScrolledWindowClass::visualPolicy()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNvisualPolicy, &c, NULL);
   return c;
}

void
ScrolledWindowClass::workWindow(Widget w)
{
   XtVaSetValues(widget(),XmNworkWindow, w, NULL);
}

Widget
ScrolledWindowClass::workWindow()
{
   Widget w;
   XtVaGetValues(widget(),XmNworkWindow, &w, NULL);
   return w;
}

/* constructor */
ScrolledWindow::ScrolledWindow(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateScrolledWindow(parent, "XmScrolledWindow",
                               arglist, cnt);
 
   widget(w);
}

