/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Scale.C,v 1.3 1994/10/27 23:26:50 pgw Exp */
#include <Xarm/Scale.h>

/* ScaleClass Members */
/* callbacks */
void
ScaleClass::dragCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNdragCallback,funcp,data);
}

void
ScaleClass::valueChangedCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNvalueChangedCallback,funcp,data);
}

/* resources */
void
ScaleClass::decimalPoints(short s)
{
   XtVaSetValues(widget(), XmNdecimalPoints, s, NULL);
}

short
ScaleClass::decimalPoints()
{
   short s;
   XtVaGetValues(widget(), XmNdecimalPoints, &s, NULL);
   return s;
}

void
ScaleClass::fontList(XmFontList fl)
{
   XtVaSetValues(widget(), XmNfontList, fl, NULL);
}

XmFontList
ScaleClass::fontList()
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNfontList, &fl, NULL);
   return fl;
}

void
ScaleClass::highlightOnEnter(Boolean b)
{
   XtVaSetValues(widget(), XmNhighlightOnEnter, b, NULL);
}

Boolean
ScaleClass::highlightOnEnter()
{
   Boolean b;
   XtVaGetValues(widget(), XmNhighlightOnEnter, &b, NULL);
   return b;
}

void
ScaleClass::highlightThickness(Dimension d)
{
   XtVaSetValues(widget(), XmNhighlightThickness, d, NULL);
}

Dimension
ScaleClass::highlightThickness()
{
   Dimension d;
   XtVaGetValues(widget(), XmNhighlightThickness, &d, NULL);
   return d;
}

void
ScaleClass::maximum(int max)
{
   XtVaSetValues(widget(), XmNmaximum, max, NULL);
}

int
ScaleClass::maximum()
{
   int max;
   XtVaGetValues(widget(), XmNmaximum, &max, NULL);
   return max;
}

void
ScaleClass::minimum(int min)
{
   XtVaSetValues(widget(), XmNminimum, min, NULL);
}

int
ScaleClass::minimum()
{
   int min;
   XtVaGetValues(widget(), XmNminimum, &min, NULL);
   return min;
}

void
ScaleClass::orientation(unsigned char orient)
{
   XtVaSetValues(widget(), XmNorientation, orient, NULL);
}

unsigned char
ScaleClass::orientation()
{
   unsigned char orient;
   XtVaGetValues(widget(), XmNorientation, &orient, NULL);
   return orient;
}

void
ScaleClass::scaleHeight(Dimension h)
{
   XtVaSetValues(widget(), XmNscaleHeight, h, NULL);
}

Dimension
ScaleClass::scaleHeight()
{
   Dimension d;
   XtVaGetValues(widget(), XmNscaleHeight, &d, NULL);
   return d;
}

void
ScaleClass::scaleMultiple(int m)
{
   XtVaSetValues(widget(), XmNscaleMultiple, m, NULL);
}

int
ScaleClass::scaleMultiple()
{
   int i;
   XtVaGetValues(widget(), XmNscaleMultiple, &i, NULL);
   return i;
}

void
ScaleClass::scaleWidth(Dimension w)
{
   XtVaSetValues(widget(), XmNscaleWidth, w, NULL);
}

Dimension
ScaleClass::scaleWidth()
{
   Dimension d;
   XtVaGetValues(widget(), XmNscaleWidth, &d, NULL);
   return d;
}

void
ScaleClass::showValue(Boolean val)
{
   XtVaSetValues(widget(), XmNshowValue, val, NULL);
}

Boolean
ScaleClass::showValue()
{
   Boolean b;
   XtVaGetValues(widget(), XmNshowValue, &b, NULL);
   return b;
}

void
ScaleClass::titleString(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNtitleString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
ScaleClass::titleString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNtitleString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
ScaleClass::value(int val)
{
   XtVaSetValues(widget(), XmNvalue, val, NULL);
}

int
ScaleClass::value()
{
   int val;
   XtVaGetValues(widget(), XmNvalue, &val, NULL);
   return val;
}

Scale::Scale(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateScale(parent, "XmScale", arglist, cnt);
   widget(wid);
}

