/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* RowColumn.C,v 1.5 1994/10/29 18:34:42 pgw Exp */
#include <Xarm/RowColumn.h>

/* callbacks */
void
RowColumnClass::entryCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNentryCallback, funcp, data);
}

void 
RowColumnClass::mapCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNmapCallback, funcp, data);
}

void 
RowColumnClass::tearOffMenuActivateCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNtearOffMenuActivateCallback, funcp, data);
}

void 
RowColumnClass::tearOffMenuDeactivateCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNtearOffMenuDeactivateCallback, funcp, data);
}

void 
RowColumnClass::unmapCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNunmapCallback, funcp, data);
}

/* resources */
void 
RowColumnClass::adjustLast(Boolean b)
{
   XtVaSetValues(widget(), XmNadjustLast, b, NULL);
}

Boolean 
RowColumnClass::adjustLast()
{
   Boolean b;
   XtVaGetValues(widget(), XmNadjustLast, &b, NULL);
   return b;
}

void 
RowColumnClass::adjustMargin(Boolean b)
{
   XtVaSetValues(widget(), XmNadjustMargin, b, NULL);
}

Boolean 
RowColumnClass::adjustMargin()
{
   Boolean b;
   XtVaGetValues(widget(), XmNadjustMargin, &b, NULL);
   return b;
}

void 
RowColumnClass::entryAlignment(unsigned char c)
{
   XtVaSetValues(widget(), XmNentryAlignment, c, NULL);
}

unsigned char 
RowColumnClass::entryAlignment()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNentryAlignment, &c, NULL);
   return c;
}

void 
RowColumnClass::entryBorder(Dimension d)
{
   XtVaSetValues(widget(), XmNentryBorder, d, NULL);
}

Dimension 
RowColumnClass::entryBorder()
{
   Dimension d;
   XtVaGetValues(widget(), XmNentryBorder, &d, NULL);
   return d;
}

void 
RowColumnClass::entryClass(WidgetClass wc)
{
   XtVaSetValues(widget(), XmNentryClass, wc, NULL);
}

WidgetClass 
RowColumnClass::entryClass()
{
   WidgetClass wc;
   XtVaGetValues(widget(), XmNentryClass, &wc, NULL);
   return wc;
}

void 
RowColumnClass::entryVerticalAlignment(unsigned char c)
{
   XtVaSetValues(widget(), XmNentryVerticalAlignment, c, NULL);
}

unsigned char 
RowColumnClass::entryVerticalAlignment()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNentryVerticalAlignment, &c, NULL);
   return c;
}

void 
RowColumnClass::isAligned(Boolean b)
{
   XtVaSetValues(widget(), XmNisAligned, b, NULL);
}

Boolean 
RowColumnClass::isAligned()
{
   Boolean b;
   XtVaGetValues(widget(), XmNisAligned, &b, NULL);
   return b;
}

void 
RowColumnClass::isHomogeneous(Boolean b)
{
   XtVaSetValues(widget(), XmNisHomogeneous, b, NULL);
}

Boolean 
RowColumnClass::isHomogeneous()
{
   Boolean b;
   XtVaGetValues(widget(), XmNisHomogeneous, &b, NULL);
   return b;
}

void 
RowColumnClass::marginHeight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginHeight, d, NULL);
}

Dimension 
RowColumnClass::marginHeight()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginHeight, &d, NULL);
   return d;
}

void 
RowColumnClass::marginWidth(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginWidth, d, NULL);
}

Dimension 
RowColumnClass::marginWidth()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginWidth, &d, NULL);
   return d;
}

void 
RowColumnClass::menuAccelerator(String s)
{
   XtVaSetValues(widget(), XmNmenuAccelerator, s, NULL);
}

String 
RowColumnClass::menuAccelerator()
{
   String s;
   XtVaGetValues(widget(), XmNmenuAccelerator, &s, NULL);
   return s;
}

void 
RowColumnClass::menuHelpWidget(Widget w)
{
   XtVaSetValues(widget(), XmNmenuHelpWidget, w, NULL);
}

Widget 
RowColumnClass::menuHelpWidget()
{
   Widget w;
   XtVaGetValues(widget(), XmNmenuHelpWidget, &w, NULL);
   return w;
}

void 
RowColumnClass::menuHistory(Widget w)
{
   XtVaSetValues(widget(), XmNmenuHistory, w, NULL);
}

Widget 
RowColumnClass::menuHistory()
{
   Widget w;
   XtVaGetValues(widget(), XmNmenuHistory, &w, NULL);
   return w;
}

void 
RowColumnClass::menuPost(String s)
{
   XtVaSetValues(widget(), XmNmenuPost, s, NULL);
}

String 
RowColumnClass::menuPost()
{
   String s;
   XtVaGetValues(widget(), XmNmenuPost, &s, NULL);
   return s;
}

void 
RowColumnClass::mnemonic(KeySym k)
{
   XtVaSetValues(widget(), XmNmnemonic, k, NULL);
}

KeySym 
RowColumnClass::mnemonic()
{
   KeySym k;
   XtVaGetValues(widget(), XmNmnemonic, &k, NULL);
   return k;
}

void 
RowColumnClass::mnemonicCharSet(String s)
{
   XtVaSetValues(widget(), XmNmnemonicCharSet, s, NULL);
}

String 
RowColumnClass::mnemonicCharSet()
{
   String s;
   XtVaGetValues(widget(), XmNmnemonicCharSet, &s, NULL);
   return s;
}

void 
RowColumnClass::numColumns(short s)
{
   XtVaSetValues(widget(), XmNnumColumns, s, NULL);
}

short 
RowColumnClass::numColumns()
{
   short s;
   XtVaGetValues(widget(), XmNnumColumns, &s, NULL);
   return s;
}

void 
RowColumnClass::orientation(unsigned char c)
{
   XtVaSetValues(widget(), XmNorientation, c, NULL);
}

unsigned char 
RowColumnClass::orientation()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNorientation, &c, NULL);
   return c;
}

void 
RowColumnClass::packing(unsigned char c)
{
   XtVaSetValues(widget(), XmNpacking, c, NULL);
}

unsigned char 
RowColumnClass::packing()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNpacking, &c, NULL);
   return c;
}

void 
RowColumnClass::popupEnabled(Boolean b)
{
   XtVaSetValues(widget(), XmNpopupEnabled, b, NULL);
}

Boolean 
RowColumnClass::popupEnabled()
{
   Boolean b;
   XtVaGetValues(widget(), XmNpopupEnabled, &b, NULL);
   return b;
}

void 
RowColumnClass::radioAlwaysOne(Boolean b)
{
   XtVaSetValues(widget(), XmNradioAlwaysOne, b, NULL);
}

Boolean 
RowColumnClass::radioAlwaysOne()
{
   Boolean b;
   XtVaGetValues(widget(), XmNradioAlwaysOne, &b, NULL);
   return b;
}

void 
RowColumnClass::radioBehavior(Boolean b)
{
   XtVaSetValues(widget(), XmNradioBehavior, b, NULL);
}

Boolean 
RowColumnClass::radioBehavior()
{
   Boolean b;
   XtVaGetValues(widget(), XmNradioBehavior, &b, NULL);
   return b;
}

void 
RowColumnClass::resizeHeight(Boolean b)
{
   XtVaSetValues(widget(), XmNresizeHeight, b, NULL);
}

Boolean 
RowColumnClass::resizeHeight()
{
   Boolean b;
   XtVaGetValues(widget(), XmNresizeHeight, &b, NULL);
   return b;
}

void 
RowColumnClass::resizeWidth(Boolean b)
{
   XtVaSetValues(widget(), XmNresizeWidth, b, NULL);
}

Boolean 
RowColumnClass::resizeWidth()
{
   Boolean b;
   XtVaGetValues(widget(), XmNresizeWidth, &b, NULL);
   return b;
}

unsigned char 
RowColumnClass::rowColumnType()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNrowColumnType, &c, NULL);
   return c;
}

void 
RowColumnClass::spacing(Dimension d)
{
   XtVaSetValues(widget(), XmNspacing, d, NULL);
}

Dimension 
RowColumnClass::spacing()
{
   Dimension d;
   XtVaGetValues(widget(), XmNspacing, &d, NULL);
   return d;
}

void 
RowColumnClass::subMenuId(Widget w)
{
   XtVaSetValues(widget(), XmNsubMenuId, w, NULL);
}

Widget 
RowColumnClass::subMenuId()
{
   Widget w;
   XtVaGetValues(widget(), XmNsubMenuId, &w, NULL);
   return w;
}

void 
RowColumnClass::tearOffModel(unsigned char c)
{
   XtVaSetValues(widget(), XmNtearOffModel, c, NULL);
}

unsigned char 
RowColumnClass::tearOffModel()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNtearOffModel, &c, NULL);
   return c;
}

void 
RowColumnClass::whichButton(unsigned int i)
{
   XtVaSetValues(widget(), XmNwhichButton, i, NULL);
}

unsigned int 
RowColumnClass::whichButton()
{
   unsigned int i;
   XtVaGetValues(widget(), XmNwhichButton, &i, NULL);
   return i;
}

/* RowColumn constructor */
RowColumn::RowColumn(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateRowColumn(parent,"XmRowColumn",arglist,cnt);
   widget(wid);
}

/* pulldown menu constructor */
PulldownMenu::PulldownMenu(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreatePulldownMenu(parent,"XmPulldownMenu",arglist,cnt);
   widget(wid);
}

