/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Registry.C,v 1.2 1994/10/27 03:21:42 pgw Exp */

/* Include(s) */
#include <Xarm/Registry.h>

/* Drop site members */
void 
DropSiteClass::dragProc(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdragProc,fp,udata);
}

void 
DropSiteClass::dropProc(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdropProc,fp,udata);
}

/* convenience routines */
void 
DropSiteClass::configureStackingOrder(Widget sibling, Cardinal stack_mode)
{
   XmDropSiteConfigureStackingOrder(widget(), sibling, stack_mode);
}

void 
DropSiteClass::endUpdate()
{
   XmDropSiteEndUpdate(widget());
}

Status 
DropSiteClass::queryStackingOrder(Widget *parent_ret, 
                             Widget **children_ret, 
                             Cardinal *num_children_ret)
{
   return XmDropSiteQueryStackingOrder(widget(), 
                                       parent_ret,   
                                       children_ret, 
                                       num_children_ret);
}

void
DropSiteClass::Register(ArgList arglist, Cardinal cnt)
{
   XmDropSiteRegister(widget(),arglist, cnt);
}

void
DropSiteClass::retrieve(ArgList arglist, Cardinal cnt)
{
   XmDropSiteRetrieve(widget(),arglist, cnt);
}

void 
DropSiteClass::startUpdate()
{
   XmDropSiteStartUpdate(widget());
}
   
void
DropSiteClass::update(ArgList arglist, Cardinal cnt)
{
   XmDropSiteUpdate(widget(),arglist, cnt);
}

void
DropSiteClass::unregister()
{
   XmDropSiteUnregister(widget());
}

/* resources */
void 
DropSiteClass::animationMask(Pixmap p)
{
   Arg arglist[1] = { { (String) XmNanimationMask, (XtArgVal) p } };
   Cardinal argcount = 1;
   XmDropSiteUpdate(widget(),arglist, argcount);
}

Pixmap 
DropSiteClass::animationMask()
{
   Pixmap p;
   Arg arglist[1] = { { (String) XmNanimationMask, (XtArgVal) &p } };
   Cardinal argcount = 1;
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return p;
}

void 
DropSiteClass::animationPixmap(Pixmap p)
{
   Arg arglist[1] = { { (String) XmNanimationPixmap, (XtArgVal) p } };
   Cardinal argcount = 1;
   XmDropSiteUpdate(widget(),arglist, argcount);
}

Pixmap 
DropSiteClass::animationPixmap()
{
   Pixmap p;
   Arg arglist[1] = { { (String) XmNanimationPixmap, (XtArgVal) &p } };
   Cardinal argcount = 1;
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return p;
}

void 
DropSiteClass::animationPixmapDepth(int i)
{
   Arg arglist[1] = { { (String) XmNanimationPixmapDepth, (XtArgVal) i } };
   Cardinal argcount = 1;
   XmDropSiteUpdate(widget(),arglist, argcount);
}

int 
DropSiteClass::animationPixmapDepth()
{
   int i;
   Arg arglist[1] = { { (String) XmNanimationPixmapDepth, (XtArgVal) &i } };
   Cardinal argcount = 1;
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return i;
}

void 
DropSiteClass::animationStyle(unsigned char c)
{
   Arg arglist[1] = { { (String) XmNanimationStyle, (XtArgVal) c } };
   Cardinal argcount = 1;
   XmDropSiteUpdate(widget(),arglist, argcount);
}

unsigned char 
DropSiteClass::animationStyle()
{
   unsigned char c;
   Arg arglist[1] = { { (String) XmNanimationStyle, (XtArgVal) &c } };
   Cardinal argcount = 1;
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

void 
DropSiteClass::dropRectangles(XRectangle * r)
{
   Arg arglist[1] = { { (String) XmNdropRectangles, (XtArgVal) r } };
   Cardinal argcount = 1;
   XmDropSiteUpdate(widget(),arglist, argcount);
}

XRectangle *
DropSiteClass::dropRectangles()
{
   XRectangle *r;
   Arg arglist[1] = { { (String) XmNdropRectangles, (XtArgVal) &r } };
   Cardinal argcount = 1;
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return r;
}

void 
DropSiteClass::dropSiteActivity(unsigned char c)
{
   Arg arglist[1] = { { (String) XmNdropSiteActivity, (XtArgVal) c } };
   Cardinal argcount = 1;
   XmDropSiteUpdate(widget(),arglist, argcount);
}

unsigned char 
DropSiteClass::dropSiteActivity()
{
   unsigned char c;
   Arg arglist[1] = { { (String) XmNdropSiteActivity, (XtArgVal) &c } };
   Cardinal argcount = 1;
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

void 
DropSiteClass::dropSiteOperations(unsigned char c)
{
   Arg arglist[1] = { { (String) XmNdropSiteOperations, (XtArgVal) c } };
   Cardinal argcount = 1;
   XmDropSiteUpdate(widget(),arglist, argcount);
}

unsigned char 
DropSiteClass::dropSiteOperations()
{
   unsigned char c;
   Arg arglist[1] = { { (String) XmNdropSiteOperations, (XtArgVal) &c } };
   Cardinal argcount = 1;
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

unsigned char 
DropSiteClass::dropSiteType()
{
   unsigned char c;
   Arg arglist[1] = { { (String) XmNdropSiteType, (XtArgVal) &c } };
   Cardinal argcount = 1;
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

void 
DropSiteClass::importTargets(Atom *a)
{
   Arg arglist[1] = { { (String) XmNimportTargets, (XtArgVal) a } };
   Cardinal argcount = 1;
   XmDropSiteUpdate(widget(),arglist, argcount);
}

Atom *
DropSiteClass::importTargets()
{
   Atom *a;
   Arg arglist[1] = { { (String) XmNimportTargets, (XtArgVal) &a } };
   Cardinal argcount = 1;
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return a;
}

void 
DropSiteClass::numDropRectangles(Cardinal c)
{
   Arg arglist[1] = { { (String) XmNnumDropRectangles, (XtArgVal) c } };
   Cardinal argcount = 1;
   XmDropSiteUpdate(widget(),arglist, argcount);
}

Cardinal 
DropSiteClass::numDropRectangles()
{
   Cardinal c;
   Arg arglist[1] = { { (String) XmNnumDropRectangles, (XtArgVal) &c } };
   Cardinal argcount = 1;
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

void 
DropSiteClass::numImportTargets(Cardinal c)
{
   Arg arglist[1] = { { (String) XmNnumImportTargets, (XtArgVal) c } };
   Cardinal argcount = 1;
   XmDropSiteUpdate(widget(),arglist, argcount);
}

Cardinal 
DropSiteClass::numImportTargets()
{
   Cardinal c;
   Arg arglist[1] = { { (String) XmNnumImportTargets, (XtArgVal) &c } };
   Cardinal argcount = 1;
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

