/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* PushBG.C,v 1.3 1994/10/27 23:26:47 pgw Exp */
#include <Xarm/PushBG.h>
/* PushButtonGadgetClass member functions */
void
PushButtonGadgetClass::autoSpace(int size)
{
   /* auto space buttons */
   int border = width();
   if(border < size) {
      int offset = (size-border)%2;
      border = (size - border)/2;
      XtVaSetValues(widget(),XmNmarginLeft,border,
         XmNmarginRight, ((Dimension) border+offset), NULL);
   } 
}

/* callbacks */
void
PushButtonGadgetClass::activateCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNactivateCallback,fp,udata);
}

void
PushButtonGadgetClass::armCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNarmCallback,fp,udata);
}

void
PushButtonGadgetClass::disarmCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdisarmCallback,fp,udata);
}

/* resources */
void
PushButtonGadgetClass::armColor(Pixel p)
{
   XtVaSetValues(widget(),XmNarmColor, p, NULL);
}

Pixel
PushButtonGadgetClass::armColor()
{
   Pixel p;
   XtVaGetValues(widget(),XmNarmColor, &p, NULL);
   return p;
}

void
PushButtonGadgetClass::defaultButtonShadowThickness(Dimension d)
{
   XtVaSetValues(widget(),XmNdefaultButtonShadowThickness,d, NULL);
}

Dimension
PushButtonGadgetClass::defaultButtonShadowThickness()
{
   Dimension d;
   XtVaGetValues(widget(),XmNdefaultButtonShadowThickness, &d, NULL);
   return d;
}

void
PushButtonGadgetClass::fillOnArm(Boolean b)
{
   XtVaSetValues(widget(),XmNfillOnArm,b, NULL);
}

Boolean
PushButtonGadgetClass::fillOnArm()
{
   Boolean b;
   XtVaGetValues(widget(),XmNfillOnArm, &b, NULL);
   return b;
}

void
PushButtonGadgetClass::multiClick(unsigned char c)
{
   XtVaSetValues(widget(),XmNmultiClick,c, NULL);
}

unsigned char
PushButtonGadgetClass::multiClick()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNmultiClick, &c, NULL);
   return c;
}

void
PushButtonGadgetClass::showAsDefault(Dimension d)
{
   XtVaSetValues(widget(),XmNshowAsDefault, d, NULL);
}

Dimension
PushButtonGadgetClass::showAsDefault()
{
   Dimension d;
   XtVaGetValues(widget(),XmNshowAsDefault, &d, NULL);
   return d;
}

PushButtonGadget::PushButtonGadget(Widget parent, char *text, KeySym mn,
                String acc, char *acc_text)
{
   Widget wid = XtVaCreateWidget("XmPushButtonGadget", xmPushButtonWidgetClass,
                                 parent, NULL);
   widget(wid);
   labelString(text);

   alignment(XmALIGNMENT_BEGINNING);
   if(mn != 0) mnemonic(mn);
   if(acc) accelerator(acc);
   if(acc_text) acceleratorText(acc_text);

   manage();
}

PushButtonGadget::PushButtonGadget(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreatePushButtonGadget(parent,"XmPushButtonGadget" , arglist, cnt);
   
   widget(wid);
   manage();
}


