/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* PushB.C,v 1.3 1994/10/27 23:26:46 pgw Exp */
#include <Xarm/PushB.h>
/* PushButtonClass member functions */
void
PushButtonClass::autoSpace(int size)
{
   /* auto space buttons */
   int border = width();
   if(border < size) {
      int offset = (size-border)%2;
      border = (size - border)/2;
      XtVaSetValues(widget(),XmNmarginLeft,border,
         XmNmarginRight, ((Dimension) border+offset), NULL);
   } 
}

/* callbacks */
void
PushButtonClass::activateCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNactivateCallback,fp,udata);
}

void
PushButtonClass::armCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNarmCallback,fp,udata);
}

void
PushButtonClass::disarmCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdisarmCallback,fp,udata);
}

/* resources */
void
PushButtonClass::armColor(Pixel p)
{
   XtVaSetValues(widget(),XmNarmColor, p, NULL);
}

Pixel
PushButtonClass::armColor()
{
   Pixel p;
   XtVaGetValues(widget(),XmNarmColor, &p, NULL);
   return p;
}

void
PushButtonClass::defaultButtonShadowThickness(Dimension d)
{
   XtVaSetValues(widget(),XmNdefaultButtonShadowThickness,d, NULL);
}

Dimension
PushButtonClass::defaultButtonShadowThickness()
{
   Dimension d;
   XtVaGetValues(widget(),XmNdefaultButtonShadowThickness, &d, NULL);
   return d;
}

void
PushButtonClass::fillOnArm(Boolean b)
{
   XtVaSetValues(widget(),XmNfillOnArm,b, NULL);
}

Boolean
PushButtonClass::fillOnArm()
{
   Boolean b;
   XtVaGetValues(widget(),XmNfillOnArm, &b, NULL);
   return b;
}

void
PushButtonClass::multiClick(unsigned char c)
{
   XtVaSetValues(widget(),XmNmultiClick,c, NULL);
}

unsigned char
PushButtonClass::multiClick()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNmultiClick, &c, NULL);
   return c;
}

void
PushButtonClass::showAsDefault(Dimension d)
{
   XtVaSetValues(widget(),XmNshowAsDefault, d, NULL);
}

Dimension
PushButtonClass::showAsDefault()
{
   Dimension d;
   XtVaGetValues(widget(),XmNshowAsDefault, &d, NULL);
   return d;
}

/* constructors */

PushButton::PushButton(Widget parent, char *text, KeySym mn,
                String acc, char *acc_text)
{
   Widget wid = XtVaCreateWidget("XmPushButton", xmPushButtonWidgetClass, 
                                 parent, NULL);
   widget(wid);
   labelString(text);

   alignment(XmALIGNMENT_BEGINNING);
   if(mn != 0) mnemonic(mn);
   if(acc) accelerator(acc);
   if(acc_text) acceleratorText(acc_text);

   manage();
}

PushButton::PushButton(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreatePushButton(parent,"XmPushButton" , arglist, cnt);
   
   widget(wid);
   manage();
}

