/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* MessageB.C,v 1.3 1994/10/27 23:26:42 pgw Exp */
#include <Xarm/MessageB.h>

/* MessageBoxClass Members */
/* convenience routines */
Widget
MessageBoxClass::getChild(unsigned char child)
{
   return XmMessageBoxGetChild(widget(), child);
}

/* callbacks */
void
MessageBoxClass::cancelCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNcancelCallback,funcp,data);
}

void
MessageBoxClass::okCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNokCallback,funcp,data);
}

/* resources */
void
MessageBoxClass::cancelLabelString(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNcancelLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
MessageBoxClass::cancelLabelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNcancelLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
MessageBoxClass::defaultButtonType(unsigned char c)
{
   XtVaSetValues(widget(), XmNdefaultButtonType, c, NULL);
}

unsigned char
MessageBoxClass::defaultButtonType()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNdefaultButtonType, &c, NULL);
   return c;
}

void
MessageBoxClass::dialogType(unsigned char c)
{
   XtVaSetValues(widget(), XmNdialogType, c, NULL);
}

unsigned char
MessageBoxClass::dialogType()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNdialogType, &c, NULL);
   return c;
}

void
MessageBoxClass::messageAlignment(unsigned char c)
{
   XtVaSetValues(widget(), XmNmessageAlignment, c, NULL);
}

unsigned char
MessageBoxClass::messageAlignment()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNmessageAlignment, &c, NULL);
   return c;
}

void
MessageBoxClass::messageString(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNmessageString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
MessageBoxClass::messageString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNmessageString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
MessageBoxClass::minimizeButtons(Boolean b)
{
   XtVaSetValues(widget(), XmNminimizeButtons, b, NULL);
}

Boolean
MessageBoxClass::minimizeButtons()
{
   Boolean b;
   XtVaGetValues(widget(), XmNminimizeButtons, &b, NULL);
   return b;
}

char *
MessageBoxClass::okLabelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNokLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr); 
}

void
MessageBoxClass::okLabelString(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNokLabelString, xmstr, NULL);
   XmStringFree(xmstr); 
}

void
MessageBoxClass::symbolPixmap(Pixmap pixmap)
{
   XtVaSetValues(widget(), XmNsymbolPixmap, pixmap, NULL);
}

Pixmap
MessageBoxClass::symbolPixmap()
{
   Pixmap pixmap;
   XtVaGetValues(widget(), XmNsymbolPixmap, &pixmap, NULL);
   return pixmap;
}

/* constructor */
MessageBox::MessageBox(Widget parent, char *mesg)
{
   Widget w = XmCreateMessageBox(parent,"XmMessageBox",
                                          NULL,0); 
   widget(w);
   messageString(mesg);
   manage();
}

MessageBox::MessageBox(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateMessageBox(parent,"XmMessageBox", arglist, cnt);

   widget(w);
   manage();
}

MessageDialog::MessageDialog(Widget parent, char *mesg)
{
   Widget w = XmCreateMessageDialog(parent,"XmMessageDialog",
                                          NULL,0); 
   widget(w);
   messageString(mesg);
}

MessageDialog::MessageDialog(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateMessageDialog(parent,"XmMessageDialog", arglist, cnt);

   widget(w);
}

InformationDialog::InformationDialog(Widget parent, char *mesg)
{
   Widget w = XmCreateInformationDialog(parent,"XmInformationDialog",
                                          NULL,0); 
   widget(w);
   messageString(mesg);
}

InformationDialog::InformationDialog(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateInformationDialog(parent,"XmInformationDialog", 
                                        arglist, cnt);

   widget(w);
}

QuestionDialog::QuestionDialog(Widget parent, char *mesg)
{
   Widget w = XmCreateQuestionDialog(parent,"XmQuestionDialog",
                                          NULL,0); 
   widget(w);
   messageString(mesg);
}

QuestionDialog::QuestionDialog(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateQuestionDialog(parent,"XmQuestionDialog", arglist, cnt);
   widget(w);
}

WarningDialog::WarningDialog(Widget parent, char *mesg)
{
   Widget w = XmCreateWarningDialog(parent,"XmWarningDialog",
                                          NULL,0); 
   widget(w);
   messageString(mesg);
}

WarningDialog::WarningDialog(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateWarningDialog(parent,"XmWarningDialog", arglist, cnt);
   widget(w);
}

WorkingDialog::WorkingDialog(Widget parent, char *mesg)
{
   Widget w = XmCreateWorkingDialog(parent,"XmWorkingDialog",
                                          NULL,0); 
   widget(w);
   messageString(mesg);
}

WorkingDialog::WorkingDialog(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateWorkingDialog(parent,"XmWorkingDialog",
                                          arglist, cnt); 
   widget(w);
}

ErrorDialog::ErrorDialog(Widget parent, char *mesg)
{
   Widget w = XmCreateErrorDialog(parent,"XmErrorDialog",
                                          NULL,0); 
   widget(w);
   messageString(mesg);
}

ErrorDialog::ErrorDialog(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget w = XmCreateErrorDialog(parent,"XmErrorDialog",
                                          arglist, cnt); 
   widget(w);
}


