/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* List.C,v 1.3 1994/10/27 23:26:37 pgw Exp */
#include <Xarm/List.h>

/* ListClass Members */

/* callbacks */

void
ListClass::browseSelectionCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNbrowseSelectionCallback, fp, data);
}

void 
ListClass::defaultActionCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNdefaultActionCallback, fp, data);
}

void 
ListClass::extendedSelectionCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNextendedSelectionCallback, fp, data);
}

void 
ListClass::multipleSelectionCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNmultipleSelectionCallback, fp, data);
}

void 
ListClass::singleSelectionCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNsingleSelectionCallback, fp, data);
}

/* resources */

void
ListClass::automaticSelection(Boolean b)
{
   XtVaSetValues(widget(),XmNautomaticSelection, b, NULL);
}

Boolean
ListClass::automaticSelection()
{
   Boolean b;
   XtVaGetValues(widget(),XmNautomaticSelection, &b, NULL);
   return b;
}

void 
ListClass::doubleClickInterval(int i)
{
   XtVaSetValues(widget(), XmNdoubleClickInterval, i, NULL);
}

int
ListClass::doubleClickInterval()
{
   int i;
   XtVaGetValues(widget(), XmNdoubleClickInterval, &i, NULL);
   return i;
}

void
ListClass::fontList(XmFontList fl)
{
   XtVaSetValues(widget(), XmNfontList, fl, NULL);
}

XmFontList
ListClass::fontList()
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNfontList, &fl, NULL);
   return fl;
}

void
ListClass::itemCount(int i)
{
   XtVaSetValues(widget(),XmNitemCount, i, NULL);
}

int
ListClass::itemCount()
{
   int i;
   XtVaGetValues(widget(),XmNitemCount, &i, NULL);
   return i;
}

void
ListClass::items(XmStringTable s)
{
   XtVaSetValues(widget(),XmNitems,s, NULL);
}

XmStringTable
ListClass::items()
{
   XmStringTable s;
   XtVaGetValues(widget(),XmNitems, &s, NULL);
   return s;
}

void
ListClass::listMarginHeight(Dimension d)
{
   XtVaSetValues(widget(), XmNlistMarginHeight, d, NULL);
}

Dimension
ListClass::listMarginHeight()
{
   Dimension d;
   XtVaGetValues(widget(), XmNlistMarginHeight, &d, NULL);
   return d;
}

void
ListClass::listMarginWidth(Dimension d)
{
   XtVaSetValues(widget(), XmNlistMarginWidth, d, NULL);
}

Dimension
ListClass::listMarginWidth()
{
   Dimension d;
   XtVaGetValues(widget(), XmNlistMarginWidth, &d, NULL);
   return d;
}

unsigned char
ListClass::listSizePolicy()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNlistSizePolicy, &c, NULL);
   return c;
}

void
ListClass::listSpacing(Dimension d)
{
   XtVaSetValues(widget(), XmNlistSpacing, d, NULL);
}

Dimension
ListClass::listSpacing()
{
   Dimension d;
   XtVaGetValues(widget(), XmNlistSpacing, &d, NULL);
   return d;
}

void
ListClass::scrollBarDisplayPolicy(unsigned char c)
{
   XtVaSetValues(widget(), XmNscrollBarDisplayPolicy, c, NULL);
}

unsigned char
ListClass::scrollBarDisplayPolicy()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNscrollBarDisplayPolicy, &c, NULL);
   return c;
}

void
ListClass::selectedItemCount(int i)
{
   XtVaSetValues(widget(), XmNselectedItemCount, i, NULL);
}

int
ListClass::selectedItemCount()
{
   int i;
   XtVaGetValues(widget(), XmNselectedItemCount, &i, NULL);
   return i;
}

void
ListClass::selectedItems(XmStringTable s)
{
   XtVaSetValues(widget(), XmNselectedItems, s, NULL);
}

XmStringTable
ListClass::selectedItems()
{
   XmStringTable s;
   XtVaGetValues(widget(), XmNselectedItems, &s, NULL);
   return s;
}

void
ListClass::selectionPolicy(unsigned char c)
{
   XtVaSetValues(widget(), XmNselectionPolicy, c, NULL);
}

unsigned char
ListClass::selectionPolicy()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNselectionPolicy, &c, NULL);
   return c;
}

void
ListClass::stringDirection(XmStringDirection s)
{
   XtVaSetValues(widget(), XmNstringDirection, s, NULL);
}

XmStringDirection
ListClass::stringDirection()
{
   XmStringDirection s;
   XtVaGetValues(widget(), XmNstringDirection, &s, NULL);
   return s;
}

void
ListClass::topItemPosition(int i)
{
   XtVaSetValues(widget(), XmNtopItemPosition, i, NULL);
}

int
ListClass::topItemPosition()
{
   int i;
   XtVaGetValues(widget(), XmNtopItemPosition, &i, NULL);
   return i;
}

void
ListClass::visibleItemCount(int i)
{
   XtVaSetValues(widget(), XmNvisibleItemCount, i, NULL);
}

int
ListClass::visibleItemCount()
{
   int i;
   XtVaGetValues(widget(), XmNvisibleItemCount, &i, NULL);
   return i;
}


/* extras */
void 
ListClass::add(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListAddItem(widget(),xmstr,0);
   XmStringFree(xmstr);
}

void
ListClass::add(char **l, int c)
{
   XmString *xmstr = new XmString [c];
   for(int i=0; i<c; i++)
   {
      xmstr[i] = cvtStringToXmString(l[i]);
   }
   XmListAddItems(widget(), xmstr, c, 0);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

void
ListClass::deselect(const char *str)
{
   XmString xmstr = cvtStringToXmString((char *)str);
   XmListDeselectItem(widget(), xmstr);
   XmStringFree(xmstr);
}
void
ListClass::deselect(int p)
{
   XmListDeselectPos(widget(), p);
}

void
ListClass::clear()
{
   XmListDeleteAllItems(widget());
}

int
ListClass::count()
{
   int cnt;
   XtVaGetValues(widget(),XmNitemCount, &cnt, 0);
   return cnt;
}

void
ListClass::del(int p)
{
   XmListDeletePos(widget(),p);
}

void
ListClass::del(int n, int p)
{
   XmListDeleteItemsPos(widget(),n,p);
}

void
ListClass::del(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListDeleteItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void
ListClass::del(char **slist, int n)
{
   XmString *xmstr = new XmString [n];
   for(int i=0; i<n; i++)
   {
      xmstr[i] = cvtStringToXmString(slist[i]);
   }
   XmListDeleteItems(widget(), xmstr, n);
   for(i = 0; i<n; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

int
ListClass::exists(const char *str)
{
   XmString xmstr = cvtStringToXmString((char *)str);
   int ret = (int) XmListItemExists(widget(),xmstr);
   XmStringFree(xmstr);
   return ret;
}

void
ListClass::horizontal(int p)
{
   XmListSetHorizPos(widget(),p);
}


void
ListClass::insert(char *str, int p)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListAddItem(widget(),xmstr,p);
   XmStringFree(xmstr);
}

void
ListClass::insert(char **l, int c, int p)
{
   XmString *xmstr = new XmString [c];
   for(int i=0; i<c; i++)
   {
      xmstr[i] = cvtStringToXmString(l[i]);
   }
   XmListAddItems(widget(), xmstr, c, p);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

int
ListClass::item(const char *str)
{
   XmString xmstr = cvtStringToXmString((char *) str);
   int ret = XmListItemPos(widget(),xmstr);
   XmStringFree(xmstr);
   return ret;
}
int
ListClass::match(char *str, int * &p, int &c)
{
   int res = False;
   XmString xmstr = cvtStringToXmString(str);
   res = XmListGetMatchPos(widget(), xmstr, &p, &c);
   XmStringFree(xmstr);
   return res;
}

void
ListClass::replace(char **l, int c, int p)
{
   XmString *xmstr = new XmString [c];
   for(int i=0; i<c; i++)
   {
      xmstr[i] = cvtStringToXmString(l[i]);
   }
   XmListReplaceItemsPos(widget(), xmstr, c, p);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

void
ListClass::replace(char **o, int c, char **n)
{
   XmString *xmold = new XmString [c];
   XmString *xmnew = new XmString [c];
   for(int i=0; i<c; i++)
   {
      xmold[i] = cvtStringToXmString(o[i]);
      xmnew[i] = cvtStringToXmString(n[i]);
   }
   XmListReplaceItems(widget(), xmold, c, xmnew);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmold[i]);
      XmStringFree(xmnew[i]);
   } 
   delete [] xmold;
   delete [] xmnew;
}

Boolean
ListClass::selected(int * &slist, int &snum)
{
   return XmListGetSelectedPos(widget(), &slist, &snum);
}

void
ListClass::select(const char *str, int notify)
{
   XmString xmstr = cvtStringToXmString((char *)str);
   XmListSelectItem(widget(), xmstr, notify);
   XmStringFree(xmstr);
}
void
ListClass::select(int p, int notify)
{
   XmListSelectPos(widget(),p,notify);
}

void
ListClass::set(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListSetItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void
ListClass::set(int p)
{
   XmListSetPos(widget(),p);
} 

void
ListClass::setBottom(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListSetBottomItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void
ListClass::setBottom(int p)
{
   XmListSetBottomPos(widget(), p);
}

/* constructors */
List::List(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateList(parent,"XmList", arglist, cnt);
   widget(wid);
}


