/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* DrawingA.C,v 1.3 1994/10/27 23:26:29 pgw Exp */
#include <Xarm/DrawingA.h>

/* DrawingAreaClass Members */
/* Callbacks */
void
DrawingAreaClass::exposeCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNexposeCallback,funcp,data);
}

void
DrawingAreaClass::inputCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNinputCallback,funcp,data);
}

void
DrawingAreaClass::resizeCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNresizeCallback,funcp,data);
}

/* resources */
void
DrawingAreaClass::marginHeight(Dimension h)
{
   XtVaSetValues(widget(),XmNmarginHeight, h, NULL);
}

Dimension
DrawingAreaClass::marginHeight()
{
   Dimension h;
   XtVaGetValues(widget(),XmNmarginHeight, &h, NULL);
   return h;
}

void
DrawingAreaClass::marginWidth(Dimension w)
{
   XtVaSetValues(widget(),XmNmarginWidth, w, NULL);
}

Dimension
DrawingAreaClass::marginWidth()
{
   Dimension w;
   XtVaGetValues(widget(),XmNmarginWidth, &w, NULL);
   return w;
}

void
DrawingAreaClass::resizePolicy(unsigned char policy)
{
   XtVaSetValues(widget(),XmNresizePolicy, policy, NULL);
}

unsigned char
DrawingAreaClass::resizePolicy()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNresizePolicy, &c, NULL);
   return c;
}

/* constructor */
DrawingArea::DrawingArea(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateDrawingArea(parent,"XmDrawingArea", arglist, cnt);
   widget(wid);
   manage();
}


