/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* CascadeBG.C,v 1.3 1994/10/27 23:26:22 pgw Exp */

#include <Xarm/CascadeBG.h>

/* CascadeButtonGadgetClass member functions */
void
CascadeButtonGadgetClass::activateCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNactivateCallback,fp,udata);
}

void
CascadeButtonGadgetClass::cascadingCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNcascadingCallback,fp,udata);
}

void
CascadeButtonGadgetClass::cascadePixmap(Pixmap id)
{
   XtVaSetValues(widget(),XmNcascadePixmap,id, NULL);
}

Pixmap
CascadeButtonGadgetClass::cascadePixmap()
{
   Pixmap id;
   XtVaSetValues(widget(),XmNcascadePixmap, &id, NULL);
   return id;
}

void
CascadeButtonGadgetClass::mappingDelay(int delay)
{
   XtVaSetValues(widget(),XmNmappingDelay,delay, NULL);
}   

int
CascadeButtonGadgetClass::mappingDelay()
{
   int delay;
   XtVaSetValues(widget(),XmNmappingDelay, &delay, NULL);
   return delay;
}   

void
CascadeButtonGadgetClass::subMenuId(Widget sub)
{
   if(sub)
   {
      XtVaSetValues(widget(),XmNsubMenuId,sub, NULL);
   }
}

Widget
CascadeButtonGadgetClass::subMenuId()
{
   Widget w;
   XtVaSetValues(widget(),XmNsubMenuId,&w, NULL);
   return w;
}

/* constructors */
CascadeButtonGadget::CascadeButtonGadget(Widget parent,char *str)
{
   Widget wid = XtVaCreateWidget("XmCascadeButtonGadget",
                                 xmCascadeButtonGadgetClass,
                                 parent,
                                 NULL);
   widget(wid);
   labelString(str);
   manage();
}

CascadeButtonGadget::CascadeButtonGadget(Widget parent, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateCascadeButtonGadget(parent,"XmCascadeButtonGadget",
                                      arglist, cnt);
   widget(wid);
   manage();
}

/* */
