/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* BulletinB.C,v 1.4 1994/10/27 23:26:21 pgw Exp */

/* Include(s): */
#include <Xarm/BulletinB.h>

/* BulletinBoardClass Members */
void
BulletinBoardClass::allowOverlap(Boolean b)
{
   XtVaSetValues(widget(), XmNallowOverlap, b, NULL);
}

Boolean 
BulletinBoardClass::allowOverlap()
{
   Boolean b;
   XtVaGetValues(widget(), XmNallowOverlap, &b, NULL);
   return b;
}

Boolean 
BulletinBoardClass::autoUnmanage()
{
   Boolean b;
   XtVaGetValues(widget(), XmNautoUnmanage, &b, NULL);
   return b;
}

void
BulletinBoardClass::buttonFontList(XmFontList fl)
{
   XtVaSetValues(widget(), XmNbuttonFontList, fl, NULL);
}

XmFontList
BulletinBoardClass::buttonFontList()
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNbuttonFontList, &fl, NULL);
   return fl;
}

void
BulletinBoardClass::cancelButton(Widget w)
{
   XtVaSetValues(widget(), XmNcancelButton, w, NULL);
}

Widget
BulletinBoardClass::cancelButton()
{
   Widget w;
   XtVaGetValues(widget(), XmNcancelButton, &w, NULL);
   return w;
}

void
BulletinBoardClass::defaultButton(Widget w)
{
   XtVaSetValues(widget(), XmNdefaultButton, w, NULL);
}

Widget
BulletinBoardClass::defaultButton()
{
   Widget w;
   XtVaSetValues(widget(), XmNdefaultButton, &w, NULL);
   return w;
}

void
BulletinBoardClass::defaultPosition(Boolean b)
{
   XtVaSetValues(widget(), XmNdefaultPosition, b, NULL);
}

Boolean
BulletinBoardClass::defaultPosition()
{
   Boolean b;
   XtVaGetValues(widget(), XmNdefaultPosition, &b, NULL);
   return b;
}

void
BulletinBoardClass::dialogStyle(unsigned char s)
{
   XtVaSetValues(widget(), XmNdialogStyle, s, NULL);
}

unsigned char 
BulletinBoardClass::dialogStyle()
{
   unsigned char s;
   XtVaGetValues(widget(), XmNdialogStyle, &s, NULL);
   return s;
}

void
BulletinBoardClass::dialogTitle(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNdialogTitle, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
BulletinBoardClass::dialogTitle()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNdialogTitle, &xmstr, NULL);
   char *s = cvtXmStringToString(xmstr);
   XmStringFree(xmstr);
   return s;
}

void
BulletinBoardClass::focusCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNfocusCallback,fp,udata);
}

void
BulletinBoardClass::labelFontList(XmFontList fl)
{
   XtVaSetValues(widget(), XmNlabelFontList, fl, NULL);
}

XmFontList
BulletinBoardClass::labelFontList()
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNlabelFontList, &fl, NULL);
   return fl;
}

void
BulletinBoardClass::mapCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNmapCallback,fp,udata);
}

void
BulletinBoardClass::marginHeight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginHeight, d, NULL);
}

Dimension
BulletinBoardClass::marginHeight()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginHeight, &d, NULL);
   return d;
}

void
BulletinBoardClass::marginWidth(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginWidth, d, NULL);
}

Dimension
BulletinBoardClass::marginWidth()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginWidth, &d, NULL);
   return d;
}

void
BulletinBoardClass::noResize(Boolean b)
{
   XtVaSetValues(widget(), XmNnoResize, b, NULL);
}

Boolean
BulletinBoardClass::noResize()
{
   Boolean b;
   XtVaGetValues(widget(), XmNnoResize, &b, NULL);
   return b;
}

void
BulletinBoardClass::resizePolicy(unsigned char p)
{
   XtVaSetValues(widget(), XmNresizePolicy, p, NULL);
}

unsigned char
BulletinBoardClass::resizePolicy()
{
   unsigned char p;
   XtVaGetValues(widget(), XmNresizePolicy, &p, NULL);
   return p;
}

void
BulletinBoardClass::shadowType(unsigned char s)
{
   XtVaSetValues(widget(), XmNshadowType, s, NULL);
}

unsigned char
BulletinBoardClass::shadowType()
{
   unsigned char s;
   XtVaGetValues(widget(), XmNshadowType, &s, NULL);
   return s;
}

void
BulletinBoardClass::textFontList(XmFontList fl)
{
   XtVaSetValues(widget(), XmNtextFontList, fl, NULL);
}

XmFontList
BulletinBoardClass::textFontList()
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNtextFontList, &fl, NULL);
   return fl;
}

void
BulletinBoardClass::unmapCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNunmapCallback,fp,udata);
}

BulletinBoard::BulletinBoard(Widget p, ArgList arglist, Cardinal cnt)
{
   Widget wid = XmCreateBulletinBoard(p,"XmBulletinBoard",arglist, cnt);

   widget(wid);
}


