/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* SelectioB.h,v 1.6 1994/10/27 23:25:46 pgw Exp */

#if !defined(_SELECTIOB_H_)
#define _SELECTIOB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/BulletinB.h>

class SelectionBoxClass : public BulletinBoardClass {
 protected:
   SelectionBoxClass() {}
 public:
   /* callbacks */
   void applyCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void cancelCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void noMatchCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void okCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* convenience routines */
   virtual Widget getChild(unsigned char);

   /* resources */
   void applyLabelString(char *);
   char *applyLabelString();
   void cancelLabelString(char *);
   char *cancelLabelString();
   void childPlacement(unsigned char);
   unsigned char childPlacement();
   void dialogType(unsigned char);
   unsigned char dialogType();
   void helpLabelString(char *);
   char *helpLabelString();
   void listItemCount(int);
   int listItemCount();
   void listItems(XmStringTable);
   XmStringTable listItems();
   void listLabelString(char *);
   char *listLabelString();
   void listVisibleItemCount(int);
   int listVisibleItemCount();
   void minimizeButtons(Boolean);
   Boolean minimizeButtons();
   void mustMatch(Boolean);
   Boolean mustMatch();
   void okLabelString(char *);
   char *okLabelString();
   void selectionLabelString(char *str);
   char *selectionLabelString();
   void textColumns(short);
   short textColumns();
   void textString(char *str);
   char *textString();
};

class SelectionBox : public SelectionBoxClass {
 public:
   SelectionBox(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

class SelectionDialog : public SelectionBoxClass {
 public:
   SelectionDialog(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

class PromptDialog : public SelectionBoxClass {
 public:
   PromptDialog(Widget parent, char *mesg);
   PromptDialog(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

#endif
