/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* RowColumn.h,v 1.8 1994/10/28 03:49:27 pgw Exp */

#if !defined(_ROWCOLUMN_H_)
#define _ROWCOLUMN_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>

class RowColumnClass : public ManagerClass {
 protected:
   RowColumnClass() {} /* only a derived class can make this */
 public:
   /* callbacks */
   void entryCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void mapCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void tearOffMenuActivateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void tearOffMenuDeactivateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void unmapCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void adjustLast(Boolean b);
   Boolean adjustLast();
   void adjustMargin(Boolean b);
   Boolean adjustMargin();
   void entryAlignment(unsigned char c);
   unsigned char entryAlignment();
   void entryBorder(Dimension d);
   Dimension entryBorder();
   void entryClass(WidgetClass wc);
   WidgetClass entryClass();
   void entryVerticalAlignment(unsigned char c);
   unsigned char entryVerticalAlignment();
   void isAligned(Boolean b);
   Boolean isAligned();
   void isHomogeneous(Boolean b);
   Boolean isHomogeneous();
   void marginHeight(Dimension d);
   Dimension marginHeight();
   void marginWidth(Dimension d);
   Dimension marginWidth();
   void menuAccelerator(String s);
   String menuAccelerator();
   void menuHelpWidget(Widget w);
   Widget menuHelpWidget();
   void menuHistory(Widget w);
   Widget menuHistory();
   void menuPost(String s);
   String menuPost();
   void mnemonic(KeySym k);
   KeySym mnemonic();
   void mnemonicCharSet(String s);
   String mnemonicCharSet();
   void numColumns(short s);
   short numColumns();
   void orientation(unsigned char c);
   unsigned char orientation();
   void packing(unsigned char c);
   unsigned char packing();
   void popupEnabled(Boolean b);
   Boolean popupEnabled();
   void radioAlwaysOne(Boolean b);
   Boolean radioAlwaysOne();
   void radioBehavior(Boolean b);
   Boolean radioBehavior();
   void resizeHeight(Boolean b);
   Boolean resizeHeight();
   void resizeWidth(Boolean b);
   Boolean resizeWidth();
   unsigned char rowColumnType();
   void spacing(Dimension d);
   Dimension spacing();
   void subMenuId(Widget w);
   Widget subMenuId();
   void tearOffModel(unsigned char c);
   unsigned char tearOffModel();
   void whichButton(unsigned int);
   unsigned int whichButton();
};

class RowColumn : public RowColumnClass {
 public:
   RowColumn(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};



class CheckBoxClass : public RowColumnClass {
 protected:
   CheckBoxClass() {}
};

class PulldownMenuClass : public RowColumnClass {
 protected:
   PulldownMenuClass() {} /* only a derived class can make this */
};

class PulldownMenu : public PulldownMenuClass {
 public:
   PulldownMenu(Widget parent, ArgList arglist = NULL, Cardinal = 0);
};

class MenuBarClass : public RowColumnClass {
 protected:
   MenuBarClass() {} /* only a derived class can make this */
 public:
   /* extra functionality */
   void help(Widget pull);
   void help(PulldownMenuClass *pull) { help(pull->widget()); }
};

class MenuBar : public MenuBarClass {
 public:
   MenuBar(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

class OptionMenuClass : public RowColumnClass {
 protected:
   OptionMenuClass() {} /* only a derived class can make this */
};

class PopupMenuClass : public RowColumnClass {
 protected:
   PopupMenuClass() {} /* only a derived class can make this */
};


class RadioBoxClass : public RowColumnClass {
 protected:
   RadioBoxClass() {} /* only a derived class can make this */
};

#endif
