/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* PushBG.h,v 1.6 1994/10/27 23:25:38 pgw Exp */

#if !defined(_PUSHBG_H_)
#define _PUSHBG_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/LabelG.h>

class PushButtonGadgetClass : public LabelGadgetClass {
 protected:
   PushButtonGadgetClass() {} /* only a derived class can make this */
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void armCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void disarmCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void armColor(Pixel);
   Pixel armColor();
   void defaultButtonShadowThickness(Dimension);
   Dimension defaultButtonShadowThickness();
   void fillOnArm(Boolean);
   Boolean fillOnArm();
   void multiClick(unsigned char);
   unsigned char multiClick();
   void showAsDefault(Dimension);
   Dimension showAsDefault();

   /* extra functionality */
   void autoSpace(int size = 100);
};
   
class PushButtonGadget : public PushButtonGadgetClass {
 public:
   PushButtonGadget(Widget parent, char *text, KeySym mn = 0,
                    String acc = NULL, char *acc_text = NULL);
   PushButtonGadget(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

#endif
