/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* Primitive.h,v 1.5 1994/10/27 23:25:36 pgw Exp */

#if !defined(_PRIMITIVE_H_)
#define _PRIMITIVE_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Core.h>

class PrimitiveClass : public CoreClass {
 protected:
   PrimitiveClass() {} /* only a derived class can make this */
 public:
   /* callbacks */
   void helpCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void bottomShadowColor(Pixel);
   Pixel bottomShadowColor();
   void bottomShadowPixmap(Pixmap);
   Pixmap bottomShadowPixmap();
   void foreground(Pixel);
   Pixel foreground();
   void highlightColor(Pixel);
   Pixel highlightColor();
   void highlightOnEnter(Boolean);
   Boolean highlightOnEnter();
   void highlightPixmap(Pixmap);
   Pixmap highlightPixmap();
   void highlightThickness(Dimension);
   Dimension highlightThickness();
   void navigationType(XmNavigationType);
   XmNavigationType navigationType();
   void shadowThickness(Dimension);
   Dimension shadowThickness();
   void topShadowColor(Pixel);
   Pixel topShadowColor();
   void topShadowPixmap(Pixmap);
   Pixmap topShadowPixmap();
   void traversalOn(Boolean on); 
   Boolean traversalOn(); 
   void unitType(unsigned char c);
   unsigned char unitType();
   void userData(XtPointer udata);
   XtPointer userData(); 
};

#endif
