/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* MessageB.h,v 1.6 1994/10/27 23:25:33 pgw Exp */

#if !defined(_MESSAGEB_H_)
#define _MESSAGEB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/BulletinB.h>

class MessageBoxClass : public BulletinBoardClass {
 protected:
   MessageBoxClass() {}
 public:
   /* convenience rountines */
   Widget getChild(unsigned char);

   /* callbacks */
   void cancelCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void okCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void cancelLabelString(char *);
   char *cancelLabelString();
   void defaultButtonType(unsigned char);
   unsigned char defaultButtonType();
   void dialogType(unsigned char);
   unsigned char dialogType();
   void messageAlignment(unsigned char);
   unsigned char messageAlignment();
   void messageString(char *);
   char * messageString();
   void minimizeButtons(Boolean);
   Boolean minimizeButtons();
   void okLabelString(char *);
   char *okLabelString();
   void symbolPixmap(Pixmap);
   Pixmap symbolPixmap();
};

class MessageBox : public MessageBoxClass {
 public:
   MessageBox(Widget parent,char *str);
   MessageBox(Widget parent,ArgList arglist = NULL, Cardinal cnt = 0);
};

class MessageDialog : public MessageBoxClass {
 public:
   MessageDialog(Widget parent,char *str);
   MessageDialog(Widget parent,ArgList arglist = NULL, Cardinal cnt = 0);
};

class QuestionDialog : public MessageBoxClass {
 public:
   QuestionDialog(Widget parent, char *mesg);
   QuestionDialog(Widget parent,ArgList arglist = NULL, Cardinal cnt = 0);
};

class InformationDialog : public MessageBoxClass { 
 public:
   InformationDialog(Widget parent, char *mesg);
   InformationDialog(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

class ErrorDialog : public MessageBoxClass { 
 public:
   ErrorDialog(Widget parent, char *mesg);
   ErrorDialog(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

class WarningDialog : public MessageBoxClass { 
 public:
   WarningDialog(Widget parent, char *mesg);
   WarningDialog(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};

class WorkingDialog : public MessageBoxClass { 
 public:
   WorkingDialog(Widget parent, char *mesg);
   WorkingDialog(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};


#endif
