/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* MainW.h,v 1.7 1994/10/27 23:25:30 pgw Exp */

#if !defined(_MAINW_H_)
#define _MAINW_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/ScrolledW.h>

class MainWindowClass : public ScrolledWindowClass {
 protected:
   MainWindowClass() {}
 public:
   /* convenience routines */
   Widget separator1();
   Widget separator2();
   Widget separator3();
   void setArea(Widget menu,Widget command,
		Widget hscroll, Widget vscroll,
		Widget work);

   /* resources */
   void commandWindow(Widget);
   Widget commandWindow();
   unsigned char commandWindowLocation();
   void mainWindowMarginHeight(Dimension);
   Dimension mainWindowMarginHeight();
   void mainWindowMarginWidth(Dimension);
   Dimension mainWindowMarginWidth();
   void menuBar(Widget);
   Widget menuBar();
   void messageWindow(Widget);
   Widget messageWindow();
   void showSeparator(Boolean);
   Boolean showSeparator();
};

class MainWindow : public MainWindowClass {
 public:
   MainWindow(Widget parent, unsigned char scroll_policy,
                   Boolean show_separator = FALSE);
   MainWindow(Widget parent, Dimension width, Dimension height,
                   unsigned char scroll_policy = XmAPPLICATION_DEFINED,
                   Boolean show_separator = FALSE);
   MainWindow(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);
};
   
#endif
